/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.ImageLoaderCallback;
import com.sun.deploy.util.SafeThreadFactory;
import com.sun.deploy.util.URLUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class ImageLoader
implements Runnable {
    private Component _component;
    private static ImageLoader _instance = null;
    private final Object _imageLoadingLock = new Object();
    private boolean _running = false;
    private ArrayList<LoadEntry> _toLoad = new ArrayList();

    private ImageLoader() {
    }

    public static ImageLoader getInstance() {
        if (_instance == null) {
            _instance = new ImageLoader();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getComponent() {
        if (this._component == null) {
            ImageLoader imageLoader = this;
            synchronized (imageLoader) {
                if (this._component == null) {
                    this._component = new Component(){};
                }
            }
        }
        return this._component;
    }

    public Image loadImage(String path) throws IOException {
        Image image = Toolkit.getDefaultToolkit().createImage(path);
        if (image != null) {
            Component c = this.getComponent();
            MediaTracker mt = new MediaTracker(c);
            mt.addImage(image, 0);
            try {
                mt.waitForID(0, 5000L);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to load");
            }
            if (!mt.isErrorID(0)) {
                return image;
            }
        }
        return null;
    }

    public Image loadImage(URL url) throws IOException {
        Image image = Toolkit.getDefaultToolkit().createImage(url);
        if (image != null) {
            Component c = this.getComponent();
            MediaTracker mt = new MediaTracker(c);
            mt.addImage(image, 0);
            try {
                mt.waitForID(0, 5000L);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to load");
            }
            return image;
        }
        return null;
    }

    public void loadImage(URL iconRef, String iconVer, ImageLoaderCallback cb) {
        this.loadImage(iconRef, iconVer, cb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadImage(URL iconRef, String iconVer, ImageLoaderCallback cb, boolean useCached) {
        boolean createThread = false;
        Object object = this._imageLoadingLock;
        synchronized (object) {
            if (!this._running) {
                this._running = true;
                createThread = true;
            }
            this._toLoad.add(new LoadEntry(iconRef, iconVer, cb, useCached));
        }
        if (createThread) {
            SafeThreadFactory.createThread(this).start();
        }
    }

    public void loadImage(URL url, ImageLoaderCallback cb) {
        this.loadImage(url, cb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadImage(URL url, ImageLoaderCallback cb, boolean useCached) {
        boolean createThread = false;
        Object object = this._imageLoadingLock;
        synchronized (object) {
            if (!this._running) {
                this._running = true;
                createThread = true;
            }
            this._toLoad.add(new LoadEntry(url, cb, useCached));
        }
        if (createThread) {
            SafeThreadFactory.createThread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean done = false;
        while (!done) {
            LoadEntry entry = null;
            Object object = this._imageLoadingLock;
            synchronized (object) {
                if (this._toLoad.size() > 0) {
                    entry = this._toLoad.remove(0);
                } else {
                    done = true;
                    this._running = false;
                }
            }
            if (done) continue;
            try {
                Image image = null;
                File file = null;
                URL url = entry.url;
                if (url == null) {
                    Resource r = ResourceProvider.get().getResource(entry.iconRef, entry.iconVer, false, 0, null);
                    File file2 = file = r != null ? r.getDataFile() : null;
                    if (file != null) {
                        url = URLUtil.fileToURL(file);
                    }
                }
                if (url != null) {
                    image = this.loadImage(url);
                }
                if (image != null) {
                    if (entry.useCached) {
                        ImageLoader.publish(entry, image, file, true);
                        continue;
                    }
                    ImageLoader.publish(entry, image, file, false);
                    if (entry.iconRef == null) continue;
                    SafeThreadFactory.createThread(new DelayedImageLoader(entry, image)).start();
                    continue;
                }
                if (entry.iconRef == null) continue;
                SafeThreadFactory.createThread(new DelayedImageLoader(entry, image)).start();
            }
            catch (MalformedURLException murle) {
                Trace.ignoredException(murle);
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
            }
        }
    }

    private static void publish(LoadEntry entry, final Image image, final File file, final boolean isComplete) {
        final URL url = entry.iconRef;
        final String version = entry.iconVer;
        final ImageLoaderCallback cb = entry.cb;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (isComplete) {
                    cb.finalImageAvailable(url, version, image, file);
                } else {
                    cb.imageAvailable(url, version, image, file);
                }
            }
        });
    }

    private class DelayedImageLoader
    implements Runnable {
        private LoadEntry _entry;
        private Image _image;

        public DelayedImageLoader(LoadEntry entry, Image image) {
            this._entry = entry;
            this._image = image;
        }

        @Override
        public void run() {
            try {
                Resource r = ResourceProvider.get().getResource(this._entry.iconRef, this._entry.iconVer);
                File file = r != null ? r.getDataFile() : null;
                this._image = file != null ? ImageLoader.this.loadImage(file.getPath()) : ImageLoader.this.loadImage(this._entry.iconRef);
                ImageLoader.publish(this._entry, this._image, file, true);
            }
            catch (MalformedURLException murle) {
                Trace.ignoredException(murle);
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
            }
        }
    }

    private class LoadEntry {
        public URL url;
        public URL iconRef;
        public String iconVer;
        public ImageLoaderCallback cb;
        public boolean useCached;

        public LoadEntry(URL iconRef, String iconVer, ImageLoaderCallback cb, boolean useCached) {
            this.cb = cb;
            this.url = null;
            this.iconRef = iconRef;
            this.iconVer = iconVer;
            this.useCached = useCached;
        }

        public LoadEntry(URL url, ImageLoaderCallback cb, boolean useCached) {
            this.url = url;
            this.cb = cb;
            this.iconRef = null;
            this.iconVer = null;
            this.useCached = useCached;
        }

        public String toString() {
            return "LoadEntry:\n  url: " + this.url + "\n  iconRef " + this.iconRef + "\n  iconVer: " + this.iconVer + "  useCached: " + this.useCached;
        }
    }
}

