/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.ui;

import com.sun.deploy.Environment;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.trace.TraceListener;
import com.sun.deploy.util.SystemPropertyUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class NativeMixedCodeDialog {
    public static final int ERROR = -1;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int ALWAYS = 2;
    private static Boolean jnlpNativeMixedCodeDialog = null;

    public static final void main(String[] args) {
        int ret = -1;
        try {
            String showAlwaysText;
            TraceListener tl = new TraceListener(){

                @Override
                public void flush() {
                    System.err.flush();
                }

                @Override
                public void print(String trace) {
                    System.err.print(trace);
                }
            };
            Trace.addTraceListener(tl);
            Trace.println("NativeMixedCodeDialog.main enter");
            Platform.get();
            boolean isJsToJava = args.length >= 5 && args[1].length() > 0 && args[2].length() > 0 && args[3].length() > 0 && args[4].length() > 0;
            String prefix = "security.dialog.nativemixcode." + (isJsToJava ? "js." : "");
            String title = ResourceManager.getString(prefix + "title");
            String masthead = ResourceManager.getString(prefix + "masthead");
            String message = ResourceManager.getString(prefix + "message");
            String info = ResourceManager.getString(prefix + "info");
            String blockBtnStr = ResourceManager.getString(prefix + "firstBtnStr");
            String dontBlockBtnStr = ResourceManager.getString(prefix + "secondBtnStr");
            String helpBtnStr = ResourceManager.getString(prefix + "helpBtnStr");
            String closeBtnStr = ResourceManager.getString(prefix + "closeBtnStr");
            String helpTitle = ResourceManager.getString(prefix + "helpTitle");
            String helpMessage = ResourceManager.getString(prefix + "helpMessage");
            String appLabelStr = ResourceManager.getString(prefix + "appLabelStr");
            String appTitle = args[0];
            String appLabelWebsite = isJsToJava ? args[1] : "";
            String appWebsiteText = isJsToJava ? args[2] : "";
            String appLabelPublisher = isJsToJava ? args[3] : "";
            String appPublisherText = isJsToJava ? args[4] : "";
            String string = showAlwaysText = isJsToJava ? args[5] : "";
            if (NativeMixedCodeDialog.isSupported()) {
                ret = NativeMixedCodeDialog.showImmediately(title, masthead, message, info, blockBtnStr, dontBlockBtnStr, helpBtnStr, closeBtnStr, helpTitle, helpMessage, appLabelStr, appTitle, appLabelWebsite, appWebsiteText, appLabelPublisher, appPublisherText, showAlwaysText);
                Trace.println("NativeMixedCodeDialog.show(...) returns " + ret);
            } else {
                Trace.println("NativeMixedCodeDialog isn't supported");
            }
            Trace.println("NativeMixedCodeDialog.main exit");
            Trace.ensureMessageQueueProcessingStarted();
        }
        catch (Throwable t) {
            Trace.ignored(t);
            ret = -1;
        }
        System.exit(ret);
    }

    private static native int _show(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13, String var14, String var15, String var16, String var17);

    private static int _show(String title, String masthead, String message, String info, String blockBtnStr, String dontBlockBtnStr, String helpBtnStr, String closeBtnStr, String helpTitle, String helpMessage, String appLabelStr, String appTitle, String appLabelWebsite, String appWebsiteText, String appLabelPublisher, String appPublisherText, String showAlwaysText) {
        return NativeMixedCodeDialog._show(title, masthead, message, info, blockBtnStr, dontBlockBtnStr, helpBtnStr, closeBtnStr, helpTitle, helpMessage, appLabelStr, appTitle, appLabelWebsite, appWebsiteText, appLabelPublisher, appPublisherText, showAlwaysText, Environment.getJavaHome());
    }

    private static native void _activateCurrentProcess();

    private static native boolean _isMainToolkitThread();

    public static int show(String title, String masthead, String message, String info, String blockBtnStr, String dontBlockBtnStr, String helpBtnStr, String closeBtnStr, String helpTitle, String helpMessage, String appLabelStr, String appTitle) {
        return NativeMixedCodeDialog.show(title, masthead, message, info, blockBtnStr, dontBlockBtnStr, helpBtnStr, closeBtnStr, helpTitle, helpMessage, appLabelStr, appTitle, "", "", "", "", null);
    }

    public static int show(String title, String masthead, String message, String info, String blockBtnStr, String dontBlockBtnStr, String helpBtnStr, String closeBtnStr, String helpTitle, String helpMessage, String appLabelStr, String appTitle, String appLabelWebsite, String appWebsiteText, String appLabelPublisher, String appPublisherText, String showAlwaysText) {
        if (NativeMixedCodeDialog._isMainToolkitThread()) {
            return NativeMixedCodeDialog.showImmediately(title, masthead, message, info, blockBtnStr, dontBlockBtnStr, helpBtnStr, closeBtnStr, helpTitle, helpMessage, appLabelStr, appTitle, appLabelWebsite, appWebsiteText, appLabelPublisher, appPublisherText, showAlwaysText);
        }
        String appWebsiteTextEx = appWebsiteText.replaceAll("\"", "");
        appWebsiteTextEx = appWebsiteTextEx.replaceAll(" ", "");
        if ((appWebsiteTextEx = appWebsiteTextEx.replaceAll("\t", "")).endsWith("\\")) {
            appWebsiteTextEx = appWebsiteTextEx.substring(0, appWebsiteTextEx.length() - 1);
        }
        String[] args = new String[]{Environment.getJavaHome() + (OSType.isWin() ? "\\bin\\javaw.exe" : "/bin/java"), "-cp", Environment.getJavaHome() + (OSType.isWin() ? "\\lib\\deploy.jar" : "/lib/deploy.jar"), "com.sun.deploy.uitoolkit.ui.NativeMixedCodeDialog", appTitle, appLabelWebsite, appWebsiteTextEx, appLabelPublisher, appPublisherText, showAlwaysText};
        Trace.println("NativeMixedCodeDialog executes the command in a separate process:", TraceLevel.UI);
        for (int i = 0; i < args.length; ++i) {
            if (OSType.isWin()) {
                args[i] = "\"" + args[i] + "\"";
            }
            Trace.println("    args[" + i + "]=" + args[i], TraceLevel.UI);
        }
        int ret = -1;
        try {
            Process p = Runtime.getRuntime().exec(args);
            ret = p.waitFor();
            NativeMixedCodeDialog._activateCurrentProcess();
        }
        catch (Throwable t) {
            Trace.ignored(t);
            ret = -1;
        }
        return ret;
    }

    private static int showImmediately(final String title, final String masthead, final String message, final String info, final String blockBtnStr, final String dontBlockBtnStr, final String helpBtnStr, final String closeBtnStr, final String helpTitle, final String helpMessage, final String appLabelStr, final String appTitle, final String appLabelWebsite, final String appWebsiteText, final String appLabelPublisher, final String appPublisherText, final String showAlwaysText) {
        if (title == null || masthead == null || message == null || info == null || blockBtnStr == null || dontBlockBtnStr == null || helpBtnStr == null || closeBtnStr == null || helpTitle == null || helpMessage == null || appLabelStr == null || appTitle == null) {
            Trace.println("parameters shouldn't be null", TraceLevel.UI);
            return -1;
        }
        PrivilegedAction<Integer> action = new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                int userAnswer = NativeMixedCodeDialog._show(title, masthead, message, info, blockBtnStr, dontBlockBtnStr, helpBtnStr, closeBtnStr, helpTitle, helpMessage, appLabelStr, appTitle, appLabelWebsite, appWebsiteText, appLabelPublisher, appPublisherText, showAlwaysText);
                return userAnswer;
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (Throwable e) {
            Trace.ignored(e);
            return -1;
        }
    }

    public static boolean isSupported() {
        return (!OSType.isUnix() || Platform.get().isGTKAvailable(2, 14, 0)) && NativeMixedCodeDialog.getNativeMixedCodeDialogProperty();
    }

    private static boolean getNativeMixedCodeDialogProperty() {
        if (jnlpNativeMixedCodeDialog == null) {
            String useNativeDialog = SystemPropertyUtil.getProperty("jnlp.nativeMixedCodeDialog", "true");
            jnlpNativeMixedCodeDialog = useNativeDialog.equals("false") ? Boolean.FALSE : Boolean.TRUE;
        }
        return jnlpNativeMixedCodeDialog;
    }
}

