/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.ref.Helpers;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.SystemUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class DeploymentHooks {
    static boolean usageTrackerFailed = false;
    Object usageTracker;
    Method runMethod;
    String storedAppName = null;
    String storedArg1 = null;
    String storedArg2 = null;

    private boolean initialize() {
        if (usageTrackerFailed) {
            return false;
        }
        if (this.runMethod == null) {
            try {
                Class<?> usageTrackerClass = Class.forName("sun.usagetracker.UsageTrackerClient", true, null);
                Constructor<?> con = usageTrackerClass.getConstructor(new Class[0]);
                this.usageTracker = con.newInstance(new Object[0]);
                this.runMethod = usageTrackerClass.getMethod("run", String.class, String.class);
            }
            catch (Throwable t) {
                usageTrackerFailed = true;
                return false;
            }
        }
        return true;
    }

    public synchronized void storeAppName(String appName) {
        this.storedAppName = appName;
    }

    private synchronized String getAndClearAppName() {
        String name = this.storedAppName;
        this.storedAppName = null;
        return name;
    }

    public synchronized void trackUsage(AppInfo ai, DeploymentRuleSet drs) {
        if (!this.initialize()) {
            return;
        }
        Object appName = this.getAndClearAppName();
        if (appName == null) {
            return;
        }
        try {
            Object probeName = null;
            if (Environment.isOldPlugin()) {
                probeName = "plugin";
            } else if (Environment.isJavaPlugin()) {
                probeName = Environment.isJavawsAppletLifecycle() ? "javaws applet" : "plugin2";
            } else if (Environment.isJavaWebStart()) {
                probeName = "javaws application";
            }
            if (drs.isRuleBlock()) {
                probeName = (String)probeName + " denied";
                if (drs.getMessage() != null) {
                    probeName = (String)probeName + " [" + drs.getMessage() + "]";
                }
            } else if (drs.isRuleRun()) {
                String ruleVersion = drs.getVersionString();
                probeName = ruleVersion == null || SecureStaticVersioning.satisfiesDRSVersion(ruleVersion) ? (String)probeName + " permitted" : (String)probeName + " denied [required version " + ruleVersion + " not available]";
            }
            String appModelString = Helpers.storeAppModelToString(ai.getAppModel());
            String customer = drs.getCustomerString();
            appName = (String)appName + " app_model=" + appModelString;
            if (customer != null) {
                Trace.println("customer string in Main DRS used is:\n" + customer, TraceLevel.RULESET);
                appName = (String)appName + " app_customer=" + SystemUtils.encodeString(customer);
            }
            this.storedArg1 = probeName;
            this.storedArg2 = appName;
        }
        catch (Throwable t) {
            Trace.println("Error invoking UsageTracker:", TraceLevel.BASIC);
            Trace.ignored(t);
        }
    }

    public synchronized void confirmAppRun() {
        this.confirm(this.storedArg1, this.storedArg2);
        this.storedArg2 = null;
        this.storedArg1 = null;
    }

    public synchronized void confirmAppDenied(DeploymentRuleSet drs) {
        this.confirm(this.storedArg1 + " denied [by user]", this.storedArg2);
        this.storedArg2 = null;
        this.storedArg1 = null;
    }

    public synchronized void confirmAppBlocked(DeploymentRuleSet drs) {
        Object arg1 = this.storedArg1;
        if (!drs.isRuleBlock() && !drs.isRuleRun()) {
            arg1 = (String)arg1 + " denied [by security settings]";
        }
        this.confirm((String)arg1, this.storedArg2);
        this.storedArg2 = null;
        this.storedArg1 = null;
    }

    private void confirm(String arg1, String arg2) {
        try {
            if (arg1 != null && arg2 != null) {
                Object[] utArgs = new Object[]{arg1, arg2};
                this.runMethod.invoke(this.usageTracker, utArgs);
                Trace.println("JUT Record:\n    " + arg1 + "\n    " + arg2, TraceLevel.SECURITY);
            }
        }
        catch (Throwable t) {
            Trace.println("Error invoking UsageTracker:", TraceLevel.BASIC);
            Trace.ignored(t);
        }
    }
}

