/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SyncAccess;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

public class SyncFileAccess {
    private static final AccessControlContext ACC_FILE_INSTANCE;
    private static final int TYPE_RANDOM_ACCESS_FILE = 1;
    private static final int TYPE_FILE_INPUT_STREAM = 2;
    private static final int TYPE_FILE_OUTPUT_STREAM = 3;
    private final SyncAccess fileAccSync;
    private final File file;

    public SyncFileAccess(File file) {
        this.file = file;
        this.fileAccSync = new SyncAccess(8);
    }

    public RandomAccessFileLock openLockRandomAccessFile(String mode, int timeout, boolean privileged) throws IOException {
        Object fobjL = this.openLockFileObject(1, mode, timeout, privileged, false);
        return (RandomAccessFileLock)fobjL;
    }

    public FileInputStreamLock openLockFileInputStream(int timeout, boolean privileged) throws IOException {
        Object fobjL = this.openLockFileObject(2, "r", timeout, privileged, false);
        return (FileInputStreamLock)fobjL;
    }

    public FileOutputStreamLock openLockFileOutputStream(boolean append, int timeout, boolean privileged) throws IOException {
        Object fobjL = this.openLockFileObject(3, "rw", timeout, privileged, append);
        return (FileOutputStreamLock)fobjL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object openLockFileObject(final int type, final String mode, int timeout, boolean privileged, final boolean fopt1) throws IOException {
        boolean forever = timeout == 0;
        boolean readOnly = mode.equals("r");
        SyncAccess.Lock fileAccLock = this.fileAccSync.lock(readOnly ? 2 : 4);
        Object fobj = null;
        try {
            while (null == fobj) {
                if (privileged) {
                    fobj = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            Closeable o = null;
                            try {
                                switch (type) {
                                    case 1: {
                                        o = new RandomAccessFile(SyncFileAccess.this.file, mode);
                                        break;
                                    }
                                    case 2: {
                                        o = new FileInputStream(SyncFileAccess.this.file);
                                        break;
                                    }
                                    case 3: {
                                        o = new FileOutputStream(SyncFileAccess.this.file.getPath(), fopt1);
                                        break;
                                    }
                                    default: {
                                        throw new InternalError("wrong fobj type: " + type);
                                    }
                                }
                            }
                            catch (FileNotFoundException fnfe) {
                                Trace.ignoredException(fnfe);
                            }
                            return o;
                        }
                    }, ACC_FILE_INSTANCE);
                } else {
                    try {
                        switch (type) {
                            case 1: {
                                fobj = new RandomAccessFile(this.file, mode);
                                break;
                            }
                            case 2: {
                                fobj = new FileInputStream(this.file);
                                break;
                            }
                            case 3: {
                                fobj = new FileOutputStream(this.file.getPath(), fopt1);
                                break;
                            }
                            default: {
                                throw new InternalError("wrong fobj type: " + type);
                            }
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        Trace.ignoredException(fnfe);
                    }
                }
                if (null == fobj) {
                    throw new FileNotFoundException("index file not found");
                }
                FileChannel fc = null;
                switch (type) {
                    case 1: {
                        fc = ((RandomAccessFile)fobj).getChannel();
                        break;
                    }
                    case 2: {
                        fc = ((FileInputStream)fobj).getChannel();
                        break;
                    }
                    case 3: {
                        fc = ((FileOutputStream)fobj).getChannel();
                        break;
                    }
                    default: {
                        throw new InternalError("wrong fobj type: " + type);
                    }
                }
                if (fc == null) {
                    throw new InternalError("Invalid FileChannel");
                }
                if (!fc.isOpen()) {
                    fc = null;
                    fobj = null;
                    if (!forever && timeout <= 0) {
                        throw new IOException("index file could not be opened, timeout reached");
                    }
                    Trace.println("SyncFileAccess.openLock: index file not opened, remaining TO : " + timeout, TraceLevel.NETWORK);
                    try {
                        if (!forever) {
                            Thread.sleep(timeout > 100 ? 100L : (long)timeout);
                            timeout -= 100;
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    FileLock fl = null;
                    while (fl == null) {
                        try {
                            fl = fc.lock(0L, Long.MAX_VALUE, readOnly);
                        }
                        catch (OverlappingFileLockException ofle) {
                            if (!forever && timeout <= 0) {
                                throw new IOException("handled OverlappingFileLockException, timeout reached", ofle);
                            }
                            Trace.println("SyncFileAccess.openLock: handled OverlappingFileLockException, remainint TO : " + timeout, TraceLevel.NETWORK);
                            try {
                                if (!forever) {
                                    Thread.sleep(timeout > 100 ? 100L : (long)timeout);
                                    timeout -= 100;
                                } else {
                                    Thread.sleep(100L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            fl = null;
                        }
                        catch (IOException e) {
                            fobj = null;
                            Object var13_20 = null;
                            if (fobj == null) {
                                fileAccLock.release();
                            }
                            return var13_20;
                        }
                    }
                }
                catch (ClosedChannelException cce) {
                    fobj = null;
                    if (!forever && timeout <= 0) {
                        throw new IOException("handled ClosedChannelException, timeout reached", cce);
                    }
                    Trace.println("SyncFileAccess.openLock: handled ClosedChannelException, remaining TO: " + timeout, TraceLevel.NETWORK);
                    try {
                        if (!forever) {
                            Thread.sleep(timeout > 100 ? 100L : (long)timeout);
                            timeout -= 100;
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            if (fobj == null) {
                fileAccLock.release();
            }
        }
        if (fobj != null) {
            return FObjLock.createFObjLock(type, fobj, fileAccLock);
        }
        return null;
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }

    private static class FObjLock {
        protected Object fobj;
        private SyncAccess.Lock lock;

        private FObjLock(Object fobj, SyncAccess.Lock lock) {
            this.fobj = fobj;
            this.lock = lock;
        }

        public void release() {
            if (this.lock != null) {
                this.lock.release();
                this.lock = null;
            }
        }

        protected static Object createFObjLock(int type, Object fobj, SyncAccess.Lock lock) {
            FObjLock fobjL;
            switch (type) {
                case 1: {
                    fobjL = new RandomAccessFileLock((RandomAccessFile)fobj, lock);
                    break;
                }
                case 2: {
                    fobjL = new FileInputStreamLock((FileInputStream)fobj, lock);
                    break;
                }
                case 3: {
                    fobjL = new FileOutputStreamLock((FileOutputStream)fobj, lock);
                    break;
                }
                default: {
                    throw new InternalError("wrong fobj type: " + type);
                }
            }
            return fobjL;
        }
    }

    public static class FileOutputStreamLock
    extends FObjLock {
        private FileOutputStreamLock(FileOutputStream fos, SyncAccess.Lock lock) {
            super(fos, lock);
        }

        public FileOutputStream getFileOutputStream() {
            return (FileOutputStream)this.fobj;
        }
    }

    public static class FileInputStreamLock
    extends FObjLock {
        private FileInputStreamLock(FileInputStream fis, SyncAccess.Lock lock) {
            super(fis, lock);
        }

        public FileInputStream getFileInputStream() {
            return (FileInputStream)this.fobj;
        }
    }

    public static class RandomAccessFileLock
    extends FObjLock {
        private RandomAccessFileLock(RandomAccessFile raf, SyncAccess.Lock lock) {
            super(raf, lock);
        }

        public RandomAccessFile getRandomAccessFile() {
            return (RandomAccessFile)this.fobj;
        }
    }
}

