/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.DeployJavaUtilJarAccess;
import com.sun.deploy.util.TrustedLibrariesSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class TrustedLibraries {
    private static TrustedLibraries INSTANCE = null;
    private static final String DIGEST_MANIFEST = "-DIGEST-MANIFEST";
    private final HashMap<String, Object> entries = new HashMap();
    private static long lastModified = 0L;

    public static TrustedLibraries getInstance() {
        return INSTANCE;
    }

    public static TrustedLibraries getInstance(File file) {
        return new TrustedLibraries(file);
    }

    private TrustedLibraries() {
        try {
            String _userTrustedLibrariesFilename = Config.getUserTrustedLibrariesFile();
            String _systemTrustedLibrariesFilename = Config.getSystemTrustedLibrariesFile();
            File userTrustedLibrariesFile = new File(_userTrustedLibrariesFilename);
            File systemTrustedLibrariesFile = new File(_systemTrustedLibrariesFilename);
            if (userTrustedLibrariesFile.exists()) {
                this.setup(userTrustedLibrariesFile);
                lastModified = userTrustedLibrariesFile.lastModified();
            }
            if (systemTrustedLibrariesFile.exists()) {
                this.setup(systemTrustedLibrariesFile);
                long tm = systemTrustedLibrariesFile.lastModified();
                if (tm > lastModified) {
                    lastModified = tm;
                }
            }
        }
        catch (IOException ioe) {
            throw new TrustedLibrariesSyntaxException(ioe);
        }
    }

    private TrustedLibraries(File file) {
        try {
            this.setup(file);
        }
        catch (IOException ioe) {
            throw new TrustedLibrariesSyntaxException(ioe);
        }
    }

    private void setup(final File file) throws IOException {
        try (BufferedReader br = null;){
            FileInputStream fis = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws Exception {
                    return new FileInputStream(file);
                }
            });
            br = new BufferedReader(new InputStreamReader(fis));
            this.parse(br);
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    private void setupTokenizer(StreamTokenizer st) {
        st.resetSyntax();
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.wordChars(48, 57);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        st.wordChars(95, 95);
        st.wordChars(43, 43);
        st.wordChars(47, 47);
        st.whitespaceChars(0, 32);
        st.commentChar(35);
        st.eolIsSignificant(true);
    }

    private void parse(Reader r) throws IOException {
        int token;
        StreamTokenizer st = new StreamTokenizer(r);
        this.setupTokenizer(st);
        while ((token = st.nextToken()) != -1) {
            if (token == 10) continue;
            if (token != -3) {
                throw new IOException("Unexpected token: " + st);
            }
            String word = st.sval;
            if (word.toUpperCase(Locale.ENGLISH).endsWith(DIGEST_MANIFEST)) {
                this.parseJarEntry(st);
                continue;
            }
            throw new IOException("Unknown attribute `" + word + "', line " + st.lineno());
        }
    }

    private void parseColon(StreamTokenizer st) throws IOException {
        int token = st.nextToken();
        if (token != 58) {
            throw new IOException("Expected ':', read " + st);
        }
    }

    private void parseJarEntry(StreamTokenizer st) throws IOException {
        String attribute = st.sval;
        this.parseColon(st);
        String hash = null;
        st.wordChars(61, 61);
        int token = st.nextToken();
        if (token != -3) {
            throw new IOException("Unexpected value: " + st);
        }
        st.ordinaryChar(61);
        hash = st.sval;
        if (hash == null) {
            throw new IOException("hash must be specified");
        }
        this.entries.put(attribute.toUpperCase(Locale.ENGLISH) + hash, null);
    }

    public boolean contains(String attribute, String hash) {
        return this.entries.containsKey(attribute.toUpperCase(Locale.ENGLISH) + hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes readAttributes(JarFile f, JarEntry e) throws IOException {
        if (f.getJarEntry(e.getName()) == null) {
            return null;
        }
        final InputStream is = f.getInputStream(e);
        if (is == null) {
            return null;
        }
        try {
            Attributes attributes = AccessController.doPrivileged(new PrivilegedExceptionAction<Attributes>(){

                @Override
                public Attributes run() throws Exception {
                    Manifest mf = new Manifest(is);
                    return mf.getMainAttributes();
                }
            });
            return attributes;
        }
        catch (PrivilegedActionException privilegedActionException) {
        }
        finally {
            is.close();
        }
        return null;
    }

    public static boolean checkJarEntry(JarFile jar, JarEntry entry) throws IOException, GeneralSecurityException {
        if (INSTANCE == null || INSTANCE.isEmpty()) {
            return true;
        }
        if (!entry.getName().toUpperCase(Locale.ENGLISH).endsWith(".SF")) {
            return false;
        }
        Attributes mainAttrs = TrustedLibraries.readAttributes(jar, entry);
        if (mainAttrs == null) {
            return false;
        }
        Iterator<Object> iterAttr = mainAttrs.keySet().iterator();
        while (iterAttr.hasNext()) {
            Attributes.Name sha1AttrName;
            String hash;
            String key = iterAttr.next().toString();
            if (!key.toUpperCase(Locale.ENGLISH).endsWith(DIGEST_MANIFEST) || !INSTANCE.contains(key, hash = mainAttrs.getValue(sha1AttrName = new Attributes.Name(key)))) continue;
            Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.found");
            throw new GeneralSecurityException("trusted libraries list entry!");
        }
        Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.notfound");
        return false;
    }

    public static boolean checkJarFile(JarFile jar) throws IOException {
        if (INSTANCE == null || INSTANCE.isEmpty()) {
            Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.notexist");
            return false;
        }
        List<Object> digests = TrustedLibraries.getManifestDigests(jar);
        if (digests != null && digests.size() > 0) {
            try {
                Iterator<Object> itor = digests.iterator();
                while (itor.hasNext()) {
                    String hash;
                    String key = (String)itor.next();
                    if (!INSTANCE.contains(key, hash = (String)itor.next())) continue;
                    Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.found");
                    return true;
                }
                return false;
            }
            catch (NoSuchElementException itor) {
                // empty catch block
            }
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String uname = entry.getName().toUpperCase(Locale.ENGLISH);
            if (!uname.startsWith("META-INF/") && !uname.startsWith("/META-INF/")) continue;
            try {
                if (!TrustedLibraries.checkJarEntry(jar, entry)) continue;
                return false;
            }
            catch (GeneralSecurityException ge) {
                return true;
            }
        }
        Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.notsigned");
        return false;
    }

    public static boolean hasBeenModifiedSince(long tm) {
        return INSTANCE != null && lastModified >= tm;
    }

    private static List<Object> getManifestDigests(JarFile jar) {
        try {
            DeployJavaUtilJarAccess access = DeployJavaUtilJarAccess.instance();
            return access.getManifestDigests(jar);
        }
        catch (NoSuchMethodError e) {
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            return null;
        }
    }

    static {
        if (Config.getBooleanProperty("deployment.security.blacklist.check")) {
            Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.enabled");
            INSTANCE = new TrustedLibraries();
        }
    }
}

