/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xml;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.xml.XMLAttribute;
import com.sun.deploy.xml.XMLNode;
import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler {
    private XMLNode _root;
    private String _source;
    private Stack<XMLNode> _inProgress;
    private String _characters;
    private static final String DTD_DOWNLOAD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static SAXParserFactory spf = SAXParserFactory.newInstance();

    public XMLParser(String source) {
        this._source = source.trim();
        Trace.println("XMLParser with _source:\n" + this._source, TraceLevel.BASIC);
    }

    public XMLNode parse() throws SAXException {
        return this.parse(false);
    }

    public XMLNode parse(boolean validating) throws SAXException {
        this._root = null;
        this._inProgress = new Stack();
        try {
            InputSource is = new InputSource(new StringReader(this._source));
            spf.setValidating(validating);
            try {
                spf.setFeature(DTD_DOWNLOAD, validating);
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
            SAXParser sp = spf.newSAXParser();
            sp.parse(is, (DefaultHandler)this);
        }
        catch (ParserConfigurationException pce) {
            Trace.ignored(pce);
            throw new SAXException(pce);
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
            throw new SAXException(ioe);
        }
        return this._root;
    }

    @Override
    public void startElement(String uri, String localeName, String qName, Attributes attributes) throws SAXException {
        XMLAttribute first = null;
        XMLAttribute last = null;
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            XMLAttribute att = new XMLAttribute(attributes.getQName(i).trim(), attributes.getValue(i).trim());
            if (first == null) {
                first = att;
            }
            if (last != null) {
                last.setNext(att);
            }
            last = att;
        }
        this._inProgress.push(new XMLNode(qName, first));
        this._characters = null;
    }

    @Override
    public void endElement(String uri, String localeName, String elementName) throws SAXException {
        String trimCharacters;
        XMLNode node = this._inProgress.pop();
        if (node != null && node.getNested() != null && this._characters != null && ((trimCharacters = this._characters.trim()) == null || trimCharacters.length() == 0)) {
            this._characters = null;
        }
        if (this._characters != null && this._characters.trim().length() > 0) {
            this.addChild(node, new XMLNode(this._characters));
        }
        if (this._inProgress.isEmpty()) {
            this._root = node;
        } else {
            this.addChild(this._inProgress.peek(), node);
        }
        this._characters = null;
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        String s = new String(chars, start, length);
        this._characters = this._characters == null ? s : this._characters + s;
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
        String s = new String(chars, start, length);
        this._characters = this._characters == null ? s : this._characters + s;
    }

    private void addChild(XMLNode parent, XMLNode child) {
        child.setParent(parent);
        XMLNode sibling = parent.getNested();
        if (sibling == null) {
            parent.setNested(child);
        } else {
            while (sibling.getNext() != null) {
                sibling = sibling.getNext();
            }
            sibling.setNext(child);
        }
    }
}

