/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.javascript;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.plugin.javascript.JSClassLoader;

public class ReflectUtil {
    public static Method[] getJScriptMethods(Class<?> cls) {
        boolean done;
        ArrayList<Method> m = new ArrayList<Method>();
        HashMap<String, Method> sigs = new HashMap<String, Method>();
        while (cls != null && !(done = ReflectUtil.getPublicMethods(cls, m, sigs))) {
            ReflectUtil.getJScriptInterfaceMethods(cls, m, sigs);
            cls = cls.getSuperclass();
        }
        return m.toArray(new Method[m.size()]);
    }

    private static void getJScriptInterfaceMethods(Class<?> cls, List<Method> m, Map<String, Method> sigs) {
        Class<?>[] intfs;
        for (Class<?> intf1 : intfs = cls.getInterfaces()) {
            Class<?> intf = intf1;
            boolean done = ReflectUtil.getPublicMethods(intf, m, sigs);
            if (done) continue;
            ReflectUtil.getJScriptInterfaceMethods(intf, m, sigs);
        }
    }

    private static boolean getPublicMethods(Class<?> cls, List<Method> m, Map<String, Method> sigs) {
        Class<?> dc;
        Method[] methods = null;
        try {
            if (!Modifier.isPublic(cls.getModifiers())) {
                return false;
            }
            if (!JSClassLoader.isPackageAccessible(cls)) {
                return false;
            }
            methods = cls.getMethods();
        }
        catch (SecurityException se) {
            return false;
        }
        boolean done = true;
        for (Method method : methods) {
            dc = method.getDeclaringClass();
            if (Modifier.isPublic(dc.getModifiers())) continue;
            done = false;
            break;
        }
        if (sigs.isEmpty() && !m.isEmpty()) {
            ReflectUtil.initSignatureMap(m, sigs);
        }
        if (done) {
            for (Method method : methods) {
                ReflectUtil.addMethod(m, sigs, method);
            }
        } else {
            for (Method method : methods) {
                dc = method.getDeclaringClass();
                if (!cls.equals(dc)) continue;
                ReflectUtil.addMethod(m, sigs, method);
            }
        }
        return done;
    }

    private static void initSignatureMap(List<Method> m, Map<String, Method> sigs) {
        for (Method entry : m) {
            sigs.put(ReflectUtil.getSignature(entry), entry);
        }
    }

    private static void addMethod(List<Method> m, Map<String, Method> sigs, Method method) {
        if (sigs.isEmpty()) {
            m.add(method);
            return;
        }
        String signature = ReflectUtil.getSignature(method);
        if (!sigs.containsKey(signature)) {
            m.add(method);
            sigs.put(signature, method);
        }
    }

    private static String getSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName());
        Class<?>[] params = method.getParameterTypes();
        sb.append('(');
        if (params.length > 0) {
            sb.append(params[0].getName());
        }
        for (int i = 1; i < params.length; ++i) {
            sb.append(',');
            sb.append(params[i].getName());
        }
        sb.append(')');
        return sb.toString();
    }

    public static Field[] getJScriptFields(Class<?> cls) {
        boolean done;
        ArrayList<Field> m = new ArrayList<Field>();
        HashMap<String, Field> names = new HashMap<String, Field>();
        while (cls != null && !(done = ReflectUtil.getPublicFields(cls, m, names))) {
            ReflectUtil.getJScriptInterfaceFields(cls, m, names);
            cls = cls.getSuperclass();
        }
        return m.toArray(new Field[m.size()]);
    }

    private static void getJScriptInterfaceFields(Class<?> cls, List<Field> m, Map<String, Field> names) {
        Class<?>[] intfs;
        for (Class<?> intf1 : intfs = cls.getInterfaces()) {
            Class<?> intf = intf1;
            boolean done = ReflectUtil.getPublicFields(intf, m, names);
            if (done) continue;
            ReflectUtil.getJScriptInterfaceFields(intf, m, names);
        }
    }

    private static boolean getPublicFields(Class<?> cls, List<Field> m, Map<String, Field> names) {
        Class<?> dc;
        Field[] fields = null;
        try {
            if (!Modifier.isPublic(cls.getModifiers())) {
                return false;
            }
            if (!JSClassLoader.isPackageAccessible(cls)) {
                return false;
            }
            fields = cls.getFields();
        }
        catch (SecurityException se) {
            return false;
        }
        boolean done = true;
        for (Field field : fields) {
            dc = field.getDeclaringClass();
            if (Modifier.isPublic(dc.getModifiers())) continue;
            done = false;
            break;
        }
        if (done) {
            for (Field field : fields) {
                ReflectUtil.addField(m, names, field);
            }
        } else {
            for (Field field : fields) {
                dc = field.getDeclaringClass();
                if (!cls.equals(dc)) continue;
                ReflectUtil.addField(m, names, field);
            }
        }
        return done;
    }

    private static void addField(List<Field> m, Map<String, Field> names, Field field) {
        String name = field.getName();
        if (!names.containsKey(name)) {
            m.add(field);
            names.put(name, field);
        }
    }
}

