/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import sun.net.ProgressEvent;
import sun.net.ProgressListener;
import sun.net.ProgressSource;
import sun.plugin.util.EventMulticaster;

public class ProgressMonitor
extends sun.net.ProgressMonitor {
    private final ArrayList<ProgressSource> progressSourceList = new ArrayList();
    private final HashMap<Integer, ProgressListener> threadGroupListenerMap = new HashMap();
    private static volatile Method progressSourceGetProgressMethod;
    private static volatile Method progressSourceGetExpectedMethod;
    private static volatile Method progressEventGetProgressMethod;
    private static volatile Method progressEventGetExpectedMethod;
    private static volatile Constructor<?> progressEventCtor;
    private static volatile boolean usingLongs;
    private static ProgressMonitor instance;
    private static boolean isInstalled;

    private ProgressMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProgressSource> getProgressSources() {
        ArrayList<ProgressSource> snapshot = new ArrayList<ProgressSource>();
        try {
            ArrayList<ProgressSource> arrayList = this.progressSourceList;
            synchronized (arrayList) {
                for (ProgressSource pi : this.progressSourceList) {
                    snapshot.add((ProgressSource)pi.clone());
                }
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return snapshot;
    }

    public int getProgressUpdateThreshold() {
        return 65536;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldMeterInput(URL url, String method) {
        Thread t = Thread.currentThread();
        ThreadGroup tg = t.getThreadGroup();
        ProgressListener listener = null;
        HashMap<Integer, ProgressListener> hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            listener = this.threadGroupListenerMap.get(tg.hashCode());
        }
        if (listener == null) {
            return false;
        }
        String protocol = url.getProtocol();
        return (protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https") || protocol.equalsIgnoreCase("file")) && method.equalsIgnoreCase("GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSource(ProgressSource pi) {
        ArrayList<ProgressSource> arrayList = this.progressSourceList;
        synchronized (arrayList) {
            if (this.progressSourceList.contains(pi)) {
                return;
            }
            this.progressSourceList.add(pi);
        }
        Thread t = Thread.currentThread();
        ThreadGroup tg = t.getThreadGroup();
        ProgressListener listener = null;
        HashMap<Integer, ProgressListener> hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            listener = this.threadGroupListenerMap.get(tg.hashCode());
        }
        if (listener != null) {
            ProgressEvent pe = ProgressMonitor.newProgressEvent(pi);
            listener.progressStart(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSource(ProgressSource pi) {
        ArrayList<ProgressSource> arrayList = this.progressSourceList;
        synchronized (arrayList) {
            if (!this.progressSourceList.contains(pi)) {
                return;
            }
            pi.close();
            this.progressSourceList.remove(pi);
        }
        Thread t = Thread.currentThread();
        ThreadGroup tg = t.getThreadGroup();
        ProgressListener listener = null;
        HashMap<Integer, ProgressListener> hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            listener = this.threadGroupListenerMap.get(tg.hashCode());
        }
        if (listener != null) {
            ProgressEvent pe = ProgressMonitor.newProgressEvent(pi);
            listener.progressFinish(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(ProgressSource pi) {
        ArrayList<ProgressSource> arrayList = this.progressSourceList;
        synchronized (arrayList) {
            if (!this.progressSourceList.contains(pi)) {
                return;
            }
        }
        Thread t = Thread.currentThread();
        ThreadGroup tg = t.getThreadGroup();
        ProgressListener listener = null;
        HashMap<Integer, ProgressListener> hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            listener = this.threadGroupListenerMap.get(tg.hashCode());
        }
        if (listener != null) {
            ProgressEvent pe = ProgressMonitor.newProgressEvent(pi);
            listener.progressUpdate(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ThreadGroup tg, ProgressListener l) {
        Trace.msgPrintln((String)"progress.listener.added", (Object[])new Object[]{l}, (TraceLevel)TraceLevel.BASIC);
        ProgressMonitor.install();
        Integer key = tg != null ? tg.hashCode() : 0;
        HashMap<Integer, ProgressListener> hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            ProgressListener listener = this.threadGroupListenerMap.get(key);
            listener = EventMulticaster.add(listener, l);
            this.threadGroupListenerMap.put(key, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ThreadGroup tg, ProgressListener l) {
        Trace.msgPrintln((String)"progress.listener.removed", (Object[])new Object[]{l}, (TraceLevel)TraceLevel.BASIC);
        HashMap<Integer, ProgressListener> hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            ProgressListener listener = this.threadGroupListenerMap.get(tg.hashCode());
            listener = EventMulticaster.remove(listener, l);
            if (listener != null) {
                this.threadGroupListenerMap.put(tg.hashCode(), listener);
            } else {
                this.threadGroupListenerMap.remove(tg.hashCode());
            }
        }
    }

    public static long getProgress(ProgressEvent event) {
        if (progressEventGetProgressMethod == null) {
            progressEventGetProgressMethod = ProgressMonitor.getProgressEventMethod("getProgress");
        }
        try {
            return ((Number)progressEventGetProgressMethod.invoke((Object)event, (Object[])null)).longValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long getExpected(ProgressEvent event) {
        if (progressEventGetExpectedMethod == null) {
            progressEventGetExpectedMethod = ProgressMonitor.getProgressEventMethod("getExpected");
        }
        try {
            return ((Number)progressEventGetExpectedMethod.invoke((Object)event, (Object[])null)).longValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getProgressSourceMethod(final String method) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return ProgressSource.class.getDeclaredMethod(method, new Class[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static long getProgress(ProgressSource source) {
        if (progressSourceGetProgressMethod == null) {
            progressSourceGetProgressMethod = ProgressMonitor.getProgressSourceMethod("getProgress");
        }
        try {
            return ((Number)progressSourceGetProgressMethod.invoke((Object)source, (Object[])null)).longValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static long getExpected(ProgressSource source) {
        if (progressSourceGetExpectedMethod == null) {
            progressSourceGetExpectedMethod = ProgressMonitor.getProgressSourceMethod("getExpected");
        }
        try {
            return ((Number)progressSourceGetExpectedMethod.invoke((Object)source, (Object[])null)).longValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getProgressEventMethod(final String method) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return ProgressEvent.class.getDeclaredMethod(method, new Class[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static Constructor<?> getProgressEventConstructor(boolean useLongs) {
        try {
            return ProgressEvent.class.getDeclaredConstructor(ProgressSource.class, URL.class, String.class, String.class, ProgressSource.State.class, useLongs ? Long.TYPE : Integer.TYPE, useLongs ? Long.TYPE : Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static ProgressEvent newProgressEvent(ProgressSource source) {
        if (progressEventCtor == null) {
            progressEventCtor = (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() {
                    try {
                        Constructor c = ProgressMonitor.getProgressEventConstructor(true);
                        if (c != null) {
                            usingLongs = true;
                        } else {
                            c = ProgressMonitor.getProgressEventConstructor(false);
                        }
                        return c;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        long progress = ProgressMonitor.getProgress(source);
        long expected = ProgressMonitor.getExpected(source);
        Number progressBox = null;
        Number expectedBox = null;
        if (usingLongs) {
            progressBox = progress;
            expectedBox = expected;
        } else {
            progressBox = (int)progress;
            expectedBox = (int)expected;
        }
        try {
            return (ProgressEvent)progressEventCtor.newInstance(source, source.getURL(), source.getMethod(), source.getContentType(), source.getState(), progressBox, expectedBox);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void warmup() {
        ProgressMonitor.install();
    }

    private static synchronized void install() {
        Trace.println((String)("Installing progress monitor " + isInstalled), (TraceLevel)TraceLevel.PRELOADER);
        try {
            if (!isInstalled) {
                sun.net.ProgressMonitor.setDefault((sun.net.ProgressMonitor)instance);
            }
        }
        catch (Throwable e) {
            Trace.ignored((Throwable)e);
        }
        isInstalled = true;
    }

    public static ProgressMonitor get() {
        return instance;
    }

    static ProgressEvent unusedCreateProgressEvent(ProgressSource source) {
        return new ProgressEvent(source, source.getURL(), source.getMethod(), source.getContentType(), source.getState(), source.getProgress(), source.getExpected());
    }

    static {
        instance = new ProgressMonitor();
        isInstalled = false;
    }
}

