/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.security.JNLPSignedResourcesHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import sun.net.www.ParseUtil;
import sun.plugin2.applet.Applet2Manager;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;

public class Applet2ClassLoader
extends Plugin2ClassLoader {
    private static final boolean DEBUG = Config.getDebug();
    private Object syncResourceAsStream = new Object();
    private Object syncResourceAsStreamFromJar = new Object();
    private boolean resourceAsStreamInCall = false;
    private boolean resourceAsStreamFromJarInCall = false;
    private boolean processingException = false;

    private Applet2ClassLoader(URL base) {
        super(new URL[0], base);
    }

    private Applet2ClassLoader(URL base, ClassLoader parent) {
        super(new URL[0], base, parent);
    }

    public static Applet2ClassLoader newInstance(URL base) {
        Applet2ClassLoader parent = new Applet2ClassLoader(base);
        Applet2ClassLoader child = new Applet2ClassLoader(base, (ClassLoader)((Object)parent));
        if (!Plugin2ClassLoader.setDeployURLClassPathCallbacks(parent, child)) {
            return parent;
        }
        return child;
    }

    @Override
    public AppInfo getAppInfo(URL u) {
        Plugin2Manager man = Plugin2Manager.getCurrentManager();
        AppInfo appInfo = man instanceof Applet2Manager ? ((Applet2Manager)man).getAppInfo() : new AppInfo();
        if (u != null) {
            appInfo.setFrom(u);
        }
        return appInfo;
    }

    private int getPermissionRequestType() {
        Plugin2Manager man = Plugin2Manager.getCurrentManager();
        if (man instanceof Applet2Manager) {
            return ((Applet2Manager)man).getPermissionRequestType();
        }
        return 0;
    }

    @Override
    public boolean wantsAllPerms(CodeSource cs) {
        int mode = this.getPermissionRequestType();
        if (mode == 2) {
            return true;
        }
        if (mode == 1) {
            return false;
        }
        if (cs == null || cs.getCertificates() == null) {
            return false;
        }
        String version = (String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + cs.getLocation().toString()));
        int modeInJar = DeployManifestChecker.getPermissionRequestType((URL)cs.getLocation(), (String)version);
        return modeInJar != 1;
    }

    public URL[] getURLs() {
        URL[] jars = super.getURLs();
        URL[] urls = new URL[jars.length + 1];
        System.arraycopy(jars, 0, urls, 0, jars.length);
        urls[urls.length - 1] = this.base;
        return urls;
    }

    public String toString() {
        return "Applet2ClassLoader{" + Arrays.asList(this.getURLs()) + "}";
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, false);
    }

    @Override
    protected Class<?> findClass(String name, boolean delegated) throws ClassNotFoundException {
        try {
            return this.findClassHelper(name);
        }
        catch (ClassNotFoundException e) {
            if (e.getCause() instanceof JARSigningException) {
                throw e;
            }
            ClassNotFoundException exc = (ClassNotFoundException)cnfeThreadLocal.get();
            if (exc != null) {
                cnfeThreadLocal.set(null);
            }
            if (!this.getCodebaseLookup()) {
                if (exc != null) {
                    throw exc;
                }
                throw new ClassNotFoundException(name);
            }
            final CodeSource[] actualCodeSource = new CodeSource[1];
            String encodedName = this.parseUtilEncodePath(name.replace('.', '/'), false);
            AppContext ac = this.getAppContext();
            Object obj = null;
            String cookie = "";
            if (ac != null && (obj = ac.get((Object)("applet-code-rewrite-" + name))) != null) {
                cookie = obj.toString();
            }
            final String path = new StringBuffer(encodedName).append(".class").append(cookie).toString();
            try {
                byte[] b = AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws IOException, SecurityException {
                        try {
                            URL finalURL = new URL(Applet2ClassLoader.this.base, path);
                            if (!URLUtil.checkTargetURL((URL)Plugin2Manager.getCurrentManager().getDocumentBase(), (URL)finalURL)) {
                                throw new SecurityException("Permission denied: " + finalURL);
                            }
                            if (!URLUtil.checkTargetURL((URL)Applet2ClassLoader.this.base, (URL)finalURL)) {
                                throw new SecurityException("Permission denied: " + finalURL);
                            }
                            if (Applet2ClassLoader.this.base.getProtocol().equals(finalURL.getProtocol()) && Applet2ClassLoader.this.base.getHost().equals(finalURL.getHost()) && Applet2ClassLoader.this.base.getPort() == finalURL.getPort()) {
                                return Applet2ClassLoader.getBytes(finalURL, actualCodeSource);
                            }
                            return null;
                        }
                        catch (Exception e) {
                            if (e instanceof SecurityException) {
                                throw (SecurityException)e;
                            }
                            return null;
                        }
                    }
                }, this._acc);
                if (b != null) {
                    CodeSource cs = actualCodeSource[0] != null ? actualCodeSource[0] : this.codesource;
                    try {
                        if (this.getSecurityCheck() && TrustDecider.isAllPermissionGranted((CodeSource)cs, (AppInfo)this.getAppInfo(cs.getLocation()), (DeploymentRuleSet)this.getDeploymentRuleSet(cs.getLocation()), (Preloader)this.getPreloader()) == 0L) {
                            throw new ClassNotFoundException(name);
                        }
                    }
                    catch (Exception ex) {
                        throw Applet2ClassLoader.newClassNotFoundException(name);
                    }
                    this.checkResource(name.replace('.', '/') + ".class");
                    return this.defineClass(name, b, 0, b.length, cs);
                }
                if (exc != null) {
                    throw exc;
                }
                throw new ClassNotFoundException(name);
            }
            catch (PrivilegedActionException e2) {
                if (exc != null) {
                    throw exc;
                }
                throw new ClassNotFoundException(name, e2.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String name) {
        InputStream is;
        block13: {
            if (name == null) {
                throw new NullPointerException("name");
            }
            is = null;
            try {
                Object object = this.syncResourceAsStream;
                synchronized (object) {
                    this.resourceAsStreamInCall = true;
                    is = super.getResourceAsStream(name);
                    this.resourceAsStreamInCall = false;
                    if (is != null) {
                        return is;
                    }
                }
                if (this.getCodebaseLookup()) {
                    URL url = new URL(this.base, this.parseUtilEncodePath(name, false));
                    if (!URLUtil.checkTargetURL((URL)this.base, (URL)url)) {
                        throw new SecurityException("Permission denied: " + url);
                    }
                    is = url.openStream();
                    this.checkResource(name);
                    CodeSource cs = new CodeSource(url, (CodeSigner[])null);
                    if (this.getResourcePermission(cs, this.wantsAllPerms(cs), this.getAppInfo(cs.getLocation()), this.getDeploymentRuleSet(cs.getLocation()), this.getPreloader(), true)) {
                        return is;
                    }
                }
            }
            catch (Exception e) {
                if (name != null && name.endsWith(".properties")) break block13;
                Trace.ignored((Throwable)e);
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (name.startsWith("META-INF/")) {
            return url;
        }
        if (url == null) {
            if (!this.getCodebaseLookup()) {
                return url;
            }
            boolean insideGetResourceAsStreamFromJar = false;
            Object object = this.syncResourceAsStreamFromJar;
            synchronized (object) {
                insideGetResourceAsStreamFromJar = this.resourceAsStreamFromJarInCall;
            }
            if (insideGetResourceAsStreamFromJar) {
                return null;
            }
            boolean insideGetResourceAsStream = false;
            Object object2 = this.syncResourceAsStream;
            synchronized (object2) {
                insideGetResourceAsStream = this.resourceAsStreamInCall;
            }
            if (!insideGetResourceAsStream) {
                try {
                    url = new URL(this.base, this.parseUtilEncodePath(name, false));
                    if (!URLUtil.checkTargetURL((URL)this.base, (URL)url)) {
                        throw new SecurityException("Permission denied: " + url);
                    }
                    if (!this.resourceExists(url)) {
                        url = null;
                    } else {
                        this.checkResource(name);
                    }
                }
                catch (Exception e) {
                    url = null;
                }
            }
        }
        return url;
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        final Enumeration e = super.findResources(name);
        if (name.startsWith("META-INF/")) {
            return e;
        }
        if (!this.getCodebaseLookup()) {
            return e;
        }
        URL u = new URL(this.base, this.parseUtilEncodePath(name, false));
        if (!URLUtil.checkTargetURL((URL)this.base, (URL)u)) {
            throw new SecurityException("Permission denied: " + u);
        }
        if (!this.resourceExists(u)) {
            u = null;
        } else {
            try {
                this.checkResource(name);
            }
            catch (Exception ex) {
                u = null;
            }
        }
        final URL url = u;
        return new Enumeration<URL>(){
            private boolean done;

            @Override
            public URL nextElement() {
                if (!this.done) {
                    if (e.hasMoreElements()) {
                        return (URL)e.nextElement();
                    }
                    this.done = true;
                    if (url != null) {
                        return url;
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return !this.done && (e.hasMoreElements() || url != null);
            }
        };
    }

    protected void addJar(String name) throws IOException {
        URL url;
        if (name == null || name.equals("")) {
            return;
        }
        if (DEBUG) {
            System.out.println("Applet2ClassLoader: addJar:  base " + this.base + " jar: " + name);
        }
        try {
            url = new URL(this.base, name);
            if (!URLUtil.checkTargetURL((URL)this.base, (URL)url)) {
                throw new SecurityException("Permission denied: " + url);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("name");
        }
        this.addURL(url);
    }

    void addLocalJar(URL url) {
        this.addURL(url, true);
    }

    @Override
    public URL getBaseURL() {
        return this.base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStreamFromJar(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            InputStream is = null;
            Object object = this.syncResourceAsStreamFromJar;
            synchronized (object) {
                this.resourceAsStreamFromJarInCall = true;
                is = super.getResourceAsStream(name);
                this.resourceAsStreamFromJarInCall = false;
            }
            return is;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean resourceExists(URL url) {
        boolean ok = true;
        try {
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hconn = (HttpURLConnection)conn;
                hconn.setRequestMethod("HEAD");
                int code = hconn.getResponseCode();
                if (code == 200) {
                    return true;
                }
                if (code >= 400) {
                    return false;
                }
            } else {
                InputStream is = conn.getInputStream();
                is.close();
            }
        }
        catch (Exception ex) {
            ok = false;
        }
        return ok;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        try {
            String jarVersion = (String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + codesource.getLocation().toString()));
            Resource r = ResourceProvider.get().getCachedResource(codesource.getLocation(), jarVersion);
            if (r != null && r.isJarFile()) {
                byte[] jnlp = JNLPSignedResourcesHelper.getSignedJNLPBits((URL)codesource.getLocation(), (String)jarVersion, (boolean)true);
                if (jnlp != null) {
                    throw new SecurityException("JAR should not contain JNLP-INF/APPLICATION_TEMPLATE.JNLP");
                }
                jnlp = JNLPSignedResourcesHelper.getSignedJNLPBits((URL)codesource.getLocation(), (String)jarVersion, (boolean)false);
                if (jnlp != null) {
                    throw new SecurityException("JAR should not contain JNLP-INF/APPLICATION.JNLP");
                }
            }
        }
        catch (IOException ioe) {
            Trace.ignored((Throwable)ioe);
        }
        return super.getPermissions(codesource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(URL url, CodeSource[] actualCodeSource) throws IOException {
        byte[] b;
        HttpURLConnection huc;
        int code;
        URLConnection uc = url.openConnection();
        if (uc instanceof HttpURLConnection && (code = (huc = (HttpURLConnection)uc).getResponseCode()) >= 400) {
            throw new IOException("open HTTP connection failed:" + url);
        }
        try (BufferedInputStream in = new BufferedInputStream(uc.getInputStream());){
            int len;
            if (len != -1) {
                int n;
                b = new byte[len];
                for (len = uc.getContentLength(); len > 0; len -= n) {
                    n = ((InputStream)in).read(b, b.length - len, len);
                    if (n != -1) continue;
                    throw new IOException("unexpected EOF");
                }
            } else {
                byte[] tmp;
                b = new byte[8192];
                int total = 0;
                while ((len = ((InputStream)in).read(b, total, b.length - total)) != -1) {
                    if ((total += len) < b.length) continue;
                    tmp = new byte[total * 2];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
                if (total != b.length) {
                    tmp = new byte[total];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
            }
        }
        if (b != null) {
            URL finalURLFromCache;
            URL actual = uc.getURL();
            String version = (String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + url.toString()));
            Resource cachedResource = ResourceProvider.get().getCachedResource(url, version);
            if (cachedResource != null && !URLUtil.sameURLs((URL)(finalURLFromCache = new URL(cachedResource.getURL())), (URL)url)) {
                actual = finalURLFromCache;
            }
            if (!URLUtil.sameURLs((URL)actual, (URL)url)) {
                CodeSource cs;
                actualCodeSource[0] = cs = new CodeSource(actual, (Certificate[])null);
                DownloadEngine.addKnownRedirectHost((String)url.getHost(), (String)actual.getHost());
            }
        }
        return b;
    }

    private String parseUtilEncodePath(String name, boolean flag) {
        try {
            return ParseUtil.encodePath(name, flag);
        }
        catch (NoSuchMethodError e) {
            return ParseUtil.encodePath(name);
        }
    }

    public DeploymentRuleSet getDeploymentRuleSet(URL location) {
        Plugin2Manager pman = Plugin2Manager.getCurrentManager();
        if (!(pman instanceof Applet2Manager)) {
            return DeploymentRuleSet.getDefault();
        }
        Applet2Manager man = (Applet2Manager)pman;
        return man.getMainDeploymentRuleSet(location);
    }
}

