/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.FXLoader;
import com.sun.deploy.util.NativeLibraryBundle;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.ClipboardServiceImpl;
import com.sun.jnlp.DownloadService2Impl;
import com.sun.jnlp.DownloadServiceImpl;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.IntegrationServiceImpl;
import com.sun.jnlp.IntegrationServiceNSBImpl;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.PersistenceServiceImpl;
import com.sun.jnlp.PrintServiceImpl;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadService2;
import javax.jnlp.ExtendedService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.IntegrationService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.SingleInstanceService;
import sun.plugin2.applet.Plugin2BasicService;
import sun.plugin2.applet.Plugin2ClassLoader;

public final class JNLP2ClassLoader
extends Plugin2ClassLoader
implements JNLPClassLoaderIf {
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy;
    private boolean _initialized = false;
    private Map<String, JARDesc> _jarsInURLClassLoader = new HashMap<String, JARDesc>();
    private ArrayList<JARDesc> _jarsNotInURLClassLoader = new ArrayList();
    private NativeLibraryBundle nativeLibraries = null;
    private JNLP2ClassLoader _jclParent;
    private boolean processingException = false;
    BasicService _basicService = null;

    protected JNLP2ClassLoader(URL base, ClassLoader parent) {
        super(new URL[0], base, parent);
        if (parent instanceof JNLP2ClassLoader) {
            this._jclParent = (JNLP2ClassLoader)((Object)parent);
        }
        if (DEBUG) {
            Trace.println((String)"JNLP2ClassLoader: cstr ...", (TraceLevel)TraceLevel.BASIC);
        }
    }

    @Override
    boolean isClassLoadedByPluginClassLoader(Class<?> cls) {
        ClassLoader clUsed = cls.getClassLoader();
        if (this.isShadowClassLoader() && this._jclParent != null) {
            return clUsed == this || clUsed == this._jclParent;
        }
        return clUsed == this;
    }

    @Override
    public boolean wantsAllPerms(CodeSource cs) {
        LaunchDesc ld;
        JARDesc jd;
        return cs != null && ((jd = this.getJarDescFromURL(cs.getLocation())) != null && jd.getParent() != null ? (ld = jd.getParent().getParent()) != null && ld.getSecurityModel() != 0 : cs.getCertificates() != null && this._launchDesc != null && this._launchDesc.getSecurityModel() != 0);
    }

    protected void initialize(LaunchDesc launchDesc, AppPolicy appPolicy) {
        if (DEBUG) {
            Trace.println((String)"JNLP2ClassLoader: initialize ...", (TraceLevel)TraceLevel.BASIC);
        }
        this._launchDesc = launchDesc;
        this._appPolicy = appPolicy;
        this._initialized = true;
        if (this._launchDesc.getCodebase() != null) {
            this.base = this._launchDesc.getCodebase();
        }
        if (this._jclParent != null) {
            this._jclParent.initialize(launchDesc, appPolicy);
            this.drainPendingURLs();
            return;
        }
        if (launchDesc.needFX()) {
            try {
                FXLoader.loadFX();
            }
            catch (Throwable t) {
                Trace.ignored((Throwable)t);
            }
        }
        ResourcesDesc rd = launchDesc.getResources();
        ArrayList jarsInClassLoader = new ArrayList();
        if (rd != null) {
            JNLPUtils.sortResourcesForClasspath((ResourcesDesc)rd, jarsInClassLoader, this._jarsNotInURLClassLoader);
            for (JARDesc jd : jarsInClassLoader) {
                if (DEBUG) {
                    Trace.println((String)("\t addURL: " + jd.getLocationString()), (TraceLevel)TraceLevel.BASIC);
                }
                this._jarsInURLClassLoader.put(URLUtil.toNormalizedString((URL)jd.getLocation()), jd);
                this.addURL2(jd.getLocation());
            }
        }
        if (DEBUG) {
            Trace.println((String)"JNLP2ClassLoader: initialize done", (TraceLevel)TraceLevel.BASIC);
        }
    }

    public URL getResource(String name) {
        URL resource = null;
        for (int i = 0; resource == null && i < 3; ++i) {
            resource = super.getResource(name);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findLibrary0(String name) {
        JARDesc[] jars;
        Trace.println((String)("JNLP2ClassLoader.findLibrary: Looking up native library: " + name), (TraceLevel)TraceLevel.BASIC);
        JNLP2ClassLoader jNLP2ClassLoader = this;
        synchronized (jNLP2ClassLoader) {
            if (this.nativeLibraries != null) {
                String fullPath = this.nativeLibraries.get(name);
                if (fullPath != null) {
                    Trace.println((String)("JNLP2ClassLoader.findLibrary: native library found: " + fullPath), (TraceLevel)TraceLevel.BASIC);
                    return fullPath;
                }
            } else {
                this.nativeLibraries = new NativeLibraryBundle();
            }
        }
        ResourcesDesc rd = this._launchDesc.getResources();
        for (JARDesc jar : jars = rd.getEagerOrAllJarDescs(true)) {
            if (!jar.isNativeLib()) continue;
            try {
                String dir = ResourceProvider.get().getLibraryDirForJar(name, jar.getLocation(), jar.getVersion());
                if (dir == null) continue;
                JarFile jf = ResourceProvider.get().getCachedJarFile(jar.getLocation(), jar.getVersion());
                this.nativeLibraries.prepareLibrary(name, jf, dir);
                String fullPath = this.nativeLibraries.get(name);
                Trace.println((String)("JNLP2ClassLoader.findLibrary: native library found: " + fullPath), (TraceLevel)TraceLevel.BASIC);
                return fullPath;
            }
            catch (IOException ioe) {
                Trace.ignoredException((Exception)ioe);
            }
        }
        return null;
    }

    protected String findLibrary(String name) {
        if (this._jclParent != null) {
            return this._jclParent.findLibrary(name);
        }
        if (!this._initialized) {
            Trace.println((String)("JNLP2ClassLoader.findLibrary: " + name + ": not initialized -> super()"), (TraceLevel)TraceLevel.BASIC);
            return super.findLibrary(name);
        }
        Object libName = System.mapLibraryName(name);
        String path = this.findLibrary0((String)libName);
        if (path != null) {
            return path;
        }
        if (OSType.isMac() && (path = this.findLibrary0((String)(libName = "lib" + name + ".jnilib"))) != null) {
            return path;
        }
        Trace.println((String)("JNLP2ClassLoader: Native library " + name + " not found"), (TraceLevel)TraceLevel.BASIC);
        return super.findLibrary(name);
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException("can't happen");
    }

    @Override
    protected Class<?> findClass(String name, boolean delegated) throws ClassNotFoundException {
        if (!this._initialized) {
            Trace.println((String)("JNLP2ClassLoader.findClass: " + name + ": not initialized -> super()"), (TraceLevel)TraceLevel.BASIC);
            return super.findClass(name);
        }
        try {
            return this.findClassHelper(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.checkPackageParts(name)) {
                return this.findClassHelper(name);
            }
            throw cnfe;
        }
    }

    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (!this._initialized) {
            Trace.println((String)("JNLP2ClassLoader.findResource: " + name + ": not initialized -> super()"), (TraceLevel)TraceLevel.BASIC);
            return url;
        }
        if (url == null && this.checkPackageParts(name)) {
            url = super.findResource(name);
        }
        return url;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        JarFile jf;
        Trace.println((String)"JNLP2ClassLoader.getPermissions()", (TraceLevel)TraceLevel.BASIC);
        PermissionCollection perms = super.getPermissions(codesource);
        boolean addPerms = !perms.implies(new AllPermission());
        try {
            this._appPolicy.addPermissions((JNLPClassLoaderIf)this, perms, codesource, addPerms);
        }
        catch (ExitException ee) {
            Trace.println((String)("_appPolicy.addPermissions: " + ee), (TraceLevel)TraceLevel.BASIC);
            throw new BlockedException(null, (Throwable)ee);
        }
        URL url = codesource.getLocation();
        SecureStaticVersioning.checkVersionAllowed((DeploymentRuleSet)this.getDeploymentRuleSet(url));
        JARDesc jd = this.getJarDescFromURL(url);
        if (jd != null && (jf = ResourceProvider.get().getCachedJarFile(jd.getLocation(), jd.getVersion())) != null) {
            String jarPath = jf.getName();
            perms.add(new FilePermission(jarPath, "read"));
        }
        Trace.println((String)"JNLP2ClassLoader.getPermissions() X", (TraceLevel)TraceLevel.BASIC);
        return perms;
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    public JARDesc getJarDescFromURL(URL url) {
        if (this._jclParent != null) {
            return this._jclParent.getJarDescFromURL(url);
        }
        String queryURL = URLUtil.toNormalizedString((URL)url);
        JARDesc jd = this._jarsInURLClassLoader.get(queryURL);
        if (jd != null) {
            return jd;
        }
        HashMap<String, JARDesc> newURLs = new HashMap<String, JARDesc>();
        for (String u : this._jarsInURLClassLoader.keySet()) {
            jd = this._jarsInURLClassLoader.get(u);
            String redirectFinal = URLUtil.toNormalizedString((URL)DownloadEngine.getKnownRedirectFinalURL((URL)jd.getLocation()));
            if (this._jarsInURLClassLoader.containsKey(redirectFinal)) continue;
            newURLs.put(redirectFinal, jd);
            if (!queryURL.equals(redirectFinal)) continue;
            this._jarsInURLClassLoader.putAll(newURLs);
            return jd;
        }
        this._jarsInURLClassLoader.putAll(newURLs);
        return null;
    }

    public JarFile getJarFile(URL url) throws IOException {
        final JARDesc jd = this.getJarDescFromURL(url);
        JarFile jf = null;
        if (jd != null) {
            final int contentType = LaunchDownload.getDownloadType((JARDesc)jd);
            jf = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public JarFile run() throws SecurityException {
                    int level = ResourceProvider.get().incrementInternalUse();
                    try {
                        JarFile jf;
                        Resource r = ResourceProvider.get().getResource(jd.getLocation(), jd.getVersion(), true, contentType, null);
                        JarFile jarFile = jf = r != null ? r.getJarFile() : null;
                        if (jf != null) {
                            JarFile jarFile2 = jf;
                            return jarFile2;
                        }
                    }
                    catch (IOException ioe) {
                        Trace.ignoredException((Exception)ioe);
                    }
                    finally {
                        ResourceProvider.get().decrementInternalUse(level);
                    }
                    return null;
                }
            });
            if (jf == null) {
                throw new IOException("Resource not found: " + jd.getLocation() + ":" + jd.getVersion());
            }
            return jf;
        }
        return null;
    }

    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    private boolean checkPackageParts(String name) {
        boolean ret = false;
        if (this._jclParent != null) {
            return this.drainPendingURLs();
        }
        try {
            JARDesc[] jds = null;
            ResourcesDesc resources = this._launchDesc.getResources();
            ResourcesDesc.PackageInformation pi = resources.getPackageInformation(name);
            if (pi != null) {
                jds = pi.getLaunchDesc().getResources().getPart(pi.getPart());
            }
            if (jds != null) {
                for (JARDesc jd : jds) {
                    String u = jd.getLocationString();
                    if (!this._jarsNotInURLClassLoader.contains(jd)) continue;
                    this._jarsNotInURLClassLoader.remove(jd);
                    if (this._jarsInURLClassLoader.containsKey(u)) continue;
                    this._jarsInURLClassLoader.put(u, jd);
                    this.addURL2(jd.getLocation());
                    ret = true;
                }
            }
        }
        catch (Exception e) {
            Trace.ignoredException((Exception)e);
        }
        return ret;
    }

    protected void updateJarDescriptors(ResourcesDesc rd) {
        if (this._jclParent != null) {
            this._jclParent.updateJarDescriptors(rd);
            this.drainPendingURLs();
            return;
        }
        JARDesc[] jds = rd.getEagerOrAllJarDescs(true);
        if (jds != null) {
            for (JARDesc jd : jds) {
                this.updateJarDescriptor(rd, jd);
            }
        }
    }

    protected void updateJarDescriptor(ResourcesDesc rd, JARDesc jd) {
        String u;
        if (jd != null && !this._jarsInURLClassLoader.containsKey(u = jd.getLocationString()) && !this._jarsNotInURLClassLoader.contains(jd)) {
            if (!jd.isLazyDownload() || !rd.isPackagePart(jd.getPartName())) {
                this._jarsInURLClassLoader.put(u, jd);
                this.addURL2(jd.getLocation());
            } else {
                this._jarsNotInURLClassLoader.add(jd);
            }
        }
    }

    public void addResource(URL resource, String version, String id) {
        if (this._jclParent != null) {
            this._jclParent.addResource(resource, version, id);
            this.drainPendingURLs();
            return;
        }
        JARDesc jd = new JARDesc(resource, version, true, false, false, null, 0, null);
        String u = jd.getLocationString();
        if (!this._jarsInURLClassLoader.containsKey(u)) {
            this._launchDesc.getResources().addResource((ResourceType)jd);
            this._jarsInURLClassLoader.put(u, jd);
            this.addURL2(resource);
        }
    }

    public BasicService getBasicService() {
        if (this._basicService == null) {
            URL codebase = this._launchDesc.getCodebase();
            if (codebase == null) {
                codebase = this.base;
            }
            this._basicService = new Plugin2BasicService(codebase);
        }
        return this._basicService;
    }

    public FileOpenService getFileOpenService() {
        return FileOpenServiceImpl.getInstance();
    }

    public FileSaveService getFileSaveService() {
        return FileSaveServiceImpl.getInstance();
    }

    public ExtensionInstallerService getExtensionInstallerService() {
        return ExtensionInstallerServiceImpl.getInstance();
    }

    public DownloadService getDownloadService() {
        return DownloadServiceImpl.getInstance();
    }

    public ClipboardService getClipboardService() {
        return ClipboardServiceImpl.getInstance();
    }

    public PrintService getPrintService() {
        return PrintServiceImpl.getInstance();
    }

    public PersistenceService getPersistenceService() {
        return PersistenceServiceImpl.getInstance();
    }

    public ExtendedService getExtendedService() {
        return ExtendedServiceImpl.getInstance();
    }

    public SingleInstanceService getSingleInstanceService() {
        return SingleInstanceServiceImpl.getInstance();
    }

    public IntegrationService getIntegrationService() {
        if (Platform.get().isNativeSandbox()) {
            return new IntegrationServiceNSBImpl(new IntegrationServiceImpl((JNLPClassLoaderIf)this));
        }
        return new IntegrationServiceImpl((JNLPClassLoaderIf)this);
    }

    public DownloadService2 getDownloadService2() {
        return DownloadService2Impl.getInstance();
    }

    @Override
    public AppInfo getAppInfo(URL u) {
        AppInfo ainfo = null;
        JARDesc jd = this.getJarDescFromURL(u);
        if (jd != null) {
            ResourcesDesc ld = jd.getParent();
            if (ld != null && ld.getParent() != null) {
                ainfo = ld.getParent().getAppInfo();
            }
        } else {
            ainfo = this._launchDesc != null ? this._launchDesc.getAppInfo() : new AppInfo();
        }
        return ainfo;
    }

    public DeploymentRuleSet getDeploymentRuleSet(URL location) {
        LaunchDesc ld;
        JARDesc jd = this.getJarDescFromURL(location);
        if (jd != null && jd.getParent() != null && (ld = jd.getParent().getParent()) != null) {
            CodeRef codeRef = new CodeRef(location, null, false, jd.isPack200Enabled());
            AppRef appRef = LaunchDesc.getJNLPAppRef((LaunchDesc)ld);
            return DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
        }
        URL anchor = this.getLaunchDesc() == null ? null : this.getLaunchDesc().getAnchorURL();
        boolean pack200Enabled = jd != null ? jd.isPack200Enabled() : false;
        CodeRef codeRef = new CodeRef(location, null, false, pack200Enabled);
        AppRef appRef = new AppRef(AppRef.Type.JNLP, null, null, null, anchor);
        return DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
    }
}

