/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.ipc.windows;

import com.sun.deploy.util.ByteBufferWrapper;
import com.sun.deploy.util.SystemUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import sun.plugin2.ipc.NamedPipe;
import sun.plugin2.os.windows.Windows;

public class WindowsNamedPipe
extends NamedPipe {
    private long writeHandle = -1L;
    private long readHandle = -1L;
    private String writeName;
    private String readName;
    private boolean iAmServer;
    private boolean connected;
    private IOException connectException;
    private boolean connectFailed;
    private boolean created;
    private RuntimeException createException;
    private boolean createFailed;
    private IntBuffer numReadBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
    private IntBuffer numWrittenBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();

    public WindowsNamedPipe(long writeHandle, long readHandle, String writeName, String readName, boolean iAmServer) {
        this.writeHandle = writeHandle;
        this.readHandle = readHandle;
        this.writeName = writeName;
        this.readName = readName;
        this.iAmServer = iAmServer;
        if (iAmServer) {
            this.startConnectThread();
        } else {
            this.startCreateThread();
        }
    }

    private void startConnectThread() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int error;
                    Windows.BooleanResult result = Windows.ConnectNamedPipe(WindowsNamedPipe.this.writeHandle, null);
                    if (!result.isSuccess() && (error = result.errorCode()) != 535) {
                        throw new IOException("Error " + error + " connecting named pipe");
                    }
                    result = Windows.ConnectNamedPipe(WindowsNamedPipe.this.readHandle, null);
                    if (!result.isSuccess() && (error = result.errorCode()) != 535) {
                        throw new IOException("Error " + error + " connecting named pipe");
                    }
                    WindowsNamedPipe windowsNamedPipe = WindowsNamedPipe.this;
                    synchronized (windowsNamedPipe) {
                        WindowsNamedPipe.this.connected = true;
                    }
                }
                catch (IOException e) {
                    WindowsNamedPipe windowsNamedPipe = WindowsNamedPipe.this;
                    synchronized (windowsNamedPipe) {
                        WindowsNamedPipe.this.connectException = e;
                        WindowsNamedPipe.this.connectFailed = true;
                    }
                }
                WindowsNamedPipe windowsNamedPipe = WindowsNamedPipe.this;
                synchronized (windowsNamedPipe) {
                    WindowsNamedPipe.this.notifyAll();
                }
            }
        }, "Pipe Connector Thread").start();
    }

    private void startCreateThread() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WindowsNamedPipe windowsNamedPipe;
                do {
                    try {
                        if (WindowsNamedPipe.this.writeHandle == -1L && !WindowsNamedPipe.this.createFailed) {
                            WindowsNamedPipe.this.writeHandle = Windows.CreateFileA("\\\\.\\pipe\\" + WindowsNamedPipe.this.writeName, 2, 0, null, 3, 128, 0L, true);
                            if (WindowsNamedPipe.this.writeHandle == 0L) {
                                throw new RuntimeException("Error opening named pipe \"\\\\.\\pipe\\" + WindowsNamedPipe.this.writeName + "\"  for writing");
                            }
                        }
                        if (WindowsNamedPipe.this.readHandle == -1L && !WindowsNamedPipe.this.createFailed) {
                            WindowsNamedPipe.this.readHandle = Windows.CreateFileA("\\\\.\\pipe\\" + WindowsNamedPipe.this.readName, 1, 0, null, 3, 128, 0L, true);
                            if (WindowsNamedPipe.this.readHandle == 0L) {
                                throw new RuntimeException("Error opening named pipe \"\\\\.\\pipe\\" + WindowsNamedPipe.this.readName + "\" for reading");
                            }
                        }
                        windowsNamedPipe = WindowsNamedPipe.this;
                        synchronized (windowsNamedPipe) {
                            if (WindowsNamedPipe.this.writeHandle != -1L && WindowsNamedPipe.this.readHandle != -1L) {
                                WindowsNamedPipe.this.created = true;
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        WindowsNamedPipe windowsNamedPipe2 = WindowsNamedPipe.this;
                        synchronized (windowsNamedPipe2) {
                            WindowsNamedPipe.this.createException = e;
                            WindowsNamedPipe.this.createFailed = true;
                        }
                    }
                } while (!WindowsNamedPipe.this.created && !WindowsNamedPipe.this.createFailed);
                windowsNamedPipe = WindowsNamedPipe.this;
                synchronized (windowsNamedPipe) {
                    WindowsNamedPipe.this.notifyAll();
                }
            }
        }, "Pipe Create Thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForConnection() throws IOException {
        if (this.iAmServer) {
            WindowsNamedPipe windowsNamedPipe = this;
            synchronized (windowsNamedPipe) {
                while (!this.connected) {
                    if (this.connectFailed) {
                        if (this.connectException != null) {
                            throw this.connectException;
                        }
                        throw new IOException("Never received connection from client side");
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        WindowsNamedPipe windowsNamedPipe = this;
        synchronized (windowsNamedPipe) {
            while (!this.created) {
                if (this.createFailed) {
                    if (this.createException != null) {
                        throw this.createException;
                    }
                    throw new IOException("Never received connection from client side");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public int read(ByteBufferWrapper dest) throws IOException {
        this.waitForConnection();
        int numToRead = dest.remaining();
        int numRead = 0;
        do {
            long t0 = SystemUtils.microTime();
            Windows.BooleanResult result = Windows.ReadFile(this.readHandle, dest.getBuffer(), numToRead, this.numReadBuffer, null);
            numRead = this.numReadBuffer.get(0);
            if (result.isSuccess()) continue;
            long t1 = SystemUtils.microTime();
            throw new IOException("Error " + result.errorCode() + " reading from " + this + ", numRead " + numRead + ", ReadFile ts: " + t0 + ", now ts: " + t1 + ", dT " + (t1 - t0));
        } while (numRead == 0);
        dest.position(dest.position() + numRead);
        return numRead;
    }

    @Override
    public int write(ByteBufferWrapper src) throws IOException {
        this.waitForConnection();
        int numToWrite = src.remaining();
        while (src.hasRemaining()) {
            long t0 = SystemUtils.microTime();
            Windows.BooleanResult result = Windows.WriteFile(this.writeHandle, src.getBuffer(), numToWrite, this.numWrittenBuffer, null);
            int numWritten = this.numWrittenBuffer.get(0);
            if (!result.isSuccess()) {
                long t1 = SystemUtils.microTime();
                throw new IOException("Error " + result.errorCode() + " writing to " + this + ": numWritten " + numWritten + ", WriteFile ts: " + t0 + ", now ts: " + t1 + ", dT " + (t1 - t0));
            }
            src.position(src.position() + numWritten);
        }
        return numToWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.writeHandle == 0L || this.readHandle == 0L) {
            throw new IOException("Already closed");
        }
        if (this.iAmServer) {
            Thread disconnector = new Thread(new Runnable(){

                @Override
                public void run() {
                    Windows.DisconnectNamedPipe(WindowsNamedPipe.this.writeHandle);
                    Windows.DisconnectNamedPipe(WindowsNamedPipe.this.readHandle);
                }
            }, "Pipe Disconnector Thread");
            disconnector.start();
            try {
                disconnector.join(500L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.createFailed = true;
        }
        final boolean[] resBox = new boolean[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean res1 = Windows.CloseHandle(WindowsNamedPipe.this.writeHandle);
                boolean res2 = Windows.CloseHandle(WindowsNamedPipe.this.readHandle);
                resBox[0] = res1 && res2;
            }
        };
        if (this.iAmServer) {
            Thread closer = new Thread(r, "Pipe Closer Thread");
            closer.start();
            try {
                closer.join(500L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            r.run();
        }
        this.writeHandle = 0L;
        this.readHandle = 0L;
        WindowsNamedPipe windowsNamedPipe = this;
        synchronized (windowsNamedPipe) {
            this.connectFailed = true;
            this.notifyAll();
        }
        if (!resBox[0]) {
            throw new IOException("Error closing " + this);
        }
    }

    @Override
    public boolean isOpen() {
        return this.writeHandle != 0L && this.readHandle != 0L;
    }

    @Override
    public String toString() {
        return "WindowsNamedPipe: server: " + this.iAmServer + "; readPipe: " + this.readName + ", readBufferSz: 4096; writePipe: " + this.writeName + ", writeBufferSz: 4096";
    }

    @Override
    public Map<String, String> getChildProcessParameters() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("write_pipe_name", this.readName);
        ret.put("read_pipe_name", this.writeName);
        return ret;
    }
}

