/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.jvm;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.plugin2.jvm.JVMEventListener;
import sun.plugin2.jvm.ProcessLauncher;

public class JVMLauncher
implements ProcessLauncher {
    private static final boolean DEBUG = Config.getDebug();
    private long jvmLaunchTime;
    private final long appletLaunchTime;
    private final String javaHome;
    private final JVMParameters params;
    private boolean isRelaunch = false;
    private JREInfo jreInfo = null;
    private Process process;
    private volatile boolean exited;
    private int exitCode = -1;
    private Exception error;
    private final ArrayList<JVMEventListener> listeners = new ArrayList();

    public JVMLauncher(long appletLaunchTime, String javaHome, JVMParameters params, boolean isRelaunch) {
        this.appletLaunchTime = appletLaunchTime;
        this.javaHome = javaHome;
        this.jreInfo = JREInfo.findByJREPath((String)javaHome);
        this.params = params;
        this.isRelaunch = isRelaunch;
    }

    @Override
    public synchronized void addJVMEventListener(JVMEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void start() {
        ProcessBuilder builder;
        Map<String, String> env;
        String ldLibraryPath;
        Iterator itr;
        List args;
        this.jvmLaunchTime = SystemUtils.microTime();
        if (DEBUG) {
            System.out.println("JVMLauncher.start: launcher params:");
            List subordinateArgs = this.params.getCommandLineArguments(this.jreInfo, true);
            Iterator iter = subordinateArgs.iterator();
            while (iter.hasNext()) {
                System.out.println("\t<" + (String)iter.next() + ">");
            }
        }
        if (DEBUG) {
            System.out.println("JVMLauncher.start(): now - user.startApplet(): " + (this.jvmLaunchTime - this.appletLaunchTime) + " us");
        }
        String appletLaunchTimeProperty = "-D__applet_launched=" + this.appletLaunchTime;
        String jvmLaunchTimeProperty = "-D__jvm_launched=" + this.jvmLaunchTime;
        String java = Config.getJavaCommand();
        if (java == null) {
            throw new RuntimeException("Unable to locate the java launcher in java.home \"" + this.javaHome + "\"");
        }
        this.exited = false;
        this.error = null;
        if (Config.useSecureLaunch((JREInfo)this.jreInfo)) {
            String launcher = Platform.get().findSecureLauncher(null);
            if (launcher == null) {
                throw new RuntimeException("Unable to locate the Java Plug-In's custom launcher in java.home \"" + System.getProperty("java.home") + "\"");
            }
            args = this.params.getCommandLineArguments(this.jreInfo, false, true, true, true, true);
            args.add(0, launcher);
            args.add(1, jvmLaunchTimeProperty);
            args.add(2, appletLaunchTimeProperty);
        } else {
            int i;
            args = this.params.getCommandLineArguments(this.jreInfo, false, true, true, true, false);
            String arg = null;
            itr = args.iterator();
            int n = args.size();
            for (i = 0; i < n && JVMParameters.isJVMCommandLineArgument((String)(arg = (String)itr.next())); ++i) {
                if (!arg.equals("--add-modules") || !itr.hasNext()) continue;
                itr.next();
            }
            if (i == n) {
                this.exited = true;
                this.error = new RuntimeException("Invalid arguments: no main class found");
                this.fireJVMExited();
                return;
            }
            if (arg != null && !arg.equals("sun.plugin2.main.client.PluginMain") && !arg.equals("jdk.plugin/sun.plugin2.main.client.PluginMain")) {
                this.exited = true;
                this.error = new RuntimeException("Invalid arguments: PluginMain main class not found");
                this.fireJVMExited();
                return;
            }
            args.add(0, java);
            args.add(1, jvmLaunchTimeProperty);
            args.add(2, appletLaunchTimeProperty);
        }
        List launchArgs = args;
        if (Config.useSecureLaunch((JREInfo)this.jreInfo)) {
            String insecureArg;
            JVMParameters secureJvmParams = null;
            List insecureArgs = this.params.getCommandLineArguments(null, false, false, false, this.isRelaunch, false);
            itr = insecureArgs.iterator();
            while (itr.hasNext() && !(insecureArg = (String)itr.next()).equals("sun.plugin2.main.client.PluginMain") && !insecureArg.equals("-m")) {
                if (this.jreInfo.getVmArgs() != null && this.jreInfo.getVmArgs().contains(insecureArg)) {
                    if (!DEBUG) continue;
                    System.out.println("skip: " + insecureArg);
                    continue;
                }
                if (secureJvmParams == null) {
                    secureJvmParams = new JVMParameters();
                }
                secureJvmParams.setIncludeExtendedASCIIValues(true);
                secureJvmParams.addArgument(insecureArg);
            }
            if (DEBUG) {
                System.out.println("JVMLauncher, added secureJvmParms: " + secureJvmParams);
            }
            launchArgs = ArgumentParsingUtil.getSecureLaunchArgs((JREInfo)this.jreInfo, (List)args, secureJvmParams, (boolean)this.isRelaunch, (boolean)true);
        }
        if ((ldLibraryPath = (env = (builder = new ProcessBuilder(launchArgs)).environment()).get("LD_LIBRARY_PATH")) != null) {
            String[] entries = ldLibraryPath.split(File.pathSeparator);
            String homePath = Config.getJREHome();
            for (int i = 0; i < entries.length; ++i) {
                if (!entries[i].startsWith(homePath)) continue;
                entries[i] = null;
            }
            Object newPath = null;
            for (String path : entries) {
                if (path == null) continue;
                newPath = newPath == null ? path : (String)newPath + File.pathSeparator + path;
            }
            env.put("LD_LIBRARY_PATH", (String)newPath);
        }
        if (OSType.isMac()) {
            env.put("LC_CTYPE", "UTF-8");
        }
        env.remove("CLASSPATH");
        try {
            this.process = Platform.get().startProcessBuilder(builder);
            this.afterStart();
        }
        catch (Exception e) {
            this.exited = true;
            this.error = e;
        }
    }

    protected void afterStart() {
        System.out.println("JVMLauncher.afterStart(): starting JVM process watcher");
        new Thread(new JVMWatcher()).start();
    }

    public JVMParameters getParameters() {
        return this.params;
    }

    @Override
    public void addParameter(String arg) {
        this.params.addArgument(arg);
    }

    @Override
    public void clearUserArguments() {
        this.params.clearUserArguments();
    }

    @Override
    public boolean exited() {
        return this.exited;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public Exception getErrorDuringStartup() {
        return this.error;
    }

    @Override
    public void destroy() {
        this.process.destroy();
    }

    @Override
    public InputStream getInputStream() {
        if (this.process != null) {
            return this.process.getInputStream();
        }
        return null;
    }

    @Override
    public InputStream getErrorStream() {
        if (this.process != null) {
            return this.process.getErrorStream();
        }
        return null;
    }

    @Override
    public long getJVMLaunchTime() {
        return this.jvmLaunchTime;
    }

    public long getAppletLaunchTime() {
        return this.appletLaunchTime;
    }

    private synchronized List<JVMEventListener> copyListeners() {
        return (List)this.listeners.clone();
    }

    private void fireJVMExited() {
        for (JVMEventListener listener : this.copyListeners()) {
            listener.jvmExited(this);
        }
    }

    class JVMWatcher
    implements Runnable {
        JVMWatcher() {
        }

        @Override
        public void run() {
            boolean done = false;
            while (!done) {
                try {
                    JVMLauncher.this.exitCode = JVMLauncher.this.process.waitFor();
                    done = true;
                }
                catch (InterruptedException e) {
                    Trace.printException((Throwable)e);
                }
            }
            JVMLauncher.this.exited = true;
            JVMLauncher.this.fireJVMExited();
        }
    }
}

