/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.liveconnect;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.InvocationDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.Result;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.plugin.javascript.JSClassLoader;
import sun.plugin.javascript.ReflectUtil;

public class JavaClass
implements InvocationDelegate {
    private Class<?> clazz;
    private Bridge bridge;
    private Map<String, MemberBundle> methodMap;
    private Map<String, Field> fieldMap;
    private MemberBundle constructors;
    private Map<String, MemberBundle> lowerCaseMethodMap;
    private Map<String, Field> lowerCaseFieldMap;
    private boolean isArray;
    private Class<?> componentType;

    public JavaClass(Class<?> clazz, Bridge bridge) {
        this.clazz = clazz;
        this.bridge = bridge;
        this.isArray = clazz.isArray();
        if (this.isArray) {
            this.componentType = clazz.getComponentType();
        }
    }

    private static String argsToString(Object[] arguments) {
        StringBuilder buf = new StringBuilder("[");
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                Object arg = arguments[i];
                String className = null;
                if (arg != null) {
                    className = arg.getClass().getName();
                }
                buf.append(className);
            }
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public boolean hasField(String fieldName, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
        result[0] = this.hasField0(fieldName, receiver, objectIsApplet);
        return true;
    }

    private boolean hasField0(String fieldName, Object receiver, boolean objectIsApplet) {
        Field field;
        if (this.isArray) {
            if ("length".equals(fieldName)) {
                return true;
            }
            try {
                int index = Integer.parseInt(fieldName);
                return index >= 0 && index < Array.getLength(receiver);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.fieldMap == null) {
            this.collectFields();
        }
        if ((field = this.fieldMap.get(fieldName)) != null) {
            return true;
        }
        field = this.lowerCaseFieldMap.get(fieldName.toLowerCase());
        return field != null;
    }

    @Override
    public boolean hasMethod(String methodName, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
        result[0] = this.hasMethod0(methodName, receiver, objectIsApplet);
        return true;
    }

    private boolean hasMethod0(String methodName, Object receiver, boolean objectIsApplet) {
        MemberBundle bundle;
        if (this.methodMap == null) {
            this.collectMethods();
        }
        if ((bundle = this.methodMap.get(methodName)) != null) {
            return true;
        }
        bundle = this.lowerCaseMethodMap.get(methodName.toLowerCase());
        return bundle != null;
    }

    @Override
    public boolean hasFieldOrMethod(String name, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
        boolean res;
        result[0] = res = this.hasField0(name, receiver, objectIsApplet) || this.hasMethod0(name, receiver, objectIsApplet);
        return true;
    }

    @Override
    public boolean invoke(String methodName, Object receiver, Object[] arguments, boolean isStatic, boolean objectIsApplet, Result[] result) throws Exception {
        result[0] = this.invoke0(methodName, receiver, arguments, objectIsApplet);
        return true;
    }

    private Result invoke0(String methodName, Object receiver, Object[] arguments, boolean objectIsApplet) throws Exception {
        MemberBundle bundle;
        if (this.methodMap == null) {
            this.collectMethods();
        }
        if ((bundle = this.methodMap.get(methodName)) == null) {
            bundle = this.lowerCaseMethodMap.get(methodName.toLowerCase());
        }
        if (bundle == null) {
            throw new NoSuchMethodException(methodName + " in class: " + this.clazz.getName());
        }
        return bundle.invoke(receiver, arguments);
    }

    @Override
    public Object findClass(String name) {
        throw new UnsupportedOperationException("Should not call this");
    }

    @Override
    public Object newInstance(Object clazz, Object[] arguments) throws Exception {
        if (this.constructors == null) {
            this.collectConstructors();
        }
        Result res = null;
        try {
            res = this.constructors.invoke(null, arguments);
        }
        catch (IllegalArgumentException iae) {
            res = this.constructors.invoke(null, null);
        }
        return res.value();
    }

    @Override
    public boolean getField(String fieldName, Object receiver, boolean isStatic, boolean objectIsApplet, Result[] result) throws Exception {
        result[0] = this.getField0(fieldName, receiver, objectIsApplet);
        return true;
    }

    private Result getField0(String fieldName, Object receiver, boolean objectIsApplet) throws Exception {
        Field field;
        if (this.isArray) {
            if ("length".equals(fieldName)) {
                return new Result(Array.getLength(receiver), false);
            }
            int index = Integer.parseInt(fieldName);
            return new Result(Array.get(receiver, index), JavaClass.isBoxingClass(receiver.getClass().getComponentType()));
        }
        if (this.fieldMap == null) {
            this.collectFields();
        }
        if ((field = this.fieldMap.get(fieldName)) == null) {
            field = this.lowerCaseFieldMap.get(fieldName.toLowerCase());
        }
        if (field == null) {
            throw new NoSuchFieldException(fieldName + " in class: " + this.clazz.getName());
        }
        return new Result(field.get(receiver), JavaClass.isBoxingClass(field.getType()));
    }

    @Override
    public boolean setField(String fieldName, Object receiver, Object value, boolean isStatic, boolean objectIsApplet) throws Exception {
        if (this.isArray) {
            int index = Integer.parseInt(fieldName);
            Array.set(receiver, index, this.bridge.convert(value, this.componentType));
        } else {
            Field field;
            if (this.fieldMap == null) {
                this.collectFields();
            }
            if ((field = this.fieldMap.get(fieldName)) == null) {
                field = this.lowerCaseFieldMap.get(fieldName.toLowerCase());
            }
            if (field == null) {
                throw new NoSuchFieldException(fieldName);
            }
            Class<?> expectedType = field.getType();
            field.set(receiver, this.bridge.convert(value, expectedType));
        }
        return true;
    }

    private static boolean isBoxingClass(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Character.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class;
    }

    private void collectMethods() {
        Method[] methods = ReflectUtil.getJScriptMethods(this.clazz);
        HashMap<String, MemberBundle> methodMap = new HashMap<String, MemberBundle>();
        HashMap<String, MemberBundle> lowerCaseMethodMap = new HashMap<String, MemberBundle>();
        for (Method method : methods) {
            MemberBundle bundle = (MemberBundle)methodMap.get(method.getName());
            if (bundle == null) {
                bundle = new MemberBundle();
                methodMap.put(method.getName(), bundle);
            }
            bundle.add(method);
            String lowerCaseName = method.getName().toLowerCase();
            bundle = (MemberBundle)lowerCaseMethodMap.get(lowerCaseName);
            if (bundle == null) {
                bundle = new MemberBundle();
                lowerCaseMethodMap.put(lowerCaseName, bundle);
            }
            bundle.add(method);
        }
        this.methodMap = methodMap;
        this.lowerCaseMethodMap = lowerCaseMethodMap;
    }

    private void collectConstructors() {
        Constructor<?>[] ctors = this.clazz.getConstructors();
        MemberBundle ctorBundle = new MemberBundle();
        for (Constructor<?> ctor : ctors) {
            ctorBundle.add(ctor);
        }
        this.constructors = ctorBundle;
    }

    private void collectFields() {
        Field[] fields = ReflectUtil.getJScriptFields(this.clazz);
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        HashMap<String, Field> lowerCaseFieldMap = new HashMap<String, Field>();
        for (Field field : fields) {
            fieldMap.put(field.getName(), field);
            lowerCaseFieldMap.put(field.getName().toLowerCase(), field);
        }
        this.fieldMap = fieldMap;
        this.lowerCaseFieldMap = lowerCaseFieldMap;
    }

    private class MemberBundle {
        protected List<MemberInfo> members = new ArrayList<MemberInfo>();

        private MemberBundle() {
        }

        public void add(Method method) {
            MethodInfo info = new MethodInfo(method);
            if (!info.isBridge() && !this.members.contains(info)) {
                this.members.add(info);
            }
        }

        public void add(Constructor<?> constructor) {
            this.members.add(new ConstructorInfo(constructor));
        }

        public Result invoke(Object target, Object[] arguments) throws Exception {
            MemberInfo chosenInfo = null;
            MemberInfo ambiguousInfo = null;
            Class<?>[] chosenParameterTypes = null;
            int minNumConversions = 0;
            boolean ambiguous = false;
            for (MemberInfo info : this.members) {
                if (Config.getDebug()) {
                    Trace.println((String)("Try MemberInfo: " + info), (TraceLevel)TraceLevel.LIVECONNECT);
                }
                Class<?>[] parameterTypes = info.getParameterTypes();
                if (arguments == null ? parameterTypes.length != 0 : parameterTypes.length != arguments.length) continue;
                int numConversions = 0;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Object arg = arguments[i];
                    Class<?> expectedClass = parameterTypes[i];
                    int cost = JavaClass.this.bridge.conversionCost(arg, expectedClass);
                    if (cost < 0) {
                        numConversions = -1;
                        break;
                    }
                    numConversions += cost;
                }
                if (numConversions >= 0) {
                    if (chosenInfo == null || numConversions < minNumConversions) {
                        chosenInfo = info;
                        chosenParameterTypes = info.getParameterTypes();
                        minNumConversions = numConversions;
                        ambiguous = false;
                        continue;
                    }
                    if (numConversions != minNumConversions) continue;
                    ambiguous = true;
                    ambiguousInfo = info;
                    continue;
                }
                Trace.println((String)("Failed: " + info + ", convert cost " + numConversions), (TraceLevel)TraceLevel.LIVECONNECT);
            }
            if (chosenInfo == null) {
                throw new IllegalArgumentException("No method found matching name " + this.members.get(0).getName() + " and arguments " + JavaClass.argsToString(arguments));
            }
            if (ambiguous) {
                throw new IllegalArgumentException("More than one method matching name " + this.members.get(0).getName() + " and arguments " + JavaClass.argsToString(arguments) + "\n  Method 1: " + chosenInfo.getMember().toString() + "\n  Method 2: " + ambiguousInfo.getMember().toString());
            }
            Object[] newArgs = null;
            if (arguments != null) {
                newArgs = new Object[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    newArgs[i] = JavaClass.this.bridge.convert(arguments[i], chosenParameterTypes[i]);
                }
            }
            Object ret = chosenInfo.invoke(target, newArgs);
            return new Result(ret, JavaClass.isBoxingClass(chosenInfo.getReturnType()));
        }
    }

    private static class ConstructorInfo
    extends MemberInfo {
        protected ConstructorInfo(Constructor<?> constructor) {
            super(constructor);
            this.parameterTypes = constructor.getParameterTypes();
        }

        public Constructor<?> getConstructor() {
            return (Constructor)this.getMember();
        }

        @Override
        public Object invoke(Object target, Object[] args) throws Exception {
            return JSClassLoader.newInstance(this.getConstructor(), args);
        }

        @Override
        public Class<?> getReturnType() {
            return this.getConstructor().getDeclaringClass();
        }

        @Override
        public boolean isBridge() {
            return false;
        }
    }

    private static class MethodInfo
    extends MemberInfo {
        protected MethodInfo(Method method) {
            super(method);
            this.parameterTypes = method.getParameterTypes();
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Method self = this.getMethod();
            Method other = ((MethodInfo)o).getMethod();
            return self.getName().equals(other.getName()) && self.getReturnType() == other.getReturnType() && this.arraysEq(self.getParameterTypes(), other.getParameterTypes());
        }

        public Method getMethod() {
            return (Method)this.getMember();
        }

        @Override
        public Object invoke(Object target, Object[] args) throws Exception {
            Object res = JSClassLoader.invoke(this.getMethod(), target, args);
            if (res == null && this.getMethod().getReturnType() == Void.TYPE) {
                return Void.TYPE;
            }
            return res;
        }

        @Override
        public Class<?> getReturnType() {
            return this.getMethod().getReturnType();
        }

        @Override
        public boolean isBridge() {
            try {
                return this.getMethod().isBridge();
            }
            catch (Error e) {
                return false;
            }
        }

        private boolean arraysEq(Class<?>[] params1, Class<?>[] params2) {
            if (params1 == null != (params2 == null)) {
                return false;
            }
            if (params1 == null) {
                return true;
            }
            if (params1.length != params2.length) {
                return false;
            }
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            Method self = this.getMethod();
            int hash = 3;
            hash = 3 * hash + (self.getName() != null ? self.getName().hashCode() : 0);
            hash = 3 * hash + (self.getReturnType() != null ? self.getReturnType().hashCode() : 0);
            hash = 3 * hash + (this.parameterTypes != null ? Arrays.hashCode(this.parameterTypes) : 0);
            return hash;
        }
    }

    private static abstract class MemberInfo {
        private Member member;
        protected Class<?>[] parameterTypes;

        protected MemberInfo(Member member) {
            this.member = member;
        }

        protected Member getMember() {
            return this.member;
        }

        public String getName() {
            return this.getMember().getName();
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public abstract Object invoke(Object var1, Object[] var2) throws Exception;

        public abstract Class<?> getReturnType();

        public abstract boolean isBridge();

        public String toString() {
            return this.member.toString();
        }
    }
}

