/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message.helper;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import sun.plugin2.message.Serializer;

public final class ProxyHelper {
    private static final int DIRECT_PROXY = 0;
    private static final int HTTP_PROXY = 1;
    private static final int SOCKS_PROXY = 2;

    private static int getProxyTypeID(Proxy.Type type) throws IllegalArgumentException {
        if (type == Proxy.Type.DIRECT) {
            return 0;
        }
        if (type == Proxy.Type.HTTP) {
            return 1;
        }
        if (type == Proxy.Type.SOCKS) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    private static Proxy.Type getProxyType(int id) throws IllegalArgumentException {
        switch (id) {
            case 0: {
                return Proxy.Type.DIRECT;
            }
            case 1: {
                return Proxy.Type.HTTP;
            }
            case 2: {
                return Proxy.Type.SOCKS;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void write(Serializer ser, Proxy proxy) throws IOException {
        if (proxy == null) {
            ser.writeBoolean(false);
            return;
        }
        ser.writeBoolean(true);
        ser.writeInt(ProxyHelper.getProxyTypeID(proxy.type()));
        InetSocketAddress addr = (InetSocketAddress)proxy.address();
        if (addr != null) {
            ser.writeBoolean(true);
            ser.writeUTF(addr.getHostString());
            ser.writeInt(addr.getPort());
        } else {
            ser.writeBoolean(false);
        }
    }

    public static Proxy read(Serializer ser) throws IOException {
        if (!ser.readBoolean()) {
            return null;
        }
        Proxy.Type proxyType = ProxyHelper.getProxyType(ser.readInt());
        InetSocketAddress addr = null;
        if (ser.readBoolean()) {
            addr = new InetSocketAddress(ser.readUTF(), ser.readInt());
        }
        if (proxyType == Proxy.Type.DIRECT) {
            return Proxy.NO_PROXY;
        }
        return new Proxy(proxyType, addr);
    }
}

