/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import com.sun.applet2.Applet2;
import com.sun.applet2.Applet2Context;
import com.sun.applet2.Applet2Host;
import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.Environment;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.DownloadException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.Resource;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.Applet2Adapter;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.Window;
import com.sun.deploy.uitoolkit.impl.awt.AWTFrameWindow;
import com.sun.deploy.uitoolkit.impl.awt.AppletCompatibleHost;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.progress.CustomProgress2PreloaderAdapter;
import com.sun.javaws.ui.LaunchErrorDialog;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import javax.jnlp.DownloadServiceListener;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import netscape.javascript.JSObject;
import sun.awt.AWTAccessor;
import sun.awt.EmbeddedFrame;
import sun.plugin.javascript.JSContext;
import sun.plugin2.applet.Applet2ClassLoader;
import sun.plugin2.applet2.Plugin2Host;
import sun.plugin2.uitoolkit.impl.awt.AWTDefaultPreloader;
import sun.plugin2.uitoolkit.impl.awt.AWTErrorPanel;
import sun.plugin2.uitoolkit.impl.awt.Applet2AudioClipFactory;
import sun.plugin2.uitoolkit.impl.awt.Applet2ImageFactory;
import sun.plugin2.uitoolkit.impl.awt.OldPluginAWTUtil;
import sun.plugin2.util.ColorUtil;

public class AWTAppletAdapter
extends Applet2Adapter {
    private AppContext appletAppContext = null;
    private AppletStubImpl stub = null;
    private AppletContextImpl context = null;
    private Container parentContainer = null;
    private static boolean firstCheck = true;
    Applet applet = null;
    private static final String APPCONTEXT_JAPPLET_USED_KEY = "JAppletUsedKey";
    private Container progressContainer = null;
    private Preloader preloader = null;
    Boolean jdk11Applet = null;
    Boolean jdk12Applet = null;

    public AWTAppletAdapter(Applet2Context ctx) {
        super(ctx);
        ToolkitStore.get();
        this.context = new AppletContextImpl(this.getApplet2Context());
        this.stub = new AppletStubImpl(this.getApplet2Context());
    }

    public void setAppletAppContext(AppContext appContext) {
        this.appletAppContext = appContext;
        this.appletAppContext.put((Object)"AppletContextKey", (Object)this.context);
    }

    public synchronized void setParentContainer(Window parent) {
        if (null != parent) {
            assert (parent instanceof AWTFrameWindow);
            this.parentContainer = (Container)parent.getWindowObject();
        }
    }

    public synchronized void instantiateApplet(final Class<?> cls) throws InstantiationException, IllegalAccessException {
        if (this.parentContainer == null) {
            Trace.println((String)"Instantiating applet without parent container!", (TraceLevel)TraceLevel.UI);
        }
        final Applet[] appletBox = new Applet[1];
        final Error[] errorBox = new Error[]{null};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Applet a = (Applet)cls.newInstance();
                    a.setVisible(false);
                    appletBox[0] = a;
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (Error err) {
                    errorBox[0] = err;
                }
            }
        };
        if (this.parentContainer != null) {
            this.runOnEDTAndWait(this.parentContainer, r);
            if (null != errorBox[0]) {
                throw new RuntimeException(errorBox[0]);
            }
        } else {
            r.run();
        }
        Applet a = appletBox[0];
        this.setApplet(a);
    }

    public void cleanup() {
        super.cleanup();
        if (this.appletAppContext != null && this.appletAppContext.get((Object)APPCONTEXT_JAPPLET_USED_KEY) != null) {
            RepaintManager.setCurrentManager(null);
        }
    }

    private void setApplet(Applet applet) {
        this.applet = applet;
        if (applet == null) {
            Trace.ignored((Throwable)new Exception("setApplet with null applet!"));
        }
        if (this.parentContainer == null) {
            Trace.println((String)"Adapting applet without parent container!", (TraceLevel)TraceLevel.UI);
        }
        if (applet != null) {
            AppContext ac;
            this.findAppletJDKLevel(applet.getClass());
            if (JApplet.class.isAssignableFrom(applet.getClass()) && (ac = this.appletAppContext) != null) {
                ac.put((Object)APPCONTEXT_JAPPLET_USED_KEY, (Object)Boolean.TRUE);
            }
            applet.setStub(this.stub);
        }
    }

    public Applet2 getApplet2() {
        return null;
    }

    private void doClearParentContainer() {
        if (JFrame.class.isAssignableFrom(this.parentContainer.getClass())) {
            ((JFrame)this.parentContainer).getContentPane().removeAll();
        } else if (this.parentContainer != null) {
            this.parentContainer.removeAll();
        }
    }

    public void doShowApplet() {
        if (this.applet == null) {
            return;
        }
        Applet2Context ctx = this.getApplet2Context();
        final Dimension size = new Dimension(ctx.getWidth(), ctx.getHeight());
        this.runOnEDTAndWait(this.applet, new Runnable(){

            @Override
            public void run() {
                if (AWTAppletAdapter.this.applet.getParent() != null && AWTAppletAdapter.this.applet.isVisible()) {
                    return;
                }
                AWTAppletAdapter.this.applet.resize(size);
                AWTAppletAdapter.this.doClearParentContainer();
                if (AWTAppletAdapter.this.parentContainer != null) {
                    AWTAppletAdapter.this.parentContainer.add((Component)AWTAppletAdapter.this.applet, "Center");
                }
            }
        });
    }

    public Object getStubObject() {
        return this.stub;
    }

    public void init() {
        this.markAlive(true);
        try {
            this.applet.init();
        }
        catch (Throwable t) {
            this.runOnEDT(this.parentContainer, new Runnable(){

                @Override
                public void run() {
                    if (AWTAppletAdapter.this.parentContainer != null) {
                        AWTAppletAdapter.this.parentContainer.remove(AWTAppletAdapter.this.applet);
                    }
                }
            });
            throw new RuntimeException(t);
        }
    }

    private void showApplet() {
        this.runOnEDT(this.applet, new Runnable(){

            @Override
            public void run() {
                try {
                    AWTAccessor.getContainerAccessor().validateUnconditionally(AWTAppletAdapter.this.parentContainer);
                }
                catch (Throwable e) {
                    if (AWTAppletAdapter.this.parentContainer != null) {
                        AWTAppletAdapter.this.parentContainer.validate();
                    }
                    AWTAppletAdapter.this.applet.validate();
                }
                AWTAppletAdapter.this.applet.setVisible(true);
                if (AWTAppletAdapter.this.hasInitialFocus()) {
                    AWTAppletAdapter.this.setDefaultFocus();
                }
            }
        });
    }

    public void start() {
        this.markAlive(true);
        try {
            this.showApplet();
            this.applet.start();
            this.runOnEDT(this.applet, new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            AWTAccessor.getContainerAccessor().validateUnconditionally(AWTAppletAdapter.this.parentContainer);
                        }
                        catch (Throwable e) {
                            if (AWTAppletAdapter.this.parentContainer == null) break block2;
                            AWTAppletAdapter.this.parentContainer.invalidate();
                            AWTAppletAdapter.this.parentContainer.validate();
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            if (this.parentContainer != null) {
                this.runOnEDT(this.parentContainer, new Runnable(){

                    @Override
                    public void run() {
                        AWTAppletAdapter.this.parentContainer.remove(AWTAppletAdapter.this.applet);
                    }
                });
            }
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.runOnEDT(this.applet, new Runnable(){

            @Override
            public void run() {
                AWTAppletAdapter.this.applet.setVisible(false);
            }
        });
        try {
            this.applet.stop();
        }
        finally {
            this.markAlive(false);
        }
    }

    public void destroy() {
        this.applet.destroy();
    }

    public void resize(final int width, final int height) {
        if (this.applet == null) {
            return;
        }
        this.runOnEDT(this.applet, new Runnable(){

            @Override
            public void run() {
                if (AWTAppletAdapter.this.applet == null) {
                    return;
                }
                AWTAppletAdapter.this.applet.resize(width, height);
                AWTAppletAdapter.this.applet.validate();
            }
        });
    }

    public void doClearAppletArea() {
        this.runOnEDT(this.parentContainer, new Runnable(){

            @Override
            public void run() {
                AWTAppletAdapter.this.doClearParentContainer();
            }
        });
    }

    private void doContainerPrivileged(Container container, final Runnable runnable) {
        AccessControlContext acc = AWTAccessor.getComponentAccessor().getAccessControlContext(container);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                runnable.run();
                return null;
            }
        }, acc);
    }

    private void runOnEDT(Container container, Runnable runnable) {
        assert (container != null);
        if (EventQueue.isDispatchThread()) {
            this.doContainerPrivileged(container, runnable);
        } else {
            OldPluginAWTUtil.invokeLater(container, runnable);
        }
    }

    private void runOnEDTAndWait(Container container, Runnable runnable) {
        assert (container != null);
        if (EventQueue.isDispatchThread()) {
            this.doContainerPrivileged(container, runnable);
        } else {
            try {
                OldPluginAWTUtil.invokeAndWait(container, runnable);
            }
            catch (InterruptedException ie) {
                Trace.ignoredException((Exception)ie);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void setDefaultFocus() {
        Component toFocus = null;
        if (this.parentContainer != null) {
            if (this.parentContainer instanceof java.awt.Window) {
                toFocus = ((java.awt.Window)this.parentContainer).getMostRecentFocusOwner();
                if (toFocus == this.parentContainer || toFocus == null) {
                    toFocus = this.parentContainer.getFocusTraversalPolicy().getInitialComponent((java.awt.Window)this.parentContainer);
                }
            } else if (this.parentContainer.isFocusCycleRoot()) {
                toFocus = this.parentContainer.getFocusTraversalPolicy().getDefaultComponent(this.parentContainer);
            }
        }
        if (toFocus != null) {
            if (this.parentContainer instanceof EmbeddedFrame) {
                try {
                    ((EmbeddedFrame)this.parentContainer).synthesizeWindowActivation(true);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (Throwable t) {
                    Trace.ignored((Throwable)t);
                }
            }
            toFocus.requestFocusInWindow();
        }
    }

    private Container getSurfaceObject() {
        if (this.progressContainer == null) {
            AppContext c = this.appletAppContext;
            final Object[] results = new Object[1];
            if (c != null) {
                try {
                    c.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            results[0] = new JPanel(new BorderLayout());
                        }
                    });
                    this.progressContainer = (Container)results[0];
                }
                catch (Exception e) {
                    Trace.ignored((Throwable)e);
                }
            }
        }
        return this.progressContainer;
    }

    private void installProgressContainer() {
        final Container parent = this.parentContainer;
        Trace.println((String)("install: " + parent + " " + this.progressContainer), (TraceLevel)TraceLevel.PRELOADER);
        if (parent == null) {
            return;
        }
        if (this.progressContainer != null) {
            final Container child = this.progressContainer;
            this.runOnEDT(parent, new Runnable(){

                @Override
                public void run() {
                    Trace.println((String)"Adding Custom Progress container to parent", (TraceLevel)TraceLevel.PRELOADER);
                    parent.add(child);
                    try {
                        AWTAccessor.getContainerAccessor().validateUnconditionally(parent);
                    }
                    catch (Throwable e) {
                        parent.invalidate();
                        parent.validate();
                    }
                }
            });
        }
    }

    private DownloadServiceListener createCustomProgress(Class<?> progressClass) {
        Class[] noArgs = new Class[]{};
        Class[] objectArgs = new Class[]{new Object().getClass()};
        Class[] twoArgs = new Class[]{new Object().getClass(), new Object().getClass()};
        Object[] constructorArgs = noArgs;
        Constructor<?> progressConstructor = null;
        try {
            progressConstructor = progressClass.getConstructor(twoArgs);
            constructorArgs = new Object[]{this.getSurfaceObject(), this.stub};
        }
        catch (Exception e) {
            try {
                progressConstructor = progressClass.getConstructor(objectArgs);
                constructorArgs = new Object[]{this.getSurfaceObject()};
            }
            catch (Exception e2) {
                try {
                    progressConstructor = progressClass.getConstructor(noArgs);
                }
                catch (Exception e3) {
                    throw new SecurityException("Invalid preloader-class or progress-class. No valid constructor");
                }
            }
        }
        if (progressConstructor == null) {
            return null;
        }
        if (DownloadServiceListener.class.isAssignableFrom(progressClass)) {
            Trace.println((String)("Using " + constructorArgs.length + "-argument constructor"), (TraceLevel)TraceLevel.PRELOADER);
            try {
                return (DownloadServiceListener)progressConstructor.newInstance(constructorArgs);
            }
            catch (Exception e) {
                throw new SecurityException("Invalid preloader-class or progress-class.", e);
            }
        }
        throw new SecurityException("Invalid preloader-class or progress-class.");
    }

    private synchronized void setPreloader(Preloader p) {
        this.preloader = p;
    }

    public synchronized Preloader getPreloader() {
        return this.preloader;
    }

    public Preloader instantiatePreloader(Class<?> progressClass) {
        Trace.println((String)("Requested to use preloader class: " + progressClass), (TraceLevel)TraceLevel.PRELOADER);
        if (progressClass != null) {
            try {
                DownloadServiceListener ds = this.createCustomProgress(progressClass);
                if (ds != null) {
                    CustomProgress2PreloaderAdapter p = new CustomProgress2PreloaderAdapter(ds, this.getApplet2Context());
                    this.installProgressContainer();
                    this.setPreloader((Preloader)p);
                    return p;
                }
            }
            catch (Exception e) {
                Trace.ignored((Throwable)e);
            }
        }
        AWTDefaultPreloader p = new AWTDefaultPreloader(this.getApplet2Context(), this.parentContainer);
        this.setPreloader(p);
        return p;
    }

    public void doShowPreloader() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Color getBackgroundColor() {
        ColorUtil.ColorRGB val = null;
        String boxBGColorStr = this.stub.getParameter("boxbgcolor");
        if (boxBGColorStr != null) {
            val = ColorUtil.createColorRGB("boxbgcolor", boxBGColorStr);
        }
        if (val != null) {
            return new Color(val.rgb);
        }
        return Color.white;
    }

    private Color getForegroundColor() {
        ColorUtil.ColorRGB val = null;
        String boxBGColorStr = this.stub.getParameter("boxfgcolor");
        if (boxBGColorStr != null) {
            val = ColorUtil.createColorRGB("boxfgcolor", boxBGColorStr);
        }
        if (val != null) {
            return new Color(val.rgb);
        }
        return Color.red;
    }

    public void doShowError(final String message, final Throwable t, final boolean offerReload) {
        final String title = this.getTitle(t);
        if (this.parentContainer == null) {
            Environment.setEnvironmentType((int)1);
            LaunchErrorDialog.show(null, (Throwable)(t != null ? t : new ExitException((Throwable)new Exception("Launch error"), 3)), (boolean)true);
        } else {
            this.runOnEDT(this.parentContainer, new Runnable(){

                @Override
                public void run() {
                    Trace.println((String)"Show default error panel", (TraceLevel)TraceLevel.UI);
                    AWTAppletAdapter.this.parentContainer.setVisible(true);
                    AWTErrorPanel p = new AWTErrorPanel(AWTAppletAdapter.this.getBackgroundColor(), AWTAppletAdapter.this.getForegroundColor(), AWTAppletAdapter.this.getApplet2Host(), offerReload);
                    p.setMessage(title, message);
                    p.setThrowable(t);
                    AWTAppletAdapter.this.doClearParentContainer();
                    AWTAppletAdapter.this.parentContainer.add((Component)p, "Center");
                    try {
                        AWTAccessor.getContainerAccessor().validateUnconditionally(AWTAppletAdapter.this.parentContainer);
                    }
                    catch (Throwable e) {
                        Trace.ignored((Throwable)e);
                        AWTAppletAdapter.this.parentContainer.invalidate();
                        AWTAppletAdapter.this.parentContainer.validate();
                    }
                }
            });
        }
    }

    public Object getLiveConnectObject() {
        return this.applet;
    }

    public boolean isInstantiated() {
        return this.applet != null;
    }

    public Applet getApplet() {
        return this.applet;
    }

    public void abort() {
        if (Config.getDebug()) {
            Trace.ignoredException((Exception)new Exception("ABORT " + ((Object)((Object)this)).hashCode()));
        }
        this.applet = null;
    }

    private String getTitle(Throwable t) {
        String title = null;
        if (t instanceof DownloadException) {
            title = ResourceManager.getString((String)"launcherrordialog.brief.message");
        } else if (t instanceof BlockedException) {
            title = ResourceManager.getString((String)"applet.error.blocked.message");
        } else if (t != null) {
            title = SystemUtils.getSimpleName(t.getClass());
        }
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAppletJDKLevel(final Class<?> appletClass) {
        Class<?> clazz = appletClass;
        synchronized (clazz) {
            if (this.jdk11Applet != null || this.jdk12Applet != null) {
                return;
            }
            this.jdk11Applet = Boolean.FALSE;
            this.jdk12Applet = Boolean.FALSE;
            String name = appletClass.getName();
            name = name.replace('.', '/');
            final String resourceName = name + ".class";
            byte[] classHeader = new byte[8];
            try {
                InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        return appletClass.getClassLoader().getResourceAsStream(resourceName);
                    }
                });
                int byteRead = is.read(classHeader, 0, 8);
                is.close();
                if (byteRead != 8) {
                    return;
                }
            }
            catch (IOException e) {
                return;
            }
            catch (NullPointerException e) {
                return;
            }
            int major_version = AWTAppletAdapter.readShort(classHeader, 6);
            if (major_version < 46) {
                this.jdk11Applet = Boolean.TRUE;
            } else if (major_version == 46) {
                this.jdk12Applet = Boolean.TRUE;
            }
        }
    }

    private boolean isJDK11Applet() {
        return this.jdk11Applet;
    }

    private boolean isJDK12Applet() {
        return this.jdk12Applet;
    }

    private static int readShort(byte[] b, int off) {
        int hi = AWTAppletAdapter.readByte(b[off]);
        int lo = AWTAppletAdapter.readByte(b[off + 1]);
        return hi << 8 | lo;
    }

    private static int readByte(byte b) {
        return b & 0xFF;
    }

    private boolean hasInitialFocus() {
        if (this.isJDK11Applet() || this.isJDK12Applet()) {
            return false;
        }
        String initialFocus = this.getApplet2Context().getParameter("initial_focus");
        if (initialFocus != null && initialFocus.toLowerCase().equals("false")) {
            return false;
        }
        return !Platform.get().isNativeModalDialogUp();
    }

    static class Applet2ObjectInputStream
    extends ObjectInputStream {
        private ClassLoader loader;

        public Applet2ObjectInputStream(InputStream in, ClassLoader loader) throws IOException, StreamCorruptedException {
            super(in);
            if (loader == null) {
                throw new NullPointerException("AppletObjectInputStream requires non-null loader");
            }
            this.loader = loader;
        }

        private Class<?> primitiveType(char type) {
            switch (type) {
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
            }
            return null;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            String cname = classDesc.getName();
            if (cname.startsWith("[")) {
                Class<?> component;
                int dcount = 1;
                while (cname.charAt(dcount) == '[') {
                    ++dcount;
                }
                if (cname.charAt(dcount) == 'L') {
                    component = this.loader.loadClass(cname.substring(dcount + 1, cname.length() - 1));
                } else {
                    if (cname.length() != dcount + 1) {
                        throw new ClassNotFoundException(cname);
                    }
                    component = this.primitiveType(cname.charAt(dcount));
                }
                int[] dim = new int[dcount];
                for (int i = 0; i < dcount; ++i) {
                    dim[i] = 0;
                }
                return Array.newInstance(component, dim).getClass();
            }
            if (firstCheck) {
                firstCheck = false;
                Applet2ClassLoader acl = (Applet2ClassLoader)((Object)this.loader);
                Resource re = acl.getResourceAsResource(cname + ".class");
                if (re != null && re.getManifest() != null) {
                    DeployManifestChecker.verifyMainClass((String)cname, (Attributes)re.getManifest().getMainAttributes());
                }
            }
            return this.loader.loadClass(cname);
        }
    }

    private static class AppletContextImpl
    implements AppletContext,
    JSContext {
        private final Applet2Context ctx;
        private static final Map<String, SoftReference<Image>> imageRefs = new HashMap<String, SoftReference<Image>>();
        private static final Map<String, Map<String, SoftReference<AudioClip>>> audioClipStore = new HashMap<String, Map<String, SoftReference<AudioClip>>>();
        private static final Map<URL, HashMap<String, byte[]>> streamStore = new HashMap<URL, HashMap<String, byte[]>>();
        private static final int PERSIST_STREAM_MAX_SIZE = 65536;

        private AppletContextImpl(Applet2Context ctx) {
            this.ctx = ctx;
        }

        private AppletCompatibleHost getHost() {
            Applet2Host host = this.ctx.getHost();
            if (host instanceof AppletCompatibleHost) {
                return (AppletCompatibleHost)host;
            }
            throw new IllegalStateException();
        }

        private static void legacyCheckURL(SecurityManager security, URL url) {
            String protocol = url.getProtocol().toLowerCase();
            if ("file".equals(protocol) || "jar".equals(protocol)) {
                File file = new File(url.getPath());
                security.checkRead(file.getPath());
            } else {
                security.checkConnect(url.getHost(), url.getPort());
            }
        }

        private static void checkURL(URL url) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                try {
                    Permission perm = AppletContextImpl.getPermission(url);
                    if (perm != null) {
                        security.checkPermission(perm);
                    } else {
                        AppletContextImpl.legacyCheckURL(security, url);
                    }
                }
                catch (IOException ioe) {
                    AppletContextImpl.legacyCheckURL(security, url);
                }
            }
        }

        private static Permission getPermission(URL url) throws IOException {
            return URLUtil.getConnectPermission((URL)url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AudioClip getAudioClip(URL url) {
            if (url == null) {
                return null;
            }
            AppletContextImpl.checkURL(url);
            AudioClip clip = null;
            Map<String, Map<String, SoftReference<AudioClip>>> map = audioClipStore;
            synchronized (map) {
                String urlStr;
                SoftReference audio_ref;
                String ctxStr = this.ctx.getCodeBase().toExternalForm();
                HashMap<String, SoftReference<AudioClip>> audioClips = (HashMap<String, SoftReference<AudioClip>>)audioClipStore.get(ctxStr);
                if (audioClips == null) {
                    audioClips = new HashMap<String, SoftReference<AudioClip>>();
                    audioClipStore.put(ctxStr, audioClips);
                }
                if ((audio_ref = (SoftReference)audioClips.get(urlStr = url.toExternalForm())) != null) {
                    clip = (AudioClip)audio_ref.get();
                }
                if (clip == null) {
                    clip = Applet2AudioClipFactory.createAudioClip(url);
                    audioClips.put(urlStr, new SoftReference<AudioClip>(clip));
                }
            }
            Trace.msgPrintln((String)"appletcontext.audio.loaded", (Object[])new Object[]{url}, (TraceLevel)TraceLevel.BASIC);
            return clip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Image getImage(URL url) {
            if (url == null) {
                return null;
            }
            AppletContextImpl.checkURL(url);
            Image image = null;
            Map<String, SoftReference<Image>> map = imageRefs;
            synchronized (map) {
                String urlStr = url.toExternalForm();
                SoftReference<Image> image_ref = imageRefs.get(urlStr);
                if (image_ref != null) {
                    image = image_ref.get();
                }
                if (image == null) {
                    image = Applet2ImageFactory.createImage(url);
                    imageRefs.put(urlStr, new SoftReference<Image>(image));
                }
            }
            Trace.msgPrintln((String)"appletcontext.image.loaded", (Object[])new Object[]{url}, (TraceLevel)TraceLevel.BASIC);
            return image;
        }

        @Override
        public Applet getApplet(String name) {
            Applet2Adapter ad = this.getHost().getApplet2Adapter(name);
            if (ad != null && ad instanceof AWTAppletAdapter) {
                return ((AWTAppletAdapter)ad).getApplet();
            }
            return null;
        }

        @Override
        public Enumeration<Applet> getApplets() {
            ArrayList<Applet> applets = new ArrayList<Applet>();
            Enumeration contexts = this.getHost().getApplet2Adapters();
            while (contexts.hasMoreElements()) {
                Applet2Adapter ad = (Applet2Adapter)contexts.nextElement();
                if (!(ad instanceof AWTAppletAdapter)) continue;
                applets.add(((AWTAppletAdapter)ad).getApplet());
            }
            return Collections.enumeration(applets);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void setStream(String name, InputStream is) throws IOException {
            HashMap<String, Object> streamMap;
            Map<URL, HashMap<String, byte[]>> map = streamStore;
            synchronized (map) {
                streamMap = streamStore.get(this.ctx.getCodeBase());
                if (streamMap == null) {
                    streamMap = new HashMap();
                    streamStore.put(this.ctx.getCodeBase(), streamMap);
                }
            }
            map = streamMap;
            synchronized (map) {
                if (is != null) {
                    byte[] data = (byte[])streamMap.get(name);
                    if (data == null) {
                        int streamSize = is.available();
                        if (streamSize >= 65536) throw new IOException("Stream size exceeds the maximum limit");
                        data = new byte[streamSize];
                        is.read(data, 0, streamSize);
                        streamMap.put(name, data);
                    } else {
                        streamMap.remove(name);
                        this.setStream(name, is);
                    }
                } else {
                    streamMap.remove(name);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream getStream(String name) {
            ByteArrayInputStream bAIS = null;
            HashMap<String, byte[]> streamMap = streamStore.get(this.ctx.getCodeBase());
            if (streamMap != null) {
                HashMap<String, byte[]> hashMap = streamMap;
                synchronized (hashMap) {
                    byte[] data = streamMap.get(name);
                    if (data != null) {
                        bAIS = new ByteArrayInputStream(data);
                    }
                }
            }
            return bAIS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<String> getStreamKeys() {
            Iterator<String> iter = null;
            HashMap<String, byte[]> streamMap = streamStore.get(this.ctx.getCodeBase());
            if (streamMap != null) {
                HashMap<String, byte[]> hashMap = streamMap;
                synchronized (hashMap) {
                    iter = streamMap.keySet().iterator();
                }
            }
            return iter;
        }

        @Override
        public void showDocument(URL url) {
            this.getHost().showDocument(url);
        }

        @Override
        public void showDocument(URL url, String target) {
            this.getHost().showDocument(url, target);
        }

        @Override
        public void showStatus(String status) {
            this.getHost().showStatus(status);
        }

        @Override
        public JSObject getJSObject() {
            AppletCompatibleHost host = this.getHost();
            return host instanceof Plugin2Host ? ((Plugin2Host)host).getJSObject() : null;
        }

        @Override
        public JSObject getOneWayJSObject() {
            AppletCompatibleHost host = this.getHost();
            return host instanceof Plugin2Host ? ((Plugin2Host)host).getOneWayJSObject() : null;
        }
    }

    private class AppletStubImpl
    implements AppletStub {
        private final Applet2Context ctx;

        AppletStubImpl(Applet2Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public boolean isActive() {
            return this.ctx.isActive();
        }

        @Override
        public URL getDocumentBase() {
            return AWTAppletAdapter.this.getApplet2Host().getDocumentBase();
        }

        @Override
        public URL getCodeBase() {
            return this.ctx.getCodeBase();
        }

        @Override
        public String getParameter(String name) {
            return this.ctx.getParameter(name);
        }

        @Override
        public AppletContext getAppletContext() {
            return AWTAppletAdapter.this.context;
        }

        @Override
        public void appletResize(final int width, final int height) {
            final Applet a = AWTAppletAdapter.this.applet;
            if (a != null && AWTAppletAdapter.this.appletAppContext != null) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        a.resize(width, height);
                        a.validate();
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    r.run();
                } else {
                    OldPluginAWTUtil.invokeLater(a, r);
                }
            }
        }
    }
}

