/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.OSType;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.Window;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import sun.awt.SunToolkit;
import sun.plugin2.uitoolkit.DragContext;
import sun.plugin2.uitoolkit.DragHelper;
import sun.plugin2.uitoolkit.DragListener;
import sun.plugin2.uitoolkit.impl.awt.AWTAppletAdapter;
import sun.plugin2.uitoolkit.impl.awt.OldPluginAWTUtil;

public class AWTDragHelper
implements DragHelper {
    private static final boolean DEBUG = Config.getDebug();
    private static final boolean isOSX = OSType.isMac();
    private static final AWTDragHelper soleInstance = new AWTDragHelper();
    private boolean initialized;
    private Method isSystemGeneratedMethod;
    private final List<PerAppletInfo> perAppletInfoList = new ArrayList<PerAppletInfo>();
    private volatile boolean dragging;
    private Image javaLogoImage;

    public static AWTDragHelper getInstance() {
        return soleInstance;
    }

    @Override
    public synchronized void register(DragContext ctx, DragListener listener) {
        if (!this.initialize()) {
            return;
        }
        this.perAppletInfoList.add(new PerAppletInfo(ctx, listener));
    }

    @Override
    public void makeDisconnected(DragContext ctx, Window container) {
        for (PerAppletInfo info : this.perAppletInfoList) {
            if (info.getDragContext() != ctx) continue;
            info.makeDisconnected((Frame)container.getWindowObject());
            return;
        }
    }

    @Override
    public synchronized void restore(DragContext ctx) {
        for (PerAppletInfo info : this.perAppletInfoList) {
            if (info.getDragContext() != ctx) continue;
            info.restore();
            return;
        }
    }

    @Override
    public synchronized void unregister(DragContext ctx) {
        Iterator<PerAppletInfo> iter = this.perAppletInfoList.iterator();
        while (iter.hasNext()) {
            PerAppletInfo info = iter.next();
            if (info.getDragContext() != ctx) continue;
            assert (!info.iAmDragging());
            if (info.iAmDragging()) {
                if (DEBUG) {
                    Trace.print((String)"Dragging applet interrupted.", (TraceLevel)TraceLevel.UI);
                }
                this.setSomeoneDragging(false);
            }
            iter.remove();
            return;
        }
    }

    private AWTDragHelper() {
    }

    private boolean initialize() {
        if (!this.initialized) {
            this.initialized = true;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    block2: {
                        try {
                            Class<SunToolkit> c = SunToolkit.class;
                            AWTDragHelper.this.isSystemGeneratedMethod = c.getMethod("isSystemGenerated", AWTEvent.class);
                        }
                        catch (Exception e) {
                            if (isOSX) break block2;
                            Trace.printException((Throwable)e);
                        }
                    }
                    Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                        @Override
                        public void eventDispatched(AWTEvent event) {
                            AWTDragHelper.this.dispatchEvent(event);
                        }
                    }, 48L);
                    return null;
                }
            });
        }
        return this.isSystemGeneratedMethod != null || isOSX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(AWTEvent event) {
        if (event instanceof InputEvent) {
            InputEvent ev = (InputEvent)event;
            if (this.isSystemGenerated(event) && (this.dragging || AWTDragHelper.couldBeDragStartEvent(ev))) {
                AWTDragHelper aWTDragHelper = this;
                synchronized (aWTDragHelper) {
                    for (PerAppletInfo info : this.perAppletInfoList) {
                        if (!info.dispatchEvent(ev)) continue;
                        return;
                    }
                }
            }
        }
    }

    private boolean isSystemGenerated(AWTEvent event) {
        if (this.isSystemGeneratedMethod == null) {
            if (!isOSX) {
                return false;
            }
            return !((InputEvent)event).isConsumed();
        }
        try {
            return (Boolean)this.isSystemGeneratedMethod.invoke(null, event);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSomeoneDragging() {
        return this.dragging;
    }

    private void setSomeoneDragging(boolean isDragging) {
        this.dragging = isDragging;
    }

    private static boolean couldBeDragStartEvent(AWTEvent ae) {
        int id = ae.getID();
        return id == 501 || id == 506;
    }

    private static Point getCurrentMouseLocation() {
        return AccessController.doPrivileged(new PrivilegedAction<Point>(){

            @Override
            public Point run() {
                return MouseInfo.getPointerInfo().getLocation();
            }
        });
    }

    private static Dimension getDragSize(Component component) {
        Dimension result = null;
        for (Component c = component; c != null; c = c.getParent()) {
            Dimension cur = c.getSize();
            if (result != null && cur.width >= result.width && cur.height >= result.height) continue;
            result = cur;
        }
        return result;
    }

    private Image getJavaLogoImage(final Component c) {
        if (this.javaLogoImage == null) {
            this.javaLogoImage = AccessController.doPrivileged(new PrivilegedAction<Image>(){

                @Override
                public Image run() {
                    Image logoImage = ResourceManager.getImageResource((String)"JavaCupLogo-161.png");
                    MediaTracker mt = new MediaTracker(c);
                    mt.addImage(logoImage, 0);
                    try {
                        mt.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return logoImage;
                }
            });
        }
        return this.javaLogoImage;
    }

    private Canvas getJavaLogoCanvas(Dimension size) {
        Canvas c = new Canvas(){

            @Override
            public void paint(Graphics g) {
                Image image = AWTDragHelper.this.getJavaLogoImage(this);
                if (image != null) {
                    Rectangle r = AWTDragHelper.getCenteredImageBoundsWithinContainer(new Dimension(image.getWidth(this), image.getHeight(this)), this.getParent().getSize());
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g2d.drawImage(image, r.x, r.y, r.width, r.height, this);
                }
            }
        };
        c.setSize(size);
        return c;
    }

    private static Rectangle getCenteredImageBoundsWithinContainer(Dimension imageSize, Dimension containerSize) {
        float containerAspectRatio = (float)containerSize.width / (float)containerSize.height;
        float aspectRatio = (float)imageSize.width / (float)imageSize.height;
        if (containerAspectRatio < aspectRatio) {
            if (imageSize.width > containerSize.width) {
                int newImageHeight = (int)((float)containerSize.width / aspectRatio);
                return new Rectangle(0, (containerSize.height - newImageHeight) / 2, containerSize.width, newImageHeight);
            }
        } else if (imageSize.height > containerSize.height) {
            int newImageWidth = (int)((float)containerSize.height * aspectRatio);
            return new Rectangle((containerSize.width - newImageWidth) / 2, 0, newImageWidth, containerSize.height);
        }
        return new Rectangle((containerSize.width - imageSize.width) / 2, (containerSize.height - imageSize.height) / 2, imageSize.width, imageSize.height);
    }

    private static boolean isSubclass(Class<?> c, String name) {
        if (c == null) {
            return false;
        }
        if (c.getName().equals(name)) {
            return true;
        }
        return AWTDragHelper.isSubclass(c.getSuperclass(), name);
    }

    private class PerAppletInfo {
        private final DragContext ctx;
        private Frame frame;
        private Point dragOffset;
        private Point upperLeft;
        private final DragListener listener;
        private boolean notificationsSent;
        private Frame closeButtonFrame;
        private final Point closeButtonOffset = new Point(5, -5);
        private ActionListener closeListener;
        private boolean closing;
        private Dimension dragSize;
        private static final int CLOSE_BUTTON_SIZE = 10;
        private static final int CLOSE_BUTTON_OFFSET = 5;
        private boolean initializedDragStartMethod;
        private Method dragStartMethod;

        PerAppletInfo(DragContext ctx, DragListener listener) {
            this.ctx = ctx;
            this.listener = listener;
        }

        public DragContext getDragContext() {
            return this.ctx;
        }

        public boolean dispatchEvent(AWTEvent event) {
            MouseEvent e = (MouseEvent)event;
            if (AWTDragHelper.this.isSomeoneDragging() && !this.iAmDragging()) {
                return false;
            }
            Applet a = ((AWTAppletAdapter)this.ctx.getApplet2Adapter()).getApplet();
            if (a == null) {
                return false;
            }
            if (this.ctx.getModalityLevel() != 0) {
                return false;
            }
            if (this.iAmDragging()) {
                this.dispatchEventImpl(a, e, this.ctx.isSignedApplet());
                return true;
            }
            boolean mightBeDragStart = false;
            for (Component c = e.getComponent(); c != null; c = c.getParent()) {
                if (c != a) continue;
                mightBeDragStart = true;
                break;
            }
            if (!mightBeDragStart) {
                return false;
            }
            if (this.isDragStartEvent(a, e)) {
                this.dispatchEventImpl(a, e, this.ctx.isSignedApplet());
                return true;
            }
            return false;
        }

        public void restore() {
            Container originalContainer = (Container)this.ctx.getParentContainer().getWindowObject();
            Applet applet = ((AWTAppletAdapter)this.ctx.getApplet2Adapter()).getApplet();
            if (applet != null && originalContainer != null) {
                if (originalContainer instanceof JFrame) {
                    ((JFrame)originalContainer).getContentPane().removeAll();
                } else {
                    originalContainer.removeAll();
                }
                applet.resize(this.dragSize.width, this.dragSize.height);
                originalContainer.add(applet);
                this.sendAppletRestored(applet);
                this.notificationsSent = false;
                this.closing = false;
                applet.repaint();
            }
        }

        private boolean iAmDragging() {
            return this.dragOffset != null;
        }

        private void setFrameTitle(Frame frame) {
            String name = this.ctx.getDraggedTitle();
            int lastDot = name.lastIndexOf(".");
            if (lastDot > 0) {
                name = name.substring(lastDot + 1);
            }
            frame.setTitle(name);
        }

        private void setupCloseListener(Applet applet, boolean signed) {
            this.closeListener = new CloseListener();
            if (!this.sendSetAppletCloseListener(applet, this.closeListener)) {
                this.closeButtonFrame = this.createCloseButton(this.closeListener, signed);
                this.refreshCloseButtonFrame();
                this.closeButtonFrame.setVisible(true);
            }
        }

        private void setupWindow(Frame frame) {
            DisplayMode mode;
            GraphicsDevice dev;
            frame.addWindowListener(new WindowAdapter(){
                private long lastActivate;

                @Override
                public void windowActivated(WindowEvent e) {
                    long curActivate = System.currentTimeMillis();
                    if (curActivate - this.lastActivate > 200L) {
                        if (PerAppletInfo.this.closeButtonFrame != null) {
                            PerAppletInfo.this.closeButtonFrame.toFront();
                        }
                        this.lastActivate = curActivate;
                    }
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    if (PerAppletInfo.this.closeListener != null) {
                        PerAppletInfo.this.closeListener.actionPerformed(null);
                    }
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    if (PerAppletInfo.this.closeButtonFrame != null) {
                        PerAppletInfo.this.closeButtonFrame.setVisible(false);
                    }
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    if (PerAppletInfo.this.closeButtonFrame != null) {
                        PerAppletInfo.this.closeButtonFrame.setVisible(true);
                        PerAppletInfo.this.refreshCloseButtonFrame();
                    }
                }
            });
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (env != null && (dev = env.getDefaultScreenDevice()) != null && (mode = dev.getDisplayMode()) != null) {
                int maxSizeDelta = 30;
                frame.setMaximizedBounds(new Rectangle(0, 0, mode.getWidth() - maxSizeDelta, mode.getHeight() - maxSizeDelta));
            }
        }

        private void makeDisconnected(Frame frame) {
            this.frame = frame;
            this.setupWindow(frame);
            this.setFrameTitle(frame);
            this.upperLeft = frame.getLocation();
            Applet applet = ((AWTAppletAdapter)this.ctx.getApplet2Adapter()).getApplet();
            this.sendDragStarted(applet);
            this.sendDragFinished(applet);
            this.notificationsSent = true;
            this.setupCloseListener(applet, this.ctx.isSignedApplet());
        }

        private void refreshCloseButtonFrame() {
            if (this.closeButtonFrame != null && this.frame != null) {
                int posY;
                Point framePos = this.frame.getLocationOnScreen();
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                int screenWidth = (int)screen.getWidth();
                int posX = framePos.x + this.frame.getWidth() + this.closeButtonOffset.x;
                if (posX > screenWidth) {
                    posX = screenWidth - 10;
                }
                if ((posY = framePos.y + this.closeButtonOffset.y) < 0) {
                    posY = 10;
                }
                this.closeButtonFrame.setLocation(posX, posY);
            }
        }

        private void dispatchEventImpl(Applet applet, MouseEvent e, boolean signed) {
            if (!this.iAmDragging()) {
                AWTDragHelper.this.setSomeoneDragging(true);
                this.upperLeft = applet.getLocationOnScreen();
                Point curPos = AWTDragHelper.getCurrentMouseLocation();
                this.dragOffset = new Point(curPos.x - this.upperLeft.x, curPos.y - this.upperLeft.y);
                this.dragSize = AWTDragHelper.getDragSize(applet);
                if (this.frame == null) {
                    this.frame = AWTDragHelper.isSubclass(applet.getClass(), "javax.swing.JApplet") ? (signed ? new JFrame() : new DraggedAppletJFrame()) : (signed ? new Frame() : new DraggedAppletFrame());
                    this.ctx.setDraggedApplet();
                    boolean undecorated = this.ctx.getUndecorated();
                    this.frame.setUndecorated(undecorated);
                    this.setupWindow(this.frame);
                    this.setFrameTitle(this.frame);
                    final Container currentParent = (Container)this.ctx.getParentContainer().getWindowObject();
                    if (currentParent != null) {
                        currentParent.remove(applet);
                        OldPluginAWTUtil.invokeLater(currentParent, new Runnable(){

                            @Override
                            public void run() {
                                Canvas c = AWTDragHelper.this.getJavaLogoCanvas(PerAppletInfo.this.dragSize);
                                currentParent.add(c);
                            }
                        });
                    }
                    this.frame.add((Component)applet, "Center");
                    applet.setLocation(0, 0);
                    this.frame.setSize(this.dragSize);
                    this.frame.setResizable(false);
                }
                if (!this.notificationsSent) {
                    this.sendDragStarted(applet);
                    this.listener.appletDraggingToDesktop(this.ctx);
                }
                this.frame.setLocation(this.upperLeft);
                this.frame.setVisible(true);
                if (isOSX && !this.notificationsSent) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            try {
                                Robot r = new Robot();
                                r.mouseRelease(16);
                                r.mousePress(16);
                            }
                            catch (Exception e) {
                                Trace.printException((Throwable)e);
                            }
                            return null;
                        }
                    });
                }
            } else {
                int id = e.getID();
                if (id == 506 || id == 505) {
                    if (this.frame != null && this.dragOffset != null) {
                        block14: {
                            try {
                                Point curPos = AWTDragHelper.getCurrentMouseLocation();
                                this.upperLeft.x = curPos.x - this.dragOffset.x;
                                this.upperLeft.y = curPos.y - this.dragOffset.y;
                            }
                            catch (Throwable t) {
                                if (id == 505) break block14;
                                int deltaX = e.getX() - this.dragOffset.x;
                                int deltaY = e.getY() - this.dragOffset.y;
                                this.upperLeft.x += deltaX;
                                this.upperLeft.y += deltaY;
                            }
                        }
                        this.frame.setLocation(this.upperLeft);
                        this.frame.toFront();
                        if (this.closeButtonFrame != null) {
                            this.refreshCloseButtonFrame();
                            this.closeButtonFrame.toFront();
                        }
                    }
                } else if (id == 502 && e.getButton() == 1 || id == 503) {
                    this.dragOffset = null;
                    if (!this.notificationsSent) {
                        this.sendDragFinished(applet);
                        this.listener.appletDroppedOntoDesktop(this.ctx);
                        this.notificationsSent = true;
                        this.setupCloseListener(applet, signed);
                    }
                    AWTDragHelper.this.setSomeoneDragging(false);
                }
            }
            e.consume();
        }

        private Frame createCloseButton(final ActionListener closeListener, boolean signed) {
            Canvas closeButton = new Canvas(){

                @Override
                public void paint(Graphics graphics) {
                    Graphics2D g = (Graphics2D)graphics;
                    int rectWidth = (int)Math.max(1.0, 0.025 * (double)Math.min(this.getWidth(), this.getHeight()));
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 0, rectWidth, this.getHeight());
                    g.fillRect(0, 0, this.getWidth(), rectWidth);
                    g.fillRect(0, this.getHeight() - rectWidth, this.getWidth(), rectWidth);
                    g.fillRect(this.getWidth() - rectWidth, 0, rectWidth, this.getHeight());
                    g.setStroke(new BasicStroke(rectWidth, 0, 2));
                    float insetPercentage = 0.15f;
                    g.drawLine((int)(insetPercentage * (float)this.getWidth()), (int)(insetPercentage * (float)this.getHeight()), (int)((1.0f - insetPercentage) * (float)this.getWidth()), (int)((1.0f - insetPercentage) * (float)this.getHeight()));
                    g.drawLine((int)((1.0f - insetPercentage) * (float)this.getWidth()), (int)(insetPercentage * (float)this.getHeight()), (int)(insetPercentage * (float)this.getWidth()), (int)((1.0f - insetPercentage) * (float)this.getHeight()));
                }
            };
            closeButton.setBackground(Color.BLACK);
            closeButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    closeListener.actionPerformed(null);
                    if (PerAppletInfo.this.closeButtonFrame != null) {
                        PerAppletInfo.this.closeButtonFrame.setVisible(false);
                        PerAppletInfo.this.closeButtonFrame.dispose();
                        PerAppletInfo.this.closeButtonFrame = null;
                    }
                }
            });
            Frame f = new Frame();
            f.setUndecorated(true);
            f.setResizable(false);
            f.setFocusableWindowState(false);
            f.add(closeButton);
            f.setSize(10, 10);
            return f;
        }

        private boolean isDragStartEvent(Applet a, MouseEvent e) {
            if (!this.initializedDragStartMethod) {
                this.initializedDragStartMethod = true;
                try {
                    this.dragStartMethod = a.getClass().getMethod("isAppletDragStart", MouseEvent.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.dragStartMethod != null) {
                try {
                    return (Boolean)this.dragStartMethod.invoke((Object)a, e);
                }
                catch (Throwable t) {
                    this.dragStartMethod = null;
                }
            }
            int mods = e.getModifiersEx();
            if (isOSX) {
                mods &= 0xFFFFDFFF;
            }
            return e.getButton() == 1 && (mods == 1536 || !isOSX && mods == 1280);
        }

        private void sendDragStarted(Applet applet) {
            if (DEBUG) {
                System.out.println("DragHelper sending appletDragStarted for applet ID " + this.ctx.getAppletId());
            }
            try {
                Method m = applet.getClass().getMethod("appletDragStarted", null);
                m.invoke((Object)applet, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void sendDragFinished(Applet applet) {
            if (DEBUG) {
                System.out.println("DragHelper sending appletDragFinished for applet ID " + this.ctx.getAppletId());
            }
            try {
                Method m = applet.getClass().getMethod("appletDragFinished", null);
                m.invoke((Object)applet, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void sendAppletRestored(Applet applet) {
            if (DEBUG) {
                System.out.println("DragHelper sending appletRestored for applet ID " + this.ctx.getAppletId());
            }
            try {
                Method m = applet.getClass().getMethod("appletRestored", null);
                m.invoke((Object)applet, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private boolean sendSetAppletCloseListener(Applet applet, ActionListener l) {
            if (DEBUG) {
                System.out.println("DragHelper sending setAppletCloseListener for applet ID " + this.ctx.getAppletId());
            }
            try {
                Method m = applet.getClass().getMethod("setAppletCloseListener", ActionListener.class);
                m.invoke((Object)applet, l);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        class CloseListener
        implements ActionListener {
            CloseListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PerAppletInfo.this.closing) {
                    return;
                }
                PerAppletInfo.this.closing = true;
                if (PerAppletInfo.this.listener != null) {
                    PerAppletInfo.this.listener.appletExternalWindowClosed(PerAppletInfo.this.ctx);
                }
                if (PerAppletInfo.this.ctx.isDisconnected()) {
                    AWTDragHelper.this.unregister(PerAppletInfo.this.ctx);
                }
                PerAppletInfo.this.frame.setVisible(false);
                PerAppletInfo.this.frame.dispose();
                PerAppletInfo.this.frame = null;
                if (PerAppletInfo.this.closeButtonFrame != null) {
                    PerAppletInfo.this.closeButtonFrame.setVisible(false);
                    PerAppletInfo.this.closeButtonFrame.dispose();
                    PerAppletInfo.this.closeButtonFrame = null;
                }
            }
        }
    }

    public class DraggedAppletFrame
    extends Frame {
        private static final long serialVersionUID = -6974266300082796764L;

        DraggedAppletFrame() {
        }
    }

    public class DraggedAppletJFrame
    extends JFrame {
        private static final long serialVersionUID = 6116888844837641532L;

        DraggedAppletJFrame() {
        }
    }
}

