/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

public class PojoUtil {
    private final StringBuffer sb = new StringBuffer();
    private final ArrayList<Object> path = new ArrayList();

    private PojoUtil() {
    }

    public static String toJson(Object obj) {
        PojoUtil pu = new PojoUtil();
        pu.toJson(obj, 0);
        return pu.sb.toString();
    }

    private void indent(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.sb.append("  ");
        }
    }

    private void toJson(Object obj, int depth) {
        if (this.path.contains(obj)) {
            this.sb.append("{/*loop->").append(obj.getClass().getName()).append("@").append(obj.hashCode()).append("*/}");
            return;
        }
        this.path.add(obj);
        if (null == obj) {
            this.sb.append("null");
        } else if (obj instanceof String || obj instanceof Character) {
            this.sb.append('\"').append(obj).append('\"');
        } else if (obj instanceof Boolean) {
            this.sb.append((Boolean)obj != false ? "true" : "false");
        } else if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
            this.sb.append(obj);
        } else if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            if (length == 0) {
                this.sb.append("[]");
            } else {
                this.sb.append("[\n");
                for (int i = 0; i < length; ++i) {
                    if (i != 0) {
                        this.sb.append(",\n");
                    }
                    this.indent(depth + 1);
                    this.toJson(Array.get(obj, i), depth + 1);
                }
                this.sb.append("\n");
                this.indent(depth);
                this.sb.append(']');
            }
        } else {
            this.pojo2json(obj, depth, obj.getClass());
        }
        this.path.remove(this.path.size() - 1);
    }

    private void pojo2json(final Object obj, final int depth, final Class<?> cls) {
        if (depth > 10) {
            this.sb.append("{/*...*/}");
            return;
        }
        boolean empty = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Field[] fields = cls.getDeclaredFields();
                boolean empty = true;
                PojoUtil.this.sb.append("{");
                for (int i = 0; i < fields.length; ++i) {
                    int mask = 24;
                    Field field = fields[i];
                    if (mask == (field.getModifiers() & mask)) continue;
                    empty = false;
                    boolean accessible = field.isAccessible();
                    if (!accessible) {
                        field.setAccessible(true);
                    }
                    if (i != 0) {
                        PojoUtil.this.sb.append(",\n");
                    } else {
                        PojoUtil.this.sb.append("\n");
                    }
                    PojoUtil.this.indent(depth + 1);
                    PojoUtil.this.sb.append('\"').append(fields[i].getName()).append("\": ");
                    try {
                        PojoUtil.this.toJson(fields[i].get(obj), depth + 1);
                    }
                    catch (IllegalArgumentException ex) {
                        ex.printStackTrace();
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    field.setAccessible(accessible);
                }
                return empty;
            }
        });
        Class<?> superCls = cls.getSuperclass();
        if (superCls != null && superCls != Object.class) {
            if (!empty) {
                this.sb.append(",\n");
            } else {
                this.sb.append("\n");
            }
            empty = false;
            this.indent(depth + 1);
            this.sb.append('\"').append(superCls.getName()).append("\": ");
            this.pojo2json(obj, depth + 1, superCls);
        }
        if (!empty) {
            this.sb.append("\n");
            this.indent(depth);
        }
        this.sb.append("}");
    }
}

