/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom;

import org.w3c.dom.DOMException;
import sun.plugin.dom.DOMObject;

public class DOMObjectHelper {
    public static boolean getBooleanMember(DOMObject obj, String name) throws DOMException {
        Object result = obj.getMember(name);
        if (result != null) {
            return new Boolean(result.toString());
        }
        return false;
    }

    public static boolean getBooleanMemberNoEx(DOMObject obj, String name) {
        try {
            return DOMObjectHelper.getBooleanMember(obj, name);
        }
        catch (DOMException e) {
            return false;
        }
    }

    public static void setBooleanMember(DOMObject obj, String name, boolean value) throws DOMException {
        obj.setMember(name, "" + value);
    }

    public static void setBooleanMemberNoEx(DOMObject obj, String name, boolean value) {
        try {
            DOMObjectHelper.setBooleanMember(obj, name, value);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
    }

    public static int getIntMember(DOMObject obj, String name) throws DOMException {
        Object result = obj.getMember(name);
        if (result != null) {
            return new Float(result.toString()).intValue();
        }
        return 0;
    }

    public static int getIntMemberNoEx(DOMObject obj, String name) {
        try {
            return DOMObjectHelper.getIntMember(obj, name);
        }
        catch (DOMException dOMException) {
            return 0;
        }
    }

    public static void setIntMember(DOMObject obj, String name, int value) throws DOMException {
        obj.setMember(name, "" + value);
    }

    public static void setIntMemberNoEx(DOMObject obj, String name, int value) {
        try {
            DOMObjectHelper.setIntMember(obj, name, value);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
    }

    public static String getStringMember(DOMObject obj, String name) throws DOMException {
        Object result = obj.getMember(name);
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public static String getStringMemberNoEx(DOMObject obj, String name) {
        try {
            return DOMObjectHelper.getStringMember(obj, name);
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    public static void setStringMember(DOMObject obj, String name, String value) throws DOMException {
        obj.setMember(name, value);
    }

    public static void setStringMemberNoEx(DOMObject obj, String name, String value) {
        try {
            DOMObjectHelper.setStringMember(obj, name, value);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
    }

    public static String callStringMethod(DOMObject obj, String name, Object[] args) {
        Object result = obj.call(name, args);
        if (result != null) {
            return result.toString();
        }
        return null;
    }
}

