/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.core;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.html.HTMLDocument;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectFactory;
import sun.plugin.dom.exception.PluginNotSupportedException;

public abstract class Node
implements org.w3c.dom.Node {
    protected DOMObject obj;
    private Document doc;

    protected Node(DOMObject obj, Document doc) {
        this.obj = obj;
        this.doc = doc;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Node)) {
            return false;
        }
        return this.obj.equals(((Node)other).obj);
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(this.toString());
        return sb.toString().hashCode();
    }

    public String toString() {
        if (this.obj != null) {
            return this.obj.toString();
        }
        return super.toString();
    }

    public DOMObject getDOMObject() {
        return this.obj;
    }

    @Override
    public String getNodeName() {
        return (String)this.obj.getMember("nodeName");
    }

    @Override
    public abstract String getNodeValue() throws DOMException;

    @Override
    public abstract void setNodeValue(String var1) throws DOMException;

    @Override
    public short getNodeType() {
        return ((Number)this.obj.getMember("nodeType")).shortValue();
    }

    @Override
    public NodeList getChildNodes() {
        return DOMObjectFactory.createNodeList(this.obj.getMember("childNodes"), (HTMLDocument)this.getOwnerDocument());
    }

    @Override
    public org.w3c.dom.Node getParentNode() {
        return DOMObjectFactory.createNode(this.obj.getMember("parentNode"), this.getOwnerDocument());
    }

    @Override
    public org.w3c.dom.Node getFirstChild() {
        NodeList nodes = this.getChildNodes();
        if (nodes != null && nodes.getLength() > 0) {
            return nodes.item(0);
        }
        return null;
    }

    @Override
    public org.w3c.dom.Node getLastChild() {
        int size;
        NodeList nodes = this.getChildNodes();
        if (nodes != null && (size = nodes.getLength()) > 0) {
            return nodes.item(size - 1);
        }
        return null;
    }

    @Override
    public org.w3c.dom.Node getPreviousSibling() {
        return DOMObjectFactory.createNode(this.obj.getMember("previousSibling"), this.getOwnerDocument());
    }

    @Override
    public org.w3c.dom.Node getNextSibling() {
        return DOMObjectFactory.createNode(this.obj.getMember("nextSibling"), (HTMLDocument)this.getOwnerDocument());
    }

    @Override
    public NamedNodeMap getAttributes() {
        return DOMObjectFactory.createNamedNodeMap(this.obj.getMember("attributes"), (HTMLDocument)this.getOwnerDocument());
    }

    @Override
    public Document getOwnerDocument() {
        return this.doc;
    }

    @Override
    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        if (newChild != null && refChild != null) {
            if (newChild instanceof Node && refChild instanceof Node) {
                Node newNode = (Node)newChild;
                Node newRefNode = (Node)refChild;
                Object result = this.obj.call("insertBefore", new Object[]{newNode.obj.getJSObject(), newRefNode.obj.getJSObject()});
                return DOMObjectFactory.createNode(result, (HTMLDocument)this.getOwnerDocument());
            }
            throw new PluginNotSupportedException("Node.insertBefore() does not support node type: (" + newChild.getClass().getName() + ", " + refChild.getClass().getName() + ")");
        }
        return null;
    }

    @Override
    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) throws DOMException {
        if (newChild != null && oldChild != null) {
            if (newChild instanceof Node && oldChild instanceof Node) {
                Node newNode = (Node)newChild;
                Node oldNode = (Node)oldChild;
                Object result = this.obj.call("replaceChild", new Object[]{newNode.obj.getJSObject(), oldNode.obj.getJSObject()});
                return DOMObjectFactory.createNode(result, (HTMLDocument)this.getOwnerDocument());
            }
            throw new PluginNotSupportedException("Node.replaceChild() does not support node type: (" + newChild.getClass().getName() + ", " + oldChild.getClass().getName() + ")");
        }
        return null;
    }

    @Override
    public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) throws DOMException {
        if (oldChild != null) {
            if (oldChild instanceof Node) {
                Node node = (Node)oldChild;
                Object result = this.obj.call("removeChild", new Object[]{node.obj.getJSObject()});
                return DOMObjectFactory.createNode(result, (HTMLDocument)this.getOwnerDocument());
            }
            throw new PluginNotSupportedException("Node.removeChild() does not support node type: " + oldChild.getClass().getName());
        }
        return null;
    }

    @Override
    public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) throws DOMException {
        if (newChild != null) {
            if (newChild instanceof Node) {
                Node node = (Node)newChild;
                Object result = this.obj.call("appendChild", new Object[]{node.obj.getJSObject()});
                return DOMObjectFactory.createNode(result, (HTMLDocument)this.getOwnerDocument());
            }
            throw new PluginNotSupportedException("Node.appendChild() does not support node type: " + newChild.getClass().getName());
        }
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return (Boolean)this.obj.call("hasChildNodes", null);
    }

    @Override
    public org.w3c.dom.Node cloneNode(boolean deep) {
        Object result = this.obj.call("cloneNode", new Object[]{new Boolean(deep)});
        return DOMObjectFactory.createNode(result, (HTMLDocument)this.getOwnerDocument());
    }

    @Override
    public void normalize() {
        this.obj.call("normalize", null);
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this.getOwnerDocument().getImplementation().hasFeature(feature, version);
    }

    @Override
    public String getNamespaceURI() {
        return (String)this.obj.getMember("namespaceURI");
    }

    @Override
    public String getPrefix() {
        return (String)this.obj.getMember("prefix");
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.obj.setMember("prefix", prefix);
    }

    @Override
    public String getLocalName() {
        return (String)this.obj.getMember("localName");
    }

    @Override
    public boolean hasAttributes() {
        return (Boolean)this.obj.call("hasAttributes", null);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new PluginNotSupportedException("Node.setUserData() is not supported.");
    }

    @Override
    public Object getUserData(String key) {
        throw new PluginNotSupportedException("Node.getUserData() is not supported.");
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new PluginNotSupportedException("Node.getFeature() is not supported.");
    }

    @Override
    public boolean isSameNode(org.w3c.dom.Node node) {
        throw new PluginNotSupportedException("Node.isSameNode() is not supported.");
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node node) {
        throw new PluginNotSupportedException("Node.isEqualNode() is not supported.");
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new PluginNotSupportedException("Node.lookupNamespaceURI() is not supported.");
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new PluginNotSupportedException("Node.isDefaultNamespace() is not supported.");
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new PluginNotSupportedException("Node.lookupPrefix() is not supported.");
    }

    @Override
    public String getTextContent() throws DOMException {
        throw new PluginNotSupportedException("Node.getTextContent() is not supported.");
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new PluginNotSupportedException("Node.setTextContent() is not supported.");
    }

    @Override
    public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
        throw new PluginNotSupportedException("Node.compareDocumentPosition() is not supported.");
    }

    @Override
    public String getBaseURI() {
        throw new PluginNotSupportedException("Node.getBaseURI() is not supported.");
    }
}

