/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.html;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ElementCSSInlineStyle;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectFactory;
import sun.plugin.dom.DOMObjectHelper;
import sun.plugin.dom.core.Document;
import sun.plugin.dom.css.ViewCSS;
import sun.plugin.dom.exception.PluginNotSupportedException;
import sun.plugin.dom.html.HTMLElement;

public class HTMLDocument
extends Document
implements org.w3c.dom.html.HTMLDocument,
DocumentView,
DocumentStyle,
DocumentCSS {
    private static final String TAG_HTML = "HTML";

    public HTMLDocument(DOMObject obj, org.w3c.dom.html.HTMLDocument doc) {
        super(obj, doc);
    }

    @Override
    public String getTitle() {
        return this.getAttribute("title");
    }

    @Override
    public void setTitle(String title) {
        this.setAttribute("title", title);
    }

    @Override
    public String getReferrer() {
        return this.getAttribute("referrer");
    }

    @Override
    public String getDomain() {
        return this.getAttribute("domain");
    }

    @Override
    public String getURL() {
        return this.getAttribute("URL");
    }

    @Override
    public org.w3c.dom.html.HTMLElement getBody() {
        Object result = this.obj.getMember("body");
        if (result == null) {
            return null;
        }
        return DOMObjectFactory.createHTMLElement((DOMObject)result, this);
    }

    @Override
    public void setBody(org.w3c.dom.html.HTMLElement body) {
        DOMObject newBody = ((HTMLElement)body).getDOMObject();
        this.obj.setMember("body", newBody);
    }

    @Override
    public HTMLCollection getImages() {
        return DOMObjectFactory.createHTMLCollection(this.obj.getMember("images"), this);
    }

    @Override
    public HTMLCollection getApplets() {
        return DOMObjectFactory.createHTMLCollection(this.obj.getMember("applets"), this);
    }

    @Override
    public HTMLCollection getLinks() {
        return DOMObjectFactory.createHTMLCollection(this.obj.getMember("links"), this);
    }

    @Override
    public HTMLCollection getForms() {
        return DOMObjectFactory.createHTMLCollection(this.obj.getMember("forms"), this);
    }

    @Override
    public HTMLCollection getAnchors() {
        return DOMObjectFactory.createHTMLCollection(this.obj.getMember("anchors"), this);
    }

    @Override
    public String getCookie() {
        return this.getAttribute("cookie");
    }

    @Override
    public void setCookie(String cookie) {
        this.setAttribute("cookie", cookie);
    }

    @Override
    public void open() {
        throw new PluginNotSupportedException("HTMLDocument.open() is not supported");
    }

    @Override
    public void close() {
        throw new PluginNotSupportedException("HTMLDocument.close() is not supported");
    }

    @Override
    public void write(String text) {
        throw new PluginNotSupportedException("HTMLDocument.write() is not supported");
    }

    @Override
    public void writeln(String text) {
        throw new PluginNotSupportedException("HTMLDocument.writeln() is not supported");
    }

    @Override
    public NodeList getElementsByName(String elementName) {
        return DOMObjectFactory.createNodeList(this.obj.call("getElementsByName", new Object[]{elementName}), this);
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return DOMObjectFactory.createNodeList(this.obj.call("getElementsByTagName", new Object[]{tagname}), this);
    }

    @Override
    public Element getDocumentElement() {
        Object result = this.obj.getMember("documentElement");
        if (result == null) {
            return null;
        }
        return DOMObjectFactory.createHTMLElement((DOMObject)result, this);
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        Object result = this.obj.call("createElement", new Object[]{tagName});
        if (result == null) {
            return null;
        }
        return DOMObjectFactory.createHTMLElement((DOMObject)result, this);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        Object result = this.obj.call("createElementNS", new Object[]{namespaceURI, qualifiedName});
        if (result == null) {
            return null;
        }
        return DOMObjectFactory.createHTMLElement((DOMObject)result, this);
    }

    @Override
    public Element getElementById(String elementId) {
        Object result = this.obj.call("getElementById", new Object[]{elementId});
        if (result == null) {
            return null;
        }
        return DOMObjectFactory.createHTMLElement((DOMObject)result, this);
    }

    private String getAttribute(String name) {
        return DOMObjectHelper.getStringMember(this.obj, name);
    }

    private void setAttribute(String name, String value) {
        DOMObjectHelper.setStringMember(this.obj, name, value);
    }

    @Override
    public AbstractView getDefaultView() {
        return new ViewCSS(this);
    }

    @Override
    public StyleSheetList getStyleSheets() {
        return DOMObjectFactory.createStyleSheetList(this.obj.getMember("styleSheets"), this);
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        if (elt instanceof ElementCSSInlineStyle) {
            ElementCSSInlineStyle element = (ElementCSSInlineStyle)((Object)elt);
            return element.getStyle();
        }
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        return this.getElementsByTagName(TAG_HTML);
    }
}

