'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
var _a;
/**
 * A constant that indicates whether the environment the code is running is Node.JS.
 */
const isNode = typeof process !== "undefined" && Boolean(process.version) && Boolean((_a = process.versions) === null || _a === void 0 ? void 0 : _a.node);

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * A wrapper for setTimeout that resolves a promise after timeInMs milliseconds.
 * @param timeInMs - The number of milliseconds to be delayed.
 * @returns Promise that is resolved after timeInMs
 */
function delay(timeInMs) {
    return new Promise((resolve) => setTimeout(() => resolve(), timeInMs));
}

exports.delay = delay;
exports.isNode = isNode;
//# sourceMappingURL=index.js.map
