"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writeToTrackingBuffer = writeToTrackingBuffer;
const TYPE = {
  QUERY_NOTIFICATIONS: 1,
  TXN_DESCRIPTOR: 2,
  TRACE_ACTIVITY: 3
};
const TXNDESCRIPTOR_HEADER_DATA_LEN = 4 + 8;
const TXNDESCRIPTOR_HEADER_LEN = 4 + 2 + TXNDESCRIPTOR_HEADER_DATA_LEN;

function writeToTrackingBuffer(buffer, txnDescriptor, outstandingRequestCount) {
  buffer.writeUInt32LE(0);
  buffer.writeUInt32LE(TXNDESCRIPTOR_HEADER_LEN);
  buffer.writeUInt16LE(TYPE.TXN_DESCRIPTOR);
  buffer.writeBuffer(txnDescriptor);
  buffer.writeUInt32LE(outstandingRequestCount);
  const data = buffer.data;
  data.writeUInt32LE(data.length, 0);
  return buffer;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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