"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CEKEntry = void 0;

// This code is based on the `mssql-jdbc` library published under the conditions of MIT license.
// Copyright (c) 2019 Microsoft Corporation
class CEKEntry {
  constructor(ordinalVal) {
    this.columnEncryptionKeyValues = void 0;
    this.ordinal = void 0;
    this.databaseId = void 0;
    this.cekId = void 0;
    this.cekVersion = void 0;
    this.cekMdVersion = void 0;
    this.ordinal = ordinalVal;
    this.databaseId = 0;
    this.cekId = 0;
    this.cekVersion = 0;
    this.cekMdVersion = Buffer.alloc(0);
    this.columnEncryptionKeyValues = [];
  }

  add(encryptedKey, dbId, keyId, keyVersion, mdVersion, keyPath, keyStoreName, algorithmName) {
    const encryptionKey = {
      encryptedKey,
      dbId,
      keyId,
      keyVersion,
      mdVersion,
      keyPath,
      keyStoreName,
      algorithmName
    };
    this.columnEncryptionKeyValues.push(encryptionKey);

    if (this.databaseId === 0) {
      this.databaseId = dbId;
      this.cekId = keyId;
      this.cekVersion = keyVersion;
      this.cekMdVersion = mdVersion;
    } else if (this.databaseId !== dbId || this.cekId !== keyId || this.cekVersion !== keyVersion || !this.cekMdVersion || !mdVersion || this.cekMdVersion.length !== mdVersion.length) {
      throw new Error('Invalid databaseId, cekId, cekVersion or cekMdVersion.');
    }
  }

}

exports.CEKEntry = CEKEntry;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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