"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@js-joda/core");

// globalDate is to be used for JavaScript's global 'Date' object to avoid name clashing with the 'Date' constant below
const globalDate = global.Date;

const EPOCH_DATE = _core.LocalDate.ofYearDay(1, 1);

const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x03]);
const Date = {
  id: 0x28,
  type: 'DATEN',
  name: 'Date',
  declaration: function () {
    return 'date';
  },
  generateTypeInfo: function () {
    return Buffer.from([this.id]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const value = parameter.value; // Temporary solution. Remove 'any' later.

    let date;

    if (options.useUTC) {
      date = _core.LocalDate.of(value.getUTCFullYear(), value.getUTCMonth() + 1, value.getUTCDate());
    } else {
      date = _core.LocalDate.of(value.getFullYear(), value.getMonth() + 1, value.getDate());
    }

    const days = EPOCH_DATE.until(date, _core.ChronoUnit.DAYS);
    const buffer = Buffer.alloc(3);
    buffer.writeUIntLE(days, 0, 3);
    yield buffer;
  },

  // TODO: value is techincally of type 'unknown'.
  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!(value instanceof globalDate)) {
      value = new globalDate(globalDate.parse(value));
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }

    return value;
  }
};
var _default = Date;
exports.default = _default;
module.exports = Date;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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