"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _decimaln = _interopRequireDefault(require("./decimaln"));

var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NULL_LENGTH = Buffer.from([0x00]);
const Decimal = {
  id: 0x37,
  type: 'DECIMAL',
  name: 'Decimal',
  declaration: function (parameter) {
    return 'decimal(' + this.resolvePrecision(parameter) + ', ' + this.resolveScale(parameter) + ')';
  },
  resolvePrecision: function (parameter) {
    if (parameter.precision != null) {
      return parameter.precision;
    } else if (parameter.value === null) {
      return 1;
    } else {
      return 18;
    }
  },
  resolveScale: function (parameter) {
    if (parameter.scale != null) {
      return parameter.scale;
    } else {
      return 0;
    }
  },

  generateTypeInfo(parameter, _options) {
    let precision;

    if (parameter.precision <= 9) {
      precision = 0x05;
    } else if (parameter.precision <= 19) {
      precision = 0x09;
    } else if (parameter.precision <= 28) {
      precision = 0x0D;
    } else {
      precision = 0x11;
    }

    return Buffer.from([_decimaln.default.id, precision, parameter.precision, parameter.scale]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    const precision = parameter.precision;

    if (precision <= 9) {
      return Buffer.from([0x05]);
    } else if (precision <= 19) {
      return Buffer.from([0x09]);
    } else if (precision <= 28) {
      return Buffer.from([0x0D]);
    } else {
      return Buffer.from([0x11]);
    }
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const sign = parameter.value < 0 ? 0 : 1;
    const value = Math.round(Math.abs(parameter.value * Math.pow(10, parameter.scale)));
    const precision = parameter.precision;

    if (precision <= 9) {
      const buffer = Buffer.alloc(5);
      buffer.writeUInt8(sign, 0);
      buffer.writeUInt32LE(value, 1);
      yield buffer;
    } else if (precision <= 19) {
      const buffer = new _writableTrackingBuffer.default(9);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      yield buffer.data;
    } else if (precision <= 28) {
      const buffer = new _writableTrackingBuffer.default(13);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      buffer.writeUInt32LE(0x00000000);
      yield buffer.data;
    } else {
      const buffer = new _writableTrackingBuffer.default(17);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      buffer.writeUInt32LE(0x00000000);
      buffer.writeUInt32LE(0x00000000);
      yield buffer.data;
    }
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    value = parseFloat(value);

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    return value;
  }
};
var _default = Decimal;
exports.default = _default;
module.exports = Decimal;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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