"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _writableTrackingBuffer = _interopRequireDefault(require("./tracking-buffer/writable-tracking-buffer"));

var _allHeaders = require("./all-headers");

let _Symbol$iterator;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

_Symbol$iterator = Symbol.iterator;

/*
  s2.2.6.6
 */
class SqlBatchPayload {
  constructor(sqlText, txnDescriptor, options) {
    this.sqlText = void 0;
    this.txnDescriptor = void 0;
    this.options = void 0;
    this.sqlText = sqlText;
    this.txnDescriptor = txnDescriptor;
    this.options = options;
  }

  *[_Symbol$iterator]() {
    if (this.options.tdsVersion >= '7_2') {
      const buffer = new _writableTrackingBuffer.default(18, 'ucs2');
      const outstandingRequestCount = 1;
      (0, _allHeaders.writeToTrackingBuffer)(buffer, this.txnDescriptor, outstandingRequestCount);
      yield buffer.data;
    }

    yield Buffer.from(this.sqlText, 'ucs2');
  }

  toString(indent = '') {
    return indent + ('SQL Batch - ' + this.sqlText);
  }

}

var _default = SqlBatchPayload;
exports.default = _default;
module.exports = SqlBatchPayload;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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