"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SSPIToken = exports.RowToken = exports.ReturnValueToken = exports.ReturnStatusToken = exports.OrderToken = exports.NBCRowToken = exports.LoginAckToken = exports.ErrorMessageToken = exports.InfoMessageToken = exports.FedAuthInfoToken = exports.FeatureExtAckToken = exports.RoutingEnvChangeToken = exports.CollationChangeToken = exports.ResetConnectionEnvChangeToken = exports.DatabaseMirroringPartnerEnvChangeToken = exports.RollbackTransactionEnvChangeToken = exports.CommitTransactionEnvChangeToken = exports.BeginTransactionEnvChangeToken = exports.PacketSizeEnvChangeToken = exports.CharsetEnvChangeToken = exports.LanguageEnvChangeToken = exports.DatabaseEnvChangeToken = exports.DoneProcToken = exports.DoneInProcToken = exports.DoneToken = exports.ColMetadataToken = exports.Token = exports.TYPE = void 0;
const TYPE = {
  ALTMETADATA: 0x88,
  ALTROW: 0xD3,
  COLMETADATA: 0x81,
  COLINFO: 0xA5,
  DONE: 0xFD,
  DONEPROC: 0xFE,
  DONEINPROC: 0xFF,
  ENVCHANGE: 0xE3,
  ERROR: 0xAA,
  FEATUREEXTACK: 0xAE,
  FEDAUTHINFO: 0xEE,
  INFO: 0xAB,
  LOGINACK: 0xAD,
  NBCROW: 0xD2,
  OFFSET: 0x78,
  ORDER: 0xA9,
  RETURNSTATUS: 0x79,
  RETURNVALUE: 0xAC,
  ROW: 0xD1,
  SSPI: 0xED,
  TABNAME: 0xA4
};
exports.TYPE = TYPE;

class Token {
  constructor(name, handlerName) {
    this.name = void 0;
    this.handlerName = void 0;
    this.name = name;
    this.handlerName = handlerName;
  }

}

exports.Token = Token;

class ColMetadataToken extends Token {
  constructor(columns) {
    super('COLMETADATA', 'onColMetadata');
    this.columns = void 0;
    this.columns = columns;
  }

}

exports.ColMetadataToken = ColMetadataToken;

class DoneToken extends Token {
  constructor({
    more,
    sqlError,
    attention,
    serverError,
    rowCount,
    curCmd
  }) {
    super('DONE', 'onDone');
    this.more = void 0;
    this.sqlError = void 0;
    this.attention = void 0;
    this.serverError = void 0;
    this.rowCount = void 0;
    this.curCmd = void 0;
    this.more = more;
    this.sqlError = sqlError;
    this.attention = attention;
    this.serverError = serverError;
    this.rowCount = rowCount;
    this.curCmd = curCmd;
  }

}

exports.DoneToken = DoneToken;

class DoneInProcToken extends Token {
  constructor({
    more,
    sqlError,
    attention,
    serverError,
    rowCount,
    curCmd
  }) {
    super('DONEINPROC', 'onDoneInProc');
    this.more = void 0;
    this.sqlError = void 0;
    this.attention = void 0;
    this.serverError = void 0;
    this.rowCount = void 0;
    this.curCmd = void 0;
    this.more = more;
    this.sqlError = sqlError;
    this.attention = attention;
    this.serverError = serverError;
    this.rowCount = rowCount;
    this.curCmd = curCmd;
  }

}

exports.DoneInProcToken = DoneInProcToken;

class DoneProcToken extends Token {
  constructor({
    more,
    sqlError,
    attention,
    serverError,
    rowCount,
    curCmd
  }) {
    super('DONEPROC', 'onDoneProc');
    this.more = void 0;
    this.sqlError = void 0;
    this.attention = void 0;
    this.serverError = void 0;
    this.rowCount = void 0;
    this.curCmd = void 0;
    this.more = more;
    this.sqlError = sqlError;
    this.attention = attention;
    this.serverError = serverError;
    this.rowCount = rowCount;
    this.curCmd = curCmd;
  }

}

exports.DoneProcToken = DoneProcToken;

class DatabaseEnvChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onDatabaseChange');
    this.type = void 0;
    this.newValue = void 0;
    this.oldValue = void 0;
    this.type = 'DATABASE';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.DatabaseEnvChangeToken = DatabaseEnvChangeToken;

class LanguageEnvChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onLanguageChange');
    this.type = void 0;
    this.newValue = void 0;
    this.oldValue = void 0;
    this.type = 'LANGUAGE';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.LanguageEnvChangeToken = LanguageEnvChangeToken;

class CharsetEnvChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onCharsetChange');
    this.type = void 0;
    this.newValue = void 0;
    this.oldValue = void 0;
    this.type = 'CHARSET';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.CharsetEnvChangeToken = CharsetEnvChangeToken;

class PacketSizeEnvChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onPacketSizeChange');
    this.type = void 0;
    this.newValue = void 0;
    this.oldValue = void 0;
    this.type = 'PACKET_SIZE';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.PacketSizeEnvChangeToken = PacketSizeEnvChangeToken;

class BeginTransactionEnvChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onBeginTransaction');
    this.type = void 0;
    this.newValue = void 0;
    this.oldValue = void 0;
    this.type = 'BEGIN_TXN';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.BeginTransactionEnvChangeToken = BeginTransactionEnvChangeToken;

class CommitTransactionEnvChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onCommitTransaction');
    this.type = void 0;
    this.newValue = void 0;
    this.oldValue = void 0;
    this.type = 'COMMIT_TXN';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.CommitTransactionEnvChangeToken = CommitTransactionEnvChangeToken;

class RollbackTransactionEnvChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onRollbackTransaction');
    this.type = void 0;
    this.oldValue = void 0;
    this.newValue = void 0;
    this.type = 'ROLLBACK_TXN';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.RollbackTransactionEnvChangeToken = RollbackTransactionEnvChangeToken;

class DatabaseMirroringPartnerEnvChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onDatabaseMirroringPartner');
    this.type = void 0;
    this.oldValue = void 0;
    this.newValue = void 0;
    this.type = 'DATABASE_MIRRORING_PARTNER';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.DatabaseMirroringPartnerEnvChangeToken = DatabaseMirroringPartnerEnvChangeToken;

class ResetConnectionEnvChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onResetConnection');
    this.type = void 0;
    this.oldValue = void 0;
    this.newValue = void 0;
    this.type = 'RESET_CONNECTION';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.ResetConnectionEnvChangeToken = ResetConnectionEnvChangeToken;

class CollationChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onSqlCollationChange');
    this.type = void 0;
    this.oldValue = void 0;
    this.newValue = void 0;
    this.type = 'SQL_COLLATION';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.CollationChangeToken = CollationChangeToken;

class RoutingEnvChangeToken extends Token {
  constructor(newValue, oldValue) {
    super('ENVCHANGE', 'onRoutingChange');
    this.type = void 0;
    this.newValue = void 0;
    this.oldValue = void 0;
    this.type = 'ROUTING_CHANGE';
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

}

exports.RoutingEnvChangeToken = RoutingEnvChangeToken;

class FeatureExtAckToken extends Token {
  /** Value of UTF8_SUPPORT acknowledgement.
   *
   * undefined when UTF8_SUPPORT not included in token. */
  constructor(fedAuth, utf8Support) {
    super('FEATUREEXTACK', 'onFeatureExtAck');
    this.fedAuth = void 0;
    this.utf8Support = void 0;
    this.fedAuth = fedAuth;
    this.utf8Support = utf8Support;
  }

}

exports.FeatureExtAckToken = FeatureExtAckToken;

class FedAuthInfoToken extends Token {
  constructor(spn, stsurl) {
    super('FEDAUTHINFO', 'onFedAuthInfo');
    this.spn = void 0;
    this.stsurl = void 0;
    this.spn = spn;
    this.stsurl = stsurl;
  }

}

exports.FedAuthInfoToken = FedAuthInfoToken;

class InfoMessageToken extends Token {
  constructor({
    number,
    state,
    class: clazz,
    message,
    serverName,
    procName,
    lineNumber
  }) {
    super('INFO', 'onInfoMessage');
    this.number = void 0;
    this.state = void 0;
    this.class = void 0;
    this.message = void 0;
    this.serverName = void 0;
    this.procName = void 0;
    this.lineNumber = void 0;
    this.number = number;
    this.state = state;
    this.class = clazz;
    this.message = message;
    this.serverName = serverName;
    this.procName = procName;
    this.lineNumber = lineNumber;
  }

}

exports.InfoMessageToken = InfoMessageToken;

class ErrorMessageToken extends Token {
  constructor({
    number,
    state,
    class: clazz,
    message,
    serverName,
    procName,
    lineNumber
  }) {
    super('ERROR', 'onErrorMessage');
    this.number = void 0;
    this.state = void 0;
    this.class = void 0;
    this.message = void 0;
    this.serverName = void 0;
    this.procName = void 0;
    this.lineNumber = void 0;
    this.number = number;
    this.state = state;
    this.class = clazz;
    this.message = message;
    this.serverName = serverName;
    this.procName = procName;
    this.lineNumber = lineNumber;
  }

}

exports.ErrorMessageToken = ErrorMessageToken;

class LoginAckToken extends Token {
  constructor({
    interface: interfaze,
    tdsVersion,
    progName,
    progVersion
  }) {
    super('LOGINACK', 'onLoginAck');
    this.interface = void 0;
    this.tdsVersion = void 0;
    this.progName = void 0;
    this.progVersion = void 0;
    this.interface = interfaze;
    this.tdsVersion = tdsVersion;
    this.progName = progName;
    this.progVersion = progVersion;
  }

}

exports.LoginAckToken = LoginAckToken;

class NBCRowToken extends Token {
  constructor(columns) {
    super('NBCROW', 'onRow');
    this.columns = void 0;
    this.columns = columns;
  }

}

exports.NBCRowToken = NBCRowToken;

class OrderToken extends Token {
  constructor(orderColumns) {
    super('ORDER', 'onOrder');
    this.orderColumns = void 0;
    this.orderColumns = orderColumns;
  }

}

exports.OrderToken = OrderToken;

class ReturnStatusToken extends Token {
  constructor(value) {
    super('RETURNSTATUS', 'onReturnStatus');
    this.value = void 0;
    this.value = value;
  }

}

exports.ReturnStatusToken = ReturnStatusToken;

class ReturnValueToken extends Token {
  constructor({
    paramOrdinal,
    paramName,
    metadata,
    value
  }) {
    super('RETURNVALUE', 'onReturnValue');
    this.paramOrdinal = void 0;
    this.paramName = void 0;
    this.metadata = void 0;
    this.value = void 0;
    this.paramOrdinal = paramOrdinal;
    this.paramName = paramName;
    this.metadata = metadata;
    this.value = value;
  }

}

exports.ReturnValueToken = ReturnValueToken;

class RowToken extends Token {
  constructor(columns) {
    super('ROW', 'onRow');
    this.columns = void 0;
    this.columns = columns;
  }

}

exports.RowToken = RowToken;

class SSPIToken extends Token {
  constructor(ntlmpacket, ntlmpacketBuffer) {
    super('SSPICHALLENGE', 'onSSPI');
    this.ntlmpacket = void 0;
    this.ntlmpacketBuffer = void 0;
    this.ntlmpacket = ntlmpacket;
    this.ntlmpacketBuffer = ntlmpacketBuffer;
  }

}

exports.SSPIToken = SSPIToken;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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