import { AuthError } from "./AuthError";
/**
 * InteractionRequiredServerErrorMessage contains string constants used by error codes and messages returned by the server indicating interaction is required
 */
export declare const InteractionRequiredServerErrorMessage: string[];
export declare const InteractionRequiredAuthSubErrorMessage: string[];
/**
 * Interaction required errors defined by the SDK
 */
export declare const InteractionRequiredAuthErrorMessage: {
    noTokensFoundError: {
        code: string;
        desc: string;
    };
};
/**
 * Error thrown when user interaction is required.
 */
export declare class InteractionRequiredAuthError extends AuthError {
    constructor(errorCode?: string, errorMessage?: string, subError?: string);
    /**
     * Helper function used to determine if an error thrown by the server requires interaction to resolve
     * @param errorCode
     * @param errorString
     * @param subError
     */
    static isInteractionRequiredError(errorCode?: string, errorString?: string, subError?: string): boolean;
    /**
     * Creates an error thrown when the authorization code required for a token request is null or empty.
     */
    static createNoTokensFoundError(): InteractionRequiredAuthError;
}
//# sourceMappingURL=InteractionRequiredAuthError.d.ts.map