"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _floatn = _interopRequireDefault(require("./floatn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NULL_LENGTH = Buffer.from([0x00]);
const Float = {
  id: 0x3E,
  type: 'FLT8',
  name: 'Float',
  declaration: function () {
    return 'float';
  },

  generateTypeInfo() {
    return Buffer.from([_floatn.default.id, 0x08]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return Buffer.from([0x08]);
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(8);
    buffer.writeDoubleLE(parseFloat(parameter.value), 0);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    value = parseFloat(value);

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    return value;
  }
};
var _default = Float;
exports.default = _default;
module.exports = Float;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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