"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const NULL_LENGTH = Buffer.from([0xFF, 0xFF, 0xFF, 0xFF]);
const NText = {
  id: 0x63,
  type: 'NTEXT',
  name: 'NText',
  hasTableName: true,
  declaration: function () {
    return 'ntext';
  },
  resolveLength: function (parameter) {
    const value = parameter.value; // Temporary solution. Remove 'any' later.

    if (value != null) {
      return value.length;
    } else {
      return -1;
    }
  },

  generateTypeInfo(parameter, _options) {
    const buffer = Buffer.alloc(10);
    buffer.writeUInt8(this.id, 0);
    buffer.writeInt32LE(parameter.length, 1);

    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 5, 0, 5);
    }

    return buffer;
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(Buffer.byteLength(parameter.value, 'ucs2'), 0);
    return buffer;
  },

  generateParameterData: function* (parameter, options) {
    if (parameter.value == null) {
      return;
    }

    yield Buffer.from(parameter.value.toString(), 'ucs2');
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }

    return value;
  }
};
var _default = NText;
exports.default = _default;
module.exports = NText;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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