"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _iconvLite = _interopRequireDefault(require("iconv-lite"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const MAX = (1 << 16) - 1;
const UNKNOWN_PLP_LEN = Buffer.from([0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]);
const PLP_TERMINATOR = Buffer.from([0x00, 0x00, 0x00, 0x00]);
const NULL_LENGTH = Buffer.from([0xFF, 0xFF]);
const MAX_NULL_LENGTH = Buffer.from([0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF]);
const VarChar = {
  id: 0xA7,
  type: 'BIGVARCHR',
  name: 'VarChar',
  maximumLength: 8000,
  declaration: function (parameter) {
    const value = parameter.value;
    let length;

    if (parameter.length) {
      length = parameter.length;
    } else if (value != null) {
      length = value.length || 1;
    } else if (value === null && !parameter.output) {
      length = 1;
    } else {
      length = this.maximumLength;
    }

    if (length <= this.maximumLength) {
      return 'varchar(' + length + ')';
    } else {
      return 'varchar(max)';
    }
  },
  resolveLength: function (parameter) {
    const value = parameter.value;

    if (parameter.length != null) {
      return parameter.length;
    } else if (value != null) {
      return value.length || 1;
    } else {
      return this.maximumLength;
    }
  },

  generateTypeInfo(parameter) {
    const buffer = Buffer.alloc(8);
    buffer.writeUInt8(this.id, 0);

    if (parameter.length <= this.maximumLength) {
      buffer.writeUInt16LE(parameter.length, 1);
    } else {
      buffer.writeUInt16LE(MAX, 1);
    }

    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 3, 0, 5);
    }

    return buffer;
  },

  generateParameterLength(parameter, options) {
    const value = parameter.value;

    if (value == null) {
      if (parameter.length <= this.maximumLength) {
        return NULL_LENGTH;
      } else {
        return MAX_NULL_LENGTH;
      }
    }

    if (parameter.length <= this.maximumLength) {
      const buffer = Buffer.alloc(2);
      buffer.writeUInt16LE(value.length, 0);
      return buffer;
    } else {
      return UNKNOWN_PLP_LEN;
    }
  },

  *generateParameterData(parameter, options) {
    const value = parameter.value;

    if (value == null) {
      return;
    }

    if (parameter.length <= this.maximumLength) {
      yield value;
    } else {
      if (value.length > 0) {
        const buffer = Buffer.alloc(4);
        buffer.writeUInt32LE(value.length, 0);
        yield buffer;
        yield value;
      }

      yield PLP_TERMINATOR;
    }
  },

  validate: function (value, collation) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }

    if (!collation) {
      throw new Error('No collation was set by the server for the current connection.');
    }

    if (!collation.codepage) {
      throw new Error('The collation set by the server has no associated encoding.');
    }

    return _iconvLite.default.encode(value, collation.codepage);
  }
};
var _default = VarChar;
exports.default = _default;
module.exports = VarChar;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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