"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNTLMRequest = createNTLMRequest;
const NTLMFlags = {
  NTLM_NegotiateUnicode: 0x00000001,
  NTLM_NegotiateOEM: 0x00000002,
  NTLM_RequestTarget: 0x00000004,
  NTLM_Unknown9: 0x00000008,
  NTLM_NegotiateSign: 0x00000010,
  NTLM_NegotiateSeal: 0x00000020,
  NTLM_NegotiateDatagram: 0x00000040,
  NTLM_NegotiateLanManagerKey: 0x00000080,
  NTLM_Unknown8: 0x00000100,
  NTLM_NegotiateNTLM: 0x00000200,
  NTLM_NegotiateNTOnly: 0x00000400,
  NTLM_Anonymous: 0x00000800,
  NTLM_NegotiateOemDomainSupplied: 0x00001000,
  NTLM_NegotiateOemWorkstationSupplied: 0x00002000,
  NTLM_Unknown6: 0x00004000,
  NTLM_NegotiateAlwaysSign: 0x00008000,
  NTLM_TargetTypeDomain: 0x00010000,
  NTLM_TargetTypeServer: 0x00020000,
  NTLM_TargetTypeShare: 0x00040000,
  NTLM_NegotiateExtendedSecurity: 0x00080000,
  NTLM_NegotiateIdentify: 0x00100000,
  NTLM_Unknown5: 0x00200000,
  NTLM_RequestNonNTSessionKey: 0x00400000,
  NTLM_NegotiateTargetInfo: 0x00800000,
  NTLM_Unknown4: 0x01000000,
  NTLM_NegotiateVersion: 0x02000000,
  NTLM_Unknown3: 0x04000000,
  NTLM_Unknown2: 0x08000000,
  NTLM_Unknown1: 0x10000000,
  NTLM_Negotiate128: 0x20000000,
  NTLM_NegotiateKeyExchange: 0x40000000,
  NTLM_Negotiate56: 0x80000000
};

function createNTLMRequest(options) {
  const domain = escape(options.domain.toUpperCase());
  const workstation = options.workstation ? escape(options.workstation.toUpperCase()) : '';
  let type1flags = NTLMFlags.NTLM_NegotiateUnicode + NTLMFlags.NTLM_NegotiateOEM + NTLMFlags.NTLM_RequestTarget + NTLMFlags.NTLM_NegotiateNTLM + NTLMFlags.NTLM_NegotiateOemDomainSupplied + NTLMFlags.NTLM_NegotiateOemWorkstationSupplied + NTLMFlags.NTLM_NegotiateAlwaysSign + NTLMFlags.NTLM_NegotiateVersion + NTLMFlags.NTLM_NegotiateExtendedSecurity + NTLMFlags.NTLM_Negotiate128 + NTLMFlags.NTLM_Negotiate56;

  if (workstation === '') {
    type1flags -= NTLMFlags.NTLM_NegotiateOemWorkstationSupplied;
  }

  const fixedData = Buffer.alloc(40);
  const buffers = [fixedData];
  let offset = 0;
  offset += fixedData.write('NTLMSSP', offset, 7, 'ascii');
  offset = fixedData.writeUInt8(0, offset);
  offset = fixedData.writeUInt32LE(1, offset);
  offset = fixedData.writeUInt32LE(type1flags, offset);
  offset = fixedData.writeUInt16LE(domain.length, offset);
  offset = fixedData.writeUInt16LE(domain.length, offset);
  offset = fixedData.writeUInt32LE(fixedData.length + workstation.length, offset);
  offset = fixedData.writeUInt16LE(workstation.length, offset);
  offset = fixedData.writeUInt16LE(workstation.length, offset);
  offset = fixedData.writeUInt32LE(fixedData.length, offset);
  offset = fixedData.writeUInt8(5, offset);
  offset = fixedData.writeUInt8(0, offset);
  offset = fixedData.writeUInt16LE(2195, offset);
  offset = fixedData.writeUInt8(0, offset);
  offset = fixedData.writeUInt8(0, offset);
  offset = fixedData.writeUInt8(0, offset);
  fixedData.writeUInt8(15, offset);
  buffers.push(Buffer.from(workstation, 'ascii'));
  buffers.push(Buffer.from(domain, 'ascii'));
  return Buffer.concat(buffers);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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