"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.infoParser = infoParser;
exports.errorParser = errorParser;

var _token = require("./token");

function parseToken(parser, options, callback) {
  // length
  parser.readUInt16LE(() => {
    parser.readUInt32LE(number => {
      parser.readUInt8(state => {
        parser.readUInt8(clazz => {
          parser.readUsVarChar(message => {
            parser.readBVarChar(serverName => {
              parser.readBVarChar(procName => {
                (options.tdsVersion < '7_2' ? parser.readUInt16LE : parser.readUInt32LE).call(parser, lineNumber => {
                  callback({
                    'number': number,
                    'state': state,
                    'class': clazz,
                    'message': message,
                    'serverName': serverName,
                    'procName': procName,
                    'lineNumber': lineNumber
                  });
                });
              });
            });
          });
        });
      });
    });
  });
}

function infoParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.InfoMessageToken(data));
  });
}

function errorParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.ErrorMessageToken(data));
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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