"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransientErrorLookup = void 0;

// This simple piece of code is factored out into a separate class to make it
// easy to stub it out in tests. It's hard, if not impossible, to cause a
// transient error on demand in tests.
class TransientErrorLookup {
  isTransientError(error) {
    // This list of transient errors comes from Microsoft implementation of SqlClient:
    //  - https://github.com/dotnet/corefx/blob/master/src/System.Data.SqlClient/src/System/Data/SqlClient/SqlInternalConnectionTds.cs#L115
    const transientErrors = [4060, 10928, 10929, 40197, 40501, 40613];
    return transientErrors.indexOf(error) !== -1;
  }

}

exports.TransientErrorLookup = TransientErrorLookup;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy90cmFuc2llbnQtZXJyb3ItbG9va3VwLnRzIl0sIm5hbWVzIjpbIlRyYW5zaWVudEVycm9yTG9va3VwIiwiaXNUcmFuc2llbnRFcnJvciIsImVycm9yIiwidHJhbnNpZW50RXJyb3JzIiwiaW5kZXhPZiJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNPLE1BQU1BLG9CQUFOLENBQTJCO0FBQ2hDQyxFQUFBQSxnQkFBZ0IsQ0FBQ0MsS0FBRCxFQUFnQjtBQUM5QjtBQUNBO0FBQ0EsVUFBTUMsZUFBZSxHQUFHLENBQUMsSUFBRCxFQUFPLEtBQVAsRUFBYyxLQUFkLEVBQXFCLEtBQXJCLEVBQTRCLEtBQTVCLEVBQW1DLEtBQW5DLENBQXhCO0FBQ0EsV0FBT0EsZUFBZSxDQUFDQyxPQUFoQixDQUF3QkYsS0FBeEIsTUFBbUMsQ0FBQyxDQUEzQztBQUNEOztBQU4rQiIsInNvdXJjZXNDb250ZW50IjpbIi8vIFRoaXMgc2ltcGxlIHBpZWNlIG9mIGNvZGUgaXMgZmFjdG9yZWQgb3V0IGludG8gYSBzZXBhcmF0ZSBjbGFzcyB0byBtYWtlIGl0XG4vLyBlYXN5IHRvIHN0dWIgaXQgb3V0IGluIHRlc3RzLiBJdCdzIGhhcmQsIGlmIG5vdCBpbXBvc3NpYmxlLCB0byBjYXVzZSBhXG4vLyB0cmFuc2llbnQgZXJyb3Igb24gZGVtYW5kIGluIHRlc3RzLlxuZXhwb3J0IGNsYXNzIFRyYW5zaWVudEVycm9yTG9va3VwIHtcbiAgaXNUcmFuc2llbnRFcnJvcihlcnJvcjogbnVtYmVyKSB7XG4gICAgLy8gVGhpcyBsaXN0IG9mIHRyYW5zaWVudCBlcnJvcnMgY29tZXMgZnJvbSBNaWNyb3NvZnQgaW1wbGVtZW50YXRpb24gb2YgU3FsQ2xpZW50OlxuICAgIC8vICAtIGh0dHBzOi8vZ2l0aHViLmNvbS9kb3RuZXQvY29yZWZ4L2Jsb2IvbWFzdGVyL3NyYy9TeXN0ZW0uRGF0YS5TcWxDbGllbnQvc3JjL1N5c3RlbS9EYXRhL1NxbENsaWVudC9TcWxJbnRlcm5hbENvbm5lY3Rpb25UZHMuY3MjTDExNVxuICAgIGNvbnN0IHRyYW5zaWVudEVycm9ycyA9IFs0MDYwLCAxMDkyOCwgMTA5MjksIDQwMTk3LCA0MDUwMSwgNDA2MTNdO1xuICAgIHJldHVybiB0cmFuc2llbnRFcnJvcnMuaW5kZXhPZihlcnJvcikgIT09IC0xO1xuICB9XG59XG4iXX0=