<?php
/**
 *	RSS1.0 Feed
 *	rss feed,ع߲쿴rss.
 *  useage:
 *		#1> include(rss.inc.php);
 *		#2> $rssFeed = new RssFeedBuild();
 *		#3> $rssFeed->setChannel("Ƶ", "ƵӦվURL", "ƵӦ", "logoַ");
 *		#4> $rssFeed->setItem("±", "ӦվURL", "Ӧ", "·ʱ");
 *		#5> $rssFeed->buildRssFeed($param);  //$paramֵΪECHOWRITE, ΪECHOʱ,ֱ,дrss.xmlļ
 *	version: 1.0.0
 *  author: elliott [at] 2004-08-29
 * RSS1.0RSS RDF Site Summary д
 * Madman( madcn.com )޸ 2004-10-26
 */

class RssFeedBuild
{
	var $rssHeader;
	var $rssChannel;
	var $rssItems;
	var $rssItem;

	/**
	 *	캯, xmlļͷ, rss feedԪ
	 *	@param   null
	 *	@return  null
	 */
	function RssFeedBuild()
	{
		global $langpublic;
		$this->rssHeader  = "<?xml version=\"1.0\" encoding=\"$langpublic[charset]\"?>\n";
		$this->rssHeader .= "<?xml-stylesheet href=\"./images/rss.css\" type=\"text/css\"?>\n";
		$this->rssHeader .= "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n xmlns=\"http://purl.org/rss/1.0/\"\n xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n xmlns:sy=\"http://purl.org/rss/1.0/modules/syndication/\"\n xmlns:admin=\"http://webns.net/mvcb/\"\n xmlns:cc=\"http://web.resource.org/cc/\">\n";
	}
	
	/**
	 *	Ƶ
	 *	@param $title Ƶı
	 *	@param $link  ƵӦǸվURL
	 *	@param $description Ƶصļ򵥽
	 *	@return null
	 */
	function setChannel($title, $link, $description, $logourl)
	{
		$this->rssChannel  = "<channel rdf:about=\"$link\">\n";
		$this->rssChannel .= " <title><![CDATA[".$title."]]></title>\n";
		$this->rssChannel .= " <link>".$link."</link>\n";
		$this->rssChannel .= " <description><![CDATA[".$description."]]></description>\n";
		$this->rssChannel .= " <image rdf:resource=\"".$logourl."\" />\n";
		$this->rssChannel .= "</channel>\n";
		$this->rssChannel .= "<image rdf:about=\"".$logourl."\">\n";
		$this->rssChannel .= " <title><![CDATA[".$title."]]></title>\n";
		$this->rssChannel .= " <url>".$logourl."</url>\n";
		$this->rssChannel .= "</image>\n";
	}
	
	/**
	 *	һ\¼¼
	 *	@param $title \µı
	 *	@param $link \ҳϵURL	
	 *	@param $description \µһ
	 */
	function setItem($title, $link, $description, $modified)
	{
		$this->rssItem .= "<item rdf:about=\"$link\">\n";
		$this->rssItem .= "<title><![CDATA[".$title."]]></title>\n";
		$this->rssItem .= "<link>".$link."</link>\n";
		$this->rssItem .= "<description><![CDATA[".$description."]]></description>\n";
		$this->rssItem .= "<dc:date>".$modified."</dc:date>\n";
		$this->rssItem .= "</item>\n";
	}

	/**
	 *	ֱдķʽRSS Feedļ
	 *	@param ECHO ֱrss feed
	 *	@param WRITE д뷽ʽ rss feed, ļΪ rss.xml
	 */
	function buildRssFeed($tag)
	{
		if($tag == "ECHO")
		{
			header("Content-type:application/xml");
			echo $this->rssHeader;
			echo $this->rssChannel;
			echo $this->rssItem;
			echo "</rdf:RDF>";
		}
		else if($tag == "WRITE")
		{
			$all  = $this->rssHeader;
			$all .= $this->rssChannel;
			$all .= $this->rssItem;
			$all .= "</rdf:RDF>";

			$fp = @fopen("rss.xml", w);
			@fputs($fp, $all);
		}
	}
}

?>