<?php
/**
 *	ATOM Feed
 *	atom feed,ع߲쿴atom.
 *  useage:
 *		#1> include(atomFeedBuild.inc.php);
 *		#2> $rssFeed = new RssFeedBuild();
 *		#3> $rssFeed->setChannel("Ƶ", "ƵӦվURL", "ƵӦ");
 *		#4> $rssFeed->setItem("±", "ӦվURL", "Ӧ", "·ʱ", "·ʱ", "");
 *		#5> $rssFeed->buildRssFeed($param);  //$paramֵΪECHOWRITE, ΪECHOʱ,ֱ,дrss.xmlļ
 *	version: 1.0.0
 *  author: elliott [at] 2004-08-29
 * Madman( madcn.com )޸ 2004-10-26
 */

class RssFeedBuild
{
	var $rssHeader;
	var $rssChannel;
	var $rssItems;
	var $rssItem;

	/**
	 *	캯, xmlļͷ, rss feedԪ
	 *	@param   null
	 *	@return  null
	 */
	function RssFeedBuild()
	{
         global $langpublic;
		$this->rssHeader  = "<?xml version=\"1.0\" encoding=\"$langpublic[charset]\" standalone=\"yes\"?>\n";
		$this->rssHeader .= "<?xml-stylesheet href=\"http://www.madcn.com/blog/images/atom.css\" type=\"text/css\"?>\n";
		$this->rssHeader .= "<feed version=\"0.3\" xml:lang=\"$langpublic[language]\" xmlns=\"http://purl.org/atom/ns#\">\n";
	}

	/**
	 *	Ƶ
	 *	@param $title Ƶı
	 *	@param $link  ƵӦǸվURL
	 *	@param $description Ƶصļ򵥽
	 *	@return null
	 */
	function setChannel($title, $link, $description, $webmaster, $copyright)
	{
		$this->rssChannel  = " <title mode=\"escaped\" type=\"text/html\">".$title."</title>\n";
		$this->rssChannel .= " <tagline mode=\"escaped\" type=\"text/html\"><![CDATA[".$description."]]></tagline>\n";
		$this->rssChannel .= " <link href=\"$link\" rel=\"alternate\" title=\"$title\" type=\"text/html\" />\n";
		$this->rssChannel .= " <author>\n";
		$this->rssChannel .= " <name>".$webmaster."</name>\n";
		$this->rssChannel .= " <email>".$webmaster."</email>\n";
		$this->rssChannel .= " <url>".$link."</url>\n";
		$this->rssChannel .= " </author>\n";
		$this->rssChannel .= " <id>".$link."/atom.php</id>\n";
		$this->rssChannel .= " <generator url=\"".$link."\" version=\"0.3\">".$title."</generator>\n";
		$this->rssChannel .= " <copyright type=\"text/plain\" mode=\"escaped\"><![CDATA[".$copyright."]]></copyright>\n";
		$this->rssChannel .= " <info mode=\"xml\" type=\"text/html\">\n";
		$this->rssChannel .= " <div xmlns=\"http://www.w3.org/1999/xhtml\">This is an Atom formatted XML site feed. It is intended to be viewed in a Newsreader or syndicated to another site. Please visit the <a href=\"http://www.madcn.com\">Madman's Blog</a> for more info.</div>\n";
		$this->rssChannel .= " </info>\n";
	}

	/**
	 *	һ\¼¼
	 *	@param $title \µı
	 *	@param $link \ҳϵURL	
	 *	@param $description \µһ
	 */
	function setItem($id, $title, $link, $description, $modified, $issued, $author, $email)
	{
         global $langpublic;
		$this->rssItem .= "<entry>\n";
		$this->rssItem .= "<id>".$id."</id>\n";
		$this->rssItem .= "<title type=\"text/plain\" mode=\"escaped\">".$title."</title>\n";
		$this->rssItem .= "<link rel=\"alternate\" type=\"text/html\" href=\"$link\" title=\"$title\" />\n";
		$this->rssItem .= "<link rel=\"source\" type=\"text/html\" href=\"$link\" title=\"$title\" />\n";
		$this->rssItem .= "<author>\n<name>".$author."</name>\n<url>".$link."</url>\n<email>".$email."</email>\n</author>\n";
		$this->rssItem .= "<modified>".$modified."</modified>\n";
		$this->rssItem .= "<issued>".$issued."</issued>\n";
		$this->rssItem .= "<created>".$issued."</created>\n";
		$this->rssItem .= "<summary type=\"text/plain\" mode=\"escaped\"><![CDATA[".$description."]]></summary>\n";
		$this->rssItem .= "<content type=\"application/xhtml+xml\" xml:lang=\"".$langpublic[language]."\" xml:space=\"preserve\"><div xmlns=\"http://www.w3.org/1999/xhtml\"><![CDATA[".$description."]]></div></content>\n";
		$this->rssItem .= "</entry>\n";
	}

	/**
	 *	ֱдķʽRSS Feedļ
	 *	@param ECHO ֱrss feed
	 *	@param WRITE д뷽ʽ rss feed, ļΪ rss.xml
	 */
	function buildRssFeed($tag)
	{
		if($tag == "ECHO")
		{
			header("Content-type:application/xml");
			echo $this->rssHeader;
			echo $this->rssChannel;
			echo $this->rssItem;
			echo "</feed>";
		}
		else if($tag == "WRITE")
		{
			$all  = $this->rssHeader;
			$all .= $this->rssChannel;
			$all .= $this->rssItem;
			$all .= "</feed>";

			$fp = @fopen("atom.xml", w);
			@fputs($fp, $all);
		}
	}
}

?>
