# -*- coding: utf-8 -*-
# forked from MadEdit
# Name:        MadEdit/TradSimp.cpp
# Description: Traditional Chinese <==> Simplified Chinese
# Author:      madedit@gmail.com
# Licence:     GPL
# Forked by skydarkchen <skydark2 at gmail>

import sys

UEMPTY = ''
py2 = sys.version_info < (3, 0, 0)

if py2:
    UEMPTY = UEMPTY.decode('utf8')
    chr = unichr

Simp2Trad_Table = {
    0x2018: 0x300E,
    0x2019: 0x300F,
    0x201C: 0x300C,
    0x201D: 0x300D,
    0x2033: 0x301E,
    0x3013: 0x2550,
    0x4E07: 0x842C,
    0x4E0E: 0x8207,
    0x4E11: 0x919C,
    0x4E13: 0x5C08,
    0x4E1A: 0x696D,
    0x4E1B: 0x53E2,
    0x4E1C: 0x6771,
    0x4E1D: 0x7D72,
    0x4E22: 0x4E1F,
    0x4E24: 0x5169,
    0x4E25: 0x56B4,
    0x4E27: 0x55AA,
    0x4E2A: 0x500B,
    0x4E2C: 0x723F,
    0x4E30: 0x8C50,
    0x4E34: 0x81E8,
    0x4E3A: 0x70BA,
    0x4E3D: 0x9E97,
    0x4E3E: 0x8209,
    0x4E48: 0x9EBC,
    0x4E49: 0x7FA9,
    0x4E4C: 0x70CF,
    0x4E50: 0x6A02,
    0x4E54: 0x55AC,
    0x4E60: 0x7FD2,
    0x4E61: 0x9109,
    0x4E66: 0x66F8,
    0x4E70: 0x8CB7,
    0x4E71: 0x4E82,
    0x4E89: 0x722D,
    0x4E8E: 0x65BC,
    0x4E8F: 0x8667,
    0x4E91: 0x96F2,
    0x4E98: 0x4E99,
    0x4E9A: 0x4E9E,
    0x4EA7: 0x7522,
    0x4EA9: 0x755D,
    0x4EB2: 0x89AA,
    0x4EB5: 0x893B,
    0x4EB8: 0x56B2,
    0x4EBF: 0x5104,
    0x4EC5: 0x50C5,
    0x4ECE: 0x5F9E,
    0x4ED1: 0x4F96,
    0x4ED3: 0x5009,
    0x4EEA: 0x5100,
    0x4EEC: 0x5011,
    0x4EF7: 0x50F9,
    0x4F17: 0x773E,
    0x4F18: 0x512A,
    0x4F19: 0x5925,
    0x4F1A: 0x6703,
    0x4F1B: 0x50B4,
    0x4F1E: 0x5098,
    0x4F1F: 0x5049,
    0x4F20: 0x50B3,
    0x4F24: 0x50B7,
    0x4F25: 0x5000,
    0x4F26: 0x502B,
    0x4F27: 0x5096,
    0x4F2A: 0x507D,
    0x4F2B: 0x4F47,
    0x4F53: 0x9AD4,
    0x4F59: 0x9918,
    0x4F63: 0x50AD,
    0x4F65: 0x50C9,
    0x4FA0: 0x4FE0,
    0x4FA3: 0x4FB6,
    0x4FA5: 0x50E5,
    0x4FA6: 0x5075,
    0x4FA7: 0x5074,
    0x4FA8: 0x50D1,
    0x4FA9: 0x5108,
    0x4FAA: 0x5115,
    0x4FAC: 0x5102,
    0x4FE3: 0x4FC1,
    0x4FE6: 0x5114,
    0x4FE8: 0x513C,
    0x4FE9: 0x5006,
    0x4FEA: 0x5137,
    0x4FED: 0x5109,
    0x503A: 0x50B5,
    0x503E: 0x50BE,
    0x506C: 0x50AF,
    0x507B: 0x50C2,
    0x507E: 0x50E8,
    0x507F: 0x511F,
    0x50A5: 0x513B,
    0x50A7: 0x5110,
    0x50A8: 0x5132,
    0x50A9: 0x513A,
    0x513F: 0x5152,
    0x5151: 0x514C,
    0x5156: 0x5157,
    0x515A: 0x9EE8,
    0x5170: 0x862D,
    0x5173: 0x95DC,
    0x5174: 0x8208,
    0x5179: 0x8332,
    0x517B: 0x990A,
    0x517D: 0x7378,
    0x5181: 0x56C5,
    0x5185: 0x5167,
    0x5188: 0x5CA1,
    0x518C: 0x518A,
    0x5199: 0x5BEB,
    0x519B: 0x8ECD,
    0x519C: 0x8FB2,
    0x51A2: 0x585A,
    0x51AF: 0x99AE,
    0x51B2: 0x6C96,
    0x51B3: 0x6C7A,
    0x51B5: 0x6CC1,
    0x51BB: 0x51CD,
    0x51C0: 0x6DE8,
    0x51C4: 0x6DD2,
    0x51C9: 0x6DBC,
    0x51CC: 0x6DE9,
    0x51CF: 0x6E1B,
    0x51D1: 0x6E4A,
    0x51DB: 0x51DC,
    0x51E0: 0x5E7E,
    0x51E4: 0x9CF3,
    0x51EB: 0x9CE7,
    0x51ED: 0x6191,
    0x51EF: 0x51F1,
    0x51FB: 0x64CA,
    0x51FC: 0x6C39,
    0x51FF: 0x947F,
    0x520D: 0x82BB,
    0x5212: 0x5283,
    0x5218: 0x5289,
    0x5219: 0x5247,
    0x521A: 0x525B,
    0x521B: 0x5275,
    0x5220: 0x522A,
    0x522B: 0x5225,
    0x522C: 0x5257,
    0x522D: 0x5244,
    0x523D: 0x528A,
    0x523F: 0x528C,
    0x5240: 0x5274,
    0x5242: 0x5291,
    0x5250: 0x526E,
    0x5251: 0x528D,
    0x5265: 0x525D,
    0x5267: 0x5287,
    0x529D: 0x52F8,
    0x529E: 0x8FA6,
    0x52A1: 0x52D9,
    0x52A2: 0x52F1,
    0x52A8: 0x52D5,
    0x52B1: 0x52F5,
    0x52B2: 0x52C1,
    0x52B3: 0x52DE,
    0x52BF: 0x52E2,
    0x52CB: 0x52F3,
    0x52D0: 0x731B,
    0x52DA: 0x52E9,
    0x5300: 0x52FB,
    0x5326: 0x532D,
    0x532E: 0x5331,
    0x533A: 0x5340,
    0x533B: 0x91AB,
    0x534E: 0x83EF,
    0x534F: 0x5354,
    0x5355: 0x55AE,
    0x5356: 0x8CE3,
    # //0x53:C, 0x8514,
    0x5362: 0x76E7,
    0x5364: 0x9E75,
    0x5367: 0x81E5,
    0x536B: 0x885B,
    0x5374: 0x537B,
    0x537A: 0x5DF9,
    0x5382: 0x5EE0,
    0x5385: 0x5EF3,
    0x5386: 0x66C6,
    0x5389: 0x53B2,
    0x538B: 0x58D3,
    0x538C: 0x53AD,
    0x538D: 0x5399,
    0x5395: 0x5EC1,
    0x53A2: 0x5EC2,
    0x53A3: 0x53B4,
    0x53A6: 0x5EC8,
    0x53A8: 0x5EDA,
    0x53A9: 0x5EC4,
    0x53AE: 0x5EDD,
    0x53BF: 0x7E23,
    0x53C1: 0x4E09,
    0x53C2: 0x53C3,
    0x53C6: 0x9749,
    0x53C7: 0x9746,
    0x53CC: 0x96D9,
    0x53D1: 0x767C,
    0x53D8: 0x8B8A,
    0x53D9: 0x6558,
    0x53E0: 0x758A,
    0x53F6: 0x8449,
    0x53F7: 0x865F,
    0x53F9: 0x6B4E,
    0x53FD: 0x5630,
    0x5401: 0x7C72,
    0x540E: 0x5F8C,
    0x5413: 0x5687,
    0x5415: 0x5442,
    0x5417: 0x55CE,
    0x5423: 0x551A,
    0x5428: 0x5678,
    0x542C: 0x807D,
    0x542F: 0x555F,
    0x5434: 0x5433,
    0x5452: 0x5638,
    0x5453: 0x56C8,
    0x5455: 0x5614,
    0x5456: 0x56A6,
    0x5457: 0x5504,
    0x5458: 0x54E1,
    0x5459: 0x54BC,
    0x545B: 0x55C6,
    0x545C: 0x55DA,
    0x548F: 0x8A60,
    0x5494: 0x54E2,
    0x5499: 0x56A8,
    0x549B: 0x5680,
    0x549D: 0x565D,
    0x54A4: 0x5412,
    0x54B4: 0x5645,
    0x54B8: 0x9E79,
    0x54CC: 0x5471,
    0x54CD: 0x97FF,
    0x54D1: 0x555E,
    0x54D2: 0x5660,
    0x54D3: 0x5635,
    0x54D4: 0x55F6,
    0x54D5: 0x5666,
    0x54D7: 0x5629,
    0x54D9: 0x5672,
    0x54DC: 0x568C,
    0x54DD: 0x5665,
    0x54DF: 0x55B2,
    0x551B: 0x561C,
    0x551D: 0x55CA,
    0x5520: 0x562E,
    0x5521: 0x5562,
    0x5522: 0x55E9,
    0x5523: 0x5515,
    0x5524: 0x559A,
    0x553F: 0x547C,
    0x5567: 0x5616,
    0x556C: 0x55C7,
    0x556D: 0x56C0,
    0x556E: 0x9F67,
    0x5570: 0x56C9,
    0x5574: 0x563D,
    0x5578: 0x562F,
    0x55B7: 0x5674,
    0x55BD: 0x560D,
    0x55BE: 0x56B3,
    0x55EB: 0x56C1,
    0x55EC: 0x5475,
    0x55F3: 0x566F,
    0x5618: 0x5653,
    0x5624: 0x56B6,
    0x5631: 0x56D1,
    0x565C: 0x5695,
    0x567C: 0x5288,
    0x56A3: 0x56C2,
    0x56AF: 0x8B14,
    0x56E2: 0x5718,
    0x56ED: 0x5712,
    0x56F1: 0x56EA,
    0x56F4: 0x570D,
    0x56F5: 0x5707,
    0x56FD: 0x570B,
    0x56FE: 0x5716,
    0x5706: 0x5713,
    0x5723: 0x8056,
    0x5739: 0x58D9,
    0x573A: 0x5834,
    0x5742: 0x962A,
    0x574F: 0x58DE,
    0x5757: 0x584A,
    0x575A: 0x5805,
    0x575B: 0x58C7,
    0x575C: 0x58E2,
    0x575D: 0x58E9,
    0x575E: 0x5862,
    0x575F: 0x58B3,
    0x5760: 0x589C,
    0x5784: 0x58DF,
    0x5785: 0x58DF,
    0x5786: 0x58DA,
    0x5792: 0x58D8,
    0x57A6: 0x58BE,
    0x57A7: 0x5770,
    0x57A9: 0x580A,
    0x57AB: 0x588A,
    0x57AD: 0x57E1,
    0x57AF: 0x58B6,
    0x57B1: 0x58CB,
    0x57B2: 0x584F,
    0x57B4: 0x5816,
    0x57D8: 0x5852,
    0x57D9: 0x5864,
    0x57DA: 0x581D,
    0x57DD: 0x588A,
    0x57EF: 0x57B5,
    0x5811: 0x5879,
    0x5815: 0x58AE,
    0x5846: 0x58EA,
    0x586C: 0x539F,
    0x5899: 0x7246,
    0x58EE: 0x58EF,
    0x58F0: 0x8072,
    0x58F3: 0x6BBC,
    0x58F6: 0x58FA,
    0x58F8: 0x58FC,
    0x5904: 0x8655,
    0x5907: 0x5099,
    0x590D: 0x8907,
    0x591F: 0x5920,
    0x5934: 0x982D,
    0x5938: 0x8A87,
    0x5939: 0x593E,
    0x593A: 0x596A,
    0x5941: 0x5969,
    0x5942: 0x5950,
    0x594B: 0x596E,
    0x5956: 0x734E,
    0x5965: 0x5967,
    0x5986: 0x599D,
    0x5987: 0x5A66,
    0x5988: 0x5ABD,
    0x59A9: 0x5AF5,
    0x59AA: 0x5AD7,
    0x59AB: 0x5AAF,
    0x59D7: 0x59CD,
    0x59DC: 0x8591,
    0x5A04: 0x5A41,
    0x5A05: 0x5A6D,
    0x5A06: 0x5B08,
    0x5A07: 0x5B0C,
    0x5A08: 0x5B4C,
    0x5A31: 0x5A1B,
    0x5A32: 0x5AA7,
    0x5A34: 0x5AFB,
    0x5A73: 0x5AFF,
    0x5A74: 0x5B30,
    0x5A75: 0x5B0B,
    0x5A76: 0x5B38,
    0x5AAA: 0x5ABC,
    0x5AD2: 0x5B21,
    0x5AD4: 0x5B2A,
    0x5AF1: 0x5B19,
    0x5B37: 0x5B24,
    0x5B59: 0x5B6B,
    0x5B66: 0x5B78,
    0x5B6A: 0x5B7F,
    0x5B81: 0x5BE7,
    0x5B9D: 0x5BF6,
    0x5B9E: 0x5BE6,
    0x5BA0: 0x5BF5,
    0x5BA1: 0x5BE9,
    0x5BAA: 0x61B2,
    0x5BAB: 0x5BAE,
    0x5BBD: 0x5BEC,
    0x5BBE: 0x8CD3,
    0x5BDD: 0x5BE2,
    0x5BF9: 0x5C0D,
    0x5BFB: 0x5C0B,
    0x5BFC: 0x5C0E,
    0x5BFF: 0x58FD,
    0x5C06: 0x5C07,
    0x5C14: 0x723E,
    0x5C18: 0x5875,
    0x5C1D: 0x5617,
    0x5C27: 0x582F,
    0x5C34: 0x5C37,
    0x5C38: 0x5C4D,
    0x5C3D: 0x76E1,
    0x5C42: 0x5C64,
    0x5C43: 0x5C6D,
    0x5C49: 0x5C5C,
    0x5C4A: 0x5C46,
    0x5C5E: 0x5C6C,
    0x5C61: 0x5C62,
    0x5C66: 0x5C68,
    0x5C7F: 0x5DBC,
    0x5C81: 0x6B72,
    0x5C82: 0x8C48,
    0x5C96: 0x5D87,
    0x5C97: 0x5D17,
    0x5C98: 0x5CF4,
    0x5C99: 0x5DB4,
    0x5C9A: 0x5D50,
    0x5C9B: 0x5CF6,
    0x5CAD: 0x5DBA,
    0x5CB3: 0x5DBD,
    0x5CBD: 0x5D20,
    0x5CBF: 0x5DCB,
    0x5CC3: 0x5DA8,
    0x5CC4: 0x5DA7,
    0x5CE1: 0x5CFD,
    0x5CE3: 0x5DA2,
    0x5CE4: 0x5DA0,
    0x5CE5: 0x5D22,
    0x5CE6: 0x5DD2,
    0x5D02: 0x5D97,
    0x5D03: 0x5D0D,
    0x5D04: 0x5DAE,
    0x5D2D: 0x5D84,
    0x5D58: 0x5DB8,
    0x5D5A: 0x5D94,
    0x5D5B: 0x5D33,
    0x5D5D: 0x5D81,
    0x5D74: 0x810A,
    0x5DC5: 0x5DD4,
    0x5DE9: 0x978F,
    0x5DEF: 0x5DF0,
    0x5E01: 0x5E63,
    0x5E05: 0x5E25,
    0x5E08: 0x5E2B,
    0x5E0F: 0x5E43,
    0x5E10: 0x5E33,
    0x5E18: 0x7C3E,
    0x5E1C: 0x5E5F,
    0x5E26: 0x5E36,
    0x5E27: 0x5E40,
    0x5E2E: 0x5E6B,
    0x5E31: 0x5E6C,
    0x5E3B: 0x5E58,
    0x5E3C: 0x5E57,
    0x5E42: 0x51AA,
    0x5E5E: 0x8946,
    0x5E72: 0x5E79,
    0x5E76: 0x4E26,
    0x5E7A: 0x4E48,
    0x5E7F: 0x5EE3,
    0x5E84: 0x838A,
    0x5E86: 0x6176,
    0x5E90: 0x5EEC,
    0x5E91: 0x5EE1,
    0x5E93: 0x5EAB,
    0x5E94: 0x61C9,
    0x5E99: 0x5EDF,
    0x5E9E: 0x9F90,
    0x5E9F: 0x5EE2,
    0x5EBC: 0x5ECE,
    0x5EEA: 0x5EE9,
    0x5F00: 0x958B,
    0x5F02: 0x7570,
    0x5F03: 0x68C4,
    0x5F20: 0x5F35,
    0x5F25: 0x5F4C,
    0x5F2A: 0x5F33,
    0x5F2F: 0x5F4E,
    0x5F39: 0x5F48,
    0x5F3A: 0x5F37,
    0x5F52: 0x6B78,
    0x5F53: 0x7576,
    0x5F55: 0x9304,
    0x5F5F: 0x5F60,
    0x5F66: 0x5F65,
    0x5F7B: 0x5FB9,
    0x5F84: 0x5F91,
    0x5F95: 0x5FA0,
    0x5FA1: 0x79A6,
    0x5FC6: 0x61B6,
    0x5FCF: 0x61FA,
    0x5FE7: 0x6182,
    0x5FFE: 0x613E,
    0x6000: 0x61F7,
    0x6001: 0x614B,
    0x6002: 0x616B,
    0x6003: 0x61AE,
    0x6004: 0x616A,
    0x6005: 0x60B5,
    0x6006: 0x6134,
    0x601C: 0x6190,
    0x603B: 0x7E3D,
    0x603C: 0x61DF,
    0x603F: 0x61CC,
    0x604B: 0x6200,
    0x6073: 0x61C7,
    0x6076: 0x60E1,
    0x6078: 0x615F,
    0x6079: 0x61E8,
    0x607A: 0x6137,
    0x607B: 0x60FB,
    0x607C: 0x60F1,
    0x607D: 0x60F2,
    0x60A6: 0x6085,
    0x60AB: 0x6128,
    0x60AC: 0x61F8,
    0x60AD: 0x6173,
    0x60AF: 0x61AB,
    0x60CA: 0x9A5A,
    0x60E7: 0x61FC,
    0x60E8: 0x6158,
    0x60E9: 0x61F2,
    0x60EB: 0x618A,
    0x60EC: 0x611C,
    0x60ED: 0x615A,
    0x60EE: 0x619A,
    0x60EF: 0x6163,
    0x610D: 0x6E63,
    0x6120: 0x614D,
    0x6124: 0x61A4,
    0x6126: 0x6192,
    0x613F: 0x9858,
    0x6151: 0x61FE,
    0x616D: 0x6196,
    0x61B7: 0x6035,
    0x61D1: 0x61E3,
    0x61D2: 0x61F6,
    0x61D4: 0x61CD,
    0x6206: 0x6207,
    0x620B: 0x6214,
    0x620F: 0x6232,
    0x6217: 0x6227,
    0x6218: 0x6230,
    0x622C: 0x6229,
    0x6237: 0x6236,
    0x624E: 0x7D2E,
    0x6251: 0x64B2,
    0x6266: 0x6261,
    0x6267: 0x57F7,
    0x6269: 0x64F4,
    0x626A: 0x636B,
    0x626B: 0x6383,
    0x626C: 0x63DA,
    0x6270: 0x64FE,
    0x629A: 0x64AB,
    0x629B: 0x62CB,
    0x629F: 0x6476,
    0x62A0: 0x6473,
    0x62A1: 0x6384,
    0x62A2: 0x6436,
    0x62A4: 0x8B77,
    0x62A5: 0x5831,
    0x62C5: 0x64D4,
    0x62DF: 0x64EC,
    0x62E2: 0x650F,
    0x62E3: 0x63C0,
    0x62E5: 0x64C1,
    0x62E6: 0x6514,
    0x62E7: 0x64F0,
    0x62E8: 0x64A5,
    0x62E9: 0x64C7,
    0x6302: 0x639B,
    0x631A: 0x646F,
    0x631B: 0x6523,
    0x631C: 0x6397,
    0x631D: 0x64BE,
    0x631E: 0x64BB,
    0x631F: 0x633E,
    0x6320: 0x6493,
    0x6321: 0x64CB,
    0x6322: 0x649F,
    0x6323: 0x6399,
    0x6324: 0x64E0,
    0x6325: 0x63EE,
    0x6326: 0x648F,
    0x635E: 0x6488,
    0x635F: 0x640D,
    0x6361: 0x64BF,
    0x6362: 0x63DB,
    0x6363: 0x6417,
    0x636E: 0x64DA,
    0x637B: 0x649A,
    0x63B3: 0x64C4,
    0x63B4: 0x6451,
    0x63B7: 0x64F2,
    0x63B8: 0x64A3,
    0x63BA: 0x647B,
    0x63BC: 0x645C,
    0x63F8: 0x6463,
    0x63FD: 0x652C,
    0x63FF: 0x64B3,
    0x6400: 0x6519,
    0x6401: 0x64F1,
    0x6402: 0x645F,
    0x6405: 0x652A,
    0x643A: 0x651C,
    0x6444: 0x651D,
    0x6445: 0x6504,
    0x6446: 0x64FA,
    0x6447: 0x6416,
    0x6448: 0x64EF,
    0x644A: 0x6524,
    0x6484: 0x6516,
    0x6491: 0x6490,
    0x64B5: 0x6506,
    0x64B7: 0x64F7,
    0x64B8: 0x64FC,
    0x64BA: 0x651B,
    0x64DE: 0x64FB,
    0x6512: 0x6522,
    0x654C: 0x6575,
    0x655B: 0x6582,
    0x6570: 0x6578,
    0x658B: 0x9F4B,
    0x6593: 0x6595,
    # //0x65:7, 0x9B25,
    0x65A9: 0x65AC,
    0x65AD: 0x65B7,
    0x65E0: 0x7121,
    0x65E7: 0x820A,
    0x65F6: 0x6642,
    0x65F7: 0x66E0,
    0x65F8: 0x6698,
    0x6619: 0x66C7,
    0x663C: 0x665D,
    0x663D: 0x66E8,
    0x663E: 0x986F,
    0x664B: 0x6649,
    0x6652: 0x66EC,
    0x6653: 0x66C9,
    0x6654: 0x66C4,
    0x6655: 0x6688,
    0x6656: 0x6689,
    0x6682: 0x66AB,
    0x66A7: 0x66D6,
    0x672D: 0x5284,
    0x672F: 0x8853,
    0x6734: 0x6A38,
    0x673A: 0x6A5F,
    0x6740: 0x6BBA,
    0x6742: 0x96DC,
    0x6743: 0x6B0A,
    0x6761: 0x689D,
    0x6765: 0x4F86,
    0x6768: 0x694A,
    0x6769: 0x69AA,
    0x6770: 0x5091,
    0x6781: 0x6975,
    0x6784: 0x69CB,
    0x679E: 0x6A05,
    0x67A2: 0x6A1E,
    0x67A3: 0x68D7,
    0x67A5: 0x6AEA,
    0x67A7: 0x6898,
    0x67A8: 0x68D6,
    0x67AA: 0x69CD,
    0x67AB: 0x6953,
    0x67AD: 0x689F,
    0x67DC: 0x6AC3,
    0x67E0: 0x6AB8,
    0x67FD: 0x6A89,
    0x6800: 0x6894,
    0x6805: 0x67F5,
    0x6807: 0x6A19,
    0x6808: 0x68E7,
    0x6809: 0x6ADB,
    0x680A: 0x6AF3,
    0x680B: 0x68DF,
    0x680C: 0x6AE8,
    0x680E: 0x6ADF,
    0x680F: 0x6B04,
    0x6811: 0x6A39,
    0x6816: 0x68F2,
    0x6837: 0x6A23,
    0x683E: 0x6B12,
    0x684A: 0x68EC,
    0x6860: 0x690F,
    0x6861: 0x6A48,
    0x6862: 0x6968,
    0x6863: 0x6A94,
    0x6864: 0x69BF,
    0x6865: 0x6A4B,
    0x6866: 0x6A3A,
    0x6867: 0x6A9C,
    0x6868: 0x69F3,
    0x6869: 0x6A01,
    0x68A6: 0x5922,
    0x68BC: 0x6AAE,
    0x68BE: 0x68F6,
    0x68C0: 0x6AA2,
    0x68C2: 0x6B1E,
    0x6901: 0x69E8,
    0x691F: 0x6ADD,
    0x6920: 0x69E7,
    0x6924: 0x6B0F,
    0x692D: 0x6A62,
    0x697C: 0x6A13,
    0x6984: 0x6B16,
    0x6987: 0x6AEC,
    0x6988: 0x6ADA,
    0x6989: 0x6AF8,
    0x69DA: 0x6A9F,
    0x69DB: 0x6ABB,
    0x69DF: 0x6AB3,
    0x69E0: 0x6AE7,
    0x6A2A: 0x6A6B,
    0x6A2F: 0x6AA3,
    0x6A31: 0x6AFB,
    0x6A65: 0x6AEB,
    0x6A71: 0x6AE5,
    0x6A79: 0x6AD3,
    0x6A7C: 0x6ADE,
    0x6A90: 0x7C37,
    0x6AA9: 0x6A81,
    0x6B22: 0x6B61,
    0x6B24: 0x6B5F,
    0x6B27: 0x6B50,
    0x6B7C: 0x6BB2,
    0x6B81: 0x6B7F,
    0x6B87: 0x6BA4,
    0x6B8B: 0x6B98,
    0x6B92: 0x6B9E,
    0x6B93: 0x6BAE,
    0x6B9A: 0x6BAB,
    0x6BA1: 0x6BAF,
    0x6BB4: 0x6BC6,
    0x6BC1: 0x6BC0,
    0x6BC2: 0x8F42,
    0x6BD5: 0x7562,
    0x6BD9: 0x6583,
    0x6BE1: 0x6C08,
    0x6BF5: 0x6BFF,
    0x6C07: 0x6C0C,
    0x6C14: 0x6C23,
    0x6C22: 0x6C2B,
    0x6C29: 0x6C2C,
    0x6C32: 0x6C33,
    0x6C47: 0x5F59,
    0x6C49: 0x6F22,
    0x6C61: 0x6C59,
    0x6C64: 0x6E6F,
    0x6C79: 0x6D36,
    0x6C93: 0x905D,
    0x6C9F: 0x6E9D,
    0x6CA1: 0x6C92,
    0x6CA3: 0x7043,
    0x6CA4: 0x6F1A,
    0x6CA5: 0x701D,
    0x6CA6: 0x6DEA,
    0x6CA7: 0x6EC4,
    0x6CA8: 0x6E22,
    0x6CA9: 0x6E88,
    0x6CAA: 0x6EEC,
    0x6CB5: 0x6FD4,
    0x6CDE: 0x6FD8,
    0x6CEA: 0x6DDA,
    0x6CF6: 0x6FA9,
    0x6CF7: 0x7027,
    0x6CF8: 0x7018,
    0x6CFA: 0x6FFC,
    0x6CFB: 0x7009,
    0x6CFC: 0x6F51,
    0x6CFD: 0x6FA4,
    0x6CFE: 0x6D87,
    0x6D01: 0x6F54,
    0x6D12: 0x7051,
    0x6D3C: 0x7AAA,
    0x6D43: 0x6D79,
    0x6D45: 0x6DFA,
    0x6D46: 0x6F3F,
    0x6D47: 0x6F86,
    0x6D48: 0x6E5E,
    0x6D49: 0x6EAE,
    0x6D4A: 0x6FC1,
    0x6D4B: 0x6E2C,
    0x6D4D: 0x6FAE,
    0x6D4E: 0x6FDF,
    0x6D4F: 0x700F,
    0x6D50: 0x6EFB,
    0x6D51: 0x6E3E,
    0x6D52: 0x6EF8,
    0x6D53: 0x6FC3,
    0x6D54: 0x6F6F,
    0x6D55: 0x6FDC,
    0x6D82: 0x5857,
    0x6D8C: 0x6E67,
    0x6D9B: 0x6FE4,
    0x6D9D: 0x6F87,
    0x6D9E: 0x6DF6,
    0x6D9F: 0x6F23,
    0x6DA0: 0x6F7F,
    0x6DA1: 0x6E26,
    0x6DA2: 0x6EB3,
    0x6DA3: 0x6E19,
    0x6DA4: 0x6ECC,
    0x6DA6: 0x6F64,
    0x6DA7: 0x6F97,
    0x6DA8: 0x6F32,
    0x6DA9: 0x6F80,
    0x6DC0: 0x6FB1,
    0x6E0A: 0x6DF5,
    0x6E0C: 0x6DE5,
    0x6E0D: 0x6F2C,
    0x6E0E: 0x7006,
    0x6E10: 0x6F38,
    0x6E11: 0x6FA0,
    0x6E14: 0x6F01,
    0x6E16: 0x700B,
    0x6E17: 0x6EF2,
    0x6E29: 0x6EAB,
    0x6E38: 0x904A,
    0x6E7E: 0x7063,
    0x6E7F: 0x6FD5,
    0x6E83: 0x6F70,
    0x6E85: 0x6FFA,
    0x6E86: 0x6F35,
    0x6E87: 0x6F0A,
    0x6ED7: 0x6F77,
    0x6EDA: 0x6EFE,
    0x6EDE: 0x6EEF,
    0x6EDF: 0x7069,
    0x6EE0: 0x7044,
    0x6EE1: 0x6EFF,
    0x6EE2: 0x7005,
    0x6EE4: 0x6FFE,
    0x6EE5: 0x6FEB,
    0x6EE6: 0x7064,
    0x6EE8: 0x6FF1,
    0x6EE9: 0x7058,
    0x6EEA: 0x6FA6,
    0x6F24: 0x6FEB,
    0x6F46: 0x7020,
    0x6F47: 0x701F,
    0x6F4B: 0x7032,
    0x6F4D: 0x6FF0,
    0x6F5C: 0x6F5B,
    0x6F74: 0x7026,
    0x6F9C: 0x703E,
    0x6FD1: 0x7028,
    0x6FD2: 0x7015,
    0x704F: 0x705D,
    0x706D: 0x6EC5,
    0x706F: 0x71C8,
    0x7075: 0x9748,
    0x707E: 0x707D,
    0x707F: 0x71E6,
    0x7080: 0x716C,
    0x7089: 0x7210,
    0x7096: 0x71C9,
    0x709C: 0x7152,
    0x709D: 0x7197,
    0x70B9: 0x9EDE,
    0x70BC: 0x7149,
    0x70BD: 0x71BE,
    0x70C1: 0x720D,
    0x70C2: 0x721B,
    0x70C3: 0x70F4,
    0x70DB: 0x71ED,
    0x70DF: 0x7159,
    0x70E6: 0x7169,
    0x70E7: 0x71D2,
    0x70E8: 0x71C1,
    0x70E9: 0x71F4,
    0x70EB: 0x71D9,
    0x70EC: 0x71FC,
    0x70ED: 0x71B1,
    0x7115: 0x7165,
    0x7116: 0x71DC,
    0x7118: 0x71FE,
    0x7145: 0x7146,
    0x7173: 0x7CCA,
    0x717A: 0x9000,
    0x7198: 0x6E9C,
    0x7231: 0x611B,
    0x7237: 0x723A,
    0x724D: 0x7258,
    0x7266: 0x729B,
    0x7275: 0x727D,
    0x727A: 0x72A7,
    0x728A: 0x72A2,
    0x729F: 0x5F37,
    0x72AD: 0x72AC,
    0x72B6: 0x72C0,
    0x72B7: 0x7377,
    0x72B8: 0x7341,
    0x72B9: 0x7336,
    0x72C8: 0x72FD,
    0x72CD: 0x9E85,
    0x72DD: 0x736E,
    0x72DE: 0x7370,
    0x72EC: 0x7368,
    0x72ED: 0x72F9,
    0x72EE: 0x7345,
    0x72EF: 0x736A,
    0x72F0: 0x7319,
    0x72F1: 0x7344,
    0x72F2: 0x733B,
    0x7303: 0x736B,
    0x730E: 0x7375,
    0x7315: 0x737C,
    0x7321: 0x7380,
    0x732A: 0x8C6C,
    0x732B: 0x8C93,
    0x732C: 0x875F,
    0x732E: 0x737B,
    0x736D: 0x737A,
    0x7391: 0x74A3,
    0x7399: 0x74B5,
    0x739A: 0x7452,
    0x739B: 0x746A,
    0x73AE: 0x744B,
    0x73AF: 0x74B0,
    0x73B0: 0x73FE,
    0x73B1: 0x7472,
    0x73BA: 0x74BD,
    0x73C9: 0x7449,
    0x73CF: 0x73A8,
    0x73D0: 0x743A,
    0x73D1: 0x74CF,
    0x73F0: 0x74AB,
    0x73F2: 0x743F,
    0x740E: 0x74A1,
    0x740F: 0x7489,
    0x7410: 0x7463,
    0x743C: 0x74CA,
    0x7476: 0x7464,
    0x7477: 0x74A6,
    0x7487: 0x74BF,
    0x748E: 0x74D4,
    0x74D2: 0x74DA,
    0x74EE: 0x7515,
    0x74EF: 0x750C,
    0x7535: 0x96FB,
    0x753B: 0x756B,
    0x7545: 0x66A2,
    0x7572: 0x4F58,
    0x7574: 0x7587,
    0x7596: 0x7664,
    0x7597: 0x7642,
    0x759F: 0x7627,
    0x75A0: 0x7658,
    0x75A1: 0x760D,
    0x75AC: 0x9B01,
    0x75AE: 0x7621,
    0x75AF: 0x760B,
    0x75B1: 0x76B0,
    0x75B4: 0x5C59,
    0x75C8: 0x7670,
    0x75C9: 0x75D9,
    0x75D2: 0x7662,
    0x75D6: 0x7602,
    0x75E8: 0x7646,
    0x75EA: 0x7613,
    0x75EB: 0x7647,
    0x75F4: 0x7661,
    0x7605: 0x7649,
    0x7606: 0x762E,
    0x7617: 0x761E,
    0x7618: 0x763A,
    0x762A: 0x765F,
    0x762B: 0x7671,
    0x763E: 0x766E,
    0x763F: 0x766D,
    0x765E: 0x7669,
    0x7663: 0x766C,
    0x766B: 0x7672,
    0x766F: 0x81D2,
    0x7691: 0x769A,
    0x76B1: 0x76BA,
    0x76B2: 0x76B8,
    0x76CF: 0x76DE,
    0x76D0: 0x9E7D,
    0x76D1: 0x76E3,
    0x76D6: 0x84CB,
    0x76D7: 0x76DC,
    0x76D8: 0x76E4,
    0x770D: 0x7798,
    0x7726: 0x7725,
    0x772C: 0x77D3,
    0x7740: 0x8457,
    0x7741: 0x775C,
    0x7750: 0x775E,
    0x7751: 0x77BC,
    0x7792: 0x779E,
    0x77A9: 0x77DA,
    0x77EB: 0x77EF,
    0x77F6: 0x78EF,
    0x77FE: 0x792C,
    0x77FF: 0x7926,
    0x7800: 0x78AD,
    0x7801: 0x78BC,
    0x7816: 0x78DA,
    0x7817: 0x7868,
    0x781A: 0x786F,
    0x781C: 0x78B8,
    0x783A: 0x792A,
    0x783B: 0x7931,
    0x783E: 0x792B,
    0x7840: 0x790E,
    0x7841: 0x785C,
    0x7845: 0x77FD,
    0x7855: 0x78A9,
    0x7856: 0x7864,
    0x7857: 0x78FD,
    0x7859: 0x78D1,
    0x785A: 0x7904,
    0x786E: 0x78BA,
    0x7877: 0x9E7C,
    0x788D: 0x7919,
    0x789B: 0x78E7,
    0x789C: 0x78E3,
    0x78B1: 0x583F,
    0x78B9: 0x955F,
    0x78D9: 0x6EFE,
    0x793C: 0x79AE,
    0x794E: 0x7995,
    0x7962: 0x79B0,
    0x796F: 0x798E,
    0x7977: 0x79B1,
    0x7978: 0x798D,
    0x7980: 0x7A1F,
    0x7984: 0x797F,
    0x7985: 0x79AA,
    0x79BB: 0x96E2,
    0x79C3: 0x79BF,
    0x79C6: 0x7A08,
    0x79CD: 0x7A2E,
    0x79EF: 0x7A4D,
    0x79F0: 0x7A31,
    0x79FD: 0x7A62,
    0x79FE: 0x7A60,
    0x7A06: 0x7A6D,
    0x7A0E: 0x7A05,
    0x7A23: 0x7A4C,
    0x7A33: 0x7A69,
    0x7A51: 0x7A61,
    0x7A77: 0x7AAE,
    0x7A83: 0x7ACA,
    0x7A8D: 0x7AC5,
    0x7A91: 0x7AAF,
    0x7A9C: 0x7AC4,
    0x7A9D: 0x7AA9,
    0x7AA5: 0x7ABA,
    0x7AA6: 0x7AC7,
    0x7AAD: 0x7AB6,
    0x7AD6: 0x8C4E,
    0x7ADE: 0x7AF6,
    0x7B03: 0x7BE4,
    0x7B0B: 0x7B4D,
    0x7B14: 0x7B46,
    0x7B15: 0x7B67,
    0x7B3A: 0x7B8B,
    0x7B3C: 0x7C60,
    0x7B3E: 0x7C69,
    0x7B51: 0x7BC9,
    0x7B5A: 0x7BF3,
    0x7B5B: 0x7BE9,
    0x7B5C: 0x7C39,
    0x7B5D: 0x7B8F,
    0x7B79: 0x7C4C,
    0x7B7E: 0x7C3D,
    0x7B80: 0x7C21,
    0x7B93: 0x7C59,
    0x7BA6: 0x7C00,
    0x7BA7: 0x7BCB,
    0x7BA8: 0x7C5C,
    0x7BA9: 0x7C6E,
    0x7BAA: 0x7C1E,
    0x7BAB: 0x7C2B,
    0x7BD1: 0x7C23,
    0x7BD3: 0x7C0D,
    0x7BEE: 0x7C43,
    0x7BF1: 0x7C6C,
    0x7C16: 0x7C6A,
    0x7C41: 0x7C5F,
    0x7C74: 0x7CF4,
    0x7C7B: 0x985E,
    0x7C7C: 0x79C8,
    0x7C9C: 0x7CF6,
    0x7C9D: 0x7CF2,
    0x7CA4: 0x7CB5,
    0x7CAA: 0x7CDE,
    0x7CAE: 0x7CE7,
    0x7CC1: 0x7CDD,
    0x7CC7: 0x9931,
    0x7D27: 0x7DCA,
    0x7D77: 0x7E36,
    0x7E9F: 0x7CF8,
    0x7EA0: 0x7CFE,
    0x7EA1: 0x7D06,
    0x7EA2: 0x7D05,
    0x7EA3: 0x7D02,
    0x7EA4: 0x7E96,
    0x7EA5: 0x7D07,
    0x7EA6: 0x7D04,
    0x7EA7: 0x7D1A,
    0x7EA8: 0x7D08,
    0x7EA9: 0x7E8A,
    0x7EAA: 0x7D00,
    0x7EAB: 0x7D09,
    0x7EAC: 0x7DEF,
    0x7EAD: 0x7D1C,
    0x7EAE: 0x7D18,
    0x7EAF: 0x7D14,
    0x7EB0: 0x7D15,
    0x7EB1: 0x7D17,
    0x7EB2: 0x7DB1,
    0x7EB3: 0x7D0D,
    0x7EB4: 0x7D1D,
    0x7EB5: 0x7E31,
    0x7EB6: 0x7DB8,
    0x7EB7: 0x7D1B,
    0x7EB8: 0x7D19,
    0x7EB9: 0x7D0B,
    0x7EBA: 0x7D21,
    0x7EBB: 0x7D35,
    0x7EBC: 0x7D16,
    0x7EBD: 0x7D10,
    0x7EBE: 0x7D13,
    0x7EBF: 0x7DDA,
    0x7EC0: 0x7D3A,
    0x7EC1: 0x7D4F,
    0x7EC2: 0x7D31,
    0x7EC3: 0x7DF4,
    0x7EC4: 0x7D44,
    0x7EC5: 0x7D33,
    0x7EC6: 0x7D30,
    0x7EC7: 0x7E54,
    0x7EC8: 0x7D42,
    0x7EC9: 0x7E10,
    0x7ECA: 0x7D46,
    0x7ECB: 0x7D3C,
    0x7ECC: 0x7D40,
    0x7ECD: 0x7D39,
    0x7ECE: 0x7E79,
    0x7ECF: 0x7D93,
    0x7ED0: 0x7D3F,
    0x7ED1: 0x7D81,
    0x7ED2: 0x7D68,
    0x7ED3: 0x7D50,
    0x7ED4: 0x7D5D,
    0x7ED5: 0x7E5E,
    0x7ED6: 0x7D70,
    0x7ED7: 0x7D4E,
    0x7ED8: 0x7E6A,
    0x7ED9: 0x7D66,
    0x7EDA: 0x7D62,
    0x7EDB: 0x7D73,
    0x7EDC: 0x7D61,
    0x7EDD: 0x7D55,
    0x7EDE: 0x7D5E,
    0x7EDF: 0x7D71,
    0x7EE0: 0x7D86,
    0x7EE1: 0x7D83,
    0x7EE2: 0x7D79,
    0x7EE3: 0x7E61,
    0x7EE4: 0x7D8C,
    0x7EE5: 0x7D8F,
    0x7EE6: 0x7D5B,
    0x7EE7: 0x7E7C,
    0x7EE8: 0x7D88,
    0x7EE9: 0x7E3E,
    0x7EEA: 0x7DD2,
    0x7EEB: 0x7DBE,
    0x7EEC: 0x7DD3,
    0x7EED: 0x7E8C,
    0x7EEE: 0x7DBA,
    0x7EEF: 0x7DCB,
    0x7EF0: 0x7DBD,
    0x7EF1: 0x7DD4,
    0x7EF2: 0x7DC4,
    0x7EF3: 0x7E69,
    0x7EF4: 0x7DAD,
    0x7EF5: 0x7DBF,
    0x7EF6: 0x7DAC,
    0x7EF7: 0x7E43,
    0x7EF8: 0x7DA2,
    0x7EF9: 0x7DAF,
    0x7EFA: 0x7DB9,
    0x7EFB: 0x7DA3,
    0x7EFC: 0x7D9C,
    0x7EFD: 0x7DBB,
    0x7EFE: 0x7DB0,
    0x7EFF: 0x7DA0,
    0x7F00: 0x7DB4,
    0x7F01: 0x7DC7,
    0x7F02: 0x7DD9,
    0x7F03: 0x7DD7,
    0x7F04: 0x7DD8,
    0x7F05: 0x7DEC,
    0x7F06: 0x7E9C,
    0x7F07: 0x7DF9,
    0x7F08: 0x7DF2,
    0x7F09: 0x7DDD,
    0x7F0A: 0x7E15,
    0x7F0B: 0x7E62,
    0x7F0C: 0x7DE6,
    0x7F0D: 0x7D9E,
    0x7F0E: 0x7DDE,
    0x7F0F: 0x7DF6,
    0x7F10: 0x7DDA,
    0x7F11: 0x7DF1,
    0x7F12: 0x7E0B,
    0x7F13: 0x7DE9,
    0x7F14: 0x7DE0,
    0x7F15: 0x7E37,
    0x7F16: 0x7DE8,
    0x7F17: 0x7DE1,
    0x7F18: 0x7DE3,
    0x7F19: 0x7E09,
    0x7F1A: 0x7E1B,
    0x7F1B: 0x7E1F,
    0x7F1C: 0x7E1D,
    0x7F1D: 0x7E2B,
    0x7F1E: 0x7E17,
    0x7F1F: 0x7E1E,
    0x7F20: 0x7E8F,
    0x7F21: 0x7E2D,
    0x7F22: 0x7E0A,
    0x7F23: 0x7E11,
    0x7F24: 0x7E7D,
    0x7F25: 0x7E39,
    0x7F26: 0x7E35,
    0x7F27: 0x7E32,
    0x7F28: 0x7E93,
    0x7F29: 0x7E2E,
    0x7F2A: 0x7E46,
    0x7F2B: 0x7E45,
    0x7F2C: 0x7E88,
    0x7F2D: 0x7E5A,
    0x7F2E: 0x7E55,
    0x7F2F: 0x7E52,
    0x7F30: 0x97C1,
    0x7F31: 0x7E7E,
    0x7F32: 0x7E70,
    0x7F33: 0x7E6F,
    0x7F34: 0x7E73,
    0x7F35: 0x7E98,
    0x7F42: 0x7F4C,
    0x7F51: 0x7DB2,
    0x7F57: 0x7F85,
    0x7F5A: 0x7F70,
    0x7F62: 0x7F77,
    0x7F74: 0x7F86,
    0x7F81: 0x7F88,
    0x7F9F: 0x7FA5,
    0x7FA1: 0x7FA8,
    0x7FD8: 0x7FF9,
    0x7FD9: 0x7FFD,
    0x7FDA: 0x7FEC,
    0x8022: 0x802E,
    0x8027: 0x802C,
    0x8038: 0x8073,
    0x803B: 0x6065,
    0x8042: 0x8076,
    0x804B: 0x807E,
    0x804C: 0x8077,
    0x804D: 0x8079,
    0x8054: 0x806F,
    0x8069: 0x8075,
    0x806A: 0x8070,
    0x8083: 0x8085,
    0x80A0: 0x8178,
    0x80A4: 0x819A,
    0x80B7: 0x8181,
    0x80BE: 0x814E,
    0x80BF: 0x816B,
    0x80C0: 0x8139,
    0x80C1: 0x8105,
    0x80C6: 0x81BD,
    0x80DC: 0x52DD,
    0x80E7: 0x6727,
    0x80E8: 0x8156,
    0x80EA: 0x81DA,
    0x80EB: 0x811B,
    0x80F6: 0x81A0,
    0x8109: 0x8108,
    0x810D: 0x81BE,
    0x810F: 0x9AD2,
    0x8110: 0x81CD,
    0x8111: 0x8166,
    0x8113: 0x81BF,
    0x8114: 0x81E0,
    0x811A: 0x8173,
    0x8131: 0x812B,
    0x8136: 0x8161,
    0x8138: 0x81C9,
    0x814A: 0x81D8,
    0x814C: 0x9183,
    0x8158: 0x8195,
    0x816D: 0x9F76,
    0x817B: 0x81A9,
    0x817C: 0x9766,
    0x817D: 0x8183,
    0x817E: 0x9A30,
    0x8191: 0x81CF,
    0x81DC: 0x81E2,
    0x8206: 0x8F3F,
    0x8223: 0x8264,
    0x8230: 0x8266,
    0x8231: 0x8259,
    0x823B: 0x826B,
    0x8270: 0x8271,
    0x8273: 0x8C54,
    0x8279: 0x8278,
    0x827A: 0x85DD,
    0x8282: 0x7BC0,
    0x8288: 0x7F8B,
    0x8297: 0x858C,
    0x829C: 0x856A,
    0x82A6: 0x8606,
    0x82C1: 0x84EF,
    0x82C7: 0x8466,
    0x82C8: 0x85F6,
    0x82CB: 0x83A7,
    0x82CC: 0x8407,
    0x82CD: 0x84BC,
    0x82CE: 0x82E7,
    0x82CF: 0x8607,
    0x82D8: 0x6ABE,
    0x82F9: 0x860B,
    0x8303: 0x7BC4,
    0x830E: 0x8396,
    0x830F: 0x8622,
    0x8311: 0x8526,
    0x8314: 0x584B,
    0x8315: 0x7162,
    0x8327: 0x7E6D,
    0x8346: 0x834A,
    0x8350: 0x85A6,
    0x8359: 0x8598,
    0x835A: 0x83A2,
    0x835B: 0x8558,
    0x835C: 0x84FD,
    0x835E: 0x854E,
    0x835F: 0x8588,
    0x8360: 0x85BA,
    0x8361: 0x8569,
    0x8363: 0x69AE,
    0x8364: 0x8477,
    0x8365: 0x6ECE,
    0x8366: 0x7296,
    0x8367: 0x7192,
    0x8368: 0x8541,
    0x8369: 0x85CE,
    0x836A: 0x84C0,
    0x836B: 0x852D,
    0x836C: 0x8552,
    0x836D: 0x8452,
    0x836E: 0x8464,
    0x836F: 0x85E5,
    0x8385: 0x849E,
    0x839C: 0x84E7,
    0x83B1: 0x840A,
    0x83B2: 0x84EE,
    0x83B3: 0x8494,
    0x83B4: 0x8435,
    0x83B6: 0x859F,
    0x83B7: 0x7372,
    0x83B8: 0x8555,
    0x83B9: 0x7469,
    0x83BA: 0x9DAF,
    0x83BC: 0x84F4,
    0x841A: 0x8600,
    0x841D: 0x863F,
    0x8424: 0x87A2,
    0x8425: 0x71DF,
    0x8426: 0x7E08,
    0x8427: 0x856D,
    0x8428: 0x85A9,
    0x8471: 0x8525,
    0x8487: 0x8546,
    0x8489: 0x8562,
    0x848B: 0x8523,
    0x848C: 0x851E,
    0x84DD: 0x85CD,
    0x84DF: 0x858A,
    0x84E0: 0x863A,
    0x84E3: 0x8577,
    0x84E5: 0x93A3,
    0x84E6: 0x9A40,
    0x8537: 0x8594,
    0x8539: 0x861E,
    0x853A: 0x85FA,
    0x853C: 0x85F9,
    0x8572: 0x8604,
    0x8574: 0x860A,
    0x85AE: 0x85EA,
    0x85C1: 0x69C1,
    0x85D3: 0x861A,
    0x864F: 0x865C,
    0x8651: 0x616E,
    0x865A: 0x865B,
    0x866B: 0x87F2,
    0x866C: 0x866F,
    0x866E: 0x87E3,
    0x867D: 0x96D6,
    0x867E: 0x8766,
    0x867F: 0x8806,
    0x8680: 0x8755,
    0x8681: 0x87FB,
    0x8682: 0x879E,
    0x8695: 0x8836,
    0x869D: 0x8814,
    0x86AC: 0x8706,
    0x86CA: 0x8831,
    0x86CE: 0x8823,
    0x86CF: 0x87F6,
    0x86EE: 0x883B,
    0x86F0: 0x87C4,
    0x86F1: 0x86FA,
    0x86F2: 0x87EF,
    0x86F3: 0x8784,
    0x86F4: 0x8810,
    0x8715: 0x86FB,
    0x8717: 0x8778,
    0x8721: 0x881F,
    0x8747: 0x8805,
    0x8748: 0x87C8,
    0x8749: 0x87EC,
    0x874E: 0x880D,
    0x877C: 0x87BB,
    0x877E: 0x8811,
    0x8780: 0x87BF,
    0x87A8: 0x87CE,
    0x87CF: 0x8828,
    0x8845: 0x91C1,
    0x8854: 0x929C,
    0x8865: 0x88DC,
    0x886C: 0x896F,
    0x886E: 0x889E,
    0x8884: 0x8956,
    0x8885: 0x5ACB,
    0x8886: 0x8918,
    0x889C: 0x896A,
    0x88AD: 0x8972,
    0x88AF: 0x894F,
    0x88C5: 0x88DD,
    0x88C6: 0x8960,
    0x88C8: 0x890C,
    0x88E2: 0x8933,
    0x88E3: 0x895D,
    0x88E4: 0x8932,
    0x88E5: 0x8947,
    0x891B: 0x8938,
    0x8934: 0x8964,
    0x8941: 0x7E48,
    0x8955: 0x8974,
    0x89C1: 0x898B,
    0x89C2: 0x89C0,
    0x89C3: 0x898E,
    0x89C4: 0x898F,
    0x89C5: 0x8993,
    0x89C6: 0x8996,
    0x89C7: 0x8998,
    0x89C8: 0x89BD,
    0x89C9: 0x89BA,
    0x89CA: 0x89AC,
    0x89CB: 0x89A1,
    0x89CC: 0x89BF,
    0x89CD: 0x89A5,
    0x89CE: 0x89A6,
    0x89CF: 0x89AF,
    0x89D0: 0x89B2,
    0x89D1: 0x89B7,
    0x89DE: 0x89F4,
    0x89E6: 0x89F8,
    0x89EF: 0x89F6,
    0x8A5F: 0x8B8B,
    0x8A89: 0x8B7D,
    0x8A8A: 0x8B04,
    0x8BA0: 0x8A01,
    0x8BA1: 0x8A08,
    0x8BA2: 0x8A02,
    0x8BA3: 0x8A03,
    0x8BA4: 0x8A8D,
    0x8BA5: 0x8B4F,
    0x8BA6: 0x8A10,
    0x8BA7: 0x8A0C,
    0x8BA8: 0x8A0E,
    0x8BA9: 0x8B93,
    0x8BAA: 0x8A15,
    0x8BAB: 0x8A16,
    0x8BAD: 0x8A13,
    0x8BAE: 0x8B70,
    0x8BAF: 0x8A0A,
    0x8BB0: 0x8A18,
    0x8BB1: 0x8A12,
    0x8BB2: 0x8B1B,
    0x8BB3: 0x8AF1,
    0x8BB4: 0x8B33,
    0x8BB5: 0x8A4E,
    0x8BB6: 0x8A1D,
    0x8BB7: 0x8A25,
    0x8BB8: 0x8A31,
    0x8BB9: 0x8A1B,
    0x8BBA: 0x8AD6,
    0x8BBB: 0x8A29,
    0x8BBC: 0x8A1F,
    0x8BBD: 0x8AF7,
    0x8BBE: 0x8A2D,
    0x8BBF: 0x8A2A,
    0x8BC0: 0x8A23,
    0x8BC1: 0x8B49,
    0x8BC2: 0x8A41,
    0x8BC3: 0x8A36,
    0x8BC4: 0x8A55,
    0x8BC5: 0x8A5B,
    0x8BC6: 0x8B58,
    0x8BC7: 0x8A57,
    0x8BC8: 0x8A50,
    0x8BC9: 0x8A34,
    0x8BCA: 0x8A3A,
    0x8BCB: 0x8A46,
    0x8BCC: 0x8B05,
    0x8BCD: 0x8A5E,
    0x8BCE: 0x8A58,
    0x8BCF: 0x8A54,
    0x8BD0: 0x8A56,
    0x8BD1: 0x8B6F,
    0x8BD2: 0x8A52,
    0x8BD3: 0x8A86,
    0x8BD4: 0x8A84,
    0x8BD5: 0x8A66,
    0x8BD6: 0x8A7F,
    0x8BD7: 0x8A69,
    0x8BD8: 0x8A70,
    0x8BD9: 0x8A7C,
    0x8BDA: 0x8AA0,
    0x8BDB: 0x8A85,
    0x8BDC: 0x8A75,
    0x8BDD: 0x8A71,
    0x8BDE: 0x8A95,
    0x8BDF: 0x8A6C,
    0x8BE0: 0x8A6E,
    0x8BE1: 0x8A6D,
    0x8BE2: 0x8A62,
    0x8BE3: 0x8A63,
    0x8BE4: 0x8ACD,
    0x8BE5: 0x8A72,
    0x8BE6: 0x8A73,
    0x8BE7: 0x8A6B,
    0x8BE8: 0x8AE2,
    0x8BE9: 0x8A61,
    0x8BEA: 0x8B78,
    0x8BEB: 0x8AA1,
    0x8BEC: 0x8AA3,
    0x8BED: 0x8A9E,
    0x8BEE: 0x8A9A,
    0x8BEF: 0x8AA4,
    0x8BF0: 0x8AA5,
    0x8BF1: 0x8A98,
    0x8BF2: 0x8AA8,
    0x8BF3: 0x8A91,
    0x8BF4: 0x8AAA,
    0x8BF5: 0x8AA6,
    0x8BF6: 0x8A92,
    0x8BF7: 0x8ACB,
    0x8BF8: 0x8AF8,
    0x8BF9: 0x8ACF,
    0x8BFA: 0x8AFE,
    0x8BFB: 0x8B80,
    0x8BFC: 0x8AD1,
    0x8BFD: 0x8AB9,
    0x8BFE: 0x8AB2,
    0x8BFF: 0x8AC9,
    0x8C00: 0x8ADB,
    0x8C01: 0x8AB0,
    0x8C02: 0x8AD7,
    0x8C03: 0x8ABF,
    0x8C04: 0x8AC2,
    0x8C05: 0x8AD2,
    0x8C06: 0x8AC4,
    0x8C07: 0x8AB6,
    0x8C08: 0x8AC7,
    0x8C0A: 0x8ABC,
    0x8C0B: 0x8B00,
    0x8C0C: 0x8AF6,
    0x8C0D: 0x8ADC,
    0x8C0E: 0x8B0A,
    0x8C0F: 0x8AEB,
    0x8C10: 0x8AE7,
    0x8C11: 0x8B14,
    0x8C12: 0x8B01,
    0x8C13: 0x8B02,
    0x8C14: 0x8AE4,
    0x8C15: 0x8AED,
    0x8C16: 0x8AFC,
    0x8C17: 0x8B92,
    0x8C18: 0x8AEE,
    0x8C19: 0x8AF3,
    0x8C1A: 0x8AFA,
    0x8C1B: 0x8AE6,
    0x8C1C: 0x8B0E,
    0x8C1D: 0x8ADE,
    0x8C1E: 0x8ADD,
    0x8C1F: 0x8B28,
    0x8C20: 0x8B9C,
    0x8C21: 0x8B16,
    0x8C22: 0x8B1D,
    0x8C23: 0x8B20,
    0x8C24: 0x8B17,
    0x8C25: 0x8AE1,
    0x8C26: 0x8B19,
    0x8C27: 0x8B10,
    0x8C28: 0x8B39,
    0x8C29: 0x8B3E,
    0x8C2A: 0x8B2B,
    0x8C2B: 0x8B7E,
    0x8C2C: 0x8B2C,
    0x8C2D: 0x8B5A,
    0x8C2E: 0x8B56,
    0x8C2F: 0x8B59,
    0x8C30: 0x8B95,
    0x8C31: 0x8B5C,
    0x8C32: 0x8B4E,
    0x8C33: 0x8B9E,
    0x8C34: 0x8B74,
    0x8C35: 0x8B6B,
    0x8C36: 0x8B96,
    0x8C37: 0x7A40,
    0x8C6E: 0x8C76,
    0x8D1D: 0x8C9D,
    0x8D1E: 0x8C9E,
    0x8D1F: 0x8CA0,
    0x8D20: 0x8C9F,
    0x8D21: 0x8CA2,
    0x8D22: 0x8CA1,
    0x8D23: 0x8CAC,
    0x8D24: 0x8CE2,
    0x8D25: 0x6557,
    0x8D26: 0x8CEC,
    0x8D27: 0x8CA8,
    0x8D28: 0x8CEA,
    0x8D29: 0x8CA9,
    0x8D2A: 0x8CAA,
    0x8D2B: 0x8CA7,
    0x8D2C: 0x8CB6,
    0x8D2D: 0x8CFC,
    0x8D2E: 0x8CAF,
    0x8D2F: 0x8CAB,
    0x8D30: 0x8CB3,
    0x8D31: 0x8CE4,
    0x8D32: 0x8CC1,
    0x8D33: 0x8CB0,
    0x8D34: 0x8CBC,
    0x8D35: 0x8CB4,
    0x8D36: 0x8CBA,
    0x8D37: 0x8CB8,
    0x8D38: 0x8CBF,
    0x8D39: 0x8CBB,
    0x8D3A: 0x8CC0,
    0x8D3B: 0x8CBD,
    0x8D3C: 0x8CCA,
    0x8D3D: 0x8D04,
    0x8D3E: 0x8CC8,
    0x8D3F: 0x8CC4,
    0x8D40: 0x8CB2,
    0x8D41: 0x8CC3,
    0x8D42: 0x8CC2,
    0x8D43: 0x8D13,
    0x8D44: 0x8CC7,
    0x8D45: 0x8CC5,
    0x8D46: 0x8D10,
    0x8D47: 0x8CD5,
    0x8D48: 0x8CD1,
    0x8D49: 0x8CDA,
    0x8D4A: 0x8CD2,
    0x8D4B: 0x8CE6,
    0x8D4C: 0x8CED,
    0x8D4D: 0x9F4E,
    0x8D4E: 0x8D16,
    0x8D4F: 0x8CDE,
    0x8D50: 0x8CDC,
    0x8D51: 0x8D14,
    0x8D52: 0x8CD9,
    0x8D53: 0x8CE1,
    0x8D54: 0x8CE0,
    0x8D55: 0x8CE7,
    0x8D56: 0x8CF4,
    0x8D57: 0x8CF5,
    0x8D58: 0x8D05,
    0x8D59: 0x8CFB,
    0x8D5A: 0x8CFA,
    0x8D5B: 0x8CFD,
    0x8D5C: 0x8CFE,
    0x8D5D: 0x8D17,
    0x8D5E: 0x8D0A,
    0x8D5F: 0x8D07,
    0x8D60: 0x8D08,
    0x8D61: 0x8D0D,
    0x8D62: 0x8D0F,
    0x8D63: 0x8D1B,
    0x8D6A: 0x8D6C,
    0x8D75: 0x8D99,
    0x8D76: 0x8D95,
    0x8D8B: 0x8DA8,
    0x8DB1: 0x8DB2,
    0x8DB8: 0x8E89,
    0x8DC3: 0x8E8D,
    0x8DC4: 0x8E4C,
    0x8DD6: 0x8E60,
    0x8DDE: 0x8E92,
    0x8DF5: 0x8E10,
    0x8DF6: 0x8E82,
    0x8DF7: 0x8E7A,
    0x8DF8: 0x8E55,
    0x8DF9: 0x8E9A,
    0x8DFB: 0x8E8B,
    0x8E0A: 0x8E34,
    0x8E0C: 0x8E8A,
    0x8E2A: 0x8E64,
    0x8E2C: 0x8E93,
    0x8E2F: 0x8E91,
    0x8E51: 0x8EA1,
    0x8E52: 0x8E63,
    0x8E70: 0x8E95,
    0x8E7F: 0x8EA5,
    0x8E8F: 0x8EAA,
    0x8E9C: 0x8EA6,
    0x8EAF: 0x8EC0,
    0x8F66: 0x8ECA,
    0x8F67: 0x8ECB,
    0x8F68: 0x8ECC,
    0x8F69: 0x8ED2,
    0x8F6A: 0x8ED1,
    0x8F6B: 0x8ED4,
    0x8F6C: 0x8F49,
    0x8F6D: 0x8EDB,
    0x8F6E: 0x8F2A,
    0x8F6F: 0x8EDF,
    0x8F70: 0x8F5F,
    0x8F71: 0x8EF2,
    0x8F72: 0x8EFB,
    0x8F73: 0x8F64,
    0x8F74: 0x8EF8,
    0x8F75: 0x8EF9,
    0x8F76: 0x8EFC,
    0x8F77: 0x8EE4,
    0x8F78: 0x8EEB,
    0x8F79: 0x8F62,
    0x8F7A: 0x8EFA,
    0x8F7B: 0x8F15,
    0x8F7C: 0x8EFE,
    0x8F7D: 0x8F09,
    0x8F7E: 0x8F0A,
    0x8F7F: 0x8F4E,
    0x8F80: 0x8F08,
    0x8F81: 0x8F07,
    0x8F82: 0x8F05,
    0x8F83: 0x8F03,
    0x8F84: 0x8F12,
    0x8F85: 0x8F14,
    0x8F86: 0x8F1B,
    0x8F87: 0x8F26,
    0x8F88: 0x8F29,
    0x8F89: 0x8F1D,
    0x8F8A: 0x8F25,
    0x8F8B: 0x8F1E,
    0x8F8C: 0x8F2C,
    0x8F8D: 0x8F1F,
    0x8F8E: 0x8F1C,
    0x8F8F: 0x8F33,
    0x8F90: 0x8F3B,
    0x8F91: 0x8F2F,
    0x8F92: 0x8F40,
    0x8F93: 0x8F38,
    0x8F94: 0x8F61,
    0x8F95: 0x8F45,
    0x8F96: 0x8F44,
    0x8F97: 0x8F3E,
    0x8F98: 0x8F46,
    0x8F99: 0x8F4D,
    0x8F9A: 0x8F54,
    0x8F9E: 0x8FAD,
    0x8FA9: 0x8FAF,
    0x8FAB: 0x8FAE,
    0x8FB9: 0x908A,
    0x8FBD: 0x907C,
    0x8FBE: 0x9054,
    0x8FC1: 0x9077,
    0x8FC7: 0x904E,
    0x8FC8: 0x9081,
    0x8FD0: 0x904B,
    0x8FD8: 0x9084,
    0x8FD9: 0x9019,
    0x8FDB: 0x9032,
    0x8FDC: 0x9060,
    0x8FDD: 0x9055,
    0x8FDE: 0x9023,
    0x8FDF: 0x9072,
    0x8FE9: 0x9087,
    0x8FF3: 0x9015,
    0x8FF9: 0x8DE1,
    0x9002: 0x9069,
    0x9009: 0x9078,
    0x900A: 0x905C,
    0x9012: 0x905E,
    0x9026: 0x9090,
    0x903B: 0x908F,
    0x9057: 0x907A,
    0x9065: 0x9059,
    0x9093: 0x9127,
    0x909D: 0x913A,
    0x90AC: 0x9114,
    0x90AE: 0x90F5,
    0x90B9: 0x9112,
    0x90BA: 0x9134,
    0x90BB: 0x9130,
    0x90C1: 0x9B31,
    0x90C4: 0x90E4,
    0x90CF: 0x90DF,
    0x90D0: 0x9136,
    0x90D1: 0x912D,
    0x90D3: 0x9106,
    0x90E6: 0x9148,
    0x90E7: 0x9116,
    0x90F8: 0x9132,
    0x915D: 0x919E,
    0x9166: 0x91B1,
    0x9171: 0x91AC,
    0x917D: 0x91C5,
    0x917E: 0x91C3,
    0x917F: 0x91C0,
    0x91CA: 0x91CB,
    0x91CC: 0x88CF,
    0x9274: 0x9452,
    0x92AE: 0x947E,
    0x933E: 0x93E8,
    0x9486: 0x91D3,
    0x9487: 0x91D4,
    0x9488: 0x91DD,
    0x9489: 0x91D8,
    0x948A: 0x91D7,
    0x948B: 0x91D9,
    0x948C: 0x91D5,
    0x948D: 0x91F7,
    0x948E: 0x91FA,
    0x948F: 0x91E7,
    0x9490: 0x91E4,
    0x9491: 0x9212,
    0x9492: 0x91E9,
    0x9493: 0x91E3,
    0x9494: 0x9346,
    0x9495: 0x91F9,
    0x9496: 0x935A,
    0x9497: 0x91F5,
    0x9498: 0x9203,
    0x9499: 0x9223,
    0x949A: 0x9208,
    0x949B: 0x9226,
    0x949D: 0x920D,
    0x949E: 0x9214,
    0x949F: 0x937E,
    0x94A0: 0x9209,
    0x94A1: 0x92C7,
    0x94A2: 0x92FC,
    0x94A3: 0x9211,
    0x94A4: 0x9210,
    0x94A5: 0x9470,
    0x94A6: 0x6B3D,
    0x94A7: 0x921E,
    0x94A8: 0x93A2,
    0x94A9: 0x9264,
    0x94AA: 0x9227,
    0x94AB: 0x9201,
    0x94AC: 0x9225,
    0x94AD: 0x9204,
    0x94AE: 0x9215,
    0x94AF: 0x9200,
    0x94B0: 0x923A,
    0x94B1: 0x9322,
    0x94B2: 0x9266,
    0x94B3: 0x9257,
    0x94B4: 0x9237,
    0x94B5: 0x7F3D,
    0x94B6: 0x9233,
    0x94B7: 0x9255,
    0x94B8: 0x923D,
    0x94B9: 0x9238,
    0x94BA: 0x925E,
    0x94BB: 0x947D,
    0x94BC: 0x926C,
    0x94BD: 0x926D,
    0x94BE: 0x9240,
    0x94BF: 0x923F,
    0x94C0: 0x923E,
    0x94C1: 0x9435,
    0x94C2: 0x9251,
    0x94C3: 0x9234,
    0x94C4: 0x9460,
    0x94C5: 0x925B,
    0x94C6: 0x925A,
    0x94C8: 0x9230,
    0x94C9: 0x9249,
    0x94CA: 0x9248,
    0x94CB: 0x924D,
    0x94CC: 0x922E,
    0x94CD: 0x9239,
    0x94CE: 0x9438,
    0x94CF: 0x9276,
    0x94D0: 0x92AC,
    0x94D1: 0x92A0,
    0x94D2: 0x927A,
    0x94D3: 0x92E9,
    0x94D4: 0x930F,
    0x94D5: 0x92AA,
    0x94D6: 0x92EE,
    0x94D7: 0x92CF,
    0x94D8: 0x92E3,
    0x94D9: 0x9403,
    0x94DA: 0x928D,
    0x94DB: 0x943A,
    0x94DC: 0x9285,
    0x94DD: 0x92C1,
    0x94DE: 0x92B1,
    0x94DF: 0x92A6,
    0x94E0: 0x93A7,
    0x94E1: 0x9358,
    0x94E2: 0x9296,
    0x94E3: 0x9291,
    0x94E4: 0x92CC,
    0x94E5: 0x92A9,
    0x94E6: 0x929B,
    0x94E7: 0x93F5,
    0x94E8: 0x9293,
    0x94E9: 0x93A9,
    0x94EA: 0x927F,
    0x94EB: 0x929A,
    0x94EC: 0x927B,
    0x94ED: 0x9298,
    0x94EE: 0x931A,
    0x94EF: 0x92AB,
    0x94F0: 0x9278,
    0x94F1: 0x92A5,
    0x94F2: 0x93DF,
    0x94F3: 0x9283,
    0x94F4: 0x940B,
    0x94F5: 0x92A8,
    0x94F6: 0x9280,
    0x94F7: 0x92A3,
    0x94F8: 0x9444,
    0x94F9: 0x9412,
    0x94FA: 0x92EA,
    0x94FB: 0x92D9,
    0x94FC: 0x9338,
    0x94FD: 0x92F1,
    0x94FE: 0x93C8,
    0x94FF: 0x93D7,
    0x9500: 0x92B7,
    0x9501: 0x9396,
    0x9502: 0x92F0,
    0x9503: 0x92E5,
    0x9504: 0x92E4,
    0x9505: 0x934B,
    0x9506: 0x92EF,
    0x9507: 0x92E8,
    0x9508: 0x93FD,
    0x9509: 0x92BC,
    0x950A: 0x92DD,
    0x950B: 0x92D2,
    0x950C: 0x92C5,
    0x950D: 0x92F6,
    0x950E: 0x9426,
    0x950F: 0x9427,
    0x9510: 0x92B3,
    0x9511: 0x92BB,
    0x9512: 0x92C3,
    0x9513: 0x92DF,
    0x9514: 0x92E6,
    0x9515: 0x9312,
    0x9516: 0x9306,
    0x9517: 0x937A,
    0x9518: 0x9369,
    0x9519: 0x932F,
    0x951A: 0x9328,
    0x951B: 0x931B,
    0x951C: 0x9321,
    0x951D: 0x9340,
    0x951E: 0x9301,
    0x951F: 0x9315,
    0x9520: 0x9329,
    0x9521: 0x932B,
    0x9522: 0x932E,
    0x9523: 0x947C,
    0x9524: 0x9318,
    0x9525: 0x9310,
    0x9526: 0x9326,
    0x9527: 0x9455,
    0x9528: 0x9341,
    0x9529: 0x9308,
    0x952A: 0x9343,
    0x952B: 0x9307,
    0x952C: 0x931F,
    0x952D: 0x9320,
    0x952E: 0x9375,
    0x952F: 0x92F8,
    0x9530: 0x9333,
    0x9531: 0x9319,
    0x9532: 0x9365,
    0x9533: 0x9348,
    0x9534: 0x9347,
    0x9535: 0x93D8,
    0x9536: 0x9376,
    0x9537: 0x9354,
    0x9538: 0x9364,
    0x9539: 0x936C,
    0x953A: 0x937E,
    0x953B: 0x935B,
    0x953C: 0x93AA,
    0x953D: 0x9360,
    0x953E: 0x9370,
    0x953F: 0x9384,
    0x9540: 0x934D,
    0x9541: 0x9382,
    0x9542: 0x93E4,
    0x9543: 0x93A1,
    0x9544: 0x9428,
    0x9545: 0x9387,
    0x9546: 0x93CC,
    0x9547: 0x93AE,
    0x9548: 0x939B,
    0x9549: 0x9398,
    0x954A: 0x9477,
    0x954B: 0x9482,
    0x954C: 0x942B,
    0x954D: 0x93B3,
    0x954E: 0x93BF,
    0x954F: 0x93A6,
    0x9550: 0x93AC,
    0x9551: 0x938A,
    0x9552: 0x93B0,
    0x9553: 0x93B5,
    0x9554: 0x944C,
    0x9555: 0x9394,
    0x9556: 0x93E2,
    0x9557: 0x93DC,
    0x9558: 0x93DD,
    0x9559: 0x93CD,
    0x955A: 0x93F0,
    0x955B: 0x93DE,
    0x955C: 0x93E1,
    0x955D: 0x93D1,
    0x955E: 0x93C3,
    0x9560: 0x93D0,
    0x9561: 0x9414,
    0x9562: 0x9481,
    0x9563: 0x9410,
    0x9564: 0x93F7,
    0x9565: 0x9465,
    0x9566: 0x9413,
    0x9567: 0x946D,
    0x9568: 0x9420,
    0x9569: 0x9479,
    0x956A: 0x93F9,
    0x956B: 0x9419,
    0x956C: 0x944A,
    0x956D: 0x9433,
    0x956E: 0x9436,
    0x956F: 0x9432,
    0x9570: 0x942E,
    0x9571: 0x943F,
    0x9572: 0x9454,
    0x9573: 0x9463,
    0x9574: 0x945E,
    0x9575: 0x9471,
    0x9576: 0x9472,
    0x957F: 0x9577,
    0x95E8: 0x9580,
    0x95E9: 0x9582,
    0x95EA: 0x9583,
    0x95EB: 0x9586,
    0x95EC: 0x9588,
    0x95ED: 0x9589,
    0x95EE: 0x554F,
    0x95EF: 0x95D6,
    0x95F0: 0x958F,
    0x95F1: 0x95C8,
    0x95F2: 0x9591,
    0x95F3: 0x958E,
    0x95F4: 0x9593,
    0x95F5: 0x9594,
    0x95F6: 0x958C,
    0x95F7: 0x60B6,
    0x95F8: 0x9598,
    0x95F9: 0x9B27,
    0x95FA: 0x95A8,
    0x95FB: 0x805E,
    0x95FC: 0x95E5,
    0x95FD: 0x95A9,
    0x95FE: 0x95AD,
    0x95FF: 0x95D3,
    0x9600: 0x95A5,
    0x9601: 0x95A3,
    0x9602: 0x95A1,
    0x9603: 0x95AB,
    0x9604: 0x9B2E,
    0x9605: 0x95B1,
    0x9606: 0x95AC,
    0x9607: 0x95CD,
    0x9608: 0x95BE,
    0x9609: 0x95B9,
    0x960A: 0x95B6,
    0x960B: 0x9B29,
    0x960C: 0x95BF,
    0x960D: 0x95BD,
    0x960E: 0x95BB,
    0x960F: 0x95BC,
    0x9610: 0x95E1,
    0x9611: 0x95CC,
    0x9612: 0x95C3,
    0x9613: 0x95E0,
    0x9614: 0x95CA,
    0x9615: 0x95CB,
    0x9616: 0x95D4,
    0x9617: 0x95D0,
    0x9618: 0x95D2,
    0x9619: 0x95D5,
    0x961A: 0x95DE,
    0x961B: 0x95E4,
    0x961F: 0x968A,
    0x9633: 0x967D,
    0x9634: 0x9670,
    0x9635: 0x9663,
    0x9636: 0x968E,
    0x9645: 0x969B,
    0x9646: 0x9678,
    0x9647: 0x96B4,
    0x9648: 0x9673,
    0x9649: 0x9658,
    0x9655: 0x965D,
    0x9667: 0x9689,
    0x9668: 0x9695,
    0x9669: 0x96AA,
    0x968F: 0x96A8,
    0x9690: 0x96B1,
    0x96B6: 0x96B8,
    0x96BD: 0x96CB,
    0x96BE: 0x96E3,
    0x96CF: 0x96DB,
    0x96E0: 0x8B8E,
    0x96F3: 0x9742,
    0x96FE: 0x9727,
    0x9701: 0x973D,
    0x9709: 0x9EF4,
    0x972D: 0x9744,
    0x9753: 0x975A,
    0x9759: 0x975C,
    0x9765: 0x9768,
    0x9791: 0x97C3,
    0x9792: 0x97BD,
    0x97AF: 0x97C9,
    0x97B4: 0x97DD,
    0x97E6: 0x97CB,
    0x97E7: 0x97CC,
    0x97E8: 0x97CD,
    0x97E9: 0x97D3,
    0x97EA: 0x97D9,
    0x97EB: 0x97DE,
    0x97EC: 0x97DC,
    0x97F5: 0x97FB,
    0x9875: 0x9801,
    0x9876: 0x9802,
    0x9877: 0x9803,
    0x9878: 0x9807,
    0x9879: 0x9805,
    0x987A: 0x9806,
    0x987B: 0x9808,
    0x987C: 0x980A,
    0x987D: 0x9811,
    0x987E: 0x9867,
    0x987F: 0x9813,
    0x9880: 0x980E,
    0x9881: 0x9812,
    0x9882: 0x980C,
    0x9883: 0x980F,
    0x9884: 0x9810,
    0x9885: 0x9871,
    0x9886: 0x9818,
    0x9887: 0x9817,
    0x9888: 0x9838,
    0x9889: 0x9821,
    0x988A: 0x9830,
    0x988B: 0x9832,
    0x988C: 0x981C,
    0x988D: 0x6F41,
    0x988E: 0x71B2,
    0x988F: 0x9826,
    0x9890: 0x9824,
    0x9891: 0x983B,
    0x9892: 0x982E,
    0x9893: 0x9839,
    0x9894: 0x9837,
    0x9895: 0x9834,
    0x9896: 0x7A4E,
    0x9897: 0x9846,
    0x9898: 0x984C,
    0x9899: 0x9852,
    0x989A: 0x984E,
    0x989B: 0x9853,
    0x989C: 0x984F,
    0x989D: 0x984D,
    0x989E: 0x9873,
    0x989F: 0x9862,
    0x98A0: 0x985B,
    0x98A1: 0x9859,
    0x98A2: 0x9865,
    0x98A3: 0x7E87,
    0x98A4: 0x986B,
    0x98A5: 0x986C,
    0x98A6: 0x9870,
    0x98A7: 0x9874,
    0x98CE: 0x98A8,
    0x98CF: 0x98BA,
    0x98D0: 0x98AD,
    0x98D1: 0x98AE,
    0x98D2: 0x98AF,
    0x98D3: 0x98B6,
    0x98D4: 0x98B8,
    0x98D5: 0x98BC,
    0x98D6: 0x98BB,
    0x98D7: 0x98C0,
    0x98D8: 0x98C4,
    0x98D9: 0x98C6,
    0x98DA: 0x98C6,
    0x98DE: 0x98DB,
    0x98E8: 0x9957,
    0x990D: 0x995C,
    0x9964: 0x98E3,
    0x9965: 0x9951,
    0x9966: 0x98E5,
    0x9967: 0x9933,
    0x9968: 0x98E9,
    0x9969: 0x993C,
    0x996A: 0x98EA,
    0x996B: 0x98EB,
    0x996C: 0x98ED,
    0x996D: 0x98EF,
    0x996E: 0x98F2,
    0x996F: 0x991E,
    0x9970: 0x98FE,
    0x9971: 0x98FD,
    0x9972: 0x98FC,
    0x9973: 0x98FF,
    0x9974: 0x98F4,
    0x9975: 0x990C,
    0x9976: 0x9952,
    0x9977: 0x9909,
    0x9978: 0x9904,
    0x9979: 0x990E,
    0x997A: 0x9903,
    0x997B: 0x990F,
    0x997C: 0x9905,
    0x997D: 0x9911,
    0x997E: 0x9916,
    0x997F: 0x9913,
    0x9980: 0x9918,
    0x9981: 0x9912,
    0x9982: 0x9915,
    0x9983: 0x991C,
    0x9984: 0x991B,
    0x9985: 0x9921,
    0x9986: 0x9928,
    0x9987: 0x9937,
    0x9988: 0x994B,
    0x9989: 0x9936,
    0x998A: 0x993F,
    0x998B: 0x995E,
    0x998C: 0x9941,
    0x998D: 0x9943,
    0x998E: 0x993A,
    0x998F: 0x993E,
    0x9990: 0x9948,
    0x9991: 0x9949,
    0x9992: 0x9945,
    0x9993: 0x994A,
    0x9994: 0x994C,
    0x9995: 0x9962,
    0x9A6C: 0x99AC,
    0x9A6D: 0x99AD,
    0x9A6E: 0x99B1,
    0x9A6F: 0x99B4,
    0x9A70: 0x99B3,
    0x9A71: 0x9A45,
    0x9A72: 0x99B9,
    0x9A73: 0x99C1,
    0x9A74: 0x9A62,
    0x9A75: 0x99D4,
    0x9A76: 0x99DB,
    0x9A77: 0x99DF,
    0x9A78: 0x99D9,
    0x9A79: 0x99D2,
    0x9A7A: 0x9A36,
    0x9A7B: 0x99D0,
    0x9A7C: 0x99DD,
    0x9A7D: 0x99D1,
    0x9A7E: 0x99D5,
    0x9A7F: 0x9A5B,
    0x9A80: 0x99D8,
    0x9A81: 0x9A4D,
    0x9A82: 0x7F75,
    0x9A83: 0x99F0,
    0x9A84: 0x9A55,
    0x9A85: 0x9A4A,
    0x9A86: 0x99F1,
    0x9A87: 0x99ED,
    0x9A88: 0x99E2,
    0x9A89: 0x9A6B,
    0x9A8A: 0x9A6A,
    0x9A8B: 0x9A01,
    0x9A8C: 0x9A57,
    0x9A8D: 0x9A02,
    0x9A8E: 0x99F8,
    0x9A8F: 0x99FF,
    0x9A90: 0x9A0F,
    0x9A91: 0x9A0E,
    0x9A92: 0x9A0D,
    0x9A93: 0x9A05,
    0x9A94: 0x9A0C,
    0x9A95: 0x9A4C,
    0x9A96: 0x9A42,
    0x9A97: 0x9A19,
    0x9A98: 0x9A2D,
    0x9A99: 0x9A24,
    0x9A9A: 0x9A37,
    0x9A9B: 0x9A16,
    0x9A9C: 0x9A41,
    0x9A9D: 0x9A2E,
    0x9A9E: 0x9A2B,
    0x9A9F: 0x9A38,
    0x9AA0: 0x9A43,
    0x9AA1: 0x9A3E,
    0x9AA2: 0x9A44,
    0x9AA3: 0x9A4F,
    0x9AA4: 0x9A5F,
    0x9AA5: 0x9A65,
    0x9AA6: 0x9A66,
    0x9AA7: 0x9A64,
    0x9AC5: 0x9ACF,
    0x9ACB: 0x9AD6,
    0x9ACC: 0x9AD5,
    0x9B13: 0x9B22,
    0x9B47: 0x9B58,
    0x9B49: 0x9B4E,
    0x9C7C: 0x9B5A,
    0x9C7D: 0x9B5B,
    0x9C7E: 0x9B62,
    0x9C7F: 0x9B77,
    0x9C80: 0x9B68,
    0x9C81: 0x9B6F,
    0x9C82: 0x9B74,
    0x9C84: 0x9B7A,
    0x9C85: 0x9B81,
    0x9C86: 0x9B83,
    0x9C87: 0x9BF0,
    0x9C88: 0x9C78,
    0x9C89: 0x9B8B,
    0x9C8A: 0x9B93,
    0x9C8B: 0x9B92,
    0x9C8C: 0x9B8A,
    0x9C8D: 0x9B91,
    0x9C8E: 0x9C5F,
    0x9C8F: 0x9B8D,
    0x9C90: 0x9B90,
    0x9C91: 0x9BAD,
    0x9C92: 0x9B9A,
    0x9C93: 0x9BB3,
    0x9C94: 0x9BAA,
    0x9C95: 0x9B9E,
    0x9C96: 0x9BA6,
    0x9C97: 0x9C02,
    0x9C98: 0x9B9C,
    0x9C99: 0x9C60,
    0x9C9A: 0x9C6D,
    0x9C9B: 0x9BAB,
    0x9C9C: 0x9BAE,
    0x9C9D: 0x9BBA,
    0x9C9E: 0x9BD7,
    0x9C9F: 0x9C58,
    0x9CA0: 0x9BC1,
    0x9CA1: 0x9C7A,
    0x9CA2: 0x9C31,
    0x9CA3: 0x9C39,
    0x9CA4: 0x9BC9,
    0x9CA5: 0x9C23,
    0x9CA6: 0x9C37,
    0x9CA7: 0x9BC0,
    0x9CA8: 0x9BCA,
    0x9CA9: 0x9BC7,
    0x9CAA: 0x9BB6,
    0x9CAB: 0x9BFD,
    0x9CAC: 0x9BD2,
    0x9CAD: 0x9BD6,
    0x9CAE: 0x9BEA,
    0x9CAF: 0x9BD5,
    0x9CB0: 0x9BEB,
    0x9CB1: 0x9BE1,
    0x9CB2: 0x9BE4,
    0x9CB3: 0x9BE7,
    0x9CB4: 0x9BDD,
    0x9CB5: 0x9BE2,
    0x9CB6: 0x9BF0,
    0x9CB7: 0x9BDB,
    0x9CB8: 0x9BE8,
    0x9CB9: 0x9BF5,
    0x9CBA: 0x9BF4,
    0x9CBB: 0x9BD4,
    0x9CBC: 0x9C5D,
    0x9CBD: 0x9C08,
    0x9CBE: 0x9C0F,
    0x9CBF: 0x9C68,
    0x9CC0: 0x9BF7,
    0x9CC1: 0x9C2E,
    0x9CC2: 0x9C03,
    0x9CC3: 0x9C13,
    0x9CC4: 0x9C77,
    0x9CC5: 0x9C0D,
    0x9CC6: 0x9C12,
    0x9CC7: 0x9C09,
    0x9CC8: 0x9C01,
    0x9CC9: 0x9C42,
    0x9CCA: 0x9BFF,
    0x9CCB: 0x9C20,
    0x9CCC: 0x9F07,
    0x9CCD: 0x9C2D,
    0x9CCE: 0x9C28,
    0x9CCF: 0x9C25,
    0x9CD0: 0x9C29,
    0x9CD1: 0x9C1F,
    0x9CD2: 0x9C1C,
    0x9CD3: 0x9C33,
    0x9CD4: 0x9C3E,
    0x9CD5: 0x9C48,
    0x9CD6: 0x9C49,
    0x9CD7: 0x9C3B,
    0x9CD8: 0x9C35,
    0x9CD9: 0x9C45,
    0x9CDB: 0x9C3C,
    0x9CDC: 0x9C56,
    0x9CDD: 0x9C54,
    0x9CDE: 0x9C57,
    0x9CDF: 0x9C52,
    0x9CE0: 0x9C6F,
    0x9CE1: 0x9C64,
    0x9CE2: 0x9C67,
    0x9CE3: 0x9C63,
    0x9E1F: 0x9CE5,
    0x9E20: 0x9CE9,
    0x9E21: 0x96DE,
    0x9E22: 0x9CF6,
    0x9E23: 0x9CF4,
    0x9E24: 0x9CF2,
    0x9E25: 0x9DD7,
    0x9E26: 0x9D09,
    0x9E27: 0x9DAC,
    0x9E28: 0x9D07,
    0x9E29: 0x9D06,
    0x9E2A: 0x9D23,
    0x9E2B: 0x9D87,
    0x9E2C: 0x9E15,
    0x9E2D: 0x9D28,
    0x9E2E: 0x9D1E,
    0x9E2F: 0x9D26,
    0x9E30: 0x9D12,
    0x9E31: 0x9D1F,
    0x9E32: 0x9D1D,
    0x9E33: 0x9D1B,
    0x9E34: 0x9D2C,
    0x9E35: 0x9D15,
    0x9E36: 0x9DE5,
    0x9E37: 0x9DD9,
    0x9E38: 0x9D2F,
    0x9E39: 0x9D30,
    0x9E3A: 0x9D42,
    0x9E3B: 0x9D34,
    0x9E3C: 0x9D43,
    0x9E3D: 0x9D3F,
    0x9E3E: 0x9E1E,
    0x9E3F: 0x9D3B,
    0x9E40: 0x9D50,
    0x9E41: 0x9D53,
    0x9E42: 0x9E1D,
    0x9E43: 0x9D51,
    0x9E44: 0x9D60,
    0x9E45: 0x9D5D,
    0x9E46: 0x9D52,
    0x9E47: 0x9DF3,
    0x9E48: 0x9D5C,
    0x9E49: 0x9D61,
    0x9E4A: 0x9D72,
    0x9E4B: 0x9D93,
    0x9E4C: 0x9D6A,
    0x9E4D: 0x9DA4,
    0x9E4E: 0x9D6F,
    0x9E4F: 0x9D6C,
    0x9E50: 0x9D6E,
    0x9E51: 0x9D89,
    0x9E52: 0x9D8A,
    0x9E53: 0x9D77,
    0x9E54: 0x9DEB,
    0x9E55: 0x9D98,
    0x9E56: 0x9DA1,
    0x9E57: 0x9D9A,
    0x9E58: 0x9DBB,
    0x9E59: 0x9D96,
    0x9E5A: 0x9DBF,
    0x9E5B: 0x9DA5,
    0x9E5C: 0x9DA9,
    0x9E5D: 0x9DCA,
    0x9E5E: 0x9DC2,
    0x9E5F: 0x9DB2,
    0x9E60: 0x9DB9,
    0x9E61: 0x9DBA,
    0x9E62: 0x9DC1,
    0x9E63: 0x9DBC,
    0x9E64: 0x9DB4,
    0x9E65: 0x9DD6,
    0x9E66: 0x9E1A,
    0x9E67: 0x9DD3,
    0x9E68: 0x9DDA,
    0x9E69: 0x9DEF,
    0x9E6A: 0x9DE6,
    0x9E6B: 0x9DF2,
    0x9E6C: 0x9DF8,
    0x9E6D: 0x9DFA,
    0x9E6F: 0x9E07,
    0x9E70: 0x9DF9,
    0x9E71: 0x9E0C,
    0x9E72: 0x9E0F,
    0x9E73: 0x9E1B,
    0x9E74: 0x9E18,
    0x9E7E: 0x9E7A,
    0x9EA6: 0x9EA5,
    0x9EB8: 0x9EA9,
    0x9EC4: 0x9EC3,
    0x9EC9: 0x9ECC,
    0x9EE1: 0x9EF6,
    0x9EE9: 0x9EF7,
    0x9EEA: 0x9EF2,
    0x9EFE: 0x9EFD,
    0x9F0B: 0x9EFF,
    0x9F0C: 0x9F02,
    0x9F0D: 0x9F09,
    0x9F17: 0x9780,
    0x9F39: 0x9F34,
    0x9F44: 0x9F47,
    0x9F50: 0x9F4A,
    0x9F51: 0x9F4F,
    0x9F7F: 0x9F52,
    0x9F80: 0x9F54,
    0x9F81: 0x9F55,
    0x9F82: 0x9F57,
    0x9F83: 0x9F5F,
    0x9F84: 0x9F61,
    0x9F85: 0x9F59,
    0x9F86: 0x9F60,
    0x9F87: 0x9F5C,
    0x9F88: 0x9F66,
    0x9F89: 0x9F6C,
    0x9F8A: 0x9F6A,
    0x9F8B: 0x9F72,
    0x9F8C: 0x9F77,
    0x9F99: 0x9F8D,
    0x9F9A: 0x9F94,
    0x9F9B: 0x9F95,
    0x9F9F: 0x9F9C,
}

Trad2Simp_Table = {
    0x2022: 0xFF0E,
    0x2024: 0x02D9,
    0x2025: 0x00A8,
    0x2027: 0xFF0E,
    0x2032: 0xFF07,
    0x300C: 0x201C,
    0x300D: 0x201D,
    0x300E: 0x2018,
    0x300F: 0x2019,
    0x301E: 0x2033,
    0x4E1F: 0x4E22,
    0x4E26: 0x5E76,
    0x4E7E: 0x5E72,
    0x4E82: 0x4E71,
    0x4E99: 0x4E98,
    0x4E9E: 0x4E9A,
    0x4F15: 0x592B,
    0x4F47: 0x4F2B,
    0x4F48: 0x5E03,
    0x4F54: 0x5360,
    0x4F58: 0x7572,
    0x4F75: 0x5E76,
    0x4F86: 0x6765,
    0x4F96: 0x4ED1,
    0x4FB6: 0x4FA3,
    0x4FB7: 0x5C40,
    0x4FC1: 0x4FE3,
    0x4FC2: 0x7CFB,
    0x4FE0: 0x4FA0,
    0x5000: 0x4F25,
    0x5006: 0x4FE9,
    0x5009: 0x4ED3,
    0x500B: 0x4E2A,
    0x5011: 0x4EEC,
    0x5016: 0x5E78,
    0x5023: 0x4EFF,
    0x502B: 0x4F26,
    0x5049: 0x4F1F,
    0x5074: 0x4FA7,
    0x5075: 0x4FA6,
    0x5078: 0x5077,
    0x507A: 0x54B1,
    0x507D: 0x4F2A,
    0x5091: 0x6770,
    0x5096: 0x4F27,
    0x5098: 0x4F1E,
    0x5099: 0x5907,
    0x509A: 0x6548,
    0x50A2: 0x5BB6,
    0x50AD: 0x4F63,
    0x50AF: 0x506C,
    0x50B3: 0x4F20,
    0x50B4: 0x4F1B,
    0x50B5: 0x503A,
    0x50B7: 0x4F24,
    0x50BE: 0x503E,
    0x50C2: 0x507B,
    0x50C5: 0x4EC5,
    0x50C9: 0x4F65,
    0x50D1: 0x4FA8,
    0x50D5: 0x4EC6,
    0x50DE: 0x4F2A,
    0x50E5: 0x4FA5,
    0x50E8: 0x507E,
    0x50F1: 0x96C7,
    0x50F9: 0x4EF7,
    0x5100: 0x4EEA,
    0x5102: 0x4FAC,
    0x5104: 0x4EBF,
    0x5105: 0x5F53,
    0x5108: 0x4FA9,
    0x5109: 0x4FED,
    0x5110: 0x50A7,
    0x5114: 0x4FE6,
    0x5115: 0x4FAA,
    0x5118: 0x5C3D,
    0x511F: 0x507F,
    0x512A: 0x4F18,
    0x5132: 0x50A8,
    0x5137: 0x4FEA,
    0x5138: 0x7F57,
    0x5139: 0x6512,
    0x513A: 0x50A9,
    0x513B: 0x50A5,
    0x513C: 0x4FE8,
    0x5147: 0x51F6,
    0x514C: 0x5151,
    0x5152: 0x513F,
    0x5157: 0x5156,
    0x5167: 0x5185,
    0x5169: 0x4E24,
    0x518A: 0x518C,
    0x51AA: 0x5E42,
    0x51C3: 0x6D82,
    0x51CD: 0x51BB,
    0x51DC: 0x51DB,
    0x51DF: 0x6E0E,
    0x51E6: 0x5904,
    0x51F1: 0x51EF,
    0x51F4: 0x51ED,
    0x5225: 0x522B,
    0x522A: 0x5220,
    0x5244: 0x522D,
    0x5247: 0x5219,
    0x524B: 0x514B,
    0x5257: 0x522C,
    0x525B: 0x521A,
    0x525D: 0x5265,
    0x526E: 0x5250,
    0x5274: 0x5240,
    0x5275: 0x521B,
    0x5277: 0x94F2,
    0x5283: 0x5212,
    0x5284: 0x672D,
    0x5287: 0x5267,
    0x5289: 0x5218,
    0x528A: 0x523D,
    0x528C: 0x523F,
    0x528D: 0x5251,
    0x5291: 0x5242,
    0x5292: 0x5251,
    0x52C1: 0x52B2,
    0x52D5: 0x52A8,
    0x52D7: 0x52D6,
    0x52D9: 0x52A1,
    0x52DB: 0x52CB,
    0x52DD: 0x80DC,
    0x52DE: 0x52B3,
    0x52E2: 0x52BF,
    0x52E3: 0x7EE9,
    0x52E6: 0x527F,
    0x52E9: 0x52DA,
    0x52F1: 0x52A2,
    0x52F3: 0x52CB,
    0x52F5: 0x52B1,
    0x52F8: 0x529D,
    0x52FB: 0x5300,
    0x532D: 0x5326,
    0x532F: 0x6C47,
    0x5331: 0x532E,
    0x5332: 0x5941,
    0x5333: 0x5941,
    0x5335: 0x691F,
    0x5340: 0x533A,
    0x5354: 0x534F,
    0x5379: 0x6064,
    0x537B: 0x5374,
    0x5399: 0x538D,
    0x539B: 0x5385,
    0x53A0: 0x5395,
    0x53A4: 0x5386,
    0x53AD: 0x538C,
    0x53B0: 0x5382,
    0x53B2: 0x5389,
    0x53B4: 0x53A3,
    0x53C3: 0x53C2,
    0x53E2: 0x4E1B,
    0x5412: 0x54A4,
    0x5433: 0x5434,
    0x5442: 0x5415,
    0x54BC: 0x5459,
    0x54E1: 0x5458,
    0x54E2: 0x5494,
    0x5504: 0x5457,
    0x5515: 0x5523,
    0x551A: 0x5423,
    0x5538: 0x5FF5,
    0x554F: 0x95EE,
    0x5553: 0x542F,
    0x5557: 0x5556,
    0x555E: 0x54D1,
    0x555F: 0x542F,
    0x5562: 0x5521,
    0x5563: 0x8854,
    0x5592: 0x54B1,
    0x559A: 0x5524,
    0x55A6: 0x5CA9,
    0x55AA: 0x4E27,
    0x55AB: 0x5403,
    0x55AC: 0x4E54,
    0x55AE: 0x5355,
    0x55B2: 0x54DF,
    0x55C6: 0x545B,
    0x55C7: 0x556C,
    0x55CA: 0x551D,
    0x55CE: 0x5417,
    0x55DA: 0x545C,
    0x55E9: 0x5522,
    0x55F6: 0x54D4,
    0x5606: 0x53F9,
    0x560D: 0x55BD,
    0x5614: 0x5455,
    0x5616: 0x5567,
    0x5617: 0x5C1D,
    0x561C: 0x551B,
    0x5629: 0x54D7,
    0x562E: 0x5520,
    0x562F: 0x5578,
    0x5630: 0x53FD,
    0x5635: 0x54D3,
    0x5638: 0x5452,
    0x563D: 0x5574,
    0x5641: 0x6076,
    0x5645: 0x54B4,
    0x5653: 0x5618,
    0x565D: 0x549D,
    0x5660: 0x54D2,
    0x5665: 0x54DD,
    0x5666: 0x54D5,
    0x566F: 0x55F3,
    0x5672: 0x54D9,
    0x5674: 0x55B7,
    0x5678: 0x5428,
    0x5679: 0x5F53,
    0x5680: 0x549B,
    0x5687: 0x5413,
    0x568C: 0x54DC,
    0x5690: 0x5C1D,
    0x5695: 0x565C,
    0x5699: 0x556E,
    0x56A5: 0x54BD,
    0x56A6: 0x5456,
    0x56A8: 0x5499,
    0x56AE: 0x5411,
    0x56B2: 0x4EB8,
    0x56B3: 0x55BE,
    0x56B4: 0x4E25,
    0x56B6: 0x5624,
    0x56BB: 0x56A3,
    0x56C0: 0x556D,
    0x56C1: 0x55EB,
    0x56C2: 0x56A3,
    0x56C5: 0x5181,
    0x56C8: 0x5453,
    0x56C9: 0x5570,
    0x56CC: 0x82CF,
    0x56D1: 0x5631,
    0x56D8: 0x56DE,
    0x56EA: 0x56F1,
    0x56EC: 0x56DE,
    0x56EF: 0x56FD,
    0x5707: 0x56F5,
    0x570B: 0x56FD,
    0x570D: 0x56F4,
    0x5712: 0x56ED,
    0x5713: 0x5706,
    0x5716: 0x56FE,
    0x5718: 0x56E2,
    0x5770: 0x57A7,
    0x57B5: 0x57EF,
    0x57BB: 0x575D,
    0x57E1: 0x57AD,
    0x57F0: 0x91C7,
    0x57F7: 0x6267,
    0x5805: 0x575A,
    0x580A: 0x57A9,
    0x5816: 0x57B4,
    0x581D: 0x57DA,
    0x5826: 0x9636,
    0x582F: 0x5C27,
    0x5831: 0x62A5,
    0x5834: 0x573A,
    0x583F: 0x78B1,
    0x584A: 0x5757,
    0x584B: 0x8314,
    0x584F: 0x57B2,
    0x5852: 0x57D8,
    0x5857: 0x6D82,
    0x585A: 0x51A2,
    0x5862: 0x575E,
    0x5864: 0x57D9,
    0x5872: 0x573A,
    0x5875: 0x5C18,
    0x5879: 0x5811,
    0x587C: 0x7816,
    0x588A: 0x57AB,
    0x589C: 0x5760,
    0x589D: 0x7857,
    0x58AE: 0x5815,
    0x58B0: 0x575B,
    0x58B3: 0x575F,
    0x58B6: 0x57AF,
    0x58BB: 0x5899,
    0x58BE: 0x57A6,
    0x58C7: 0x575B,
    0x58CB: 0x57B1,
    0x58CE: 0x57D9,
    0x58D3: 0x538B,
    0x58D8: 0x5792,
    0x58D9: 0x5739,
    0x58DA: 0x5786,
    0x58DC: 0x575B,
    0x58DE: 0x574F,
    0x58DF: 0x5784,
    0x58E0: 0x5784,
    0x58E2: 0x575C,
    0x58E9: 0x575D,
    0x58EA: 0x5846,
    0x58EF: 0x58EE,
    0x58FA: 0x58F6,
    0x58FC: 0x58F8,
    0x58FD: 0x5BFF,
    0x5900: 0x5BFF,
    0x5920: 0x591F,
    0x5922: 0x68A6,
    0x5925: 0x4F19,
    0x593E: 0x5939,
    0x5950: 0x5942,
    0x5967: 0x5965,
    0x5969: 0x5941,
    0x596A: 0x593A,
    0x596E: 0x594B,
    0x599D: 0x5986,
    0x59CD: 0x59D7,
    0x59E6: 0x5978,
    0x59EA: 0x4F84,
    0x5A1B: 0x5A31,
    0x5A2C: 0x59A9,
    0x5A41: 0x5A04,
    0x5A66: 0x5987,
    0x5A6C: 0x6DEB,
    0x5A6D: 0x5A05,
    0x5AA7: 0x5A32,
    0x5AAE: 0x5077,
    0x5AAF: 0x59AB,
    0x5ABC: 0x5AAA,
    0x5ABD: 0x5988,
    0x5ACB: 0x8885,
    0x5AD7: 0x59AA,
    0x5AF5: 0x59A9,
    0x5AFA: 0x5A34,
    0x5AFB: 0x5A34,
    0x5AFF: 0x5A73,
    0x5B00: 0x59AB,
    0x5B08: 0x5A06,
    0x5B0B: 0x5A75,
    0x5B0C: 0x5A07,
    0x5B19: 0x5AF1,
    0x5B1D: 0x8885,
    0x5B21: 0x5AD2,
    0x5B24: 0x5B37,
    0x5B2A: 0x5AD4,
    0x5B2D: 0x5976,
    0x5B30: 0x5A74,
    0x5B38: 0x5A76,
    0x5B3E: 0x61D2,
    0x5B43: 0x5A18,
    0x5B4C: 0x5A08,
    0x5B6B: 0x5B59,
    0x5B78: 0x5B66,
    0x5B7F: 0x5B6A,
    0x5BAE: 0x5BAB,
    0x5BE2: 0x5BDD,
    0x5BE6: 0x5B9E,
    0x5BE7: 0x5B81,
    0x5BE9: 0x5BA1,
    0x5BEB: 0x5199,
    0x5BEC: 0x5BBD,
    0x5BF5: 0x5BA0,
    0x5BF6: 0x5B9D,
    0x5C05: 0x514B,
    0x5C07: 0x5C06,
    0x5C08: 0x4E13,
    0x5C0B: 0x5BFB,
    0x5C0D: 0x5BF9,
    0x5C0E: 0x5BFC,
    0x5C32: 0x5C34,
    0x5C37: 0x5C34,
    0x5C46: 0x5C4A,
    0x5C4D: 0x5C38,
    0x5C53: 0x5C43,
    0x5C5C: 0x5C49,
    0x5C62: 0x5C61,
    0x5C64: 0x5C42,
    0x5C68: 0x5C66,
    0x5C6C: 0x5C5E,
    0x5C6D: 0x5C43,
    0x5CA1: 0x5188,
    0x5CF4: 0x5C98,
    0x5CF6: 0x5C9B,
    0x5CFD: 0x5CE1,
    0x5D0D: 0x5D03,
    0x5D10: 0x6606,
    0x5D11: 0x6606,
    0x5D17: 0x5C97,
    0x5D19: 0x4ED1,
    0x5D20: 0x5CBD,
    0x5D22: 0x5CE5,
    0x5D2C: 0x5CBD,
    0x5D33: 0x5D5B,
    0x5D50: 0x5C9A,
    0x5D57: 0x5C81,
    0x5D81: 0x5D5D,
    0x5D84: 0x5D2D,
    0x5D87: 0x5C96,
    0x5D94: 0x5D5A,
    0x5D97: 0x5D02,
    0x5DA0: 0x5CE4,
    0x5DA2: 0x5CE3,
    0x5DA7: 0x5CC4,
    0x5DA8: 0x5CC3,
    0x5DAE: 0x5D04,
    0x5DB4: 0x5C99,
    0x5DB8: 0x5D58,
    0x5DBA: 0x5CAD,
    0x5DBC: 0x5C7F,
    0x5DBD: 0x5CB3,
    0x5DCB: 0x5CBF,
    0x5DD2: 0x5CE6,
    0x5DD4: 0x5DC5,
    0x5DD6: 0x5CA9,
    0x5DF0: 0x5DEF,
    0x5DF9: 0x537A,
    0x5E25: 0x5E05,
    0x5E2B: 0x5E08,
    0x5E33: 0x5E10,
    0x5E36: 0x5E26,
    0x5E40: 0x5E27,
    0x5E43: 0x5E0F,
    0x5E57: 0x5E3C,
    0x5E58: 0x5E3B,
    0x5E5F: 0x5E1C,
    0x5E63: 0x5E01,
    0x5E6B: 0x5E2E,
    0x5E6C: 0x5E31,
    0x5E71: 0x8955,
    0x5E79: 0x5E72,
    0x5E7E: 0x51E0,
    0x5EAB: 0x5E93,
    0x5EC1: 0x5395,
    0x5EC2: 0x53A2,
    0x5EC4: 0x53A9,
    0x5EC8: 0x53A6,
    0x5ECE: 0x5EBC,
    0x5ED5: 0x836B,
    0x5EDA: 0x53A8,
    0x5EDD: 0x53AE,
    0x5EDF: 0x5E99,
    0x5EE0: 0x5382,
    0x5EE1: 0x5E91,
    0x5EE2: 0x5E9F,
    0x5EE3: 0x5E7F,
    0x5EE9: 0x5EEA,
    0x5EEC: 0x5E90,
    0x5EF3: 0x5385,
    0x5EFB: 0x56DE,
    0x5EFC: 0x4E43,
    0x5F14: 0x540A,
    0x5F33: 0x5F2A,
    0x5F35: 0x5F20,
    0x5F37: 0x5F3A,
    0x5F46: 0x522B,
    0x5F48: 0x5F39,
    0x5F4A: 0x5F3A,
    0x5F4C: 0x5F25,
    0x5F4E: 0x5F2F,
    0x5F59: 0x6C47,
    0x5F5C: 0x5F5D,
    0x5F5E: 0x5F5D,
    0x5F60: 0x5F5F,
    0x5F65: 0x5F66,
    0x5F6B: 0x96D5,
    0x5F7F: 0x4F5B,
    0x5F8C: 0x540E,
    0x5F91: 0x5F84,
    0x5F9E: 0x4ECE,
    0x5FA0: 0x5F95,
    0x5FA9: 0x590D,
    0x5FAC: 0x4EFF,
    0x5FB4: 0x5F81,
    0x5FB5: 0x5F81,
    0x5FB9: 0x5F7B,
    0x6046: 0x6052,
    0x6065: 0x803B,
    0x6085: 0x60A6,
    0x60B5: 0x6005,
    0x60B6: 0x95F7,
    0x60BD: 0x51C4,
    0x60E1: 0x6076,
    0x60F1: 0x607C,
    0x60F2: 0x607D,
    0x60FB: 0x607B,
    0x611B: 0x7231,
    0x611C: 0x60EC,
    0x6128: 0x60AB,
    0x6134: 0x6006,
    0x6137: 0x607A,
    0x613E: 0x5FFE,
    0x6144: 0x6817,
    0x6147: 0x6BB7,
    0x614B: 0x6001,
    0x614D: 0x6120,
    0x6158: 0x60E8,
    0x6159: 0x60ED,
    0x615A: 0x60ED,
    0x615F: 0x6078,
    0x6163: 0x60EF,
    0x6164: 0x60AB,
    0x616A: 0x6004,
    0x616B: 0x6002,
    0x616E: 0x8651,
    0x6173: 0x60AD,
    0x6174: 0x6151,
    0x6176: 0x5E86,
    0x617C: 0x621A,
    0x617E: 0x6B32,
    0x6182: 0x5FE7,
    0x618A: 0x60EB,
    0x6190: 0x601C,
    0x6191: 0x51ED,
    0x6192: 0x6126,
    0x6196: 0x616D,
    0x619A: 0x60EE,
    0x61A4: 0x6124,
    0x61AB: 0x60AF,
    0x61AE: 0x6003,
    0x61B2: 0x5BAA,
    0x61B6: 0x5FC6,
    0x61C7: 0x6073,
    0x61C9: 0x5E94,
    0x61CC: 0x603F,
    0x61CD: 0x61D4,
    0x61D5: 0x6079,
    0x61DE: 0x8499,
    0x61DF: 0x603C,
    0x61E3: 0x61D1,
    0x61E8: 0x6079,
    0x61F2: 0x60E9,
    0x61F6: 0x61D2,
    0x61F7: 0x6000,
    0x61F8: 0x60AC,
    0x61FA: 0x5FCF,
    0x61FC: 0x60E7,
    0x61FD: 0x6B22,
    0x61FE: 0x6151,
    0x6200: 0x604B,
    0x6207: 0x6206,
    0x6214: 0x620B,
    0x6227: 0x6217,
    0x6229: 0x622C,
    0x622F: 0x620F,
    0x6230: 0x6218,
    0x6232: 0x620F,
    0x6236: 0x6237,
    0x6261: 0x6266,
    0x62CB: 0x629B,
    0x633E: 0x631F,
    0x6368: 0x820D,
    0x636B: 0x626A,
    0x6372: 0x5377,
    0x6383: 0x626B,
    0x6384: 0x62A1,
    0x6397: 0x631C,
    0x6399: 0x6323,
    0x639B: 0x6302,
    0x63A1: 0x91C7,
    0x63C0: 0x62E3,
    0x63DA: 0x626C,
    0x63DB: 0x6362,
    0x63EE: 0x6325,
    0x63F9: 0x80CC,
    0x6406: 0x6784,
    0x6407: 0x63FF,
    0x640D: 0x635F,
    0x6416: 0x6447,
    0x6417: 0x6363,
    0x6436: 0x62A2,
    0x643E: 0x69A8,
    0x6451: 0x63B4,
    0x645C: 0x63BC,
    0x645F: 0x6402,
    0x6463: 0x63F8,
    0x646F: 0x631A,
    0x6473: 0x62A0,
    0x6476: 0x629F,
    0x647A: 0x6298,
    0x647B: 0x63BA,
    0x6488: 0x635E,
    0x648F: 0x6326,
    0x6490: 0x6491,
    0x6493: 0x6320,
    0x649A: 0x637B,
    0x649F: 0x6322,
    0x64A3: 0x63B8,
    0x64A5: 0x62E8,
    0x64AB: 0x629A,
    0x64B2: 0x6251,
    0x64B3: 0x63FF,
    0x64BB: 0x631E,
    0x64BE: 0x631D,
    0x64BF: 0x6361,
    0x64C1: 0x62E5,
    0x64C4: 0x63B3,
    0x64C7: 0x62E9,
    0x64CA: 0x51FB,
    0x64CB: 0x6321,
    0x64D4: 0x62C5,
    0x64D5: 0x643A,
    0x64DA: 0x636E,
    0x64E0: 0x6324,
    0x64E1: 0x62AC,
    0x64E3: 0x6363,
    0x64E7: 0x4E3E,
    0x64EC: 0x62DF,
    0x64EF: 0x6448,
    0x64F0: 0x62E7,
    0x64F1: 0x6401,
    0x64F2: 0x63B7,
    0x64F4: 0x6269,
    0x64F7: 0x64B7,
    0x64FA: 0x6446,
    0x64FB: 0x64DE,
    0x64FC: 0x64B8,
    0x64FE: 0x6270,
    0x6504: 0x6445,
    0x6506: 0x64B5,
    0x650F: 0x62E2,
    0x6514: 0x62E6,
    0x6516: 0x6484,
    0x6519: 0x6400,
    0x651B: 0x64BA,
    0x651C: 0x643A,
    0x651D: 0x6444,
    0x6522: 0x6512,
    0x6523: 0x631B,
    0x6524: 0x644A,
    0x6529: 0x6321,
    0x652A: 0x6405,
    0x652C: 0x63FD,
    0x6537: 0x8003,
    0x654D: 0x53D9,
    0x6557: 0x8D25,
    0x6558: 0x53D9,
    0x656D: 0x626C,
    0x6575: 0x654C,
    0x6578: 0x6570,
    0x657A: 0x9A71,
    0x6582: 0x655B,
    0x6583: 0x6BD9,
    0x6595: 0x6593,
    0x65AC: 0x65A9,
    0x65B7: 0x65AD,
    0x65BC: 0x4E8E,
    0x65C2: 0x65D7,
    0x6607: 0x5347,
    0x6642: 0x65F6,
    0x6649: 0x664B,
    0x665D: 0x663C,
    0x6688: 0x6655,
    0x6689: 0x6656,
    0x6698: 0x65F8,
    0x66A2: 0x7545,
    0x66AB: 0x6682,
    0x66B1: 0x6635,
    0x66C4: 0x6654,
    0x66C6: 0x5386,
    0x66C7: 0x6619,
    0x66C9: 0x6653,
    0x66CF: 0x5411,
    0x66D6: 0x66A7,
    0x66E0: 0x65F7,
    0x66E1: 0x53E0,
    0x66E8: 0x663D,
    0x66EC: 0x6652,
    0x66F8: 0x4E66,
    0x6703: 0x4F1A,
    0x6727: 0x80E7,
    0x6771: 0x4E1C,
    0x67B4: 0x62D0,
    0x67F5: 0x6805,
    0x67FA: 0x62D0,
    0x687F: 0x6746,
    0x6894: 0x6800,
    0x6898: 0x67A7,
    0x689D: 0x6761,
    0x689F: 0x67AD,
    0x68B1: 0x6346,
    0x68C4: 0x5F03,
    0x68D6: 0x67A8,
    0x68D7: 0x67A3,
    0x68DF: 0x680B,
    0x68E7: 0x6808,
    0x68EC: 0x684A,
    0x68F2: 0x6816,
    0x68F6: 0x68BE,
    0x690F: 0x6860,
    0x694A: 0x6768,
    0x6953: 0x67AB,
    0x6968: 0x6862,
    0x696D: 0x4E1A,
    0x6975: 0x6781,
    0x69A6: 0x5E72,
    0x69AA: 0x6769,
    0x69AE: 0x8363,
    0x69BF: 0x6864,
    0x69C3: 0x76D8,
    0x69CB: 0x6784,
    0x69CD: 0x67AA,
    0x69D3: 0x6760,
    0x69E7: 0x6920,
    0x69E8: 0x6901,
    0x69F3: 0x6868,
    0x69FC: 0x89C4,
    0x6A01: 0x6869,
    0x6A02: 0x4E50,
    0x6A05: 0x679E,
    0x6A11: 0x6881,
    0x6A13: 0x697C,
    0x6A19: 0x6807,
    0x6A1E: 0x67A2,
    0x6A23: 0x6837,
    0x6A37: 0x4E1B,
    0x6A38: 0x6734,
    0x6A39: 0x6811,
    0x6A3A: 0x6866,
    0x6A48: 0x6861,
    0x6A4B: 0x6865,
    0x6A5F: 0x673A,
    0x6A62: 0x692D,
    0x6A6B: 0x6A2A,
    0x6A70: 0x69D4,
    0x6A81: 0x6AA9,
    0x6A89: 0x67FD,
    0x6A94: 0x6863,
    0x6A9C: 0x6867,
    0x6A9F: 0x69DA,
    0x6AA2: 0x68C0,
    0x6AA3: 0x6A2F,
    0x6AAE: 0x68BC,
    0x6AAF: 0x53F0,
    0x6AB3: 0x69DF,
    0x6AB8: 0x67E0,
    0x6ABB: 0x69DB,
    0x6ABE: 0x82D8,
    0x6AC2: 0x68F9,
    0x6AC3: 0x67DC,
    0x6AD3: 0x6A79,
    0x6ADA: 0x6988,
    0x6ADB: 0x6809,
    0x6ADD: 0x691F,
    0x6ADE: 0x6A7C,
    0x6ADF: 0x680E,
    0x6AE5: 0x6A71,
    0x6AE7: 0x69E0,
    0x6AE8: 0x680C,
    0x6AEA: 0x67A5,
    0x6AEB: 0x6A65,
    0x6AEC: 0x6987,
    0x6AF3: 0x680A,
    0x6AF8: 0x6989,
    0x6AFA: 0x68C2,
    0x6AFB: 0x6A31,
    0x6B04: 0x680F,
    0x6B0A: 0x6743,
    0x6B0F: 0x6924,
    0x6B11: 0x6512,
    0x6B12: 0x683E,
    0x6B16: 0x6984,
    0x6B1E: 0x68C2,
    0x6B3D: 0x94A6,
    0x6B4E: 0x53F9,
    0x6B50: 0x6B27,
    0x6B57: 0x5578,
    0x6B5B: 0x655B,
    0x6B5F: 0x6B24,
    0x6B61: 0x6B22,
    0x6B72: 0x5C81,
    0x6B77: 0x5386,
    0x6B78: 0x5F52,
    0x6B7F: 0x6B81,
    0x6B98: 0x6B8B,
    0x6B9E: 0x6B92,
    0x6BA4: 0x6B87,
    0x6BAB: 0x6B9A,
    0x6BAE: 0x6B93,
    0x6BAF: 0x6BA1,
    0x6BB2: 0x6B7C,
    0x6BBA: 0x6740,
    0x6BBC: 0x58F3,
    0x6BC0: 0x6BC1,
    0x6BC6: 0x6BB4,
    0x6BC9: 0x533B,
    0x6BE7: 0x7ED2,
    0x6BEC: 0x7403,
    0x6BFF: 0x6BF5,
    0x6C02: 0x7266,
    0x6C08: 0x6BE1,
    0x6C0A: 0x6BE1,
    0x6C0C: 0x6C07,
    0x6C23: 0x6C14,
    0x6C2B: 0x6C22,
    0x6C2C: 0x6C29,
    0x6C33: 0x6C32,
    0x6C39: 0x51FC,
    0x6C3E: 0x6CDB,
    0x6C4E: 0x6CDB,
    0x6C59: 0x6C61,
    0x6C5A: 0x6C61,
    0x6C7A: 0x51B3,
    0x6C8D: 0x51B1,
    0x6C92: 0x6CA1,
    0x6C96: 0x51B2,
    0x6CC1: 0x51B5,
    0x6D29: 0x6CC4,
    0x6D36: 0x6C79,
    0x6D79: 0x6D43,
    0x6D87: 0x6CFE,
    0x6D96: 0x8385,
    0x6DBC: 0x51C9,
    0x6DD2: 0x51C4,
    0x6DDA: 0x6CEA,
    0x6DE5: 0x6E0C,
    0x6DE8: 0x51C0,
    0x6DE9: 0x51CC,
    0x6DEA: 0x6CA6,
    0x6DF5: 0x6E0A,
    0x6DF6: 0x6D9E,
    0x6DFA: 0x6D45,
    0x6E19: 0x6DA3,
    0x6E1B: 0x51CF,
    0x6E22: 0x6CA8,
    0x6E26: 0x6DA1,
    0x6E2C: 0x6D4B,
    0x6E3E: 0x6D51,
    0x6E4A: 0x51D1,
    0x6E5E: 0x6D48,
    0x6E63: 0x610D,
    0x6E67: 0x6D8C,
    0x6E6F: 0x6C64,
    0x6E88: 0x6CA9,
    0x6E96: 0x51C6,
    0x6E9D: 0x6C9F,
    0x6EAB: 0x6E29,
    0x6EAE: 0x6D49,
    0x6EB3: 0x6DA2,
    0x6EBC: 0x6E7F,
    0x6EC4: 0x6CA7,
    0x6EC5: 0x706D,
    0x6ECC: 0x6DA4,
    0x6ECE: 0x8365,
    0x6ED9: 0x6C47,
    0x6EEC: 0x6CAA,
    0x6EEF: 0x6EDE,
    0x6EF2: 0x6E17,
    0x6EF7: 0x5364,
    0x6EF8: 0x6D52,
    0x6EFB: 0x6D50,
    0x6EFE: 0x6EDA,
    0x6EFF: 0x6EE1,
    0x6F01: 0x6E14,
    0x6F0A: 0x6E87,
    0x6F1A: 0x6CA4,
    0x6F22: 0x6C49,
    0x6F23: 0x6D9F,
    0x6F2C: 0x6E0D,
    0x6F32: 0x6DA8,
    0x6F35: 0x6E86,
    0x6F38: 0x6E10,
    0x6F3F: 0x6D46,
    0x6F41: 0x988D,
    0x6F51: 0x6CFC,
    0x6F54: 0x6D01,
    0x6F59: 0x6CA9,
    0x6F5B: 0x6F5C,
    0x6F5F: 0x8204,
    0x6F64: 0x6DA6,
    0x6F6F: 0x6D54,
    0x6F70: 0x6E83,
    0x6F77: 0x6ED7,
    0x6F7F: 0x6DA0,
    0x6F80: 0x6DA9,
    0x6F81: 0x6DA9,
    0x6F82: 0x6F84,
    0x6F86: 0x6D47,
    0x6F87: 0x6D9D,
    0x6F97: 0x6DA7,
    0x6FA0: 0x6E11,
    0x6FA4: 0x6CFD,
    0x6FA6: 0x6EEA,
    0x6FA9: 0x6CF6,
    0x6FAE: 0x6D4D,
    0x6FB1: 0x6DC0,
    0x6FC1: 0x6D4A,
    0x6FC3: 0x6D53,
    0x6FD4: 0x6CB5,
    0x6FD5: 0x6E7F,
    0x6FD8: 0x6CDE,
    0x6FDB: 0x8499,
    0x6FDC: 0x6D55,
    0x6FDF: 0x6D4E,
    0x6FE4: 0x6D9B,
    0x6FEB: 0x6EE5,
    0x6FEC: 0x6D5A,
    0x6FF0: 0x6F4D,
    0x6FF1: 0x6EE8,
    0x6FF6: 0x9614,
    0x6FFA: 0x6E85,
    0x6FFC: 0x6CFA,
    0x6FFE: 0x6EE4,
    0x7005: 0x6EE2,
    0x7006: 0x6E0E,
    0x7009: 0x6CFB,
    0x700B: 0x6E16,
    0x700F: 0x6D4F,
    0x7015: 0x6FD2,
    0x7018: 0x6CF8,
    0x701D: 0x6CA5,
    0x701F: 0x6F47,
    0x7020: 0x6F46,
    0x7026: 0x6F74,
    0x7027: 0x6CF7,
    0x7028: 0x6FD1,
    0x7030: 0x5F25,
    0x7032: 0x6F4B,
    0x703E: 0x6F9C,
    0x7043: 0x6CA3,
    0x7044: 0x6EE0,
    0x7051: 0x6D12,
    0x7055: 0x6F13,
    0x7058: 0x6EE9,
    0x705D: 0x704F,
    0x7063: 0x6E7E,
    0x7064: 0x6EE6,
    0x7067: 0x6EDF,
    0x7069: 0x6EDF,
    0x707D: 0x707E,
    0x70A4: 0x7167,
    0x70BA: 0x4E3A,
    0x70CF: 0x4E4C,
    0x70F4: 0x70C3,
    0x7121: 0x65E0,
    0x7146: 0x7145,
    0x7147: 0x8F89,
    0x7149: 0x70BC,
    0x7152: 0x709C,
    0x7156: 0x6696,
    0x7159: 0x70DF,
    0x7162: 0x8315,
    0x7165: 0x7115,
    0x7169: 0x70E6,
    0x716C: 0x7080,
    0x7192: 0x8367,
    0x7197: 0x709D,
    0x71B1: 0x70ED,
    0x71B2: 0x988E,
    0x71BE: 0x70BD,
    0x71C1: 0x70E8,
    0x71C4: 0x7130,
    0x71C8: 0x706F,
    0x71C9: 0x7096,
    0x71D0: 0x78F7,
    0x71D2: 0x70E7,
    0x71D9: 0x70EB,
    0x71DC: 0x7116,
    0x71DF: 0x8425,
    0x71E6: 0x707F,
    0x71EC: 0x6BC1,
    0x71ED: 0x70DB,
    0x71F4: 0x70E9,
    0x71FB: 0x718F,
    0x71FC: 0x70EC,
    0x71FE: 0x7118,
    0x71FF: 0x8000,
    0x720D: 0x70C1,
    0x7210: 0x7089,
    0x7217: 0x70E8,
    0x721B: 0x70C2,
    0x722D: 0x4E89,
    0x7232: 0x4E3A,
    0x723A: 0x7237,
    0x723E: 0x5C14,
    0x723F: 0x4E2C,
    0x7240: 0x5E8A,
    0x7246: 0x5899,
    0x724B: 0x7B3A,
    0x7250: 0x95F8,
    0x7258: 0x724D,
    0x7274: 0x62B5,
    0x727D: 0x7275,
    0x7296: 0x8366,
    0x729B: 0x7266,
    0x72A2: 0x728A,
    0x72A7: 0x727A,
    0x72C0: 0x72B6,
    0x72F9: 0x72ED,
    0x72FD: 0x72C8,
    0x7319: 0x72F0,
    0x7336: 0x72B9,
    0x733B: 0x72F2,
    0x7341: 0x72B8,
    0x7343: 0x5446,
    0x7344: 0x72F1,
    0x7345: 0x72EE,
    0x734E: 0x5956,
    0x7368: 0x72EC,
    0x736A: 0x72EF,
    0x736B: 0x7303,
    0x736E: 0x72DD,
    0x7370: 0x72DE,
    0x7372: 0x83B7,
    0x7375: 0x730E,
    0x7377: 0x72B7,
    0x7378: 0x517D,
    0x737A: 0x736D,
    0x737B: 0x732E,
    0x737C: 0x7315,
    0x7380: 0x7321,
    0x7386: 0x5179,
    0x73A8: 0x73CF,
    0x73EE: 0x4F69,
    0x73FE: 0x73B0,
    0x740D: 0x7483,
    0x742F: 0x7BA1,
    0x743A: 0x73D0,
    0x743F: 0x73F2,
    0x7449: 0x73C9,
    0x744B: 0x73AE,
    0x7452: 0x739A,
    0x7463: 0x7410,
    0x7464: 0x7476,
    0x7469: 0x83B9,
    0x746A: 0x739B,
    0x746F: 0x7405,
    0x7472: 0x73B1,
    0x7489: 0x740F,
    0x74A1: 0x740E,
    0x74A3: 0x7391,
    0x74A6: 0x7477,
    0x74AB: 0x73F0,
    0x74B0: 0x73AF,
    0x74B5: 0x7399,
    0x74BD: 0x73BA,
    0x74BF: 0x7487,
    0x74CA: 0x743C,
    0x74CF: 0x73D1,
    0x74D4: 0x748E,
    0x74DA: 0x74D2,
    0x750C: 0x74EF,
    0x750E: 0x7816,
    0x7515: 0x74EE,
    0x7516: 0x7F42,
    0x7522: 0x4EA7,
    0x7523: 0x4EA7,
    0x7526: 0x82CF,
    0x752F: 0x5B81,
    0x755D: 0x4EA9,
    0x7562: 0x6BD5,
    0x756B: 0x753B,
    0x7570: 0x5F02,
    0x7571: 0x7559,
    0x7576: 0x5F53,
    0x7587: 0x7574,
    0x758A: 0x8FED,
    0x75D9: 0x75C9,
    0x75E0: 0x9178,
    0x75FA: 0x75F9,
    0x7602: 0x75D6,
    0x7609: 0x6108,
    0x760B: 0x75AF,
    0x760D: 0x75A1,
    0x7613: 0x75EA,
    0x761E: 0x7617,
    0x7621: 0x75AE,
    0x7627: 0x759F,
    0x762E: 0x7606,
    0x763A: 0x7618,
    0x763B: 0x7618,
    0x7642: 0x7597,
    0x7646: 0x75E8,
    0x7647: 0x75EB,
    0x7649: 0x7605,
    0x7652: 0x6108,
    0x7658: 0x75A0,
    0x765F: 0x762A,
    0x7661: 0x75F4,
    0x7662: 0x75D2,
    0x7664: 0x7596,
    0x7665: 0x75C7,
    0x7667: 0x75AC,
    0x7669: 0x765E,
    0x766C: 0x7663,
    0x766D: 0x763F,
    0x766E: 0x763E,
    0x7670: 0x75C8,
    0x7671: 0x762B,
    0x7672: 0x766B,
    0x767C: 0x53D1,
    0x769A: 0x7691,
    0x76B0: 0x75B1,
    0x76B8: 0x76B2,
    0x76BA: 0x76B1,
    0x76C3: 0x676F,
    0x76DC: 0x76D7,
    0x76DE: 0x76CF,
    0x76E1: 0x5C3D,
    0x76E3: 0x76D1,
    0x76E4: 0x76D8,
    0x76E7: 0x5362,
    0x76EA: 0x8361,
    0x770E: 0x89C6,
    0x7721: 0x89C6,
    0x7725: 0x7726,
    0x773E: 0x4F17,
    0x774F: 0x56F0,
    0x775C: 0x7741,
    0x775E: 0x7750,
    0x7798: 0x770D,
    0x779E: 0x7792,
    0x77BC: 0x7751,
    0x77C7: 0x8499,
    0x77D3: 0x772C,
    0x77DA: 0x77A9,
    0x77EF: 0x77EB,
    0x77FD: 0x7845,
    0x7832: 0x70AE,
    0x7843: 0x6731,
    0x785C: 0x7841,
    0x7864: 0x7856,
    0x7868: 0x7817,
    0x786F: 0x781A,
    0x7876: 0x789C,
    0x78A9: 0x7855,
    0x78AD: 0x7800,
    0x78B8: 0x781C,
    0x78BA: 0x786E,
    0x78BC: 0x7801,
    0x78D0: 0x76D8,
    0x78D1: 0x7859,
    0x78DA: 0x7816,
    0x78E3: 0x789C,
    0x78E7: 0x789B,
    0x78EF: 0x77F6,
    0x78FD: 0x7857,
    0x7904: 0x785A,
    0x790E: 0x7840,
    0x7919: 0x788D,
    0x7926: 0x77FF,
    0x792A: 0x783A,
    0x792B: 0x783E,
    0x792C: 0x77FE,
    0x792E: 0x70AE,
    0x7931: 0x783B,
    0x7950: 0x4F51,
    0x7955: 0x79D8,
    0x797F: 0x7984,
    0x798D: 0x7978,
    0x798E: 0x796F,
    0x7995: 0x794E,
    0x79A6: 0x5FA1,
    0x79AA: 0x7985,
    0x79AE: 0x793C,
    0x79B0: 0x7962,
    0x79B1: 0x7977,
    0x79BF: 0x79C3,
    0x79C8: 0x7C7C,
    0x7A05: 0x7A0E,
    0x7A08: 0x79C6,
    0x7A1C: 0x68F1,
    0x7A1F: 0x7980,
    0x7A2D: 0x79F8,
    0x7A2E: 0x79CD,
    0x7A31: 0x79F0,
    0x7A40: 0x8C37,
    0x7A4C: 0x7A23,
    0x7A4D: 0x79EF,
    0x7A4E: 0x9896,
    0x7A60: 0x79FE,
    0x7A61: 0x7A51,
    0x7A62: 0x79FD,
    0x7A68: 0x9893,
    0x7A69: 0x7A33,
    0x7A6B: 0x83B7,
    0x7A6D: 0x7A06,
    0x7AA9: 0x7A9D,
    0x7AAA: 0x6D3C,
    0x7AAE: 0x7A77,
    0x7AAF: 0x7A91,
    0x7AB0: 0x7A91,
    0x7AB6: 0x7AAD,
    0x7ABA: 0x7AA5,
    0x7AC4: 0x7A9C,
    0x7AC5: 0x7A8D,
    0x7AC7: 0x7AA6,
    0x7AC8: 0x7076,
    0x7ACA: 0x7A83,
    0x7ADD: 0x5E76,
    0x7AEA: 0x7AD6,
    0x7AF6: 0x7ADE,
    0x7B46: 0x7B14,
    0x7B4D: 0x7B0B,
    0x7B67: 0x7B15,
    0x7B87: 0x4E2A,
    0x7B8B: 0x7B3A,
    0x7B8F: 0x7B5D,
    0x7BA0: 0x68F0,
    0x7BC0: 0x8282,
    0x7BC4: 0x8303,
    0x7BC9: 0x7B51,
    0x7BCB: 0x7BA7,
    0x7BDB: 0x7BAC,
    0x7BE0: 0x7B71,
    0x7BE4: 0x7B03,
    0x7BE9: 0x7B5B,
    0x7BF3: 0x7B5A,
    0x7C00: 0x7BA6,
    0x7C0D: 0x7BD3,
    0x7C11: 0x84D1,
    0x7C1E: 0x7BAA,
    0x7C21: 0x7B80,
    0x7C23: 0x7BD1,
    0x7C2B: 0x7BAB,
    0x7C37: 0x6A90,
    0x7C39: 0x7B5C,
    0x7C3D: 0x7B7E,
    0x7C3E: 0x5E18,
    0x7C43: 0x7BEE,
    0x7C4C: 0x7B79,
    0x7C50: 0x85E4,
    0x7C59: 0x7B93,
    0x7C5C: 0x7BA8,
    0x7C5F: 0x7C41,
    0x7C60: 0x7B3C,
    0x7C62: 0x5941,
    0x7C64: 0x7B7E,
    0x7C65: 0x94A5,
    0x7C69: 0x7B3E,
    0x7C6A: 0x7C16,
    0x7C6C: 0x7BF1,
    0x7C6E: 0x7BA9,
    0x7C72: 0x5401,
    0x7CA7: 0x5986,
    0x7CAC: 0x66F2,
    0x7CB5: 0x7CA4,
    0x7CDD: 0x7CC1,
    0x7CDE: 0x7CAA,
    0x7CE2: 0x6A21,
    0x7CE7: 0x7CAE,
    0x7CF0: 0x56E2,
    0x7CF2: 0x7C9D,
    0x7CF4: 0x7C74,
    0x7CF6: 0x7C9C,
    0x7CF8: 0x7E9F,
    0x7CFE: 0x7EA0,
    0x7D00: 0x7EAA,
    0x7D02: 0x7EA3,
    0x7D04: 0x7EA6,
    0x7D05: 0x7EA2,
    0x7D06: 0x7EA1,
    0x7D07: 0x7EA5,
    0x7D08: 0x7EA8,
    0x7D09: 0x7EAB,
    0x7D0B: 0x7EB9,
    0x7D0D: 0x7EB3,
    0x7D10: 0x7EBD,
    0x7D13: 0x7EBE,
    0x7D14: 0x7EAF,
    0x7D15: 0x7EB0,
    0x7D16: 0x7EBC,
    0x7D17: 0x7EB1,
    0x7D18: 0x7EAE,
    0x7D19: 0x7EB8,
    0x7D1A: 0x7EA7,
    0x7D1B: 0x7EB7,
    0x7D1C: 0x7EAD,
    0x7D1D: 0x7EB4,
    0x7D21: 0x7EBA,
    0x7D25: 0x624E,
    0x7D2E: 0x624E,
    0x7D30: 0x7EC6,
    0x7D31: 0x7EC2,
    0x7D32: 0x7EC1,
    0x7D33: 0x7EC5,
    0x7D35: 0x7EBB,
    0x7D39: 0x7ECD,
    0x7D3A: 0x7EC0,
    0x7D3C: 0x7ECB,
    0x7D3F: 0x7ED0,
    0x7D40: 0x7ECC,
    0x7D42: 0x7EC8,
    0x7D43: 0x5F26,
    0x7D44: 0x7EC4,
    0x7D46: 0x7ECA,
    0x7D4D: 0x7EB4,
    0x7D4E: 0x7ED7,
    0x7D4F: 0x7EC1,
    0x7D50: 0x7ED3,
    0x7D55: 0x7EDD,
    0x7D5B: 0x7EE6,
    0x7D5D: 0x7ED4,
    0x7D5E: 0x7EDE,
    0x7D61: 0x7EDC,
    0x7D62: 0x7EDA,
    0x7D66: 0x7ED9,
    0x7D68: 0x7ED2,
    0x7D70: 0x7ED6,
    0x7D71: 0x7EDF,
    0x7D72: 0x4E1D,
    0x7D73: 0x7EDB,
    0x7D79: 0x7EE2,
    0x7D81: 0x7ED1,
    0x7D83: 0x7EE1,
    0x7D86: 0x7EE0,
    0x7D88: 0x7EE8,
    0x7D89: 0x7EE3,
    0x7D8C: 0x7EE4,
    0x7D8F: 0x7EE5,
    0x7D91: 0x6346,
    0x7D93: 0x7ECF,
    0x7D9C: 0x7EFC,
    0x7D9E: 0x7F0D,
    0x7DA0: 0x7EFF,
    0x7DA2: 0x7EF8,
    0x7DA3: 0x7EFB,
    0x7DAB: 0x7EBF,
    0x7DAC: 0x7EF6,
    0x7DAD: 0x7EF4,
    0x7DAF: 0x7EF9,
    0x7DB0: 0x7EFE,
    0x7DB1: 0x7EB2,
    0x7DB2: 0x7F51,
    0x7DB3: 0x7EF7,
    0x7DB4: 0x7F00,
    0x7DB5: 0x5F69,
    0x7DB8: 0x7EB6,
    0x7DB9: 0x7EFA,
    0x7DBA: 0x7EEE,
    0x7DBB: 0x7EFD,
    0x7DBD: 0x7EF0,
    0x7DBE: 0x7EEB,
    0x7DBF: 0x7EF5,
    0x7DC4: 0x7EF2,
    0x7DC7: 0x7F01,
    0x7DCA: 0x7D27,
    0x7DCB: 0x7EEF,
    0x7DCD: 0x7F17,
    0x7DD2: 0x7EEA,
    0x7DD3: 0x7EEC,
    0x7DD4: 0x7EF1,
    0x7DD7: 0x7F03,
    0x7DD8: 0x7F04,
    0x7DD9: 0x7F02,
    0x7DDA: 0x7EBF,
    0x7DDC: 0x7EF5,
    0x7DDD: 0x7F09,
    0x7DDE: 0x7F0E,
    0x7DE0: 0x7F14,
    0x7DE1: 0x7F17,
    0x7DE3: 0x7F18,
    0x7DE4: 0x7EC1,
    0x7DE6: 0x7F0C,
    0x7DE8: 0x7F16,
    0x7DE9: 0x7F13,
    0x7DEC: 0x7F05,
    0x7DEF: 0x7EAC,
    0x7DF1: 0x7F11,
    0x7DF2: 0x7F08,
    0x7DF4: 0x7EC3,
    0x7DF6: 0x7F0F,
    0x7DF9: 0x7F07,
    0x7DFB: 0x81F4,
    0x7DFC: 0x7F0A,
    0x7E02: 0x603B,
    0x7E08: 0x8426,
    0x7E09: 0x7F19,
    0x7E0A: 0x7F22,
    0x7E0B: 0x7F12,
    0x7E10: 0x7EC9,
    0x7E11: 0x7F23,
    0x7E15: 0x7F0A,
    0x7E17: 0x7F1E,
    0x7E1A: 0x7EE6,
    0x7E1B: 0x7F1A,
    0x7E1D: 0x7F1C,
    0x7E1E: 0x7F1F,
    0x7E1F: 0x7F1B,
    0x7E23: 0x53BF,
    0x7E27: 0x7EE6,
    0x7E2B: 0x7F1D,
    0x7E2D: 0x7F21,
    0x7E2E: 0x7F29,
    0x7E2F: 0x6F14,
    0x7E31: 0x7EB5,
    0x7E32: 0x7F27,
    0x7E34: 0x7EA4,
    0x7E35: 0x7F26,
    0x7E36: 0x7D77,
    0x7E37: 0x7F15,
    0x7E39: 0x7F25,
    0x7E3D: 0x603B,
    0x7E3E: 0x7EE9,
    0x7E43: 0x7EF7,
    0x7E45: 0x7F2B,
    0x7E46: 0x7F2A,
    0x7E48: 0x8941,
    0x7E52: 0x7F2F,
    0x7E54: 0x7EC7,
    0x7E55: 0x7F2E,
    0x7E56: 0x4F1E,
    0x7E59: 0x7FFB,
    0x7E5A: 0x7F2D,
    0x7E5E: 0x7ED5,
    0x7E61: 0x7EE3,
    0x7E62: 0x7F0B,
    0x7E66: 0x8941,
    0x7E69: 0x7EF3,
    0x7E6A: 0x7ED8,
    0x7E6B: 0x7CFB,
    0x7E6D: 0x8327,
    0x7E6E: 0x7F30,
    0x7E6F: 0x7F33,
    0x7E70: 0x7F32,
    0x7E73: 0x7F34,
    0x7E79: 0x7ECE,
    0x7E7C: 0x7EE7,
    0x7E7D: 0x7F24,
    0x7E7E: 0x7F31,
    0x7E87: 0x98A3,
    0x7E88: 0x7F2C,
    0x7E8A: 0x7EA9,
    0x7E8C: 0x7EED,
    0x7E8D: 0x7D2F,
    0x7E8F: 0x7F20,
    0x7E93: 0x7F28,
    0x7E96: 0x7EA4,
    0x7E98: 0x7F35,
    0x7E9C: 0x7F06,
    0x7F3D: 0x94B5,
    0x7F48: 0x575B,
    0x7F4B: 0x74EE,
    0x7F4C: 0x7F42,
    0x7F4E: 0x575B,
    0x7F4F: 0x5786,
    0x7F70: 0x7F5A,
    0x7F75: 0x9A82,
    0x7F77: 0x7F62,
    0x7F78: 0x7F5A,
    0x7F85: 0x7F57,
    0x7F86: 0x7F74,
    0x7F88: 0x7F81,
    0x7F8B: 0x8288,
    0x7FA2: 0x7ED2,
    0x7FA5: 0x7F9F,
    0x7FA8: 0x7FA1,
    0x7FA9: 0x4E49,
    0x7FB6: 0x81BB,
    0x7FD2: 0x4E60,
    0x7FEC: 0x7FDA,
    0x7FF9: 0x7FD8,
    0x7FFA: 0x7FF1,
    0x7FFD: 0x7FD9,
    0x8011: 0x7AEF,
    0x8021: 0x9504,
    0x802C: 0x8027,
    0x802E: 0x8022,
    0x8056: 0x5723,
    0x805E: 0x95FB,
    0x806F: 0x8054,
    0x8070: 0x806A,
    0x8072: 0x58F0,
    0x8073: 0x8038,
    0x8075: 0x8069,
    0x8076: 0x8042,
    0x8077: 0x804C,
    0x8079: 0x804D,
    0x807C: 0x542C,
    0x807D: 0x542C,
    0x807E: 0x804B,
    0x8085: 0x8083,
    0x8105: 0x80C1,
    0x8107: 0x80C1,
    0x8108: 0x8109,
    0x811B: 0x80EB,
    0x8123: 0x5507,
    0x8129: 0x4FEE,
    0x812B: 0x8131,
    0x8139: 0x80C0,
    0x814E: 0x80BE,
    0x8156: 0x80E8,
    0x8161: 0x8136,
    0x8166: 0x8111,
    0x816B: 0x80BF,
    0x8173: 0x811A,
    0x8178: 0x80A0,
    0x8181: 0x80B7,
    0x8183: 0x817D,
    0x8195: 0x8158,
    0x819A: 0x80A4,
    0x81A0: 0x80F6,
    0x81A9: 0x817B,
    0x81BD: 0x80C6,
    0x81BE: 0x810D,
    0x81BF: 0x8113,
    0x81C9: 0x8138,
    0x81CD: 0x8110,
    0x81CF: 0x8191,
    0x81D2: 0x766F,
    0x81D8: 0x814A,
    0x81DA: 0x80EA,
    0x81DF: 0x810F,
    0x81E0: 0x8114,
    0x81E2: 0x81DC,
    0x81E5: 0x5367,
    0x81E8: 0x4E34,
    0x81EF: 0x768B,
    0x81FA: 0x53F0,
    0x8207: 0x4E0E,
    0x8208: 0x5174,
    0x8209: 0x4E3E,
    0x820A: 0x65E7,
    0x8216: 0x94FA,
    0x8218: 0x9986,
    0x8259: 0x8231,
    0x8262: 0x6A2F,
    0x8263: 0x6A79,
    0x8264: 0x8223,
    0x8266: 0x8230,
    0x826A: 0x6A79,
    0x826B: 0x823B,
    0x8271: 0x8270,
    0x8277: 0x8273,
    0x8278: 0x8279,
    0x82BB: 0x520D,
    0x82E7: 0x82CE,
    0x8332: 0x5179,
    0x834A: 0x8346,
    0x838A: 0x5E84,
    0x8396: 0x830E,
    0x83A2: 0x835A,
    0x83A7: 0x82CB,
    0x83EF: 0x534E,
    0x83F4: 0x5EB5,
    0x83F8: 0x70DF,
    0x8407: 0x82CC,
    0x840A: 0x83B1,
    0x842C: 0x4E07,
    0x8435: 0x83B4,
    0x8449: 0x53F6,
    0x8452: 0x836D,
    0x8457: 0x7740,
    0x8460: 0x53C2,
    0x8464: 0x836E,
    0x8466: 0x82C7,
    0x846F: 0x836F,
    0x8477: 0x8364,
    0x8490: 0x641C,
    0x8493: 0x83BC,
    0x8494: 0x83B3,
    0x849E: 0x8385,
    0x84BC: 0x82CD,
    0x84C0: 0x836A,
    0x84C6: 0x5E2D,
    0x84CB: 0x76D6,
    0x84E1: 0x53C2,
    0x84E7: 0x839C,
    0x84EE: 0x83B2,
    0x84EF: 0x82C1,
    0x84F4: 0x83BC,
    0x84FD: 0x835C,
    0x8506: 0x83F1,
    0x8514: 0x535C,
    0x851E: 0x848C,
    0x8523: 0x848B,
    0x8525: 0x8471,
    0x8526: 0x8311,
    0x852D: 0x836B,
    0x8534: 0x9EBB,
    0x8541: 0x8368,
    0x8546: 0x8487,
    0x854E: 0x835E,
    0x8552: 0x836C,
    0x8553: 0x82B8,
    0x8555: 0x83B8,
    0x8558: 0x835B,
    0x8562: 0x8489,
    0x8569: 0x8361,
    0x856A: 0x829C,
    0x856D: 0x8427,
    0x8577: 0x84E3,
    0x8588: 0x835F,
    0x858A: 0x84DF,
    0x858C: 0x8297,
    0x8591: 0x59DC,
    0x8594: 0x8537,
    0x8598: 0x8359,
    0x859F: 0x83B6,
    0x85A6: 0x8350,
    0x85A9: 0x8428,
    0x85B0: 0x718F,
    0x85BA: 0x8360,
    0x85CD: 0x84DD,
    0x85CE: 0x8369,
    0x85DD: 0x827A,
    0x85E5: 0x836F,
    0x85EA: 0x85AE,
    0x85F6: 0x82C8,
    0x85F9: 0x853C,
    0x85FA: 0x853A,
    0x8600: 0x841A,
    0x8604: 0x8572,
    0x8606: 0x82A6,
    0x8607: 0x82CF,
    0x860A: 0x8574,
    0x860B: 0x82F9,
    0x861A: 0x85D3,
    0x861E: 0x8539,
    0x8622: 0x830F,
    0x862D: 0x5170,
    0x863A: 0x84E0,
    0x863F: 0x841D,
    0x8655: 0x5904,
    0x865B: 0x865A,
    0x865C: 0x864F,
    0x865F: 0x53F7,
    0x8667: 0x4E8F,
    0x866F: 0x866C,
    0x86FA: 0x86F1,
    0x86FB: 0x8715,
    0x8706: 0x86AC,
    0x8755: 0x8680,
    0x875F: 0x732C,
    0x8766: 0x867E,
    0x8768: 0x8671,
    0x8778: 0x8717,
    0x8784: 0x86F3,
    0x8798: 0x8681,
    0x879E: 0x8682,
    0x87A2: 0x8424,
    0x87BB: 0x877C,
    0x87BF: 0x8780,
    0x87C4: 0x86F0,
    0x87C8: 0x8748,
    0x87CE: 0x87A8,
    0x87E3: 0x866E,
    0x87EC: 0x8749,
    0x87EF: 0x86F2,
    0x87F2: 0x866B,
    0x87F6: 0x86CF,
    0x87FB: 0x8681,
    0x8805: 0x8747,
    0x8806: 0x867F,
    0x880D: 0x874E,
    0x8810: 0x86F4,
    0x8811: 0x877E,
    0x8814: 0x869D,
    0x881F: 0x8721,
    0x8823: 0x86CE,
    0x8828: 0x87CF,
    0x8831: 0x86CA,
    0x8836: 0x8695,
    0x883B: 0x86EE,
    0x8846: 0x4F17,
    0x884A: 0x8511,
    0x8853: 0x672F,
    0x885A: 0x80E1,
    0x885B: 0x536B,
    0x885D: 0x51B2,
    0x885E: 0x536B,
    0x8879: 0x53EA,
    0x889E: 0x886E,
    0x88B7: 0x593E,
    0x88CA: 0x8885,
    0x88CC: 0x5939,
    0x88CF: 0x91CC,
    0x88DC: 0x8865,
    0x88DD: 0x88C5,
    0x88E1: 0x91CC,
    0x88FD: 0x5236,
    0x8907: 0x590D,
    0x890C: 0x88C8,
    0x8918: 0x8886,
    0x8932: 0x88E4,
    0x8933: 0x88E2,
    0x8938: 0x891B,
    0x893B: 0x4EB5,
    0x8946: 0x5E5E,
    0x8947: 0x88E5,
    0x894D: 0x6742,
    0x894F: 0x88AF,
    0x8956: 0x8884,
    0x895D: 0x88E3,
    0x8960: 0x88C6,
    0x8964: 0x8934,
    0x896A: 0x889C,
    0x896F: 0x886C,
    0x8972: 0x88AD,
    0x8974: 0x8955,
    0x8988: 0x6838,
    0x898B: 0x89C1,
    0x898E: 0x89C3,
    0x898F: 0x89C4,
    0x8993: 0x89C5,
    0x8994: 0x89C5,
    0x8996: 0x89C6,
    0x8998: 0x89C7,
    0x899C: 0x773A,
    0x89A1: 0x89CB,
    0x89A5: 0x89CD,
    0x89A6: 0x89CE,
    0x89AA: 0x4EB2,
    0x89AC: 0x89CA,
    0x89AF: 0x89CF,
    0x89B0: 0x89D1,
    0x89B2: 0x89D0,
    0x89B7: 0x89D1,
    0x89BA: 0x89C9,
    0x89BB: 0x89D1,
    0x89BD: 0x89C8,
    0x89BF: 0x89CC,
    0x89C0: 0x89C2,
    0x89DD: 0x62B5,
    0x89F4: 0x89DE,
    0x89F6: 0x89EF,
    0x89F8: 0x89E6,
    0x8A01: 0x8BA0,
    0x8A02: 0x8BA2,
    0x8A03: 0x8BA3,
    0x8A08: 0x8BA1,
    0x8A0A: 0x8BAF,
    0x8A0C: 0x8BA7,
    0x8A0E: 0x8BA8,
    0x8A0F: 0x5401,
    0x8A10: 0x8BA6,
    0x8A12: 0x8BB1,
    0x8A13: 0x8BAD,
    0x8A15: 0x8BAA,
    0x8A16: 0x8BAB,
    0x8A17: 0x6258,
    0x8A18: 0x8BB0,
    0x8A1B: 0x8BB9,
    0x8A1D: 0x8BB6,
    0x8A1F: 0x8BBC,
    0x8A22: 0x6B23,
    0x8A23: 0x8BC0,
    0x8A25: 0x8BB7,
    0x8A26: 0x8C0C,
    0x8A29: 0x8BBB,
    0x8A2A: 0x8BBF,
    0x8A2D: 0x8BBE,
    0x8A31: 0x8BB8,
    0x8A34: 0x8BC9,
    0x8A36: 0x8BC3,
    0x8A3A: 0x8BCA,
    0x8A3B: 0x6CE8,
    0x8A3C: 0x8BC1,
    0x8A41: 0x8BC2,
    0x8A46: 0x8BCB,
    0x8A4E: 0x8BB5,
    0x8A50: 0x8BC8,
    0x8A52: 0x8BD2,
    0x8A54: 0x8BCF,
    0x8A55: 0x8BC4,
    0x8A56: 0x8BD0,
    0x8A57: 0x8BC7,
    0x8A58: 0x8BCE,
    0x8A5B: 0x8BC5,
    0x8A5E: 0x8BCD,
    0x8A60: 0x548F,
    0x8A61: 0x8BE9,
    0x8A62: 0x8BE2,
    0x8A63: 0x8BE3,
    0x8A66: 0x8BD5,
    0x8A69: 0x8BD7,
    0x8A6B: 0x8BE7,
    0x8A6C: 0x8BDF,
    0x8A6D: 0x8BE1,
    0x8A6E: 0x8BE0,
    0x8A70: 0x8BD8,
    0x8A71: 0x8BDD,
    0x8A72: 0x8BE5,
    0x8A73: 0x8BE6,
    0x8A75: 0x8BDC,
    0x8A7C: 0x8BD9,
    0x8A7E: 0x8BBB,
    0x8A7F: 0x8BD6,
    0x8A84: 0x8BD4,
    0x8A85: 0x8BDB,
    0x8A86: 0x8BD3,
    0x8A87: 0x5938,
    0x8A8C: 0x5FD7,
    0x8A8D: 0x8BA4,
    0x8A91: 0x8BF3,
    0x8A92: 0x8BF6,
    0x8A95: 0x8BDE,
    0x8A98: 0x8BF1,
    0x8A9A: 0x8BEE,
    0x8A9E: 0x8BED,
    0x8AA0: 0x8BDA,
    0x8AA1: 0x8BEB,
    0x8AA3: 0x8BEC,
    0x8AA4: 0x8BEF,
    0x8AA5: 0x8BF0,
    0x8AA6: 0x8BF5,
    0x8AA8: 0x8BF2,
    0x8AAA: 0x8BF4,
    0x8AAC: 0x8BF4,
    0x8AB0: 0x8C01,
    0x8AB2: 0x8BFE,
    0x8AB6: 0x8C07,
    0x8AB9: 0x8BFD,
    0x8ABC: 0x8C0A,
    0x8ABF: 0x8C03,
    0x8AC2: 0x8C04,
    0x8AC4: 0x8C06,
    0x8AC7: 0x8C08,
    0x8AC9: 0x8BFF,
    0x8ACB: 0x8BF7,
    0x8ACD: 0x8BE4,
    0x8ACF: 0x8BF9,
    0x8AD1: 0x8BFC,
    0x8AD2: 0x8C05,
    0x8AD6: 0x8BBA,
    0x8AD7: 0x8C02,
    0x8ADB: 0x8C00,
    0x8ADC: 0x8C0D,
    0x8ADD: 0x8C1E,
    0x8ADE: 0x8C1D,
    0x8AE1: 0x8C25,
    0x8AE2: 0x8BE8,
    0x8AE4: 0x8C14,
    0x8AE6: 0x8C1B,
    0x8AE7: 0x8C10,
    0x8AEB: 0x8C0F,
    0x8AED: 0x8C15,
    0x8AEE: 0x8C18,
    0x8AF1: 0x8BB3,
    0x8AF3: 0x8C19,
    0x8AF6: 0x8C0C,
    0x8AF7: 0x8BBD,
    0x8AF8: 0x8BF8,
    0x8AFA: 0x8C1A,
    0x8AFC: 0x8C16,
    0x8AFE: 0x8BFA,
    0x8B00: 0x8C0B,
    0x8B01: 0x8C12,
    0x8B02: 0x8C13,
    0x8B04: 0x8A8A,
    0x8B05: 0x8BCC,
    0x8B0A: 0x8C0E,
    0x8B0E: 0x8C1C,
    0x8B10: 0x8C27,
    0x8B14: 0x8C11,
    0x8B16: 0x8C21,
    0x8B17: 0x8C24,
    0x8B19: 0x8C26,
    0x8B1A: 0x8C25,
    0x8B1B: 0x8BB2,
    0x8B1D: 0x8C22,
    0x8B20: 0x8C23,
    0x8B28: 0x8C1F,
    0x8B2B: 0x8C2A,
    0x8B2C: 0x8C2C,
    0x8B33: 0x8BB4,
    0x8B39: 0x8C28,
    0x8B3E: 0x8C29,
    0x8B41: 0x54D7,
    0x8B46: 0x563B,
    0x8B49: 0x8BC1,
    0x8B4C: 0x8BB9,
    0x8B4E: 0x8C32,
    0x8B4F: 0x8BA5,
    0x8B56: 0x8C2E,
    0x8B58: 0x8BC6,
    0x8B59: 0x8C2F,
    0x8B5A: 0x8C2D,
    0x8B5C: 0x8C31,
    0x8B5F: 0x566A,
    0x8B6B: 0x8C35,
    0x8B6D: 0x6BC1,
    0x8B6F: 0x8BD1,
    0x8B70: 0x8BAE,
    0x8B74: 0x8C34,
    0x8B77: 0x62A4,
    0x8B78: 0x8BEA,
    0x8B7D: 0x8A89,
    0x8B7E: 0x8C2B,
    0x8B80: 0x8BFB,
    0x8B81: 0x8C2A,
    0x8B85: 0x5BA1,
    0x8B8A: 0x53D8,
    0x8B8B: 0x8A5F,
    0x8B8C: 0x71D5,
    0x8B8E: 0x96E0,
    0x8B90: 0x96E0,
    0x8B92: 0x8C17,
    0x8B93: 0x8BA9,
    0x8B95: 0x8C30,
    0x8B96: 0x8C36,
    0x8B9A: 0x8D5E,
    0x8B9B: 0x5453,
    0x8B9C: 0x8C20,
    0x8B9E: 0x8C33,
    0x8C3F: 0x6EAA,
    0x8C48: 0x5C82,
    0x8C4E: 0x7AD6,
    0x8C50: 0x4E30,
    0x8C54: 0x8273,
    0x8C6C: 0x732A,
    0x8C76: 0x8C6E,
    0x8C8D: 0x72F8,
    0x8C93: 0x732B,
    0x8C9D: 0x8D1D,
    0x8C9E: 0x8D1E,
    0x8C9F: 0x8D20,
    0x8CA0: 0x8D1F,
    0x8CA1: 0x8D22,
    0x8CA2: 0x8D21,
    0x8CA7: 0x8D2B,
    0x8CA8: 0x8D27,
    0x8CA9: 0x8D29,
    0x8CAA: 0x8D2A,
    0x8CAB: 0x8D2F,
    0x8CAC: 0x8D23,
    0x8CAF: 0x8D2E,
    0x8CB0: 0x8D33,
    0x8CB2: 0x8D40,
    0x8CB3: 0x8D30,
    0x8CB4: 0x8D35,
    0x8CB6: 0x8D2C,
    0x8CB7: 0x4E70,
    0x8CB8: 0x8D37,
    0x8CBA: 0x8D36,
    0x8CBB: 0x8D39,
    0x8CBC: 0x8D34,
    0x8CBD: 0x8D3B,
    0x8CBF: 0x8D38,
    0x8CC0: 0x8D3A,
    0x8CC1: 0x8D32,
    0x8CC2: 0x8D42,
    0x8CC3: 0x8D41,
    0x8CC4: 0x8D3F,
    0x8CC5: 0x8D45,
    0x8CC7: 0x8D44,
    0x8CC8: 0x8D3E,
    0x8CC9: 0x6064,
    0x8CCA: 0x8D3C,
    0x8CCD: 0x8D43,
    0x8CD1: 0x8D48,
    0x8CD2: 0x8D4A,
    0x8CD3: 0x5BBE,
    0x8CD4: 0x5BBE,
    0x8CD5: 0x8D47,
    0x8CD9: 0x8D52,
    0x8CDA: 0x8D49,
    0x8CDB: 0x8D5E,
    0x8CDC: 0x8D50,
    0x8CDE: 0x8D4F,
    0x8CE0: 0x8D54,
    0x8CE1: 0x8D53,
    0x8CE2: 0x8D24,
    0x8CE3: 0x5356,
    0x8CE4: 0x8D31,
    0x8CE6: 0x8D4B,
    0x8CE7: 0x8D55,
    0x8CEA: 0x8D28,
    0x8CEB: 0x8D4D,
    0x8CEC: 0x8D26,
    0x8CED: 0x8D4C,
    0x8CEE: 0x8D46,
    0x8CF4: 0x8D56,
    0x8CF5: 0x8D57,
    0x8CF8: 0x5269,
    0x8CFA: 0x8D5A,
    0x8CFB: 0x8D59,
    0x8CFC: 0x8D2D,
    0x8CFD: 0x8D5B,
    0x8CFE: 0x8D5C,
    0x8D04: 0x8D3D,
    0x8D05: 0x8D58,
    0x8D07: 0x8D5F,
    0x8D08: 0x8D60,
    0x8D0A: 0x8D5E,
    0x8D0B: 0x8D5D,
    0x8D0D: 0x8D61,
    0x8D0F: 0x8D62,
    0x8D10: 0x8D46,
    0x8D13: 0x8D43,
    0x8D14: 0x8D51,
    0x8D16: 0x8D4E,
    0x8D17: 0x8D5D,
    0x8D1B: 0x8D63,
    0x8D1C: 0x8D43,
    0x8D6C: 0x8D6A,
    0x8D95: 0x8D76,
    0x8D99: 0x8D75,
    0x8DA8: 0x8D8B,
    0x8DB2: 0x8DB1,
    0x8DE1: 0x8FF9,
    0x8DFC: 0x5C40,
    0x8E10: 0x8DF5,
    0x8E21: 0x8737,
    0x8E34: 0x8E0A,
    0x8E4C: 0x8DC4,
    0x8E55: 0x8DF8,
    0x8E5F: 0x8FF9,
    0x8E60: 0x8DD6,
    0x8E63: 0x8E52,
    0x8E64: 0x8E2A,
    0x8E7A: 0x8DF7,
    0x8E82: 0x8DF6,
    0x8E89: 0x8DB8,
    0x8E8A: 0x8E0C,
    0x8E8B: 0x8DFB,
    0x8E8D: 0x8DC3,
    0x8E91: 0x8E2F,
    0x8E92: 0x8DDE,
    0x8E93: 0x8E2C,
    0x8E95: 0x8E70,
    0x8E9A: 0x8DF9,
    0x8EA1: 0x8E51,
    0x8EA5: 0x8E7F,
    0x8EA6: 0x8E9C,
    0x8EAA: 0x8E8F,
    0x8EB0: 0x4F53,
    0x8EC0: 0x8EAF,
    0x8EC3: 0x4EB8,
    0x8ECA: 0x8F66,
    0x8ECB: 0x8F67,
    0x8ECC: 0x8F68,
    0x8ECD: 0x519B,
    0x8ED1: 0x8F6A,
    0x8ED2: 0x8F69,
    0x8ED4: 0x8F6B,
    0x8EDB: 0x8F6D,
    0x8EDF: 0x8F6F,
    0x8EE4: 0x8F77,
    0x8EEB: 0x8F78,
    0x8EF2: 0x8F71,
    0x8EF8: 0x8F74,
    0x8EF9: 0x8F75,
    0x8EFA: 0x8F7A,
    0x8EFB: 0x8F72,
    0x8EFC: 0x8F76,
    0x8EFE: 0x8F7C,
    0x8F03: 0x8F83,
    0x8F05: 0x8F82,
    0x8F07: 0x8F81,
    0x8F08: 0x8F80,
    0x8F09: 0x8F7D,
    0x8F0A: 0x8F7E,
    0x8F12: 0x8F84,
    0x8F13: 0x633D,
    0x8F14: 0x8F85,
    0x8F15: 0x8F7B,
    0x8F1B: 0x8F86,
    0x8F1C: 0x8F8E,
    0x8F1D: 0x8F89,
    0x8F1E: 0x8F8B,
    0x8F1F: 0x8F8D,
    0x8F25: 0x8F8A,
    0x8F26: 0x8F87,
    0x8F29: 0x8F88,
    0x8F2A: 0x8F6E,
    0x8F2C: 0x8F8C,
    0x8F2D: 0x8F6F,
    0x8F2F: 0x8F91,
    0x8F33: 0x8F8F,
    0x8F38: 0x8F93,
    0x8F3B: 0x8F90,
    0x8F3C: 0x8F92,
    0x8F3E: 0x8F97,
    0x8F3F: 0x8206,
    0x8F40: 0x8F92,
    0x8F42: 0x6BC2,
    0x8F44: 0x8F96,
    0x8F45: 0x8F95,
    0x8F46: 0x8F98,
    0x8F49: 0x8F6C,
    0x8F4D: 0x8F99,
    0x8F4E: 0x8F7F,
    0x8F54: 0x8F9A,
    0x8F5F: 0x8F70,
    0x8F61: 0x8F94,
    0x8F62: 0x8F79,
    0x8F64: 0x8F73,
    0x8FA4: 0x8F9E,
    0x8FA6: 0x529E,
    0x8FAD: 0x8F9E,
    0x8FAE: 0x8FAB,
    0x8FAF: 0x8FA9,
    0x8FB2: 0x519C,
    0x8FB3: 0x519C,
    0x8FC6: 0x8FE4,
    0x8FF4: 0x56DE,
    0x8FFA: 0x4E43,
    0x9015: 0x5F84,
    0x9019: 0x8FD9,
    0x9023: 0x8FDE,
    0x9031: 0x5468,
    0x9032: 0x8FDB,
    0x904A: 0x6E38,
    0x904B: 0x8FD0,
    0x904E: 0x8FC7,
    0x9054: 0x8FBE,
    0x9055: 0x8FDD,
    0x9059: 0x9065,
    0x905C: 0x900A,
    0x905D: 0x6C93,
    0x905E: 0x9012,
    0x9060: 0x8FDC,
    0x9069: 0x9002,
    0x9072: 0x8FDF,
    0x9077: 0x8FC1,
    0x9078: 0x9009,
    0x907A: 0x9057,
    0x907C: 0x8FBD,
    0x9081: 0x8FC8,
    0x9084: 0x8FD8,
    0x9087: 0x8FE9,
    0x908A: 0x8FB9,
    0x908F: 0x903B,
    0x9090: 0x9026,
    0x90C3: 0x5408,
    0x90DF: 0x90CF,
    0x90E4: 0x90C4,
    0x90F5: 0x90AE,
    0x9106: 0x90D3,
    0x9109: 0x4E61,
    0x9112: 0x90B9,
    0x9114: 0x90AC,
    0x9115: 0x4E61,
    0x9116: 0x90E7,
    0x9118: 0x5889,
    0x9127: 0x9093,
    0x912D: 0x90D1,
    0x9130: 0x90BB,
    0x9132: 0x90F8,
    0x9134: 0x90BA,
    0x9136: 0x90D0,
    0x913A: 0x909D,
    0x9148: 0x90E6,
    0x9167: 0x916C,
    0x9183: 0x814C,
    0x9196: 0x915D,
    0x919C: 0x4E11,
    0x919E: 0x915D,
    0x91AB: 0x533B,
    0x91AC: 0x9171,
    0x91B1: 0x9166,
    0x91BB: 0x916C,
    0x91BC: 0x71D5,
    0x91C0: 0x917F,
    0x91C1: 0x8845,
    0x91C3: 0x917E,
    0x91C5: 0x917D,
    0x91CB: 0x91CA,
    0x91D0: 0x5398,
    0x91D3: 0x9486,
    0x91D4: 0x9487,
    0x91D5: 0x948C,
    0x91D7: 0x948A,
    0x91D8: 0x9489,
    0x91D9: 0x948B,
    0x91DD: 0x9488,
    0x91E3: 0x9493,
    0x91E4: 0x9490,
    0x91E6: 0x6263,
    0x91E7: 0x948F,
    0x91E9: 0x9492,
    0x91EC: 0x710A,
    0x91F5: 0x9497,
    0x91F7: 0x948D,
    0x91F9: 0x9495,
    0x91FA: 0x948E,
    0x9200: 0x94AF,
    0x9201: 0x94AB,
    0x9203: 0x9498,
    0x9204: 0x94AD,
    0x9205: 0x94A5,
    0x9208: 0x949A,
    0x9209: 0x94A0,
    0x920D: 0x949D,
    0x920E: 0x94A9,
    0x9210: 0x94A4,
    0x9211: 0x94A3,
    0x9212: 0x9491,
    0x9214: 0x949E,
    0x9215: 0x94AE,
    0x921E: 0x94A7,
    0x9221: 0x949F,
    0x9223: 0x9499,
    0x9225: 0x94AC,
    0x9226: 0x949B,
    0x9227: 0x94AA,
    0x922E: 0x94CC,
    0x9230: 0x94C8,
    0x9233: 0x94B6,
    0x9234: 0x94C3,
    0x9237: 0x94B4,
    0x9238: 0x94B9,
    0x9239: 0x94CD,
    0x923A: 0x94B0,
    0x923D: 0x94B8,
    0x923E: 0x94C0,
    0x923F: 0x94BF,
    0x9240: 0x94BE,
    0x9244: 0x94C1,
    0x9246: 0x94BB,
    0x9248: 0x94CA,
    0x9249: 0x94C9,
    0x924B: 0x5228,
    0x924D: 0x94CB,
    0x9251: 0x94C2,
    0x9255: 0x94B7,
    0x9257: 0x94B3,
    0x925A: 0x94C6,
    0x925B: 0x94C5,
    0x925E: 0x94BA,
    0x9262: 0x94B5,
    0x9264: 0x94A9,
    0x9266: 0x94B2,
    0x926C: 0x94BC,
    0x926D: 0x94BD,
    0x9276: 0x94CF,
    0x9278: 0x94F0,
    0x927A: 0x94D2,
    0x927B: 0x94EC,
    0x927F: 0x94EA,
    0x9280: 0x94F6,
    0x9283: 0x94F3,
    0x9285: 0x94DC,
    0x928D: 0x94DA,
    0x9291: 0x94E3,
    0x9293: 0x94E8,
    0x9295: 0x94C1,
    0x9296: 0x94E2,
    0x9298: 0x94ED,
    0x929A: 0x94EB,
    0x929B: 0x94E6,
    0x929C: 0x8854,
    0x92A0: 0x94D1,
    0x92A3: 0x94F7,
    0x92A5: 0x94F1,
    0x92A6: 0x94DF,
    0x92A8: 0x94F5,
    0x92A9: 0x94E5,
    0x92AA: 0x94D5,
    0x92AB: 0x94EF,
    0x92AC: 0x94D0,
    0x92B1: 0x94DE,
    0x92B2: 0x710A,
    0x92B3: 0x9510,
    0x92B7: 0x9500,
    0x92B9: 0x9508,
    0x92BB: 0x9511,
    0x92BC: 0x9509,
    0x92C1: 0x94DD,
    0x92C3: 0x9512,
    0x92C5: 0x950C,
    0x92C7: 0x94A1,
    0x92CC: 0x94E4,
    0x92CF: 0x94D7,
    0x92D2: 0x950B,
    0x92D9: 0x94FB,
    0x92DC: 0x956F,
    0x92DD: 0x950A,
    0x92DF: 0x9513,
    0x92E3: 0x94D8,
    0x92E4: 0x9504,
    0x92E5: 0x9503,
    0x92E6: 0x9514,
    0x92E8: 0x9507,
    0x92E9: 0x94D3,
    0x92EA: 0x94FA,
    0x92EE: 0x94D6,
    0x92EF: 0x9506,
    0x92F0: 0x9502,
    0x92F1: 0x94FD,
    0x92F6: 0x950D,
    0x92F8: 0x952F,
    0x92FB: 0x9274,
    0x92FC: 0x94A2,
    0x9301: 0x951E,
    0x9304: 0x5F55,
    0x9306: 0x9516,
    0x9307: 0x952B,
    0x9308: 0x9529,
    0x930F: 0x94D4,
    0x9310: 0x9525,
    0x9312: 0x9515,
    0x9315: 0x951F,
    0x9318: 0x9524,
    0x9319: 0x9531,
    0x931A: 0x94EE,
    0x931B: 0x951B,
    0x931F: 0x952C,
    0x9320: 0x952D,
    0x9321: 0x951C,
    0x9322: 0x94B1,
    0x9326: 0x9526,
    0x9328: 0x951A,
    0x9329: 0x9520,
    0x932B: 0x9521,
    0x932E: 0x9522,
    0x932F: 0x9519,
    0x9333: 0x9530,
    0x9336: 0x8868,
    0x9338: 0x94FC,
    0x9340: 0x951D,
    0x9341: 0x9528,
    0x9343: 0x952A,
    0x9346: 0x9494,
    0x9347: 0x9534,
    0x9348: 0x9533,
    0x934A: 0x70BC,
    0x934B: 0x9505,
    0x934D: 0x9540,
    0x9354: 0x9537,
    0x9358: 0x94E1,
    0x935A: 0x9496,
    0x935B: 0x953B,
    0x9360: 0x953D,
    0x9364: 0x9538,
    0x9365: 0x9532,
    0x9369: 0x9518,
    0x936B: 0x9539,
    0x936C: 0x9539,
    0x9370: 0x953E,
    0x9375: 0x952E,
    0x9376: 0x9536,
    0x937A: 0x9517,
    0x937C: 0x9488,
    0x937E: 0x949F,
    0x9382: 0x9541,
    0x9384: 0x953F,
    0x9387: 0x9545,
    0x938A: 0x9551,
    0x938B: 0x8F96,
    0x9394: 0x9555,
    0x9396: 0x9501,
    0x9398: 0x9549,
    0x939A: 0x9524,
    0x939B: 0x9548,
    0x93A1: 0x9543,
    0x93A2: 0x94A8,
    0x93A3: 0x84E5,
    0x93A6: 0x954F,
    0x93A7: 0x94E0,
    0x93A9: 0x94E9,
    0x93AA: 0x953C,
    0x93AC: 0x9550,
    0x93AE: 0x9547,
    0x93B0: 0x9552,
    0x93B2: 0x954B,
    0x93B3: 0x954D,
    0x93B5: 0x9553,
    0x93B8: 0x954C,
    0x93BF: 0x954E,
    0x93C3: 0x955E,
    0x93C7: 0x65CB,
    0x93C8: 0x94FE,
    0x93CC: 0x9546,
    0x93CD: 0x9559,
    0x93D0: 0x9560,
    0x93D1: 0x955D,
    0x93D7: 0x94FF,
    0x93D8: 0x9535,
    0x93DA: 0x621A,
    0x93DC: 0x9557,
    0x93DD: 0x9558,
    0x93DE: 0x955B,
    0x93DF: 0x94F2,
    0x93E1: 0x955C,
    0x93E2: 0x9556,
    0x93E4: 0x9542,
    0x93E8: 0x933E,
    0x93F0: 0x955A,
    0x93F5: 0x94E7,
    0x93F7: 0x9564,
    0x93F9: 0x956A,
    0x93FD: 0x9508,
    0x9403: 0x94D9,
    0x940B: 0x94F4,
    0x9410: 0x9563,
    0x9412: 0x94F9,
    0x9413: 0x9566,
    0x9414: 0x9561,
    0x9418: 0x949F,
    0x9419: 0x956B,
    0x941D: 0x9562,
    0x9420: 0x9568,
    0x9426: 0x950E,
    0x9427: 0x950F,
    0x9428: 0x9544,
    0x942B: 0x954C,
    0x942E: 0x9570,
    0x9432: 0x956F,
    0x9433: 0x956D,
    0x9435: 0x94C1,
    0x9436: 0x956E,
    0x9438: 0x94CE,
    0x943A: 0x94DB,
    0x943F: 0x9571,
    0x9444: 0x94F8,
    0x944A: 0x956C,
    0x944C: 0x9554,
    0x9451: 0x9274,
    0x9452: 0x9274,
    0x9454: 0x9572,
    0x9455: 0x9527,
    0x945B: 0x77FF,
    0x945E: 0x9574,
    0x9460: 0x94C4,
    0x9463: 0x9573,
    0x9464: 0x5228,
    0x9465: 0x9565,
    0x946A: 0x7089,
    0x946D: 0x9567,
    0x9470: 0x94A5,
    0x9471: 0x9575,
    0x9472: 0x9576,
    0x9477: 0x954A,
    0x9479: 0x9569,
    0x947C: 0x9523,
    0x947D: 0x94BB,
    0x947E: 0x92AE,
    0x947F: 0x51FF,
    0x9481: 0x9562,
    0x9482: 0x954B,
    0x949C: 0x5DE8,
    0x9577: 0x957F,
    0x9580: 0x95E8,
    0x9582: 0x95E9,
    0x9583: 0x95EA,
    0x9586: 0x95EB,
    0x9588: 0x95EC,
    0x9589: 0x95ED,
    0x958B: 0x5F00,
    0x958C: 0x95F6,
    0x958E: 0x95F3,
    0x958F: 0x95F0,
    0x9591: 0x95F2,
    0x9592: 0x95F2,
    0x9593: 0x95F4,
    0x9594: 0x95F5,
    0x9598: 0x95F8,
    0x9599: 0x95F9,
    0x95A1: 0x9602,
    0x95A2: 0x5173,
    0x95A3: 0x9601,
    0x95A4: 0x5408,
    0x95A5: 0x9600,
    0x95A8: 0x95FA,
    0x95A9: 0x95FD,
    0x95AB: 0x9603,
    0x95AC: 0x9606,
    0x95AD: 0x95FE,
    0x95B1: 0x9605,
    0x95B2: 0x9605,
    0x95B6: 0x960A,
    0x95B9: 0x9609,
    0x95BB: 0x960E,
    0x95BC: 0x960F,
    0x95BD: 0x960D,
    0x95BE: 0x9608,
    0x95BF: 0x960C,
    0x95C3: 0x9612,
    0x95C6: 0x677F,
    0x95C8: 0x95F1,
    0x95CA: 0x9614,
    0x95CB: 0x9615,
    0x95CC: 0x9611,
    0x95CD: 0x9607,
    0x95D0: 0x9617,
    0x95D2: 0x9618,
    0x95D3: 0x95FF,
    0x95D4: 0x9616,
    0x95D5: 0x9619,
    0x95D6: 0x95EF,
    0x95DA: 0x7AA5,
    0x95DC: 0x5173,
    0x95DE: 0x961A,
    0x95E0: 0x9613,
    0x95E1: 0x9610,
    0x95E2: 0x8F9F,
    0x95E4: 0x961B,
    0x95E5: 0x95FC,
    0x962C: 0x5751,
    0x962F: 0x5740,
    0x9658: 0x9649,
    0x965D: 0x9655,
    0x965E: 0x5347,
    0x9663: 0x9635,
    0x9670: 0x9634,
    0x9673: 0x9648,
    0x9678: 0x9646,
    0x967D: 0x9633,
    0x9682: 0x9634,
    0x9684: 0x5824,
    0x9689: 0x9667,
    0x968A: 0x961F,
    0x968E: 0x9636,
    0x9695: 0x9668,
    0x9696: 0x575E,
    0x969B: 0x9645,
    0x96A3: 0x90BB,
    0x96A8: 0x968F,
    0x96AA: 0x9669,
    0x96B1: 0x9690,
    0x96B4: 0x9647,
    0x96B7: 0x96B6,
    0x96B8: 0x96B6,
    0x96BB: 0x53EA,
    0x96CB: 0x96BD,
    0x96D6: 0x867D,
    0x96D9: 0x53CC,
    0x96DB: 0x96CF,
    0x96DC: 0x6742,
    0x96DE: 0x9E21,
    0x96E2: 0x79BB,
    0x96E3: 0x96BE,
    0x96F2: 0x4E91,
    0x96FB: 0x7535,
    0x9711: 0x6CBE,
    0x971B: 0x7075,
    0x9724: 0x6E9C,
    0x9727: 0x96FE,
    0x973D: 0x9701,
    0x9742: 0x96F3,
    0x9744: 0x972D,
    0x9746: 0x53C7,
    0x9748: 0x7075,
    0x9749: 0x53C6,
    0x975A: 0x9753,
    0x975C: 0x9759,
    0x9763: 0x9762,
    0x9766: 0x817C,
    0x9768: 0x9765,
    0x976D: 0x97E7,
    0x9780: 0x9F17,
    0x9789: 0x9F17,
    0x978F: 0x5DE9,
    0x97A6: 0x79CB,
    0x97BD: 0x9792,
    0x97C1: 0x7F30,
    0x97C3: 0x9791,
    0x97C6: 0x5343,
    0x97C9: 0x97AF,
    0x97CB: 0x97E6,
    0x97CC: 0x97E7,
    0x97CD: 0x97E8,
    0x97D3: 0x97E9,
    0x97D9: 0x97EA,
    0x97DC: 0x97EC,
    0x97DD: 0x97B4,
    0x97DE: 0x97EB,
    0x97E4: 0x889C,
    0x97FB: 0x97F5,
    0x97FF: 0x54CD,
    0x9801: 0x9875,
    0x9802: 0x9876,
    0x9803: 0x9877,
    0x9805: 0x9879,
    0x9806: 0x987A,
    0x9807: 0x9878,
    0x9808: 0x987B,
    0x980A: 0x987C,
    0x980C: 0x9882,
    0x980E: 0x9880,
    0x980F: 0x9883,
    0x9810: 0x9884,
    0x9811: 0x987D,
    0x9812: 0x9881,
    0x9813: 0x987F,
    0x9817: 0x9887,
    0x9818: 0x9886,
    0x981C: 0x988C,
    0x9821: 0x9889,
    0x9824: 0x9890,
    0x9826: 0x988F,
    0x982B: 0x4FEF,
    0x982D: 0x5934,
    0x982E: 0x9892,
    0x9830: 0x988A,
    0x9832: 0x988B,
    0x9834: 0x9895,
    0x9837: 0x9894,
    0x9838: 0x9888,
    0x9839: 0x9893,
    0x983B: 0x9891,
    0x983D: 0x9893,
    0x9846: 0x9897,
    0x984C: 0x9898,
    0x984D: 0x989D,
    0x984E: 0x989A,
    0x984F: 0x989C,
    0x9852: 0x9899,
    0x9853: 0x989B,
    0x9854: 0x989C,
    0x9858: 0x613F,
    0x9859: 0x98A1,
    0x985B: 0x98A0,
    0x985E: 0x7C7B,
    0x9862: 0x989F,
    0x9865: 0x98A2,
    0x9867: 0x987E,
    0x986B: 0x98A4,
    0x986C: 0x98A5,
    0x986F: 0x663E,
    0x9870: 0x98A6,
    0x9871: 0x9885,
    0x9873: 0x989E,
    0x9874: 0x98A7,
    0x98A8: 0x98CE,
    0x98AD: 0x98D0,
    0x98AE: 0x98D1,
    0x98AF: 0x98D2,
    0x98B1: 0x53F0,
    0x98B3: 0x522E,
    0x98B6: 0x98D3,
    0x98B8: 0x98D4,
    0x98BA: 0x626C,
    0x98BB: 0x98D6,
    0x98BC: 0x98D5,
    0x98C0: 0x98D7,
    0x98C3: 0x98D8,
    0x98C4: 0x98D8,
    0x98C6: 0x98D9,
    0x98C7: 0x98D9,
    0x98C8: 0x98D9,
    0x98DB: 0x98DE,
    0x98E2: 0x9965,
    0x98E3: 0x9964,
    0x98E5: 0x9966,
    0x98E9: 0x9968,
    0x98EA: 0x996A,
    0x98EB: 0x996B,
    0x98ED: 0x996C,
    0x98EF: 0x996D,
    0x98F2: 0x996E,
    0x98F4: 0x9974,
    0x98FC: 0x9972,
    0x98FD: 0x9971,
    0x98FE: 0x9970,
    0x98FF: 0x9973,
    0x9903: 0x997A,
    0x9904: 0x9978,
    0x9905: 0x997C,
    0x9909: 0x9977,
    0x990A: 0x517B,
    0x990C: 0x9975,
    0x990E: 0x9979,
    0x990F: 0x997B,
    0x9911: 0x997D,
    0x9912: 0x9981,
    0x9913: 0x997F,
    0x9915: 0x9982,
    0x9916: 0x997E,
    0x9918: 0x4F59,
    0x991A: 0x80B4,
    0x991B: 0x9984,
    0x991C: 0x9983,
    0x991E: 0x996F,
    0x9921: 0x9985,
    0x9928: 0x9986,
    0x9931: 0x7CC7,
    0x9933: 0x9967,
    0x9935: 0x5582,
    0x9936: 0x9989,
    0x9937: 0x9987,
    0x993A: 0x998E,
    0x993C: 0x9969,
    0x993D: 0x9988,
    0x993E: 0x998F,
    0x993F: 0x998A,
    0x9941: 0x998C,
    0x9943: 0x998D,
    0x9945: 0x9992,
    0x9948: 0x9990,
    0x9949: 0x9991,
    0x994A: 0x9993,
    0x994B: 0x9988,
    0x994C: 0x9994,
    0x9951: 0x9965,
    0x9952: 0x9976,
    0x9957: 0x98E8,
    0x995C: 0x990D,
    0x995D: 0x998D,
    0x995E: 0x998B,
    0x9962: 0x9995,
    0x99AC: 0x9A6C,
    0x99AD: 0x9A6D,
    0x99AE: 0x51AF,
    0x99B1: 0x9A6E,
    0x99B3: 0x9A70,
    0x99B4: 0x9A6F,
    0x99B9: 0x9A72,
    0x99C1: 0x9A73,
    0x99D0: 0x9A7B,
    0x99D1: 0x9A7D,
    0x99D2: 0x9A79,
    0x99D4: 0x9A75,
    0x99D5: 0x9A7E,
    0x99D8: 0x9A80,
    0x99D9: 0x9A78,
    0x99DB: 0x9A76,
    0x99DD: 0x9A7C,
    0x99DF: 0x9A77,
    0x99E1: 0x9A82,
    0x99E2: 0x9A88,
    0x99ED: 0x9A87,
    0x99EE: 0x9A73,
    0x99F0: 0x9A83,
    0x99F1: 0x9A86,
    0x99F8: 0x9A8E,
    0x99FF: 0x9A8F,
    0x9A01: 0x9A8B,
    0x9A02: 0x9A8D,
    0x9A05: 0x9A93,
    0x9A0C: 0x9A94,
    0x9A0D: 0x9A92,
    0x9A0E: 0x9A91,
    0x9A0F: 0x9A90,
    0x9A10: 0x9A8C,
    0x9A16: 0x9A9B,
    0x9A17: 0x9A97,
    0x9A19: 0x9A97,
    0x9A23: 0x9B03,
    0x9A24: 0x9A99,
    0x9A2B: 0x9A9E,
    0x9A2D: 0x9A98,
    0x9A2E: 0x9A9D,
    0x9A30: 0x817E,
    0x9A36: 0x9A7A,
    0x9A37: 0x9A9A,
    0x9A38: 0x9A9F,
    0x9A3E: 0x9AA1,
    0x9A40: 0x84E6,
    0x9A41: 0x9A9C,
    0x9A42: 0x9A96,
    0x9A43: 0x9AA0,
    0x9A44: 0x9AA2,
    0x9A45: 0x9A71,
    0x9A4A: 0x9A85,
    0x9A4C: 0x9A95,
    0x9A4D: 0x9A81,
    0x9A4F: 0x9AA3,
    0x9A55: 0x9A84,
    0x9A57: 0x9A8C,
    0x9A58: 0x9AA1,
    0x9A5A: 0x60CA,
    0x9A5B: 0x9A7F,
    0x9A5F: 0x9AA4,
    0x9A62: 0x9A74,
    0x9A64: 0x9AA7,
    0x9A65: 0x9AA5,
    0x9A66: 0x9AA6,
    0x9A6A: 0x9A8A,
    0x9A6B: 0x9A89,
    0x9ABE: 0x9CA0,
    0x9ACF: 0x9AC5,
    0x9AD2: 0x810F,
    0x9AD4: 0x4F53,
    0x9AD5: 0x9ACC,
    0x9AD6: 0x9ACB,
    0x9AE9: 0x9B13,
    0x9AEE: 0x53D1,
    0x9B01: 0x75AC,
    0x9B06: 0x677E,
    0x9B0D: 0x80E1,
    0x9B1A: 0x987B,
    0x9B22: 0x9B13,
    0x9B25: 0x6597,
    0x9B26: 0x6597,
    0x9B27: 0x95F9,
    0x9B28: 0x54C4,
    0x9B29: 0x960B,
    0x9B2D: 0x6597,
    0x9B2E: 0x9604,
    0x9B31: 0x90C1,
    0x9B4E: 0x9B49,
    0x9B58: 0x9B47,
    0x9B5A: 0x9C7C,
    0x9B5B: 0x9C7D,
    0x9B62: 0x9C7E,
    0x9B68: 0x9C80,
    0x9B6F: 0x9C81,
    0x9B74: 0x9C82,
    0x9B77: 0x9C7F,
    0x9B7A: 0x9C84,
    0x9B81: 0x9C85,
    0x9B83: 0x9C86,
    0x9B8A: 0x9C8C,
    0x9B8B: 0x9C89,
    0x9B8C: 0x9CA7,
    0x9B8D: 0x9C8F,
    0x9B8E: 0x9C87,
    0x9B90: 0x9C90,
    0x9B91: 0x9C8D,
    0x9B92: 0x9C8B,
    0x9B93: 0x9C8A,
    0x9B9A: 0x9C92,
    0x9B9C: 0x9C98,
    0x9B9E: 0x9C95,
    0x9BA6: 0x9C96,
    0x9BAA: 0x9C94,
    0x9BAB: 0x9C9B,
    0x9BAD: 0x9C91,
    0x9BAE: 0x9C9C,
    0x9BB3: 0x9C93,
    0x9BB6: 0x9CAA,
    0x9BB7: 0x9CC0,
    0x9BBA: 0x9C9D,
    0x9BC0: 0x9CA7,
    0x9BC1: 0x9CA0,
    0x9BC7: 0x9CA9,
    0x9BC9: 0x9CA4,
    0x9BCA: 0x9CA8,
    0x9BD2: 0x9CAC,
    0x9BD4: 0x9CBB,
    0x9BD5: 0x9CAF,
    0x9BD6: 0x9CAD,
    0x9BD7: 0x9C9E,
    0x9BDB: 0x9CB7,
    0x9BDD: 0x9CB4,
    0x9BE1: 0x9CB1,
    0x9BE2: 0x9CB5,
    0x9BE4: 0x9CB2,
    0x9BE7: 0x9CB3,
    0x9BE8: 0x9CB8,
    0x9BEA: 0x9CAE,
    0x9BEB: 0x9CB0,
    0x9BF0: 0x9CB6,
    0x9BF4: 0x9CBA,
    0x9BF5: 0x9CB9,
    0x9BF7: 0x9CC0,
    0x9BFD: 0x9CAB,
    0x9BFF: 0x9CCA,
    0x9C01: 0x9CC8,
    0x9C02: 0x9C97,
    0x9C03: 0x9CC2,
    0x9C08: 0x9CBD,
    0x9C09: 0x9CC7,
    0x9C0C: 0x9CC5,
    0x9C0D: 0x9CC5,
    0x9C0F: 0x9CBE,
    0x9C10: 0x9CC4,
    0x9C12: 0x9CC6,
    0x9C13: 0x9CC3,
    0x9C1B: 0x9CC1,
    0x9C1C: 0x9CD2,
    0x9C1F: 0x9CD1,
    0x9C20: 0x9CCB,
    0x9C23: 0x9CA5,
    0x9C25: 0x9CCF,
    0x9C28: 0x9CCE,
    0x9C29: 0x9CD0,
    0x9C2D: 0x9CCD,
    0x9C2E: 0x9CC1,
    0x9C31: 0x9CA2,
    0x9C32: 0x9CCC,
    0x9C33: 0x9CD3,
    0x9C35: 0x9CD8,
    0x9C37: 0x9CA6,
    0x9C39: 0x9CA3,
    0x9C3A: 0x9CB9,
    0x9C3B: 0x9CD7,
    0x9C3C: 0x9CDB,
    0x9C3E: 0x9CD4,
    0x9C42: 0x9CC9,
    0x9C45: 0x9CD9,
    0x9C48: 0x9CD5,
    0x9C49: 0x9CD6,
    0x9C52: 0x9CDF,
    0x9C53: 0x9CDD,
    0x9C54: 0x9CDD,
    0x9C56: 0x9CDC,
    0x9C57: 0x9CDE,
    0x9C58: 0x9C9F,
    0x9C5D: 0x9CBC,
    0x9C5F: 0x9C8E,
    0x9C60: 0x9C99,
    0x9C63: 0x9CE3,
    0x9C64: 0x9CE1,
    0x9C67: 0x9CE2,
    0x9C68: 0x9CBF,
    0x9C6D: 0x9C9A,
    0x9C6F: 0x9CE0,
    0x9C77: 0x9CC4,
    0x9C78: 0x9C88,
    0x9C7A: 0x9CA1,
    0x9CE5: 0x9E1F,
    0x9CE7: 0x51EB,
    0x9CE9: 0x9E20,
    0x9CF2: 0x9E24,
    0x9CF3: 0x51E4,
    0x9CF4: 0x9E23,
    0x9CF6: 0x9E22,
    0x9D06: 0x9E29,
    0x9D07: 0x9E28,
    0x9D09: 0x9E26,
    0x9D12: 0x9E30,
    0x9D15: 0x9E35,
    0x9D1B: 0x9E33,
    0x9D1D: 0x9E32,
    0x9D1E: 0x9E2E,
    0x9D1F: 0x9E31,
    0x9D23: 0x9E2A,
    0x9D26: 0x9E2F,
    0x9D28: 0x9E2D,
    0x9D2C: 0x9E34,
    0x9D2F: 0x9E38,
    0x9D30: 0x9E39,
    0x9D34: 0x9E3B,
    0x9D3B: 0x9E3F,
    0x9D3F: 0x9E3D,
    0x9D42: 0x9E3A,
    0x9D43: 0x9E3C,
    0x9D50: 0x9E40,
    0x9D51: 0x9E43,
    0x9D52: 0x9E46,
    0x9D53: 0x9E41,
    0x9D5C: 0x9E48,
    0x9D5D: 0x9E45,
    0x9D5E: 0x9E45,
    0x9D60: 0x9E44,
    0x9D61: 0x9E49,
    0x9D6A: 0x9E4C,
    0x9D6C: 0x9E4F,
    0x9D6E: 0x9E50,
    0x9D6F: 0x9E4E,
    0x9D72: 0x9E4A,
    0x9D76: 0x9E26,
    0x9D77: 0x9E53,
    0x9D7E: 0x9E4D,
    0x9D87: 0x9E2B,
    0x9D89: 0x9E51,
    0x9D8A: 0x9E52,
    0x9D93: 0x9E4B,
    0x9D96: 0x9E59,
    0x9D98: 0x9E55,
    0x9D9A: 0x9E57,
    0x9DA1: 0x9E56,
    0x9DA4: 0x9E4D,
    0x9DA5: 0x9E5B,
    0x9DA9: 0x9E5C,
    0x9DAC: 0x9E27,
    0x9DAF: 0x83BA,
    0x9DB2: 0x9E5F,
    0x9DB4: 0x9E64,
    0x9DB9: 0x9E60,
    0x9DBA: 0x9E61,
    0x9DBB: 0x9E58,
    0x9DBC: 0x9E63,
    0x9DBF: 0x9E5A,
    0x9DC0: 0x9E5A,
    0x9DC1: 0x9E62,
    0x9DC2: 0x9E5E,
    0x9DC4: 0x9E21,
    0x9DCA: 0x9E5D,
    0x9DD3: 0x9E67,
    0x9DD6: 0x9E65,
    0x9DD7: 0x9E25,
    0x9DD9: 0x9E37,
    0x9DDA: 0x9E68,
    0x9DE5: 0x9E36,
    0x9DE6: 0x9E6A,
    0x9DEB: 0x9E54,
    0x9DEF: 0x9E69,
    0x9DF0: 0x71D5,
    0x9DF2: 0x9E6B,
    0x9DF3: 0x9E47,
    0x9DF4: 0x9E47,
    0x9DF8: 0x9E6C,
    0x9DF9: 0x9E70,
    0x9DFA: 0x9E6D,
    0x9DFC: 0x9E47,
    0x9E07: 0x9E6F,
    0x9E0C: 0x9E71,
    0x9E0E: 0x83BA,
    0x9E0F: 0x9E72,
    0x9E15: 0x9E2C,
    0x9E18: 0x9E74,
    0x9E1A: 0x9E66,
    0x9E1B: 0x9E73,
    0x9E1D: 0x9E42,
    0x9E1E: 0x9E3E,
    0x9E75: 0x5364,
    0x9E79: 0x54B8,
    0x9E7A: 0x9E7E,
    0x9E7C: 0x78B1,
    0x9E7D: 0x76D0,
    0x9E85: 0x72CD,
    0x9E97: 0x4E3D,
    0x9EA5: 0x9EA6,
    0x9EA9: 0x9EB8,
    0x9EAA: 0x9762,
    0x9EAF: 0x66F2,
    0x9EB4: 0x66F2,
    0x9EB5: 0x9762,
    0x9EBC: 0x4E48,
    0x9EBD: 0x4E48,
    0x9EC3: 0x9EC4,
    0x9ECC: 0x9EC9,
    0x9EDE: 0x70B9,
    0x9EE8: 0x515A,
    0x9EF2: 0x9EEA,
    0x9EF4: 0x9709,
    0x9EF6: 0x9EE1,
    0x9EF7: 0x9EE9,
    0x9EFD: 0x9EFE,
    0x9EFF: 0x9F0B,
    0x9F02: 0x9F0C,
    0x9F07: 0x9CCC,
    0x9F08: 0x9CD6,
    0x9F09: 0x9F0D,
    0x9F15: 0x51AC,
    0x9F34: 0x9F39,
    0x9F47: 0x9F44,
    0x9F4A: 0x9F50,
    0x9F4B: 0x658B,
    0x9F4E: 0x8D4D,
    0x9F4F: 0x9F51,
    0x9F52: 0x9F7F,
    0x9F54: 0x9F80,
    0x9F55: 0x9F81,
    0x9F57: 0x9F82,
    0x9F59: 0x9F85,
    0x9F5C: 0x9F87,
    0x9F5F: 0x9F83,
    0x9F60: 0x9F86,
    0x9F61: 0x9F84,
    0x9F63: 0x51FA,
    0x9F66: 0x9F88,
    0x9F67: 0x556E,
    0x9F6A: 0x9F8A,
    0x9F6C: 0x9F89,
    0x9F72: 0x9F8B,
    0x9F76: 0x816D,
    0x9F77: 0x9F8C,
    0x9F8D: 0x9F99,
    0x9F90: 0x5E9E,
    0x9F94: 0x9F9A,
    0x9F95: 0x9F9B,
    0x9F9C: 0x9F9F,
}

Kanji2Trad_Table = {
    0x2015: 0x2500,
    0x2033: 0x3003,
    0x2211: 0x03A3,
    0x2227: 0x039B,
    0x2228: 0xFF36,
    0x2312: 0xFE35,
    0x2501: 0x2500,
    0x2503: 0x2502,
    0x250F: 0x250C,
    0x2513: 0x2510,
    0x2517: 0x2514,
    0x251B: 0x2518,
    0x251D: 0x255E,
    0x2520: 0x251C,
    0x2523: 0x251C,
    0x2525: 0x2561,
    0x2528: 0x2524,
    0x252B: 0x2524,
    0x252F: 0x252C,
    0x2530: 0x252C,
    0x2533: 0x252C,
    0x2537: 0x2534,
    0x2538: 0x2534,
    0x253B: 0x2534,
    0x253F: 0x256A,
    0x2542: 0x253C,
    0x254B: 0x253C,
    0x3013: 0x2550,
    0x30FB: 0x2027,
    0x3231: 0x682A,
    0x3232: 0x6709,
    0x3239: 0x4EE3,
    0x4E07: 0x842C,
    0x4E0E: 0x8207,
    0x4E11: 0x919C,
    0x4E17: 0x4E16,
    0x4E21: 0x5169,
    0x4E28: 0x4E85,
    0x4E2A: 0x500B,
    0x4E36: 0x3001,
    0x4E55: 0x864E,
    0x4E57: 0x4E58,
    0x4E62: 0x4E10,
    0x4E71: 0x4E82,
    0x4E80: 0x9F9C,
    0x4E89: 0x722D,
    0x4E8A: 0x4E8B,
    0x4E8E: 0x65BC,
    0x4E91: 0x96F2,
    0x4E98: 0x4E99,
    0x4E9C: 0x4E9E,
    0x4EB0: 0x4EAC,
    0x4ECE: 0x5F9E,
    0x4ECF: 0x4F5B,
    0x4EED: 0x4EDE,
    0x4EEE: 0x5047,
    0x4EF7: 0x50F9,
    0x4EFC: 0x4EFB,
    0x4F03: 0x52F2,
    0x4F1A: 0x6703,
    0x4F1C: 0x5005,
    0x4F53: 0x9AD4,
    0x4F59: 0x9918,
    0x4F8A: 0x89E5,
    0x4FA0: 0x4FE0,
    0x4FA1: 0x50F9,
    0x4FAB: 0x4F5E,
    0x4FAD: 0x5118,
    0x4FE3: 0x4FC1,
    0x4FE4: 0x7CF5,
    0x4FE5: 0x86CD,
    0x4FFF: 0x864E,
    0x5024: 0x503C,
    0x5036: 0x4FF1,
    0x5039: 0x5109,
    0x5042: 0x524D,
    0x5050: 0x8D17,
    0x5056: 0x9937,
    0x506C: 0x50AF,
    0x5078: 0x5077,
    0x50CD: 0x52D5,
    0x50D8: 0x655E,
    0x50DE: 0x507D,
    0x50F4: 0x50E9,
    0x5101: 0x4FCA,
    0x5116: 0x6FEB,
    0x513F: 0x5152,
    0x514A: 0x514C,
    0x514E: 0x5154,
    0x5150: 0x5152,
    0x515A: 0x9EE8,
    0x5164: 0x6643,
    0x516A: 0x4FDE,
    0x5185: 0x5167,
    0x5186: 0x5713,
    0x518C: 0x518A,
    0x5190: 0x5192,
    0x5199: 0x5BEB,
    0x519D: 0x5B9C,
    0x51A2: 0x585A,
    0x51A6: 0x5BC7,
    0x51A8: 0x5BCC,
    0x51A9: 0x5BEB,
    0x51B2: 0x6C96,
    0x51B3: 0x6C7A,
    0x51B4: 0x51B1,
    0x51B5: 0x6CC1,
    0x51C4: 0x6DD2,
    0x51C9: 0x6DBC,
    0x51CC: 0x6DE9,
    0x51D6: 0x6E96,
    0x51DB: 0x51DC,
    0x51E0: 0x5E7E,
    0x51E6: 0x8655,
    0x51EC: 0x98A8,
    0x51ED: 0x6191,
    0x51FE: 0x51FD,
    0x5204: 0x5203,
    0x520B: 0x520A,
    0x5215: 0x52A6,
    0x5227: 0x52AB,
    0x5239: 0x524E,
    0x524F: 0x5231,
    0x5263: 0x528D,
    0x5264: 0x5291,
    0x5265: 0x525D,
    0x5270: 0x5269,
    0x5271: 0x528D,
    0x5273: 0x5284,
    0x5292: 0x528D,
    0x5294: 0x528D,
    0x52B1: 0x52F5,
    0x52B4: 0x52DE,
    0x52B5: 0x5238,
    0x52B9: 0x6548,
    0x52C5: 0x6555,
    0x52E0: 0x622E,
    0x52E7: 0x52F8,
    0x52F2: 0x52F3,
    0x5300: 0x52FB,
    0x5301: 0x5169,
    0x5302: 0x5308,
    0x5324: 0x5323,
    0x5333: 0x5969,
    0x5338: 0x531A,
    0x533A: 0x5340,
    0x533B: 0x91AB,
    0x5346: 0x5352,
    0x5358: 0x55AE,
    0x5374: 0x537B,
    0x5382: 0x5EE0,
    0x5393: 0x5D16,
    0x53A0: 0x5EC1,
    0x53A6: 0x5EC8,
    0x53A8: 0x5EDA,
    0x53A9: 0x5EC4,
    0x53AE: 0x5EDD,
    0x53B0: 0x5EE0,
    0x53B3: 0x56B4,
    0x53C2: 0x53C3,
    0x53CC: 0x96D9,
    0x53CE: 0x6536,
    0x53D9: 0x6558,
    0x53F6: 0x5354,
    0x53F6: 0x8449,
    0x53F7: 0x865F,
    0x5401: 0x7C72,
    0x540E: 0x5F8C,
    0x542C: 0x807D,
    0x5449: 0x5433,
    0x5451: 0x541E,
    0x545F: 0x7384,
    0x546A: 0x5492,
    0x548A: 0x548C,
    0x548F: 0x8A60,
    0x549C: 0x8421,
    0x54A4: 0x5412,
    0x54B2: 0x7B11,
    0x54B8: 0x9E79,
    0x54D8: 0x884C,
    0x5516: 0x555E,
    0x554C: 0x54B3,
    0x5553: 0x555F,
    0x555D: 0x7FC6,
    0x5586: 0x54F2,
    0x559E: 0x5527,
    0x55A9: 0x55BB,
    0x55B0: 0x98E7,
    0x55B6: 0x71DF,
    0x5618: 0x5653,
    0x5631: 0x56D1,
    0x5650: 0x5668,
    0x565B: 0x5699,
    0x567A: 0x66B3,
    0x568A: 0x55C5,
    0x5694: 0x568F,
    0x56A0: 0x700F,
    0x56A2: 0x56CA,
    0x56CE: 0x8D08,
    0x56D8: 0x56DE,
    0x56E3: 0x5718,
    0x56F2: 0x570D,
    0x56F3: 0x5716,
    0x56FD: 0x570B,
    0x5700: 0x570B,
    0x570F: 0x5708,
    0x5727: 0x58D3,
    0x5742: 0x962A,
    0x574F: 0x58DE,
    0x5759: 0x5DE0,
    0x577F: 0x72B6,
    0x5788: 0x708B,
    0x57AA: 0x93D3,
    0x57C0: 0x5782,
    0x57C8: 0x5CFB,
    0x57D3: 0x57D2,
    0x57D6: 0x82B1,
    0x5815: 0x58AE,
    0x583A: 0x754C,
    0x5840: 0x64E5,
    0x5841: 0x58D8,
    0x5869: 0x9E7D,
    0x5870: 0x6D77,
    0x5872: 0x5834,
    0x5897: 0x589E,
    0x58B2: 0x5893,
    0x58B9: 0x9593,
    0x58CA: 0x58DE,
    0x58CC: 0x58E4,
    0x58DC: 0x7F48,
    0x58E5: 0x5EDB,
    0x58EE: 0x58EF,
    0x58F0: 0x8072,
    0x58F1: 0x58F9,
    0x58F2: 0x8CE3,
    0x58F7: 0x58FA,
    0x58FB: 0x5A7F,
    0x5902: 0x8C32,
    0x5909: 0x8B8A,
    0x5918: 0x536F,
    0x591B: 0x591A,
    0x5932: 0x672C,
    0x5938: 0x8A87,
    0x5965: 0x5967,
    0x5968: 0x734E,
    0x596C: 0x734E,
    0x599B: 0x5AB8,
    0x59AC: 0x5992,
    0x59C9: 0x59CA,
    0x59D9: 0x598A,
    0x59DC: 0x8591,
    0x59EB: 0x59EC,
    0x5A1A: 0x5583,
    0x5A2F: 0x5A1B,
    0x5B22: 0x5B43,
    0x5B66: 0x5B78,
    0x5B8D: 0x8089,
    0x5B9D: 0x5BF6,
    0x5B9F: 0x5BE6,
    0x5BC3: 0x51A4,
    0x5BC9: 0x9DB4,
    0x5BDB: 0x5BEC,
    0x5BDD: 0x5BE2,
    0x5BF3: 0x5BF6,
    0x5BFE: 0x5C0D,
    0x5BFF: 0x58FD,
    0x5C02: 0x5C08,
    0x5C05: 0x524B,
    0x5C06: 0x5C07,
    0x5C13: 0x723E,
    0x5C1E: 0x71CE,
    0x5C20: 0x9BAE,
    0x5C2D: 0x582F,
    0x5C38: 0x5C4D,
    0x5C3D: 0x76E1,
    0x5C4A: 0x5C46,
    0x5C53: 0x5C6D,
    0x5C5E: 0x5C6C,
    0x5C61: 0x5C62,
    0x5C76: 0x6703,
    0x5CB3: 0x5DBD,
    0x5CBA: 0x5CAD,
    0x5CBB: 0x577B,
    0x5CBC: 0x576A,
    0x5CBE: 0x576B,
    0x5CE0: 0x5361,
    0x5CE1: 0x5CFD,
    0x5CE9: 0x5CE8,
    0x5CEF: 0x5CF0,
    0x5CF5: 0x5DB8,
    0x5CFA: 0x57C2,
    0x5D15: 0x5D16,
    0x5D18: 0x5D19,
    0x5D53: 0x5DD6,
    0x5D5C: 0x5D0E,
    0x5D73: 0x5D6F,
    0x5D8B: 0x5D68,
    0x5D8C: 0x5CF6,
    0x5D90: 0x9686,
    0x5DB9: 0x5CF6,
    0x5DCC: 0x5DD6,
    0x5DD3: 0x5DD4,
    0x5DE3: 0x5DE2,
    0x5DF5: 0x536E,
    0x5DFB: 0x5377,
    0x5E0B: 0x7D19,
    0x5E2F: 0x5E36,
    0x5E30: 0x6B78,
    0x5E47: 0x5E6B,
    0x5E64: 0x5E63,
    0x5E72: 0x5E79,
    0x5E76: 0x4E26,
    0x5E7A: 0x4E48,
    0x5E7F: 0x5EE3,
    0x5E81: 0x5EF3,
    0x5E83: 0x5EE3,
    0x5E84: 0x838A,
    0x5EC3: 0x5EE2,
    0x5ECF: 0x5EC4,
    0x5ED0: 0x5EC4,
    0x5EF0: 0x5EF3,
    0x5EF8: 0x8FEA,
    0x5EFB: 0x8FF4,
    0x5EFC: 0x8FFA,
    0x5F03: 0x68C4,
    0x5F09: 0x5958,
    0x5F0C: 0x58F9,
    0x5F0D: 0x8CB3,
    0x5F10: 0x8CB3,
    0x5F11: 0x5F12,
    0x5F21: 0x5F35,
    0x5F25: 0x5F4C,
    0x5F2F: 0x5F4E,
    0x5F3E: 0x5F48,
    0x5F51: 0x8FB9,
    0x5F53: 0x7576,
    0x5F5C: 0x5F5D,
    0x5F66: 0x5F65,
    0x5F83: 0x5F80,
    0x5F84: 0x5F91,
    0x5F93: 0x5F9E,
    0x5FA1: 0x79A6,
    0x5FB3: 0x5FB7,
    0x5FB4: 0x5FB5,
    0x5FDC: 0x61C9,
    0x5FF0: 0x60B4,
    0x601C: 0x6190,
    0x6031: 0x5306,
    0x603A: 0x607F,
    0x604B: 0x6200,
    0x6060: 0x602A,
    0x6075: 0x60E0,
    0x6077: 0x6058,
    0x608B: 0x541D,
    0x60A6: 0x6085,
    0x60A7: 0x5788,
    0x60A9: 0x60F1,
    0x60AA: 0x60E1,
    0x60B3: 0x5FB7,
    0x60DE: 0x6B23,
    0x60E3: 0x5A61,
    0x60E7: 0x61FC,
    0x60E8: 0x6158,
    0x610D: 0x6E63,
    0x6111: 0x6080,
    0x6120: 0x614D,
    0x6121: 0x5306,
    0x6130: 0x7DFE,
    0x613C: 0x614E,
    0x613D: 0x535A,
    0x613F: 0x9858,
    0x6142: 0x607F,
    0x6159: 0x615A,
    0x616F: 0x50B7,
    0x6187: 0x61A9,
    0x6198: 0x585A,
    0x6199: 0x559C,
    0x61D0: 0x61F7,
    0x61F4: 0x61FA,
    0x6213: 0x6216,
    0x621D: 0x8CCA,
    0x621E: 0x621B,
    0x6226: 0x6230,
    0x622F: 0x6232,
    0x6238: 0x6236,
    0x623B: 0x623E,
    0x624E: 0x7D2E,
    0x6255: 0x62C2,
    0x629B: 0x62CB,
    0x629C: 0x62D4,
    0x629E: 0x64C7,
    0x62A6: 0x79C9,
    0x62C5: 0x64D4,
    0x62DD: 0x62DC,
    0x62E0: 0x636E,
    0x62E1: 0x64F4,
    0x6302: 0x639B,
    0x6319: 0x8209,
    0x631F: 0x633E,
    0x6327: 0x7FBD,
    0x633F: 0x63D2,
    0x635C: 0x641C,
    0x636E: 0x64DA,
    0x637B: 0x649A,
    0x63B2: 0x63ED,
    0x63B4: 0x6451,
    0x63B5: 0x547D,
    0x63BB: 0x6414,
    0x63FA: 0x6416,
    0x643A: 0x651C,
    0x6442: 0x651D,
    0x6483: 0x64CA,
    0x64B9: 0x652A,
    0x64E1: 0x62AC,
    0x64E7: 0x8209,
    0x6505: 0x6522,
    0x6535: 0x590A,
    0x654D: 0x6558,
    0x654E: 0x6559,
    0x6570: 0x6578,
    0x6588: 0x5B78,
    0x6589: 0x9F4A,
    0x658E: 0x9F4B,
    0x65AD: 0x65B7,
    0x65D9: 0x65DB,
    0x65E0: 0x7121,
    0x65E0: 0x75C3,
    0x65E7: 0x820A,
    0x661E: 0x663A,
    0x663B: 0x6602,
    0x663C: 0x665D,
    0x663F: 0x66E0,
    0x6644: 0x6643,
    0x664B: 0x6649,
    0x6652: 0x66EC,
    0x6657: 0x7F12,
    0x6667: 0x7693,
    0x6669: 0x665A,
    0x6673: 0x6670,
    0x6681: 0x66C9,
    0x6683: 0x7F6A,
    0x668E: 0x6BCE,
    0x66A6: 0x66C6,
    0x66BF: 0x6DB1,
    0x66C1: 0x66A8,
    0x66F5: 0x66F3,
    0x66FA: 0x66F9,
    0x66FD: 0x66FE,
    0x670E: 0x6EDB,
    0x6716: 0x6717,
    0x671E: 0x671F,
    0x672D: 0x5284,
    0x6734: 0x6A38,
    0x6736: 0x6735,
    0x673A: 0x6A5F,
    0x6761: 0x689D,
    0x6765: 0x4F86,
    0x6770: 0x5091,
    0x67A0: 0x6A3A,
    0x67A2: 0x6A1E,
    0x67A6: 0x6AE8,
    0x67A9: 0x677E,
    0x67FB: 0x67E5,
    0x67FE: 0x67E9,
    0x6801: 0x67F3,
    0x6802: 0x6885,
    0x6804: 0x69AE,
    0x6816: 0x68F2,
    0x6822: 0x67CF,
    0x6852: 0x6851,
    0x6859: 0x6A21,
    0x685C: 0x6AFB,
    0x685D: 0x821B,
    0x685F: 0x68E7,
    0x6863: 0x6A94,
    0x6867: 0x6A9C,
    0x688D: 0x7682,
    0x68A6: 0x5922,
    0x68B6: 0x7DD1,
    0x68B9: 0x6AB3,
    0x68BC: 0x6AAE,
    0x68CA: 0x68CB,
    0x6900: 0x7897,
    0x6901: 0x69E8,
    0x6919: 0x660C,
    0x691A: 0x64AF,
    0x691C: 0x6AA2,
    0x6922: 0x69F6,
    0x6923: 0x5178,
    0x6926: 0x68EC,
    0x6928: 0x5E9C,
    0x6936: 0x68D5,
    0x6955: 0x6A62,
    0x6961: 0x6986,
    0x6973: 0x6885,
    0x697C: 0x6A13,
    0x697D: 0x6A02,
    0x698A: 0x67DB,
    0x6998: 0x8845,
    0x69C7: 0x69D9,
    0x69D8: 0x6A23,
    0x69DD: 0x5CF6,
    0x69DE: 0x6AF3,
    0x69F9: 0x69D4,
    0x6A0B: 0x901A,
    0x6A12: 0x6993,
    0x6A22: 0x8526,
    0x6A29: 0x6B0A,
    0x6A2A: 0x6A6B,
    0x6A2B: 0x9CD9,
    0x6A2E: 0x6B1E,
    0x6A72: 0x559C,
    0x6A90: 0x7C37,
    0x6AAA: 0x6ADF,
    0x6AC1: 0x6993,
    0x6B05: 0x6AF8,
    0x6B1D: 0x9B31,
    0x6B1F: 0x7F50,
    0x6B27: 0x6B50,
    0x6B53: 0x6B61,
    0x6B69: 0x6B65,
    0x6B6F: 0x9F52,
    0x6B73: 0x6B72,
    0x6B74: 0x6B77,
    0x6B8B: 0x6B98,
    0x6BB1: 0x6BB2,
    0x6BB4: 0x6BC6,
    0x6BBB: 0x6BBC,
    0x6BCE: 0x6BCF,
    0x6C14: 0x6C23,
    0x6C17: 0x6C23,
    0x6C37: 0x51B0,
    0x6C5A: 0x6C61,
    0x6C93: 0x905D,
    0x6CA1: 0x6C92,
    0x6CA2: 0x6FA4,
    0x6CEA: 0x6DDA,
    0x6D12: 0x7051,
    0x6D44: 0x6DE8,
    0x6D45: 0x6DFA,
    0x6D5C: 0x6FF1,
    0x6D8C: 0x6E67,
    0x6D96: 0x849E,
    0x6D99: 0x6DDA,
    0x6D9B: 0x6FE4,
    0x6D9C: 0x7006,
    0x6DC0: 0x6FB1,
    0x6DF8: 0x6E05,
    0x6E07: 0x6E34,
    0x6E08: 0x6FDF,
    0x6E09: 0x6D89,
    0x6E0A: 0x6DF5,
    0x6E0B: 0x6F80,
    0x6E13: 0x6EAA,
    0x6E15: 0x6DF5,
    0x6E29: 0x6EAB,
    0x6E38: 0x904A,
    0x6E76: 0x5263,
    0x6E7E: 0x7063,
    0x6E7F: 0x6FD5,
    0x6E80: 0x6EFF,
    0x6E8C: 0x6F51,
    0x6EDD: 0x7027,
    0x6EDE: 0x6EEF,
    0x6F11: 0x6E89,
    0x6F45: 0x704C,
    0x6F5C: 0x6F5B,
    0x6F74: 0x7026,
    0x6F81: 0x6F80,
    0x6F91: 0x6E9C,
    0x6FF3: 0x6F5B,
    0x6FF6: 0x95CA,
    0x701E: 0x6A36,
    0x702C: 0x7028,
    0x706F: 0x71C8,
    0x7089: 0x7210,
    0x70B9: 0x9EDE,
    0x70BB: 0x9A26,
    0x70DF: 0x7159,
    0x70F1: 0x70AF,
    0x7114: 0x7130,
    0x713C: 0x71D2,
    0x7155: 0x7199,
    0x7188: 0x7199,
    0x71D7: 0x721B,
    0x71F5: 0x5008,
    0x7232: 0x70BA,
    0x723C: 0x4FCE,
    0x7240: 0x5E8A,
    0x7282: 0x7281,
    0x7287: 0x5954,
    0x72A0: 0x72A7,
    0x72B2: 0x8C7A,
    0x72B6: 0x72C0,
    0x72B9: 0x7336,
    0x72BE: 0x72AC,
    0x72E2: 0x8C89,
    0x72EC: 0x7368,
    0x72ED: 0x72F9,
    0x731F: 0x7375,
    0x732A: 0x8C6C,
    0x732B: 0x8C93,
    0x732E: 0x737B,
    0x732F: 0x8C92,
    0x734F: 0x8C98,
    0x7363: 0x7378,
    0x73C9: 0x6725,
    0x73C9: 0x7449,
    0x73CE: 0x73CD,
    0x73F1: 0x74D4,
    0x7460: 0x7409,
    0x7476: 0x7464,
    0x74A2: 0x7409,
    0x74EE: 0x7515,
    0x7501: 0x74F6,
    0x750E: 0x78DA,
    0x751E: 0x5617,
    0x7523: 0x7522,
    0x753B: 0x756B,
    0x753C: 0x753A,
    0x7544: 0x7559,
    0x7546: 0x755D,
    0x754A: 0x8015,
    0x754D: 0x754C,
    0x7560: 0x58B0,
    0x7567: 0x7565,
    0x756D: 0x756C,
    0x7573: 0x758A,
    0x7574: 0x7587,
    0x7582: 0x758A,
    0x7589: 0x758A,
    0x758E: 0x758F,
    0x75B1: 0x5E96,
    0x75B1: 0x76B0,
    0x75C3: 0x9938,
    0x75D2: 0x7662,
    0x75E9: 0x7626,
    0x75F4: 0x7661,
    0x763B: 0x763A,
    0x7667: 0x569F,
    0x767A: 0x767C,
    0x7680: 0x7682,
    0x7683: 0x8C8C,
    0x7690: 0x768B,
    0x76B7: 0x9F13,
    0x76B9: 0x76B8,
    0x76D6: 0x84CB,
    0x76D7: 0x76DC,
    0x770C: 0x7E23,
    0x771E: 0x771F,
    0x7726: 0x7725,
    0x7740: 0x8457,
    0x7815: 0x788E,
    0x783A: 0x792A,
    0x783F: 0x7926,
    0x7845: 0x77FD,
    0x7872: 0x5CEA,
    0x7874: 0x82B1,
    0x787A: 0x971B,
    0x788D: 0x7919,
    0x78AF: 0x7459,
    0x78B5: 0x78CC,
    0x78C6: 0x9AA8,
    0x793C: 0x79AE,
    0x7962: 0x79B0,
    0x7977: 0x79B1,
    0x7980: 0x7A1F,
    0x7984: 0x797F,
    0x7985: 0x79AA,
    0x799D: 0x7A37,
    0x79F0: 0x7A31,
    0x7A0E: 0x7A05,
    0x7A32: 0x7A3B,
    0x7A3E: 0x7A3F,
    0x7A42: 0x7A57,
    0x7A49: 0x7A1A,
    0x7A4F: 0x7A69,
    0x7A50: 0x79CB,
    0x7A63: 0x7A70,
    0x7A7D: 0x9631,
    0x7A83: 0x7ACA,
    0x7A93: 0x7A97,
    0x7AB0: 0x7AAF,
    0x7AC3: 0x7076,
    0x7AC8: 0x7076,
    0x7AD2: 0x5947,
    0x7AD3: 0x860D,
    0x7ADA: 0x4F47,
    0x7ADC: 0x9F8D,
    0x7ADD: 0x4E26,
    0x7AE2: 0x4FDF,
    0x7AE7: 0x8D46,
    0x7AEA: 0x8C4E,
    0x7AF8: 0x7AF6,
    0x7B02: 0x8284,
    0x7B0B: 0x7B4D,
    0x7B36: 0x77E2,
    0x7B39: 0x5C5C,
    0x7B51: 0x7BC9,
    0x7B5D: 0x7B8F,
    0x7B6C: 0x837F,
    0x7B7A: 0x7B50,
    0x7B86: 0x83CE,
    0x7B92: 0x5E1A,
    0x7B9A: 0x5284,
    0x7B9E: 0x83E4,
    0x7B9F: 0x83CE,
    0x7BAA: 0x7C1E,
    0x7BCF: 0x5D4C,
    0x7BED: 0x7C60,
    0x7C12: 0x7BE1,
    0x7C14: 0x7C11,
    0x7C17: 0x7BC9,
    0x7C4F: 0x65D7,
    0x7C56: 0x7C64,
    0x7C58: 0x7C50,
    0x7C7E: 0x9DD4,
    0x7C83: 0x79D5,
    0x7C8B: 0x7CB9,
    0x7C9B: 0x8085,
    0x7CA4: 0x7CB5,
    0x7CAE: 0x7CE7,
    0x7CC0: 0x82B1,
    0x7CC2: 0x7CDD,
    0x7CD8: 0x7A3C,
    0x7CFA: 0x7CFE,
    0x7D48: 0x5E15,
    0x7D4B: 0x7E8A,
    0x7D4C: 0x7D93,
    0x7D75: 0x7E6A,
    0x7D76: 0x7D55,
    0x7D89: 0x7E61,
    0x7D99: 0x7E7C,
    0x7D9A: 0x7E8C,
    0x7DAB: 0x7DDA,
    0x7DCF: 0x7E3D,
    0x7DD1: 0x7DA0,
    0x7DD6: 0x7DD2,
    0x7DDC: 0x7DBF,
    0x7DE4: 0x7D32,
    0x7E01: 0x7DE3,
    0x7E04: 0x7E69,
    0x7E26: 0x7E31,
    0x7E4A: 0x7E96,
    0x7E4B: 0x7E6B,
    0x7E4D: 0x7E61,
    0x7E66: 0x7E48,
    0x7E7F: 0x8964,
    0x7E89: 0x7E98,
    0x7E8E: 0x7E96,
    0x7E92: 0x7E8F,
    0x7F47: 0x6A3D,
    0x7F4E: 0x7F48,
    0x7F51: 0x7DB2,
    0x7F78: 0x7F70,
    0x7FA1: 0x7FA8,
    0x7FA3: 0x7FA4,
    0x7FAE: 0x7FB9,
    0x7FC6: 0x7FE0,
    0x803B: 0x6065,
    0x805F: 0x5A7F,
    0x8061: 0x8070,
    0x8068: 0x806F,
    0x8074: 0x807D,
    0x80AC: 0x75A3,
    0x80C6: 0x81BD,
    0x8107: 0x8105,
    0x8109: 0x8108,
    0x811A: 0x8173,
    0x8131: 0x812B,
    0x8133: 0x8166,
    0x8193: 0x8178,
    0x81B8: 0x9AD3,
    0x81C8: 0x81D8,
    0x81D3: 0x81DF,
    0x820E: 0x820D,
    0x8217: 0x8216,
    0x8218: 0x9928,
    0x8229: 0x8239,
    0x822E: 0x826B,
    0x8262: 0x6F81,
    0x826A: 0x6AD3,
    0x8276: 0x8277,
    0x82A6: 0x8606,
    0x82C5: 0x5208,
    0x82F9: 0x860B,
    0x8303: 0x7BC4,
    0x830E: 0x8396,
    0x8318: 0x8354,
    0x8350: 0x85A6,
    0x8358: 0x838A,
    0x8362: 0x83B8,
    0x8385: 0x849E,
    0x839F: 0x83E1,
    0x83B1: 0x840A,
    0x83B5: 0x83DF,
    0x83D3: 0x679C,
    0x83F7: 0x5E1A,
    0x8462: 0x84CB,
    0x8471: 0x8525,
    0x848B: 0x8523,
    0x84AD: 0x6964,
    0x84DA: 0x84E8,
    0x8535: 0x85CF,
    0x854B: 0x854A,
    0x855A: 0x843C,
    0x8597: 0x5712,
    0x85AB: 0x85B0,
    0x85AC: 0x85E5,
    0x85AE: 0x85EA,
    0x85C1: 0x69C1,
    0x85C1: 0x7A3F,
    0x8602: 0x854A,
    0x8613: 0x8607,
    0x8616: 0x6AF1,
    0x862F: 0x8569,
    0x8630: 0x7E35,
    0x865A: 0x865B,
    0x866B: 0x87F2,
    0x8695: 0x8836,
    0x86AB: 0x9B91,
    0x86CD: 0x87A2,
    0x86CE: 0x8823,
    0x86EE: 0x883B,
    0x86EF: 0x8766,
    0x8749: 0x87EC,
    0x874B: 0x881F,
    0x874E: 0x880D,
    0x877F: 0x8805,
    0x87C7: 0x87C6,
    0x8807: 0x8823,
    0x880E: 0x87D2,
    0x880F: 0x87F9,
    0x8827: 0x8839,
    0x8842: 0x8844,
    0x8846: 0x773E,
    0x885E: 0x885B,
    0x88AE: 0x5AFE,
    0x88B4: 0x8932,
    0x88B5: 0x887D,
    0x88BF: 0x8902,
    0x88C4: 0x7D4E,
    0x88C5: 0x88DD,
    0x88F5: 0x88F4,
    0x891D: 0x894C,
    0x8941: 0x7E48,
    0x8943: 0x8912,
    0x894D: 0x96DC,
    0x8977: 0x718E,
    0x8987: 0x9738,
    0x898A: 0x7F88,
    0x899A: 0x89BA,
    0x89A7: 0x89BD,
    0x89A9: 0x7779,
    0x89B3: 0x89C0,
    0x89E6: 0x89F8,
    0x89E7: 0x89E3,
    0x8A33: 0x8B6F,
    0x8A37: 0x547B,
    0x8A89: 0x8B7D,
    0x8AAC: 0x8AAA,
    0x8AAD: 0x8B80,
    0x8ACC: 0x8AEB,
    0x8ADA: 0x97FF,
    0x8B0C: 0x6B4C,
    0x8B21: 0x8B20,
    0x8B4C: 0x8A1B,
    0x8B5B: 0x8B56,
    0x8B71: 0x5584,
    0x8B72: 0x8B93,
    0x8B83: 0x8B9A,
    0x8B90: 0x4EC7,
    0x8C37: 0x7A40,
    0x8C7C: 0x8C94,
    0x8C8E: 0x730A,
    0x8CAD: 0x8CEA,
    0x8CAE: 0x8CB3,
    0x8CCD: 0x8D13,
    0x8CCE: 0x8CE4,
    0x8CDB: 0x8D0A,
    0x8D0B: 0x8D17,
    0x8D12: 0x8CE2,
    0x8D71: 0x8D70,
    0x8D76: 0x8D95,
    0x8DD6: 0x8E60,
    0x8DF5: 0x8E10,
    0x8E08: 0x758F,
    0x8E0A: 0x8E34,
    0x8E2A: 0x8E64,
    0x8E99: 0x8EAA,
    0x8EAF: 0x8EC0,
    0x8EB0: 0x9AD4,
    0x8EB1: 0x8EB2,
    0x8EC6: 0x9AD4,
    0x8EE2: 0x8F49,
    0x8EE3: 0x8F5F,
    0x8EFD: 0x8F15,
    0x8F0C: 0x8F1B,
    0x8F19: 0x8F12,
    0x8F5C: 0x99AA,
    0x8F9E: 0x8FAD,
    0x8FA7: 0x8FA8,
    0x8FBA: 0x908A,
    0x8FE9: 0x9087,
    0x8FEF: 0x9003,
    0x8FF9: 0x8DE1,
    0x900E: 0x9052,
    0x9013: 0x905E,
    0x9039: 0x9054,
    0x9045: 0x9072,
    0x9056: 0x5583,
    0x9061: 0x6EAF,
    0x9065: 0x9059,
    0x9089: 0x908A,
    0x90A8: 0x9E37,
    0x90C1: 0x9B31,
    0x90DE: 0x90CE,
    0x90F7: 0x9109,
    0x9115: 0x9109,
    0x9154: 0x9189,
    0x9197: 0x91B1,
    0x91A4: 0x91AC,
    0x91B8: 0x91C0,
    0x91C8: 0x91CB,
    0x91CC: 0x88CF,
    0x91D6: 0x6364,
    0x91E1: 0x91DC,
    0x91E5: 0x7936,
    0x91F6: 0x82F9,
    0x91FC: 0x5203,
    0x920E: 0x9264,
    0x922C: 0x9438,
    0x923C: 0x805B,
    0x9244: 0x9435,
    0x9262: 0x7F3D,
    0x9271: 0x7926,
    0x9277: 0x7CED,
    0x92AD: 0x9322,
    0x92ED: 0x92B3,
    0x92F2: 0x59C9,
    0x92F3: 0x9444,
    0x932C: 0x934A,
    0x9332: 0x9304,
    0x9348: 0x7CB8,
    0x936E: 0x63F8,
    0x93AD: 0x93AE,
    0x93C6: 0x9475,
    0x93E5: 0x92B9,
    0x941A: 0x930F,
    0x9421: 0x9435,
    0x9441: 0x9350,
    0x9453: 0x9397,
    0x945A: 0x947D,
    0x945B: 0x7926,
    0x9587: 0x9589,
    0x9596: 0x53A2,
    0x9599: 0x9B27,
    0x95A0: 0x958F,
    0x95A2: 0x95DC,
    0x95A7: 0x9B28,
    0x95B2: 0x95B1,
    0x95D8: 0x9B25,
    0x9665: 0x9677,
    0x9666: 0x5CF6,
    0x967A: 0x96AA,
    0x968F: 0x96A8,
    0x969D: 0x5CF6,
    0x96A0: 0x96B1,
    0x96A3: 0x9130,
    0x96AF: 0x5CF6,
    0x96B2: 0x9A2D,
    0x96B6: 0x64C0,
    0x96B6: 0x96B8,
    0x96B7: 0x96B8,
    0x96D1: 0x96DC,
    0x970A: 0x9748,
    0x9751: 0x9752,
    0x9755: 0x6B63,
    0x9759: 0x975C,
    0x9764: 0x76B0,
    0x976D: 0x97CC,
    0x9771: 0x97CC,
    0x97B4: 0x97DD,
    0x97B4: 0x99E0,
    0x97C8: 0x896A,
    0x97EE: 0x97ED,
    0x97F2: 0x9F4F,
    0x97F5: 0x97FB,
    0x981A: 0x9838,
    0x982C: 0x9830,
    0x9834: 0x7A4E,
    0x983C: 0x8CF4,
    0x983D: 0x9839,
    0x984B: 0x816E,
    0x9854: 0x984F,
    0x9855: 0x986F,
    0x98C3: 0x98C4,
    0x98DC: 0x7FFB,
    0x98EE: 0x98F2,
    0x991D: 0x98FE,
    0x9920: 0x9905,
    0x9942: 0x5EBD,
    0x99BC: 0x7B29,
    0x99C4: 0x99B1,
    0x99C5: 0x9A5B,
    0x99C6: 0x9A45,
    0x99C8: 0x9A45,
    0x9A12: 0x9A37,
    0x9A13: 0x9A57,
    0x9A28: 0x9A52,
    0x9AC4: 0x9AD3,
    0x9AD9: 0x9AD8,
    0x9AE2: 0x9B04,
    0x9AEA: 0x9AEE,
    0x9AF4: 0x62C2,
    0x9B2A: 0x9B25,
    0x9B72: 0x9C78,
    0x9B83: 0x8E75,
    0x9B8E: 0x9BF0,
    0x9B8F: 0x8165,
    0x9B97: 0x8492,
    0x9B9F: 0x55B9,
    0x9BCF: 0x54DA,
    0x9BF1: 0x6119,
    0x9C00: 0x9BC7,
    0x9C0A: 0x7E65,
    0x9C0C: 0x9C0D,
    0x9C10: 0x9C77,
    0x9C15: 0x8766,
    0x9C1B: 0x9EA2,
    0x9C2E: 0x9EA2,
    0x9C2F: 0x676B,
    0x9C3A: 0x61C0,
    0x9CEB: 0x96C1,
    0x9CEC: 0x9CE7,
    0x9D0E: 0x9DD7,
    0x9D2A: 0x9D25,
    0x9D2C: 0x9DAF,
    0x9D44: 0x9D1F,
    0x9D50: 0x9373,
    0x9D5E: 0x9D5D,
    0x9D8F: 0x96DE,
    0x9DAB: 0x99A4,
    0x9DC4: 0x96DE,
    0x9DC6: 0x9DCF,
    0x9E78: 0x9E7C,
    0x9EA6: 0x9EA5,
    0x9EAA: 0x9EB5,
    0x9EB8: 0x9EA9,
    0x9EB9: 0x9EB4,
    0x9EBA: 0x9EB5,
    0x9EBF: 0x7E3B,
    0x9EC4: 0x9EC3,
    0x9ED2: 0x9ED1,
    0x9ED9: 0x9ED8,
    0x9F08: 0x9C49,
    0x9F21: 0x9F20,
    0x9F62: 0x9F61,
    0x9F9D: 0x79CB,
    0xF9DC: 0x9686,
    0xFA10: 0x585A,
    0xFA11: 0x5D0E,
    0xFA12: 0x6674,
    0xFA14: 0x6AF8,
    0xFA15: 0x51DE,
    0xFA16: 0x8C6C,
    0xFA17: 0x76CA,
    0xFA18: 0x79AE,
    0xFA19: 0x795E,
    0xFA1A: 0x7965,
    0xFA1B: 0x798F,
    0xFA1C: 0x9756,
    0xFA1D: 0x7CBE,
    0xFA1E: 0x7FBD,
    0xFA22: 0x8AF8,
    0xFA25: 0x9038,
    0xFA26: 0x90FD,
    0xFA29: 0x5CF6,
    0xFA2A: 0x98EF,
    0xFA2B: 0x98FC,
    0xFA2C: 0x9928,
    0xFA2D: 0x9DB4,
}

Kanji2Simp_Table = {
    0x2015: 0x2500,
    0x2033: 0x3003,
    0x2211: 0x03A3,
    0x2227: 0x039B,
    0x2228: 0xFF36,
    0x2312: 0xFE35,
    0x2501: 0x2500,
    0x2503: 0x2502,
    0x250F: 0x250C,
    0x2513: 0x2510,
    0x2517: 0x2514,
    0x251B: 0x2518,
    0x251D: 0x255E,
    0x2520: 0x251C,
    0x2523: 0x251C,
    0x2525: 0x2561,
    0x2528: 0x2524,
    0x252B: 0x2524,
    0x252F: 0x252C,
    0x2530: 0x252C,
    0x2533: 0x252C,
    0x2537: 0x2534,
    0x2538: 0x2534,
    0x253B: 0x2534,
    0x253F: 0x256A,
    0x2542: 0x253C,
    0x254B: 0x253C,
    0x3013: 0x2550,
    0x30FB: 0xFF0E,
    0x3231: 0x682A,
    0x3232: 0x6709,
    0x3239: 0x4EE3,
    0x4E17: 0x4E16,
    0x4E21: 0x4E24,
    0x4E26: 0x5E76,
    0x4E28: 0x4E85,
    0x4E36: 0x3001,
    0x4E55: 0x864E,
    0x4E57: 0x4E58,
    0x4E62: 0x4E10,
    0x4E7E: 0x5E72,
    0x4E80: 0x9F9F,
    0x4E82: 0x4E71,
    0x4E8A: 0x4E8B,
    0x4E99: 0x4E98,
    0x4E9C: 0x4E9A,
    0x4E9E: 0x4E9A,
    0x4EB0: 0x4EAC,
    0x4ECF: 0x4F5B,
    0x4EED: 0x4EDE,
    0x4EEE: 0x5047,
    0x4EFC: 0x4EFB,
    0x4F03: 0x52F2,
    0x4F1C: 0x5005,
    0x4F47: 0x4F2B,
    0x4F75: 0x5E76,
    0x4F86: 0x6765,
    0x4F8A: 0x89E5,
    0x4F96: 0x4ED1,
    0x4FA1: 0x4EF7,
    0x4FAB: 0x4F5E,
    0x4FAD: 0x5C3D,
    0x4FB6: 0x4FA3,
    0x4FC2: 0x7CFB,
    0x4FE4: 0x7CF5,
    0x4FE5: 0x86CD,
    0x4FFF: 0x864E,
    0x5006: 0x4FE9,
    0x5009: 0x4ED3,
    0x500B: 0x4E2A,
    0x5011: 0x4EEC,
    0x5016: 0x5E78,
    0x5023: 0x4EFF,
    0x5024: 0x503C,
    0x502B: 0x4F26,
    0x5036: 0x4FF1,
    0x5039: 0x4FED,
    0x5042: 0x524D,
    0x5049: 0x4F1F,
    0x5050: 0x8D5D,
    0x5056: 0x9987,
    0x5074: 0x4FA7,
    0x5075: 0x4FA6,
    0x5078: 0x5077,
    0x507D: 0x4F2A,
    0x5091: 0x6770,
    0x5098: 0x4F1E,
    0x5099: 0x5907,
    0x509A: 0x6548,
    0x50AD: 0x4F63,
    0x50B3: 0x4F20,
    0x50B4: 0x4F1B,
    0x50B5: 0x503A,
    0x50B7: 0x4F24,
    0x50BE: 0x503E,
    0x50C2: 0x507B,
    0x50C5: 0x4EC5,
    0x50C9: 0x4F65,
    0x50CD: 0x52A8,
    0x50D1: 0x4FA8,
    0x50D5: 0x4EC6,
    0x50D8: 0x655E,
    0x50DE: 0x4F2A,
    0x50E5: 0x4FA5,
    0x50F4: 0x50E9,
    0x50F9: 0x4EF7,
    0x5100: 0x4EEA,
    0x5101: 0x4FCA,
    0x5102: 0x4FAC,
    0x5104: 0x4EBF,
    0x5109: 0x4FED,
    0x5114: 0x4FE6,
    0x5115: 0x4FAA,
    0x5116: 0x6EE5,
    0x5118: 0x5C3D,
    0x511F: 0x507F,
    0x512A: 0x4F18,
    0x5132: 0x50A8,
    0x5137: 0x4FEA,
    0x513A: 0x50A9,
    0x513B: 0x50A5,
    0x513C: 0x4FE8,
    0x5147: 0x51F6,
    0x514A: 0x5151,
    0x514C: 0x5151,
    0x514E: 0x5154,
    0x5150: 0x513F,
    0x5152: 0x513F,
    0x5164: 0x6643,
    0x5169: 0x4E24,
    0x516A: 0x4FDE,
    0x5186: 0x5706,
    0x518A: 0x518C,
    0x5190: 0x5192,
    0x519D: 0x5B9C,
    0x51A6: 0x5BC7,
    0x51A8: 0x5BCC,
    0x51A9: 0x5199,
    0x51AA: 0x5E42,
    0x51B4: 0x51B1,
    0x51CD: 0x51BB,
    0x51D6: 0x51C6,
    0x51DC: 0x51DB,
    0x51E6: 0x5904,
    0x51EC: 0x98CE,
    0x51F1: 0x51EF,
    0x51FE: 0x51FD,
    0x5204: 0x5203,
    0x520B: 0x520A,
    0x5215: 0x52A6,
    0x5225: 0x522B,
    0x5227: 0x52AB,
    0x522A: 0x5220,
    0x5239: 0x524E,
    0x5244: 0x522D,
    0x5247: 0x5219,
    0x524B: 0x514B,
    0x524F: 0x5231,
    0x525B: 0x521A,
    0x5263: 0x5251,
    0x5264: 0x5242,
    0x5270: 0x5269,
    0x5271: 0x5251,
    0x5273: 0x672D,
    0x5274: 0x5240,
    0x5275: 0x521B,
    0x5283: 0x5212,
    0x5287: 0x5267,
    0x5289: 0x5218,
    0x528D: 0x5251,
    0x5291: 0x5242,
    0x5292: 0x5251,
    0x5294: 0x5251,
    0x52B4: 0x52B3,
    0x52B5: 0x5238,
    0x52B9: 0x6548,
    0x52C1: 0x52B2,
    0x52C5: 0x6555,
    0x52D5: 0x52A8,
    0x52D7: 0x52D6,
    0x52D9: 0x52A1,
    0x52DB: 0x52CB,
    0x52DD: 0x80DC,
    0x52DE: 0x52B3,
    0x52E0: 0x622E,
    0x52E2: 0x52BF,
    0x52E3: 0x7EE9,
    0x52E6: 0x527F,
    0x52E7: 0x529D,
    0x52F2: 0x52CB,
    0x52F3: 0x52CB,
    0x52F5: 0x52B1,
    0x52F8: 0x529D,
    0x5301: 0x4E24,
    0x5302: 0x5308,
    0x5324: 0x5323,
    0x532F: 0x6C47,
    0x5331: 0x532E,
    0x5333: 0x5941,
    0x5338: 0x531A,
    0x5340: 0x533A,
    0x5346: 0x5352,
    0x5354: 0x534F,
    0x5358: 0x5355,
    0x537B: 0x5374,
    0x5393: 0x5D16,
    0x53A0: 0x5395,
    0x53AD: 0x538C,
    0x53B0: 0x5382,
    0x53B2: 0x5389,
    0x53B3: 0x4E25,
    0x53C3: 0x53C2,
    0x53CE: 0x6536,
    0x53E2: 0x4E1B,
    0x53F6: 0x534F,
    0x5442: 0x5415,
    0x5449: 0x5434,
    0x5451: 0x541E,
    0x545F: 0x7384,
    0x546A: 0x5492,
    0x548A: 0x548C,
    0x549C: 0x8421,
    0x54B2: 0x7B11,
    0x54BC: 0x5459,
    0x54D8: 0x884C,
    0x54E1: 0x5458,
    0x54E2: 0x5494,
    0x5504: 0x5457,
    0x5516: 0x54D1,
    0x5538: 0x5FF5,
    0x554C: 0x54B3,
    0x554F: 0x95EE,
    0x5553: 0x542F,
    0x5557: 0x5556,
    0x555D: 0x7FC6,
    0x5563: 0x8854,
    0x5586: 0x54F2,
    0x559A: 0x5524,
    0x559E: 0x5527,
    0x55A9: 0x55BB,
    0x55AA: 0x4E27,
    0x55AB: 0x5403,
    0x55AC: 0x4E54,
    0x55AE: 0x5355,
    0x55B0: 0x98E7,
    0x55B6: 0x8425,
    0x55C7: 0x556C,
    0x55DA: 0x545C,
    0x5606: 0x53F9,
    0x5614: 0x5455,
    0x5616: 0x5567,
    0x5617: 0x5C1D,
    0x5629: 0x54D7,
    0x562F: 0x5578,
    0x5638: 0x5452,
    0x5650: 0x5668,
    0x565B: 0x556E,
    0x5674: 0x55B7,
    0x5678: 0x5428,
    0x567A: 0x66B3,
    0x5680: 0x549B,
    0x5687: 0x5413,
    0x568A: 0x55C5,
    0x5694: 0x568F,
    0x56A0: 0x6D4F,
    0x56A2: 0x56CA,
    0x56A5: 0x54BD,
    0x56AE: 0x5411,
    0x56B4: 0x4E25,
    0x56B6: 0x5624,
    0x56C0: 0x556D,
    0x56C1: 0x55EB,
    0x56C2: 0x56A3,
    0x56C8: 0x5453,
    0x56CE: 0x8D60,
    0x56D1: 0x5631,
    0x56D8: 0x56DE,
    0x56E3: 0x56E2,
    0x56F2: 0x56F4,
    0x56F3: 0x56FE,
    0x5700: 0x56FD,
    0x570B: 0x56FD,
    0x570D: 0x56F4,
    0x570F: 0x5708,
    0x5712: 0x56ED,
    0x5713: 0x5706,
    0x5716: 0x56FE,
    0x5718: 0x56E2,
    0x5727: 0x538B,
    0x5742: 0x962A,
    0x5759: 0x5DE0,
    0x577F: 0x72B6,
    0x5788: 0x708B,
    0x57AA: 0x93D3,
    0x57C0: 0x5782,
    0x57C8: 0x5CFB,
    0x57D3: 0x57D2,
    0x57D6: 0x82B1,
    0x57F7: 0x6267,
    0x5805: 0x575A,
    0x580A: 0x57A9,
    0x581D: 0x57DA,
    0x582F: 0x5C27,
    0x5831: 0x62A5,
    0x5834: 0x573A,
    0x583A: 0x754C,
    0x5840: 0x64E5,
    0x5841: 0x5792,
    0x584A: 0x5757,
    0x584B: 0x8314,
    0x5852: 0x57D8,
    0x5857: 0x6D82,
    0x585A: 0x51A2,
    0x5862: 0x575E,
    0x5869: 0x76D0,
    0x5870: 0x6D77,
    0x5872: 0x573A,
    0x5875: 0x5C18,
    0x5879: 0x5811,
    0x5897: 0x589E,
    0x589C: 0x5760,
    0x58AE: 0x5815,
    0x58B2: 0x5893,
    0x58B3: 0x575F,
    0x58B9: 0x95F4,
    0x58BB: 0x5899,
    0x58BE: 0x57A6,
    0x58C7: 0x575B,
    0x58CA: 0x574F,
    0x58CC: 0x58E4,
    0x58D3: 0x538B,
    0x58D8: 0x5792,
    0x58D9: 0x5739,
    0x58DC: 0x575B,
    0x58DE: 0x574F,
    0x58DF: 0x5784,
    0x58E5: 0x5EDB,
    0x58EF: 0x58EE,
    0x58F1: 0x58F9,
    0x58F2: 0x5356,
    0x58F7: 0x58F6,
    0x58FA: 0x58F6,
    0x58FB: 0x5A7F,
    0x58FC: 0x58F8,
    0x58FD: 0x5BFF,
    0x5902: 0x8C32,
    0x5909: 0x53D8,
    0x5918: 0x536F,
    0x591B: 0x591A,
    0x5922: 0x68A6,
    0x5925: 0x4F19,
    0x5932: 0x672C,
    0x593E: 0x5939,
    0x5950: 0x5942,
    0x5967: 0x5965,
    0x5968: 0x5956,
    0x5969: 0x5941,
    0x596A: 0x593A,
    0x596C: 0x5956,
    0x596E: 0x594B,
    0x599B: 0x5AB8,
    0x599D: 0x5986,
    0x59AC: 0x5992,
    0x59C9: 0x59CA,
    0x59D9: 0x598A,
    0x59E6: 0x5978,
    0x59EA: 0x4F84,
    0x59EB: 0x59EC,
    0x5A1A: 0x5583,
    0x5A2F: 0x5A31,
    0x5A41: 0x5A04,
    0x5A66: 0x5987,
    0x5A6C: 0x6DEB,
    0x5ABC: 0x5AAA,
    0x5ABD: 0x5988,
    0x5ACB: 0x8885,
    0x5AD7: 0x59AA,
    0x5AFA: 0x5A34,
    0x5AFB: 0x5A34,
    0x5B0B: 0x5A75,
    0x5B0C: 0x5A07,
    0x5B22: 0x5A18,
    0x5B2A: 0x5AD4,
    0x5B30: 0x5A74,
    0x5B3E: 0x61D2,
    0x5B43: 0x5A18,
    0x5B6B: 0x5B59,
    0x5B78: 0x5B66,
    0x5B8D: 0x8089,
    0x5B9F: 0x5B9E,
    0x5BAE: 0x5BAB,
    0x5BC3: 0x51A4,
    0x5BC9: 0x9E64,
    0x5BDB: 0x5BBD,
    0x5BE2: 0x5BDD,
    0x5BE6: 0x5B9E,
    0x5BE7: 0x5B81,
    0x5BE9: 0x5BA1,
    0x5BEB: 0x5199,
    0x5BEC: 0x5BBD,
    0x5BF3: 0x5B9D,
    0x5BF5: 0x5BA0,
    0x5BF6: 0x5B9D,
    0x5BFE: 0x5BF9,
    0x5C02: 0x4E13,
    0x5C05: 0x514B,
    0x5C07: 0x5C06,
    0x5C08: 0x4E13,
    0x5C0B: 0x5BFB,
    0x5C0D: 0x5BF9,
    0x5C0E: 0x5BFC,
    0x5C13: 0x5C14,
    0x5C1E: 0x71CE,
    0x5C20: 0x9C9C,
    0x5C2D: 0x5C27,
    0x5C46: 0x5C4A,
    0x5C4D: 0x5C38,
    0x5C53: 0x5C43,
    0x5C64: 0x5C42,
    0x5C6C: 0x5C5E,
    0x5C76: 0x4F1A,
    0x5CA1: 0x5188,
    0x5CBA: 0x5CAD,
    0x5CBB: 0x577B,
    0x5CBC: 0x576A,
    0x5CBE: 0x576B,
    0x5CE0: 0x5361,
    0x5CE9: 0x5CE8,
    0x5CEF: 0x5CF0,
    0x5CF5: 0x5D58,
    0x5CF6: 0x5C9B,
    0x5CFA: 0x57C2,
    0x5CFD: 0x5CE1,
    0x5D11: 0x6606,
    0x5D15: 0x5D16,
    0x5D17: 0x5C97,
    0x5D18: 0x4ED1,
    0x5D19: 0x4ED1,
    0x5D22: 0x5CE5,
    0x5D50: 0x5C9A,
    0x5D53: 0x5CA9,
    0x5D5C: 0x5D0E,
    0x5D73: 0x5D6F,
    0x5D84: 0x5D2D,
    0x5D87: 0x5C96,
    0x5D8B: 0x5D68,
    0x5D8C: 0x5C9B,
    0x5D90: 0x9686,
    0x5DA2: 0x5CE3,
    0x5DAE: 0x5D04,
    0x5DB8: 0x5D58,
    0x5DB9: 0x5C9B,
    0x5DBA: 0x5CAD,
    0x5DBC: 0x5C7F,
    0x5DBD: 0x5CB3,
    0x5DCC: 0x5CA9,
    0x5DD2: 0x5CE6,
    0x5DD3: 0x5DC5,
    0x5DD6: 0x5CA9,
    0x5DE3: 0x5DE2,
    0x5DF5: 0x536E,
    0x5DFB: 0x5377,
    0x5E0B: 0x7EB8,
    0x5E25: 0x5E05,
    0x5E2B: 0x5E08,
    0x5E2F: 0x5E26,
    0x5E30: 0x5F52,
    0x5E33: 0x5E10,
    0x5E36: 0x5E26,
    0x5E40: 0x5E27,
    0x5E43: 0x5E0F,
    0x5E47: 0x5E2E,
    0x5E57: 0x5E3C,
    0x5E5F: 0x5E1C,
    0x5E63: 0x5E01,
    0x5E64: 0x5E01,
    0x5E79: 0x5E72,
    0x5E7E: 0x51E0,
    0x5E81: 0x5385,
    0x5E83: 0x5E7F,
    0x5EAB: 0x5E93,
    0x5EC1: 0x5395,
    0x5EC2: 0x53A2,
    0x5EC3: 0x5E9F,
    0x5EC8: 0x53A6,
    0x5ECF: 0x53A9,
    0x5ED0: 0x53A9,
    0x5EDA: 0x53A8,
    0x5EDD: 0x53AE,
    0x5EDF: 0x5E99,
    0x5EE0: 0x5382,
    0x5EE1: 0x5E91,
    0x5EE2: 0x5E9F,
    0x5EE3: 0x5E7F,
    0x5EE9: 0x5EEA,
    0x5EEC: 0x5E90,
    0x5EF0: 0x5385,
    0x5EF3: 0x5385,
    0x5EF8: 0x8FEA,
    0x5EFB: 0x56DE,
    0x5EFC: 0x4E43,
    0x5F09: 0x5958,
    0x5F0C: 0x58F9,
    0x5F0D: 0x8D30,
    0x5F10: 0x8D30,
    0x5F11: 0x5F12,
    0x5F14: 0x540A,
    0x5F21: 0x5F20,
    0x5F35: 0x5F20,
    0x5F37: 0x5F3A,
    0x5F3E: 0x5F39,
    0x5F48: 0x5F39,
    0x5F4A: 0x5F3A,
    0x5F4C: 0x5F25,
    0x5F4E: 0x5F2F,
    0x5F51: 0x8FB9,
    0x5F59: 0x6C47,
    0x5F5C: 0x5F5D,
    0x5F6B: 0x96D5,
    0x5F7F: 0x4F5B,
    0x5F83: 0x5F80,
    0x5F8C: 0x540E,
    0x5F91: 0x5F84,
    0x5F93: 0x4ECE,
    0x5F9E: 0x4ECE,
    0x5FA0: 0x5F95,
    0x5FA9: 0x590D,
    0x5FB3: 0x5FB7,
    0x5FB4: 0x5F81,
    0x5FB9: 0x5F7B,
    0x5FDC: 0x5E94,
    0x5FF0: 0x60B4,
    0x6031: 0x5306,
    0x603A: 0x607F,
    0x6046: 0x6052,
    0x6060: 0x602A,
    0x6065: 0x803B,
    0x6075: 0x60E0,
    0x6077: 0x6058,
    0x6085: 0x60A6,
    0x608B: 0x541D,
    0x60A7: 0x5788,
    0x60A9: 0x607C,
    0x60AA: 0x6076,
    0x60B3: 0x5FB7,
    0x60B5: 0x6005,
    0x60B6: 0x95F7,
    0x60BD: 0x51C4,
    0x60DE: 0x6B23,
    0x60E1: 0x6076,
    0x60E3: 0x5A61,
    0x60F1: 0x607C,
    0x60F2: 0x607D,
    0x60FB: 0x607B,
    0x6111: 0x6080,
    0x611B: 0x7231,
    0x6121: 0x5306,
    0x6128: 0x60AB,
    0x6130: 0x7DFE,
    0x6134: 0x6006,
    0x6137: 0x607A,
    0x613C: 0x614E,
    0x613D: 0x535A,
    0x613E: 0x5FFE,
    0x6142: 0x607F,
    0x6144: 0x6817,
    0x6147: 0x6BB7,
    0x614B: 0x6001,
    0x614D: 0x6120,
    0x6158: 0x60E8,
    0x6159: 0x60ED,
    0x615A: 0x60ED,
    0x615F: 0x6078,
    0x6163: 0x60EF,
    0x616B: 0x6002,
    0x616E: 0x8651,
    0x616F: 0x4F24,
    0x6173: 0x60AD,
    0x6174: 0x6151,
    0x6176: 0x5E86,
    0x617E: 0x6B32,
    0x6182: 0x5FE7,
    0x6187: 0x61A9,
    0x618A: 0x60EB,
    0x6190: 0x601C,
    0x6191: 0x51ED,
    0x6196: 0x616D,
    0x6198: 0x51A2,
    0x6199: 0x559C,
    0x619A: 0x60EE,
    0x61A4: 0x6124,
    0x61AB: 0x60AF,
    0x61AE: 0x6003,
    0x61B2: 0x5BAA,
    0x61B6: 0x5FC6,
    0x61C7: 0x6073,
    0x61C9: 0x5E94,
    0x61CC: 0x603F,
    0x61CD: 0x61D4,
    0x61D0: 0x6000,
    0x61E3: 0x61D1,
    0x61F2: 0x60E9,
    0x61F4: 0x5FCF,
    0x61F6: 0x61D2,
    0x61F7: 0x6000,
    0x61F8: 0x60AC,
    0x61FA: 0x5FCF,
    0x61FC: 0x60E7,
    0x61FD: 0x6B22,
    0x61FE: 0x6151,
    0x6200: 0x604B,
    0x6213: 0x6216,
    0x6214: 0x620B,
    0x621D: 0x8D3C,
    0x621E: 0x621B,
    0x6226: 0x6218,
    0x622F: 0x620F,
    0x6230: 0x6218,
    0x6232: 0x620F,
    0x6238: 0x6237,
    0x623B: 0x623E,
    0x6255: 0x62C2,
    0x629C: 0x62D4,
    0x629E: 0x62E9,
    0x62A6: 0x79C9,
    0x62DD: 0x62DC,
    0x62E0: 0x636E,
    0x62E1: 0x6269,
    0x6319: 0x4E3E,
    0x6327: 0x7FBD,
    0x633E: 0x631F,
    0x633F: 0x63D2,
    0x635C: 0x641C,
    0x6368: 0x820D,
    0x636B: 0x626A,
    0x6372: 0x5377,
    0x6383: 0x626B,
    0x639B: 0x6302,
    0x63A1: 0x91C7,
    0x63B2: 0x63ED,
    0x63B5: 0x547D,
    0x63BB: 0x6414,
    0x63C0: 0x62E3,
    0x63DA: 0x626C,
    0x63DB: 0x6362,
    0x63EE: 0x6325,
    0x63FA: 0x6447,
    0x6406: 0x6784,
    0x640D: 0x635F,
    0x6416: 0x6447,
    0x6417: 0x6363,
    0x6436: 0x62A2,
    0x643E: 0x69A8,
    0x6442: 0x6444,
    0x646F: 0x631A,
    0x6476: 0x629F,
    0x647A: 0x6298,
    0x6483: 0x51FB,
    0x6488: 0x635E,
    0x6493: 0x6320,
    0x649A: 0x637B,
    0x64A5: 0x62E8,
    0x64AB: 0x629A,
    0x64B2: 0x6251,
    0x64B9: 0x6405,
    0x64BB: 0x631E,
    0x64C1: 0x62E5,
    0x64C7: 0x62E9,
    0x64D4: 0x62C5,
    0x64DA: 0x636E,
    0x64E0: 0x6324,
    0x64E1: 0x62AC,
    0x64E3: 0x6363,
    0x64E7: 0x4E3E,
    0x64EC: 0x62DF,
    0x64EF: 0x6448,
    0x64F1: 0x6401,
    0x64F2: 0x63B7,
    0x64F4: 0x6269,
    0x64FA: 0x6446,
    0x64FE: 0x6270,
    0x6505: 0x6512,
    0x651C: 0x643A,
    0x651D: 0x6444,
    0x6523: 0x631B,
    0x6524: 0x644A,
    0x652A: 0x6405,
    0x652C: 0x63FD,
    0x6535: 0x590A,
    0x6537: 0x8003,
    0x654D: 0x53D9,
    0x654E: 0x6559,
    0x6557: 0x8D25,
    0x6558: 0x53D9,
    0x6575: 0x654C,
    0x6578: 0x6570,
    0x6582: 0x655B,
    0x6583: 0x6BD9,
    0x6588: 0x5B66,
    0x6589: 0x9F50,
    0x658E: 0x658B,
    0x65AC: 0x65A9,
    0x65B7: 0x65AD,
    0x65BC: 0x4E8E,
    0x65D9: 0x65DB,
    0x65E0: 0x75C3,
    0x6607: 0x5347,
    0x661E: 0x663A,
    0x663B: 0x6602,
    0x663F: 0x65F7,
    0x6642: 0x65F6,
    0x6644: 0x6643,
    0x6649: 0x664B,
    0x6657: 0x7F12,
    0x665D: 0x663C,
    0x6667: 0x7693,
    0x6669: 0x665A,
    0x6673: 0x6670,
    0x6681: 0x6653,
    0x6683: 0x7F6A,
    0x6688: 0x6655,
    0x6689: 0x6656,
    0x668E: 0x6BCE,
    0x6698: 0x65F8,
    0x66A2: 0x7545,
    0x66A6: 0x5386,
    0x66AB: 0x6682,
    0x66BF: 0x6DB1,
    0x66C1: 0x66A8,
    0x66C4: 0x6654,
    0x66C7: 0x6619,
    0x66C9: 0x6653,
    0x66D6: 0x66A7,
    0x66E0: 0x65F7,
    0x66F5: 0x66F3,
    0x66F8: 0x4E66,
    0x66FA: 0x66F9,
    0x66FD: 0x66FE,
    0x6703: 0x4F1A,
    0x670E: 0x6EDB,
    0x6716: 0x6717,
    0x671E: 0x671F,
    0x6727: 0x80E7,
    0x6736: 0x6735,
    0x6771: 0x4E1C,
    0x67A0: 0x6866,
    0x67A6: 0x680C,
    0x67A9: 0x677E,
    0x67B4: 0x62D0,
    0x67F5: 0x6805,
    0x67FB: 0x67E5,
    0x67FE: 0x67E9,
    0x6801: 0x67F3,
    0x6802: 0x6885,
    0x6804: 0x8363,
    0x6822: 0x67CF,
    0x6852: 0x6851,
    0x6859: 0x6A21,
    0x685C: 0x6A31,
    0x685D: 0x821B,
    0x685F: 0x6808,
    0x687F: 0x6746,
    0x688D: 0x7682,
    0x6894: 0x6800,
    0x689D: 0x6761,
    0x689F: 0x67AD,
    0x68B1: 0x6346,
    0x68B6: 0x7DD1,
    0x68B9: 0x69DF,
    0x68C4: 0x5F03,
    0x68CA: 0x68CB,
    0x68D7: 0x67A3,
    0x68DF: 0x680B,
    0x68E7: 0x6808,
    0x68F2: 0x6816,
    0x6900: 0x7897,
    0x690F: 0x6860,
    0x6919: 0x660C,
    0x691A: 0x64AF,
    0x691C: 0x68C0,
    0x6922: 0x69F6,
    0x6923: 0x5178,
    0x6926: 0x684A,
    0x6928: 0x5E9C,
    0x6936: 0x68D5,
    0x694A: 0x6768,
    0x6953: 0x67AB,
    0x6955: 0x692D,
    0x6961: 0x6986,
    0x6968: 0x6862,
    0x696D: 0x4E1A,
    0x6973: 0x6885,
    0x6975: 0x6781,
    0x697D: 0x4E50,
    0x698A: 0x67DB,
    0x6998: 0x8845,
    0x69AE: 0x8363,
    0x69BF: 0x6864,
    0x69C3: 0x76D8,
    0x69C7: 0x69D9,
    0x69CB: 0x6784,
    0x69CD: 0x67AA,
    0x69D3: 0x6760,
    0x69D8: 0x6837,
    0x69DD: 0x5C9B,
    0x69DE: 0x680A,
    0x69E7: 0x6920,
    0x69E8: 0x6901,
    0x69F9: 0x69D4,
    0x6A02: 0x4E50,
    0x6A05: 0x679E,
    0x6A0B: 0x901A,
    0x6A12: 0x6993,
    0x6A13: 0x697C,
    0x6A19: 0x6807,
    0x6A1E: 0x67A2,
    0x6A22: 0x8311,
    0x6A23: 0x6837,
    0x6A29: 0x6743,
    0x6A2B: 0x9CD9,
    0x6A2E: 0x68C2,
    0x6A38: 0x6734,
    0x6A39: 0x6811,
    0x6A3A: 0x6866,
    0x6A48: 0x6861,
    0x6A4B: 0x6865,
    0x6A5F: 0x673A,
    0x6A62: 0x692D,
    0x6A6B: 0x6A2A,
    0x6A72: 0x559C,
    0x6A9C: 0x6867,
    0x6AA2: 0x68C0,
    0x6AA3: 0x6A2F,
    0x6AAA: 0x680E,
    0x6AAE: 0x68BC,
    0x6AB3: 0x69DF,
    0x6AB8: 0x67E0,
    0x6ABB: 0x69DB,
    0x6AC1: 0x6993,
    0x6AC2: 0x68F9,
    0x6AC3: 0x67DC,
    0x6AD3: 0x6A79,
    0x6ADA: 0x6988,
    0x6ADB: 0x6809,
    0x6ADE: 0x6A7C,
    0x6ADF: 0x680E,
    0x6AE8: 0x680C,
    0x6AEA: 0x67A5,
    0x6AFA: 0x68C2,
    0x6AFB: 0x6A31,
    0x6B04: 0x680F,
    0x6B05: 0x6989,
    0x6B0A: 0x6743,
    0x6B12: 0x683E,
    0x6B16: 0x6984,
    0x6B1D: 0x90C1,
    0x6B1F: 0x7F50,
    0x6B3D: 0x94A6,
    0x6B4E: 0x53F9,
    0x6B50: 0x6B27,
    0x6B53: 0x6B22,
    0x6B5B: 0x655B,
    0x6B5F: 0x6B24,
    0x6B61: 0x6B22,
    0x6B69: 0x6B65,
    0x6B6F: 0x9F7F,
    0x6B73: 0x5C81,
    0x6B74: 0x5386,
    0x6B78: 0x5F52,
    0x6B7F: 0x6B81,
    0x6B98: 0x6B8B,
    0x6B9E: 0x6B92,
    0x6BA4: 0x6B87,
    0x6BAB: 0x6B9A,
    0x6BAF: 0x6BA1,
    0x6BB1: 0x6B7C,
    0x6BB2: 0x6B7C,
    0x6BBA: 0x6740,
    0x6BBB: 0x58F3,
    0x6BBC: 0x58F3,
    0x6BC0: 0x6BC1,
    0x6BC6: 0x6BB4,
    0x6BCE: 0x6BCF,
    0x6BEC: 0x7403,
    0x6C08: 0x6BE1,
    0x6C17: 0x6C14,
    0x6C23: 0x6C14,
    0x6C37: 0x51B0,
    0x6C3E: 0x6CDB,
    0x6C4E: 0x6CDB,
    0x6C5A: 0x6C61,
    0x6C7A: 0x51B3,
    0x6C8D: 0x51B1,
    0x6C92: 0x6CA1,
    0x6C96: 0x51B2,
    0x6CA2: 0x6CFD,
    0x6CC1: 0x51B5,
    0x6D29: 0x6CC4,
    0x6D36: 0x6C79,
    0x6D44: 0x51C0,
    0x6D5C: 0x6EE8,
    0x6D79: 0x6D43,
    0x6D87: 0x6CFE,
    0x6D96: 0x8385,
    0x6D99: 0x6CEA,
    0x6D9C: 0x6E0E,
    0x6DBC: 0x51C9,
    0x6DD2: 0x51C4,
    0x6DE8: 0x51C0,
    0x6DEA: 0x6CA6,
    0x6DF5: 0x6E0A,
    0x6DF8: 0x6E05,
    0x6DFA: 0x6D45,
    0x6E07: 0x6E34,
    0x6E08: 0x6D4E,
    0x6E09: 0x6D89,
    0x6E0B: 0x6DA9,
    0x6E13: 0x6EAA,
    0x6E15: 0x6E0A,
    0x6E19: 0x6DA3,
    0x6E1B: 0x51CF,
    0x6E26: 0x6DA1,
    0x6E2C: 0x6D4B,
    0x6E3E: 0x6D51,
    0x6E4A: 0x51D1,
    0x6E67: 0x6D8C,
    0x6E6F: 0x6C64,
    0x6E76: 0x5263,
    0x6E80: 0x6EE1,
    0x6E8C: 0x6CFC,
    0x6E96: 0x51C6,
    0x6E9D: 0x6C9F,
    0x6EC4: 0x6CA7,
    0x6EC5: 0x706D,
    0x6ECC: 0x6DA4,
    0x6EDD: 0x6CF7,
    0x6EEC: 0x6CAA,
    0x6EEF: 0x6EDE,
    0x6EF2: 0x6E17,
    0x6EF7: 0x5364,
    0x6EF8: 0x6D52,
    0x6EFE: 0x6EDA,
    0x6EFF: 0x6EE1,
    0x6F01: 0x6E14,
    0x6F11: 0x6E89,
    0x6F22: 0x6C49,
    0x6F23: 0x6D9F,
    0x6F2C: 0x6E0D,
    0x6F32: 0x6DA8,
    0x6F38: 0x6E10,
    0x6F3F: 0x6D46,
    0x6F41: 0x988D,
    0x6F45: 0x704C,
    0x6F54: 0x6D01,
    0x6F5B: 0x6F5C,
    0x6F5F: 0x8204,
    0x6F64: 0x6DA6,
    0x6F6F: 0x6D54,
    0x6F70: 0x6E83,
    0x6F80: 0x6DA9,
    0x6F81: 0x6DA9,
    0x6F82: 0x6F84,
    0x6F86: 0x6D47,
    0x6F91: 0x6E9C,
    0x6F97: 0x6DA7,
    0x6FA4: 0x6CFD,
    0x6FB1: 0x6DC0,
    0x6FC1: 0x6D4A,
    0x6FC3: 0x6D53,
    0x6FD4: 0x6CB5,
    0x6FD5: 0x6E7F,
    0x6FD8: 0x6CDE,
    0x6FDB: 0x8499,
    0x6FDF: 0x6D4E,
    0x6FE4: 0x6D9B,
    0x6FEB: 0x6EE5,
    0x6FEC: 0x6D5A,
    0x6FF1: 0x6EE8,
    0x6FF3: 0x6F5C,
    0x6FF6: 0x9614,
    0x6FFA: 0x6E85,
    0x6FFE: 0x6EE4,
    0x7005: 0x6EE2,
    0x7009: 0x6CFB,
    0x700B: 0x6E16,
    0x700F: 0x6D4F,
    0x7015: 0x6FD2,
    0x7018: 0x6CF8,
    0x701D: 0x6CA5,
    0x701E: 0x6A36,
    0x701F: 0x6F47,
    0x7026: 0x6F74,
    0x7027: 0x6CF7,
    0x7028: 0x6FD1,
    0x702C: 0x6FD1,
    0x7030: 0x5F25,
    0x7032: 0x6F4B,
    0x703E: 0x6F9C,
    0x7051: 0x6D12,
    0x7058: 0x6EE9,
    0x7063: 0x6E7E,
    0x707D: 0x707E,
    0x70BA: 0x4E3A,
    0x70BB: 0x9A26,
    0x70CF: 0x4E4C,
    0x70F1: 0x70AF,
    0x7114: 0x7130,
    0x7121: 0x65E0,
    0x713C: 0x70E7,
    0x7146: 0x7145,
    0x7147: 0x8F89,
    0x7149: 0x70BC,
    0x7155: 0x7199,
    0x7156: 0x6696,
    0x7159: 0x70DF,
    0x7162: 0x8315,
    0x7165: 0x7115,
    0x7169: 0x70E6,
    0x716C: 0x7080,
    0x7188: 0x7199,
    0x71B1: 0x70ED,
    0x71BE: 0x70BD,
    0x71C1: 0x70E8,
    0x71C8: 0x706F,
    0x71C9: 0x7096,
    0x71D0: 0x78F7,
    0x71D2: 0x70E7,
    0x71D7: 0x70C2,
    0x71DF: 0x8425,
    0x71E6: 0x707F,
    0x71EC: 0x6BC1,
    0x71ED: 0x70DB,
    0x71F5: 0x5008,
    0x71FB: 0x718F,
    0x71FC: 0x70EC,
    0x71FE: 0x7118,
    0x71FF: 0x8000,
    0x720D: 0x70C1,
    0x7210: 0x7089,
    0x721B: 0x70C2,
    0x722D: 0x4E89,
    0x7232: 0x4E3A,
    0x723A: 0x7237,
    0x723C: 0x4FCE,
    0x723E: 0x5C14,
    0x723F: 0x4E2C,
    0x7240: 0x5E8A,
    0x7246: 0x5899,
    0x724B: 0x7B3A,
    0x7258: 0x724D,
    0x7274: 0x62B5,
    0x727D: 0x7275,
    0x7282: 0x7281,
    0x7287: 0x5954,
    0x7296: 0x8366,
    0x72A0: 0x727A,
    0x72A2: 0x728A,
    0x72A7: 0x727A,
    0x72B2: 0x8C7A,
    0x72BE: 0x72AC,
    0x72E2: 0x8C89,
    0x72F9: 0x72ED,
    0x72FD: 0x72C8,
    0x731F: 0x730E,
    0x732F: 0x8C92,
    0x7336: 0x72B9,
    0x7344: 0x72F1,
    0x7345: 0x72EE,
    0x734E: 0x5956,
    0x734F: 0x8C98,
    0x7363: 0x517D,
    0x7368: 0x72EC,
    0x736A: 0x72EF,
    0x7370: 0x72DE,
    0x7372: 0x83B7,
    0x7375: 0x730E,
    0x7377: 0x72B7,
    0x7378: 0x517D,
    0x737A: 0x736D,
    0x737B: 0x732E,
    0x73C9: 0x6725,
    0x73CE: 0x73CD,
    0x73EE: 0x4F69,
    0x73F1: 0x748E,
    0x73FE: 0x73B0,
    0x743A: 0x73D0,
    0x743F: 0x73F2,
    0x7460: 0x7409,
    0x7463: 0x7410,
    0x7464: 0x7476,
    0x7469: 0x83B9,
    0x746A: 0x739B,
    0x746F: 0x7405,
    0x7489: 0x740F,
    0x74A2: 0x7409,
    0x74B0: 0x73AF,
    0x74BD: 0x73BA,
    0x74CA: 0x743C,
    0x74CF: 0x73D1,
    0x74D4: 0x748E,
    0x7501: 0x74F6,
    0x750C: 0x74EF,
    0x750E: 0x7816,
    0x7515: 0x74EE,
    0x751E: 0x5C1D,
    0x7523: 0x4EA7,
    0x7526: 0x82CF,
    0x752F: 0x5B81,
    0x753C: 0x753A,
    0x7544: 0x7559,
    0x7546: 0x4EA9,
    0x754A: 0x8015,
    0x754D: 0x754C,
    0x755D: 0x4EA9,
    0x7560: 0x575B,
    0x7562: 0x6BD5,
    0x7567: 0x7565,
    0x756B: 0x753B,
    0x756D: 0x756C,
    0x7570: 0x5F02,
    0x7573: 0x8FED,
    0x7576: 0x5F53,
    0x7582: 0x8FED,
    0x7587: 0x7574,
    0x7589: 0x8FED,
    0x758A: 0x8FED,
    0x758E: 0x758F,
    0x75B1: 0x5E96,
    0x75C3: 0x9938,
    0x75D9: 0x75C9,
    0x75E9: 0x7626,
    0x75FA: 0x75F9,
    0x7609: 0x6108,
    0x760B: 0x75AF,
    0x760D: 0x75A1,
    0x7621: 0x75AE,
    0x7627: 0x759F,
    0x763B: 0x7618,
    0x7642: 0x7597,
    0x7646: 0x75E8,
    0x7647: 0x75EB,
    0x7652: 0x6108,
    0x7658: 0x75A0,
    0x7661: 0x75F4,
    0x7662: 0x75D2,
    0x7667: 0x569F,
    0x7667: 0x75AC,
    0x7669: 0x765E,
    0x766C: 0x7663,
    0x7670: 0x75C8,
    0x7672: 0x766B,
    0x767A: 0x53D1,
    0x767C: 0x53D1,
    0x7680: 0x7682,
    0x7683: 0x8C8C,
    0x7690: 0x768B,
    0x769A: 0x7691,
    0x76B0: 0x75B1,
    0x76B7: 0x9F13,
    0x76B8: 0x76B2,
    0x76B9: 0x76B2,
    0x76BA: 0x76B1,
    0x76C3: 0x676F,
    0x76DC: 0x76D7,
    0x76DE: 0x76CF,
    0x76E1: 0x5C3D,
    0x76E3: 0x76D1,
    0x76E4: 0x76D8,
    0x76E7: 0x5362,
    0x76EA: 0x8361,
    0x770C: 0x53BF,
    0x771E: 0x771F,
    0x7725: 0x7726,
    0x779E: 0x7792,
    0x77BC: 0x7751,
    0x77C7: 0x8499,
    0x77DA: 0x77A9,
    0x77EF: 0x77EB,
    0x7815: 0x788E,
    0x7832: 0x70AE,
    0x783F: 0x77FF,
    0x7864: 0x7856,
    0x786F: 0x781A,
    0x7872: 0x5CEA,
    0x7874: 0x82B1,
    0x787A: 0x7075,
    0x78A9: 0x7855,
    0x78AF: 0x7459,
    0x78B5: 0x78CC,
    0x78BA: 0x786E,
    0x78BC: 0x7801,
    0x78C6: 0x9AA8,
    0x78D0: 0x76D8,
    0x78D1: 0x7859,
    0x78DA: 0x7816,
    0x78E7: 0x789B,
    0x78EF: 0x77F6,
    0x78FD: 0x7857,
    0x790E: 0x7840,
    0x7919: 0x788D,
    0x7926: 0x77FF,
    0x792A: 0x783A,
    0x792B: 0x783E,
    0x792C: 0x77FE,
    0x7950: 0x4F51,
    0x7955: 0x79D8,
    0x797F: 0x7984,
    0x798D: 0x7978,
    0x798E: 0x796F,
    0x799D: 0x7A37,
    0x79A6: 0x5FA1,
    0x79AA: 0x7985,
    0x79AE: 0x793C,
    0x79B0: 0x7962,
    0x79BF: 0x79C3,
    0x7A08: 0x79C6,
    0x7A1C: 0x68F1,
    0x7A1F: 0x7980,
    0x7A2E: 0x79CD,
    0x7A31: 0x79F0,
    0x7A32: 0x7A3B,
    0x7A3E: 0x7A3F,
    0x7A40: 0x8C37,
    0x7A42: 0x7A57,
    0x7A49: 0x7A1A,
    0x7A4D: 0x79EF,
    0x7A4E: 0x9896,
    0x7A4F: 0x7A33,
    0x7A50: 0x79CB,
    0x7A61: 0x7A51,
    0x7A62: 0x79FD,
    0x7A63: 0x7A70,
    0x7A69: 0x7A33,
    0x7A6B: 0x83B7,
    0x7A7D: 0x9631,
    0x7A93: 0x7A97,
    0x7AA9: 0x7A9D,
    0x7AAA: 0x6D3C,
    0x7AAE: 0x7A77,
    0x7AAF: 0x7A91,
    0x7AB0: 0x7A91,
    0x7AB6: 0x7AAD,
    0x7ABA: 0x7AA5,
    0x7AC3: 0x7076,
    0x7AC4: 0x7A9C,
    0x7AC5: 0x7A8D,
    0x7AC7: 0x7AA6,
    0x7AC8: 0x7076,
    0x7ACA: 0x7A83,
    0x7AD2: 0x5947,
    0x7AD3: 0x860D,
    0x7ADA: 0x4F2B,
    0x7ADC: 0x9F99,
    0x7ADD: 0x5E76,
    0x7AE2: 0x4FDF,
    0x7AE7: 0x8D46,
    0x7AEA: 0x7AD6,
    0x7AF6: 0x7ADE,
    0x7AF8: 0x7ADE,
    0x7B02: 0x8284,
    0x7B36: 0x77E2,
    0x7B39: 0x5C49,
    0x7B46: 0x7B14,
    0x7B4D: 0x7B0B,
    0x7B67: 0x7B15,
    0x7B6C: 0x837F,
    0x7B7A: 0x7B50,
    0x7B86: 0x83CE,
    0x7B87: 0x4E2A,
    0x7B8B: 0x7B3A,
    0x7B8F: 0x7B5D,
    0x7B92: 0x5E1A,
    0x7B9A: 0x672D,
    0x7B9E: 0x83E4,
    0x7B9F: 0x83CE,
    0x7BC0: 0x8282,
    0x7BC4: 0x8303,
    0x7BC9: 0x7B51,
    0x7BCB: 0x7BA7,
    0x7BCF: 0x5D4C,
    0x7BE0: 0x7B71,
    0x7BE4: 0x7B03,
    0x7BE9: 0x7B5B,
    0x7BED: 0x7B3C,
    0x7BF3: 0x7B5A,
    0x7C00: 0x7BA6,
    0x7C0D: 0x7BD3,
    0x7C11: 0x84D1,
    0x7C12: 0x7BE1,
    0x7C14: 0x84D1,
    0x7C17: 0x7B51,
    0x7C21: 0x7B80,
    0x7C23: 0x7BD1,
    0x7C2B: 0x7BAB,
    0x7C37: 0x6A90,
    0x7C3D: 0x7B7E,
    0x7C3E: 0x5E18,
    0x7C43: 0x7BEE,
    0x7C4C: 0x7B79,
    0x7C4F: 0x65D7,
    0x7C50: 0x85E4,
    0x7C56: 0x7B7E,
    0x7C58: 0x85E4,
    0x7C5F: 0x7C41,
    0x7C60: 0x7B3C,
    0x7C64: 0x7B7E,
    0x7C65: 0x94A5,
    0x7C6C: 0x7BF1,
    0x7C7E: 0x9DD4,
    0x7C83: 0x79D5,
    0x7C8B: 0x7CB9,
    0x7C9B: 0x8083,
    0x7CA7: 0x5986,
    0x7CC0: 0x82B1,
    0x7CC2: 0x7CC1,
    0x7CD8: 0x7A3C,
    0x7CDE: 0x7CAA,
    0x7CE2: 0x6A21,
    0x7CE7: 0x7CAE,
    0x7CF2: 0x7C9D,
    0x7CF4: 0x7C74,
    0x7CF6: 0x7C9C,
    0x7CF8: 0x7E9F,
    0x7CFA: 0x7EA0,
    0x7CFE: 0x7EA0,
    0x7D00: 0x7EAA,
    0x7D02: 0x7EA3,
    0x7D04: 0x7EA6,
    0x7D05: 0x7EA2,
    0x7D06: 0x7EA1,
    0x7D0B: 0x7EB9,
    0x7D0D: 0x7EB3,
    0x7D10: 0x7EBD,
    0x7D14: 0x7EAF,
    0x7D15: 0x7EB0,
    0x7D17: 0x7EB1,
    0x7D18: 0x7EAE,
    0x7D19: 0x7EB8,
    0x7D1A: 0x7EA7,
    0x7D1B: 0x7EB7,
    0x7D1C: 0x7EAD,
    0x7D21: 0x7EBA,
    0x7D2E: 0x624E,
    0x7D30: 0x7EC6,
    0x7D32: 0x7EC1,
    0x7D33: 0x7EC5,
    0x7D35: 0x7EBB,
    0x7D39: 0x7ECD,
    0x7D3A: 0x7EC0,
    0x7D3F: 0x7ED0,
    0x7D42: 0x7EC8,
    0x7D43: 0x5F26,
    0x7D44: 0x7EC4,
    0x7D46: 0x7ECA,
    0x7D48: 0x5E15,
    0x7D4B: 0x7EA9,
    0x7D4C: 0x7ECF,
    0x7D4E: 0x7ED7,
    0x7D4F: 0x7EC1,
    0x7D50: 0x7ED3,
    0x7D5B: 0x7EE6,
    0x7D5E: 0x7EDE,
    0x7D61: 0x7EDC,
    0x7D62: 0x7EDA,
    0x7D66: 0x7ED9,
    0x7D68: 0x7ED2,
    0x7D71: 0x7EDF,
    0x7D72: 0x4E1D,
    0x7D73: 0x7EDB,
    0x7D75: 0x7ED8,
    0x7D76: 0x7EDD,
    0x7D79: 0x7EE2,
    0x7D89: 0x7EE3,
    0x7D8F: 0x7EE5,
    0x7D93: 0x7ECF,
    0x7D99: 0x7EE7,
    0x7D9A: 0x7EED,
    0x7D9C: 0x7EFC,
    0x7DA0: 0x7EFF,
    0x7DA2: 0x7EF8,
    0x7DA3: 0x7EFB,
    0x7DAB: 0x7EBF,
    0x7DAC: 0x7EF6,
    0x7DAD: 0x7EF4,
    0x7DAF: 0x7EF9,
    0x7DB0: 0x7EFE,
    0x7DB1: 0x7EB2,
    0x7DB2: 0x7F51,
    0x7DB4: 0x7F00,
    0x7DB5: 0x5F69,
    0x7DB8: 0x7EB6,
    0x7DBA: 0x7EEE,
    0x7DBB: 0x7EFD,
    0x7DBD: 0x7EF0,
    0x7DBE: 0x7EEB,
    0x7DBF: 0x7EF5,
    0x7DC7: 0x7F01,
    0x7DCA: 0x7D27,
    0x7DCB: 0x7EEF,
    0x7DCF: 0x603B,
    0x7DD1: 0x7EFF,
    0x7DD2: 0x7EEA,
    0x7DD6: 0x7EEA,
    0x7DD8: 0x7F04,
    0x7DDA: 0x7EBF,
    0x7DDC: 0x7EF5,
    0x7DDD: 0x7F09,
    0x7DDE: 0x7F0E,
    0x7DE0: 0x7F14,
    0x7DE1: 0x7F17,
    0x7DE4: 0x7EC1,
    0x7DE8: 0x7F16,
    0x7DE9: 0x7F13,
    0x7DEC: 0x7F05,
    0x7DEF: 0x7EAC,
    0x7DF2: 0x7F08,
    0x7DF4: 0x7EC3,
    0x7DFB: 0x81F4,
    0x7E01: 0x7F18,
    0x7E04: 0x7EF3,
    0x7E09: 0x7F19,
    0x7E0A: 0x7F22,
    0x7E0B: 0x7F12,
    0x7E1B: 0x7F1A,
    0x7E1E: 0x7F1F,
    0x7E1F: 0x7F1B,
    0x7E23: 0x53BF,
    0x7E26: 0x7EB5,
    0x7E2B: 0x7F1D,
    0x7E2E: 0x7F29,
    0x7E31: 0x7EB5,
    0x7E32: 0x7F27,
    0x7E35: 0x7F26,
    0x7E37: 0x7F15,
    0x7E39: 0x7F25,
    0x7E3D: 0x603B,
    0x7E3E: 0x7EE9,
    0x7E43: 0x7EF7,
    0x7E46: 0x7F2A,
    0x7E4A: 0x7EA4,
    0x7E4B: 0x7CFB,
    0x7E4D: 0x7EE3,
    0x7E52: 0x7F2F,
    0x7E54: 0x7EC7,
    0x7E55: 0x7F2E,
    0x7E56: 0x4F1E,
    0x7E59: 0x7FFB,
    0x7E5A: 0x7F2D,
    0x7E5E: 0x7ED5,
    0x7E66: 0x8941,
    0x7E69: 0x7EF3,
    0x7E6A: 0x7ED8,
    0x7E6D: 0x8327,
    0x7E70: 0x7F32,
    0x7E79: 0x7ECE,
    0x7E7C: 0x7EE7,
    0x7E7D: 0x7F24,
    0x7E7F: 0x8934,
    0x7E88: 0x7F2C,
    0x7E89: 0x7F35,
    0x7E8A: 0x7EA9,
    0x7E8C: 0x7EED,
    0x7E8E: 0x7EA4,
    0x7E8F: 0x7F20,
    0x7E92: 0x7F20,
    0x7E93: 0x7F28,
    0x7E96: 0x7EA4,
    0x7E9C: 0x7F06,
    0x7F47: 0x6A3D,
    0x7F4C: 0x7F42,
    0x7F4E: 0x575B,
    0x7F70: 0x7F5A,
    0x7F75: 0x9A82,
    0x7F77: 0x7F62,
    0x7F78: 0x7F5A,
    0x7F85: 0x7F57,
    0x7F86: 0x7F74,
    0x7F88: 0x7F81,
    0x7FA3: 0x7FA4,
    0x7FA8: 0x7FA1,
    0x7FA9: 0x4E49,
    0x7FAE: 0x7FB9,
    0x7FB6: 0x81BB,
    0x7FC6: 0x7FE0,
    0x7FD2: 0x4E60,
    0x7FF9: 0x7FD8,
    0x8021: 0x9504,
    0x8056: 0x5723,
    0x805E: 0x95FB,
    0x805F: 0x5A7F,
    0x8061: 0x806A,
    0x8068: 0x8054,
    0x806F: 0x8054,
    0x8070: 0x806A,
    0x8072: 0x58F0,
    0x8073: 0x8038,
    0x8074: 0x542C,
    0x8076: 0x8042,
    0x8077: 0x804C,
    0x8079: 0x804D,
    0x807D: 0x542C,
    0x807E: 0x804B,
    0x8085: 0x8083,
    0x80AC: 0x75A3,
    0x8105: 0x80C1,
    0x8107: 0x80C1,
    0x8108: 0x8109,
    0x811B: 0x80EB,
    0x8123: 0x5507,
    0x8129: 0x4FEE,
    0x8133: 0x8111,
    0x8139: 0x80C0,
    0x814E: 0x80BE,
    0x8166: 0x8111,
    0x816B: 0x80BF,
    0x8178: 0x80A0,
    0x8183: 0x817D,
    0x8193: 0x80A0,
    0x8195: 0x8158,
    0x819A: 0x80A4,
    0x81A0: 0x80F6,
    0x81A9: 0x817B,
    0x81B8: 0x9AD3,
    0x81BD: 0x80C6,
    0x81BE: 0x810D,
    0x81BF: 0x8113,
    0x81C8: 0x814A,
    0x81C9: 0x8138,
    0x81CD: 0x8110,
    0x81D3: 0x810F,
    0x81D8: 0x814A,
    0x81DA: 0x80EA,
    0x81DF: 0x810F,
    0x81E0: 0x8114,
    0x81E5: 0x5367,
    0x81E8: 0x4E34,
    0x81FA: 0x53F0,
    0x8207: 0x4E0E,
    0x8208: 0x5174,
    0x8209: 0x4E3E,
    0x820A: 0x65E7,
    0x820E: 0x820D,
    0x8216: 0x94FA,
    0x8217: 0x94FA,
    0x8218: 0x9986,
    0x8229: 0x8239,
    0x822E: 0x823B,
    0x8259: 0x8231,
    0x8262: 0x6A2F,
    0x8262: 0x6DA9,
    0x8264: 0x8223,
    0x8266: 0x8230,
    0x826A: 0x6A79,
    0x826B: 0x823B,
    0x8271: 0x8270,
    0x8276: 0x8273,
    0x8277: 0x8273,
    0x8278: 0x8279,
    0x82BB: 0x520D,
    0x82C5: 0x5208,
    0x82E7: 0x82CE,
    0x8318: 0x8354,
    0x8332: 0x5179,
    0x834A: 0x8346,
    0x8358: 0x5E84,
    0x8362: 0x83B8,
    0x838A: 0x5E84,
    0x8396: 0x830E,
    0x839F: 0x83E1,
    0x83A2: 0x835A,
    0x83B5: 0x83DF,
    0x83D3: 0x679C,
    0x83EF: 0x534E,
    0x83F4: 0x5EB5,
    0x83F7: 0x5E1A,
    0x8407: 0x82CC,
    0x842C: 0x4E07,
    0x8435: 0x83B4,
    0x8449: 0x53F6,
    0x8457: 0x7740,
    0x8462: 0x76D6,
    0x8466: 0x82C7,
    0x846F: 0x836F,
    0x8477: 0x8364,
    0x8490: 0x641C,
    0x8494: 0x83B3,
    0x84AD: 0x6964,
    0x84BC: 0x82CD,
    0x84C6: 0x5E2D,
    0x84CB: 0x76D6,
    0x84DA: 0x84E8,
    0x84EE: 0x83B2,
    0x84F4: 0x83BC,
    0x8506: 0x83F1,
    0x8514: 0x535C,
    0x8526: 0x8311,
    0x852D: 0x836B,
    0x8535: 0x85CF,
    0x8541: 0x8368,
    0x854B: 0x854A,
    0x854E: 0x835E,
    0x8553: 0x82B8,
    0x8555: 0x83B8,
    0x8558: 0x835B,
    0x855A: 0x843C,
    0x8569: 0x8361,
    0x856A: 0x829C,
    0x856D: 0x8427,
    0x8577: 0x84E3,
    0x8588: 0x835F,
    0x858A: 0x84DF,
    0x8591: 0x59DC,
    0x8594: 0x8537,
    0x8597: 0x56ED,
    0x85A6: 0x8350,
    0x85A9: 0x8428,
    0x85AB: 0x718F,
    0x85AC: 0x836F,
    0x85B0: 0x718F,
    0x85BA: 0x8360,
    0x85C1: 0x7A3F,
    0x85CD: 0x84DD,
    0x85DD: 0x827A,
    0x85E5: 0x836F,
    0x85EA: 0x85AE,
    0x85F9: 0x853C,
    0x85FA: 0x853A,
    0x8602: 0x854A,
    0x8606: 0x82A6,
    0x8607: 0x82CF,
    0x860A: 0x8574,
    0x860B: 0x82F9,
    0x8613: 0x82CF,
    0x8616: 0x6AF1,
    0x861A: 0x85D3,
    0x8622: 0x830F,
    0x862D: 0x5170,
    0x862F: 0x8361,
    0x8630: 0x7F26,
    0x863F: 0x841D,
    0x8655: 0x5904,
    0x865C: 0x864F,
    0x865F: 0x53F7,
    0x8667: 0x4E8F,
    0x86AB: 0x9C8D,
    0x86CD: 0x8424,
    0x86EF: 0x867E,
    0x86FB: 0x8715,
    0x8706: 0x86AC,
    0x874B: 0x8721,
    0x8755: 0x8680,
    0x875F: 0x732C,
    0x8766: 0x867E,
    0x8768: 0x8671,
    0x8778: 0x8717,
    0x877F: 0x8747,
    0x87A2: 0x8424,
    0x87BB: 0x877C,
    0x87C4: 0x86F0,
    0x87C7: 0x87C6,
    0x87EF: 0x86F2,
    0x87F2: 0x866B,
    0x87F6: 0x86CF,
    0x87FB: 0x8681,
    0x8805: 0x8747,
    0x8807: 0x86CE,
    0x880D: 0x874E,
    0x880E: 0x87D2,
    0x880F: 0x87F9,
    0x8811: 0x877E,
    0x8823: 0x86CE,
    0x8827: 0x8839,
    0x8831: 0x86CA,
    0x8836: 0x8695,
    0x883B: 0x86EE,
    0x8842: 0x8844,
    0x8846: 0x4F17,
    0x8853: 0x672F,
    0x885B: 0x536B,
    0x885D: 0x51B2,
    0x885E: 0x536B,
    0x889E: 0x886E,
    0x88AE: 0x5AFE,
    0x88B4: 0x88E4,
    0x88B5: 0x887D,
    0x88B7: 0x593E,
    0x88BF: 0x8902,
    0x88C4: 0x7ED7,
    0x88CF: 0x91CC,
    0x88DC: 0x8865,
    0x88DD: 0x88C5,
    0x88E1: 0x91CC,
    0x88F5: 0x88F4,
    0x88FD: 0x5236,
    0x8907: 0x590D,
    0x890C: 0x88C8,
    0x891D: 0x894C,
    0x8938: 0x891B,
    0x893B: 0x4EB5,
    0x8943: 0x8912,
    0x894D: 0x6742,
    0x8956: 0x8884,
    0x8960: 0x88C6,
    0x8964: 0x8934,
    0x896A: 0x889C,
    0x896F: 0x886C,
    0x8972: 0x88AD,
    0x8974: 0x8955,
    0x8977: 0x718E,
    0x8987: 0x9738,
    0x8988: 0x6838,
    0x898A: 0x7F81,
    0x898B: 0x89C1,
    0x898F: 0x89C4,
    0x8993: 0x89C5,
    0x8996: 0x89C6,
    0x8998: 0x89C7,
    0x899A: 0x89C9,
    0x89A1: 0x89CB,
    0x89A6: 0x89CE,
    0x89A7: 0x89C8,
    0x89A9: 0x7779,
    0x89AA: 0x4EB2,
    0x89AC: 0x89CA,
    0x89AF: 0x89CF,
    0x89B2: 0x89D0,
    0x89B3: 0x89C2,
    0x89BA: 0x89C9,
    0x89BD: 0x89C8,
    0x89BF: 0x89CC,
    0x89C0: 0x89C2,
    0x89DD: 0x62B5,
    0x89E7: 0x89E3,
    0x89F4: 0x89DE,
    0x89F8: 0x89E6,
    0x8A02: 0x8BA2,
    0x8A03: 0x8BA3,
    0x8A08: 0x8BA1,
    0x8A0A: 0x8BAF,
    0x8A0C: 0x8BA7,
    0x8A0E: 0x8BA8,
    0x8A10: 0x8BA6,
    0x8A12: 0x8BB1,
    0x8A13: 0x8BAD,
    0x8A16: 0x8BAB,
    0x8A17: 0x6258,
    0x8A18: 0x8BB0,
    0x8A1B: 0x8BB9,
    0x8A1D: 0x8BB6,
    0x8A1F: 0x8BBC,
    0x8A23: 0x8BC0,
    0x8A25: 0x8BB7,
    0x8A2A: 0x8BBF,
    0x8A2D: 0x8BBE,
    0x8A31: 0x8BB8,
    0x8A33: 0x8BD1,
    0x8A34: 0x8BC9,
    0x8A36: 0x8BC3,
    0x8A37: 0x547B,
    0x8A3A: 0x8BCA,
    0x8A3B: 0x6CE8,
    0x8A3C: 0x8BC1,
    0x8A41: 0x8BC2,
    0x8A46: 0x8BCB,
    0x8A50: 0x8BC8,
    0x8A52: 0x8BD2,
    0x8A54: 0x8BCF,
    0x8A55: 0x8BC4,
    0x8A5B: 0x8BC5,
    0x8A5E: 0x8BCD,
    0x8A60: 0x548F,
    0x8A62: 0x8BE2,
    0x8A63: 0x8BE3,
    0x8A66: 0x8BD5,
    0x8A69: 0x8BD7,
    0x8A6B: 0x8BE7,
    0x8A6C: 0x8BDF,
    0x8A6D: 0x8BE1,
    0x8A6E: 0x8BE0,
    0x8A70: 0x8BD8,
    0x8A71: 0x8BDD,
    0x8A72: 0x8BE5,
    0x8A73: 0x8BE6,
    0x8A7C: 0x8BD9,
    0x8A84: 0x8BD4,
    0x8A85: 0x8BDB,
    0x8A87: 0x5938,
    0x8A8C: 0x5FD7,
    0x8A8D: 0x8BA4,
    0x8A91: 0x8BF3,
    0x8A95: 0x8BDE,
    0x8A98: 0x8BF1,
    0x8A9A: 0x8BEE,
    0x8A9E: 0x8BED,
    0x8AA0: 0x8BDA,
    0x8AA1: 0x8BEB,
    0x8AA3: 0x8BEC,
    0x8AA4: 0x8BEF,
    0x8AA5: 0x8BF0,
    0x8AA6: 0x8BF5,
    0x8AA8: 0x8BF2,
    0x8AAC: 0x8BF4,
    0x8AAD: 0x8BFB,
    0x8AB0: 0x8C01,
    0x8AB2: 0x8BFE,
    0x8AB9: 0x8BFD,
    0x8ABC: 0x8C0A,
    0x8ABF: 0x8C03,
    0x8AC2: 0x8C04,
    0x8AC4: 0x8C06,
    0x8AC7: 0x8C08,
    0x8ACB: 0x8BF7,
    0x8ACC: 0x8C0F,
    0x8ACD: 0x8BE4,
    0x8ACF: 0x8BF9,
    0x8AD2: 0x8C05,
    0x8AD6: 0x8BBA,
    0x8ADA: 0x54CD,
    0x8ADB: 0x8C00,
    0x8ADC: 0x8C0D,
    0x8ADE: 0x8C1D,
    0x8AE1: 0x8C25,
    0x8AE2: 0x8BE8,
    0x8AE4: 0x8C14,
    0x8AE6: 0x8C1B,
    0x8AE7: 0x8C10,
    0x8AEB: 0x8C0F,
    0x8AED: 0x8C15,
    0x8AEE: 0x8C18,
    0x8AF1: 0x8BB3,
    0x8AF3: 0x8C19,
    0x8AF6: 0x8C0C,
    0x8AF7: 0x8BBD,
    0x8AF8: 0x8BF8,
    0x8AFA: 0x8C1A,
    0x8AFE: 0x8BFA,
    0x8B00: 0x8C0B,
    0x8B01: 0x8C12,
    0x8B02: 0x8C13,
    0x8B04: 0x8A8A,
    0x8B0C: 0x6B4C,
    0x8B0E: 0x8C1C,
    0x8B10: 0x8C27,
    0x8B14: 0x8C11,
    0x8B16: 0x8C21,
    0x8B17: 0x8C24,
    0x8B19: 0x8C26,
    0x8B1A: 0x8C25,
    0x8B1B: 0x8BB2,
    0x8B1D: 0x8C22,
    0x8B20: 0x8C23,
    0x8B21: 0x8C23,
    0x8B28: 0x8C1F,
    0x8B2B: 0x8C2A,
    0x8B2C: 0x8C2C,
    0x8B33: 0x8BB4,
    0x8B39: 0x8C28,
    0x8B3E: 0x8C29,
    0x8B41: 0x54D7,
    0x8B49: 0x8BC1,
    0x8B4C: 0x8BB9,
    0x8B4E: 0x8C32,
    0x8B4F: 0x8BA5,
    0x8B56: 0x8C2E,
    0x8B58: 0x8BC6,
    0x8B5A: 0x8C2D,
    0x8B5B: 0x8C2E,
    0x8B5C: 0x8C31,
    0x8B5F: 0x566A,
    0x8B6B: 0x8C35,
    0x8B6F: 0x8BD1,
    0x8B70: 0x8BAE,
    0x8B71: 0x5584,
    0x8B72: 0x8BA9,
    0x8B74: 0x8C34,
    0x8B77: 0x62A4,
    0x8B7D: 0x8A89,
    0x8B80: 0x8BFB,
    0x8B83: 0x8D5E,
    0x8B8A: 0x53D8,
    0x8B8C: 0x71D5,
    0x8B8E: 0x96E0,
    0x8B90: 0x4EC7,
    0x8B90: 0x96E0,
    0x8B92: 0x8C17,
    0x8B93: 0x8BA9,
    0x8B96: 0x8C36,
    0x8B9A: 0x8D5E,
    0x8C3F: 0x6EAA,
    0x8C48: 0x5C82,
    0x8C4E: 0x7AD6,
    0x8C50: 0x4E30,
    0x8C6C: 0x732A,
    0x8C7C: 0x8C94,
    0x8C8D: 0x72F8,
    0x8C8E: 0x730A,
    0x8C9D: 0x8D1D,
    0x8C9E: 0x8D1E,
    0x8CA0: 0x8D1F,
    0x8CA1: 0x8D22,
    0x8CA2: 0x8D21,
    0x8CA7: 0x8D2B,
    0x8CA8: 0x8D27,
    0x8CA9: 0x8D29,
    0x8CAA: 0x8D2A,
    0x8CAB: 0x8D2F,
    0x8CAC: 0x8D23,
    0x8CAD: 0x8D28,
    0x8CAE: 0x8D30,
    0x8CAF: 0x8D2E,
    0x8CB0: 0x8D33,
    0x8CB2: 0x8D40,
    0x8CB3: 0x8D30,
    0x8CB4: 0x8D35,
    0x8CB6: 0x8D2C,
    0x8CB7: 0x4E70,
    0x8CB8: 0x8D37,
    0x8CBB: 0x8D39,
    0x8CBC: 0x8D34,
    0x8CBD: 0x8D3B,
    0x8CBF: 0x8D38,
    0x8CC0: 0x8D3A,
    0x8CC1: 0x8D32,
    0x8CC2: 0x8D42,
    0x8CC3: 0x8D41,
    0x8CC4: 0x8D3F,
    0x8CC7: 0x8D44,
    0x8CC8: 0x8D3E,
    0x8CCA: 0x8D3C,
    0x8CCD: 0x8D43,
    0x8CCE: 0x8D31,
    0x8CD1: 0x8D48,
    0x8CD3: 0x5BBE,
    0x8CDA: 0x8D49,
    0x8CDB: 0x8D5E,
    0x8CDC: 0x8D50,
    0x8CDE: 0x8D4F,
    0x8CE0: 0x8D54,
    0x8CE2: 0x8D24,
    0x8CE3: 0x5356,
    0x8CE4: 0x8D31,
    0x8CE6: 0x8D4B,
    0x8CEA: 0x8D28,
    0x8CED: 0x8D4C,
    0x8CF4: 0x8D56,
    0x8CFA: 0x8D5A,
    0x8CFB: 0x8D59,
    0x8CFC: 0x8D2D,
    0x8CFD: 0x8D5B,
    0x8D04: 0x8D3D,
    0x8D05: 0x8D58,
    0x8D07: 0x8D5F,
    0x8D08: 0x8D60,
    0x8D0A: 0x8D5E,
    0x8D0B: 0x8D5D,
    0x8D0D: 0x8D61,
    0x8D0F: 0x8D62,
    0x8D10: 0x8D46,
    0x8D12: 0x8D24,
    0x8D13: 0x8D43,
    0x8D14: 0x8D51,
    0x8D16: 0x8D4E,
    0x8D71: 0x8D70,
    0x8D99: 0x8D75,
    0x8DA8: 0x8D8B,
    0x8DE1: 0x8FF9,
    0x8DFC: 0x5C40,
    0x8E08: 0x758F,
    0x8E10: 0x8DF5,
    0x8E34: 0x8E0A,
    0x8E4C: 0x8DC4,
    0x8E55: 0x8DF8,
    0x8E5F: 0x8FF9,
    0x8E60: 0x8DD6,
    0x8E63: 0x8E52,
    0x8E64: 0x8E2A,
    0x8E8A: 0x8E0C,
    0x8E8B: 0x8DFB,
    0x8E8D: 0x8DC3,
    0x8E91: 0x8E2F,
    0x8E93: 0x8E2C,
    0x8E99: 0x8E8F,
    0x8EA1: 0x8E51,
    0x8EAA: 0x8E8F,
    0x8EB0: 0x4F53,
    0x8EB1: 0x8EB2,
    0x8EC6: 0x4F53,
    0x8ECA: 0x8F66,
    0x8ECB: 0x8F67,
    0x8ECC: 0x8F68,
    0x8ECD: 0x519B,
    0x8ED2: 0x8F69,
    0x8EDB: 0x8F6D,
    0x8EDF: 0x8F6F,
    0x8EE2: 0x8F6C,
    0x8EE3: 0x8F70,
    0x8EEB: 0x8F78,
    0x8EF8: 0x8F74,
    0x8EFB: 0x8F72,
    0x8EFC: 0x8F76,
    0x8EFD: 0x8F7B,
    0x8EFE: 0x8F7C,
    0x8F03: 0x8F83,
    0x8F05: 0x8F82,
    0x8F09: 0x8F7D,
    0x8F0A: 0x8F7E,
    0x8F0C: 0x8F86,
    0x8F12: 0x8F84,
    0x8F13: 0x633D,
    0x8F14: 0x8F85,
    0x8F15: 0x8F7B,
    0x8F19: 0x8F84,
    0x8F1B: 0x8F86,
    0x8F1C: 0x8F8E,
    0x8F1D: 0x8F89,
    0x8F1F: 0x8F8D,
    0x8F26: 0x8F87,
    0x8F29: 0x8F88,
    0x8F2A: 0x8F6E,
    0x8F2F: 0x8F91,
    0x8F33: 0x8F8F,
    0x8F38: 0x8F93,
    0x8F3B: 0x8F90,
    0x8F3E: 0x8F97,
    0x8F3F: 0x8206,
    0x8F42: 0x6BC2,
    0x8F44: 0x8F96,
    0x8F45: 0x8F95,
    0x8F46: 0x8F98,
    0x8F49: 0x8F6C,
    0x8F4D: 0x8F99,
    0x8F4E: 0x8F7F,
    0x8F5C: 0x99AA,
    0x8F5F: 0x8F70,
    0x8F61: 0x8F94,
    0x8F62: 0x8F79,
    0x8F64: 0x8F73,
    0x8FA7: 0x8FA8,
    0x8FAD: 0x8F9E,
    0x8FAE: 0x8FAB,
    0x8FAF: 0x8FA9,
    0x8FB2: 0x519C,
    0x8FBA: 0x8FB9,
    0x8FEF: 0x9003,
    0x8FF4: 0x56DE,
    0x8FFA: 0x4E43,
    0x900E: 0x9052,
    0x9013: 0x9012,
    0x9015: 0x5F84,
    0x9019: 0x8FD9,
    0x9023: 0x8FDE,
    0x9031: 0x5468,
    0x9032: 0x8FDB,
    0x9039: 0x8FBE,
    0x9045: 0x8FDF,
    0x904A: 0x6E38,
    0x904B: 0x8FD0,
    0x904E: 0x8FC7,
    0x9054: 0x8FBE,
    0x9055: 0x8FDD,
    0x9056: 0x5583,
    0x9059: 0x9065,
    0x905C: 0x900A,
    0x905E: 0x9012,
    0x9060: 0x8FDC,
    0x9061: 0x6EAF,
    0x9069: 0x9002,
    0x9072: 0x8FDF,
    0x9077: 0x8FC1,
    0x9078: 0x9009,
    0x907A: 0x9057,
    0x907C: 0x8FBD,
    0x9081: 0x8FC8,
    0x9084: 0x8FD8,
    0x9087: 0x8FE9,
    0x9089: 0x8FB9,
    0x908A: 0x8FB9,
    0x908F: 0x903B,
    0x90A8: 0x9E37,
    0x90DE: 0x90CE,
    0x90E4: 0x90C4,
    0x90F5: 0x90AE,
    0x90F7: 0x4E61,
    0x9112: 0x90B9,
    0x9115: 0x4E61,
    0x9115: 0x9109,
    0x9127: 0x9093,
    0x912D: 0x90D1,
    0x9130: 0x90BB,
    0x9132: 0x90F8,
    0x9154: 0x9189,
    0x9197: 0x9166,
    0x919C: 0x4E11,
    0x91A4: 0x9171,
    0x91AB: 0x533B,
    0x91B8: 0x917F,
    0x91C0: 0x917F,
    0x91C1: 0x8845,
    0x91C8: 0x91CA,
    0x91CB: 0x91CA,
    0x91D0: 0x5398,
    0x91D6: 0x6364,
    0x91D7: 0x948A,
    0x91D8: 0x9489,
    0x91DD: 0x9488,
    0x91E1: 0x91DC,
    0x91E3: 0x9493,
    0x91E4: 0x9490,
    0x91E5: 0x7936,
    0x91E6: 0x6263,
    0x91E7: 0x948F,
    0x91F5: 0x9497,
    0x91F6: 0x82F9,
    0x91FC: 0x5203,
    0x920D: 0x949D,
    0x920E: 0x94A9,
    0x9210: 0x94A4,
    0x9211: 0x94A3,
    0x9214: 0x949E,
    0x9215: 0x94AE,
    0x921E: 0x94A7,
    0x922C: 0x94CE,
    0x9234: 0x94C3,
    0x9237: 0x94B4,
    0x9239: 0x94CD,
    0x923A: 0x94B0,
    0x923C: 0x805B,
    0x923F: 0x94BF,
    0x9240: 0x94BE,
    0x9244: 0x94C1,
    0x9248: 0x94CA,
    0x9249: 0x94C9,
    0x924B: 0x5228,
    0x9251: 0x94C2,
    0x9257: 0x94B3,
    0x925A: 0x94C6,
    0x925B: 0x94C5,
    0x925E: 0x94BA,
    0x9262: 0x94B5,
    0x9264: 0x94A9,
    0x9266: 0x94B2,
    0x9271: 0x77FF,
    0x9277: 0x7CED,
    0x9278: 0x94F0,
    0x9280: 0x94F6,
    0x9283: 0x94F3,
    0x9285: 0x94DC,
    0x9291: 0x94E3,
    0x9293: 0x94E8,
    0x9295: 0x94C1,
    0x9296: 0x94E2,
    0x9298: 0x94ED,
    0x929A: 0x94EB,
    0x929B: 0x94E6,
    0x929C: 0x8854,
    0x92AD: 0x94B1,
    0x92B7: 0x9500,
    0x92B9: 0x9508,
    0x92CF: 0x94D7,
    0x92D2: 0x950B,
    0x92D9: 0x94FB,
    0x92E4: 0x9504,
    0x92E9: 0x94D3,
    0x92EA: 0x94FA,
    0x92ED: 0x9510,
    0x92F2: 0x59C9,
    0x92F3: 0x94F8,
    0x92F8: 0x952F,
    0x92FB: 0x9274,
    0x92FC: 0x94A2,
    0x9306: 0x9516,
    0x930F: 0x94D4,
    0x9310: 0x9525,
    0x9318: 0x9524,
    0x9319: 0x9531,
    0x931A: 0x94EE,
    0x9320: 0x952D,
    0x9321: 0x951C,
    0x9322: 0x94B1,
    0x9326: 0x9526,
    0x9328: 0x951A,
    0x932B: 0x9521,
    0x932C: 0x70BC,
    0x932E: 0x9522,
    0x932F: 0x9519,
    0x9332: 0x5F55,
    0x9348: 0x7CB8,
    0x9348: 0x9533,
    0x934B: 0x9505,
    0x934D: 0x9540,
    0x9354: 0x9537,
    0x935B: 0x953B,
    0x9360: 0x953D,
    0x936C: 0x9539,
    0x936E: 0x63F8,
    0x9370: 0x953E,
    0x9375: 0x952E,
    0x937C: 0x9488,
    0x937E: 0x949F,
    0x9394: 0x9555,
    0x9396: 0x9501,
    0x939A: 0x9524,
    0x93A7: 0x94E0,
    0x93AC: 0x9550,
    0x93AD: 0x9547,
    0x93AE: 0x9547,
    0x93B0: 0x9552,
    0x93C3: 0x955E,
    0x93C6: 0x9475,
    0x93C8: 0x94FE,
    0x93D0: 0x9560,
    0x93D1: 0x955D,
    0x93D7: 0x94FF,
    0x93D8: 0x9535,
    0x93DD: 0x9558,
    0x93DE: 0x955B,
    0x93E1: 0x955C,
    0x93E4: 0x9542,
    0x93E5: 0x9508,
    0x93E8: 0x933E,
    0x9403: 0x94D9,
    0x9410: 0x9563,
    0x9413: 0x9566,
    0x9414: 0x9561,
    0x9418: 0x949F,
    0x9419: 0x956B,
    0x941A: 0x94D4,
    0x9421: 0x94C1,
    0x942B: 0x954C,
    0x9435: 0x94C1,
    0x9436: 0x956E,
    0x9438: 0x94CE,
    0x943A: 0x94DB,
    0x9441: 0x9350,
    0x9444: 0x94F8,
    0x9451: 0x9274,
    0x9452: 0x9274,
    0x9453: 0x9397,
    0x945A: 0x94BB,
    0x945B: 0x77FF,
    0x945E: 0x9574,
    0x9460: 0x94C4,
    0x946A: 0x7089,
    0x9470: 0x94A5,
    0x9477: 0x954A,
    0x947C: 0x9523,
    0x947D: 0x94BB,
    0x947E: 0x92AE,
    0x947F: 0x51FF,
    0x9481: 0x9562,
    0x9577: 0x957F,
    0x9580: 0x95E8,
    0x9582: 0x95E9,
    0x9583: 0x95EA,
    0x9587: 0x95ED,
    0x9589: 0x95ED,
    0x958B: 0x5F00,
    0x958F: 0x95F0,
    0x9591: 0x95F2,
    0x9592: 0x95F2,
    0x9593: 0x95F4,
    0x9594: 0x95F5,
    0x9596: 0x53A2,
    0x9598: 0x95F8,
    0x9599: 0x95F9,
    0x95A0: 0x95F0,
    0x95A2: 0x5173,
    0x95A3: 0x9601,
    0x95A4: 0x5408,
    0x95A5: 0x9600,
    0x95A7: 0x54C4,
    0x95A8: 0x95FA,
    0x95AD: 0x95FE,
    0x95B2: 0x9605,
    0x95B9: 0x9609,
    0x95BB: 0x960E,
    0x95BC: 0x960F,
    0x95BE: 0x9608,
    0x95C3: 0x9612,
    0x95CA: 0x9614,
    0x95CC: 0x9611,
    0x95CD: 0x9607,
    0x95D4: 0x9616,
    0x95D5: 0x9619,
    0x95D6: 0x95EF,
    0x95D8: 0x6597,
    0x95DC: 0x5173,
    0x95E1: 0x9610,
    0x95E2: 0x8F9F,
    0x95E5: 0x95FC,
    0x962F: 0x5740,
    0x965D: 0x9655,
    0x965E: 0x5347,
    0x9663: 0x9635,
    0x9665: 0x9677,
    0x9666: 0x5C9B,
    0x9670: 0x9634,
    0x9673: 0x9648,
    0x9678: 0x9646,
    0x967A: 0x9669,
    0x967D: 0x9633,
    0x968A: 0x961F,
    0x968E: 0x9636,
    0x9695: 0x9668,
    0x969B: 0x9645,
    0x969D: 0x5C9B,
    0x96A0: 0x9690,
    0x96A3: 0x90BB,
    0x96A8: 0x968F,
    0x96AA: 0x9669,
    0x96AF: 0x5C9B,
    0x96B1: 0x9690,
    0x96B2: 0x9A98,
    0x96B4: 0x9647,
    0x96B6: 0x64C0,
    0x96B7: 0x96B6,
    0x96B8: 0x96B6,
    0x96BB: 0x53EA,
    0x96CB: 0x96BD,
    0x96D1: 0x6742,
    0x96D6: 0x867D,
    0x96D9: 0x53CC,
    0x96DB: 0x96CF,
    0x96DC: 0x6742,
    0x96E2: 0x79BB,
    0x96E3: 0x96BE,
    0x96F2: 0x4E91,
    0x96FB: 0x7535,
    0x970A: 0x7075,
    0x9711: 0x6CBE,
    0x9724: 0x6E9C,
    0x9727: 0x96FE,
    0x973D: 0x9701,
    0x9742: 0x96F3,
    0x9744: 0x972D,
    0x9746: 0x53C7,
    0x9748: 0x7075,
    0x9749: 0x53C6,
    0x9751: 0x9752,
    0x9755: 0x6B63,
    0x975C: 0x9759,
    0x9764: 0x75B1,
    0x9766: 0x817C,
    0x9768: 0x9765,
    0x976D: 0x97E7,
    0x9771: 0x97E7,
    0x978F: 0x5DE9,
    0x97A6: 0x79CB,
    0x97B4: 0x99E0,
    0x97C3: 0x9791,
    0x97C6: 0x5343,
    0x97C8: 0x889C,
    0x97CB: 0x97E6,
    0x97D3: 0x97E9,
    0x97DC: 0x97EC,
    0x97EE: 0x97ED,
    0x97F2: 0x9F51,
    0x97FB: 0x97F5,
    0x97FF: 0x54CD,
    0x9801: 0x9875,
    0x9802: 0x9876,
    0x9803: 0x9877,
    0x9805: 0x9879,
    0x9806: 0x987A,
    0x9808: 0x987B,
    0x980C: 0x9882,
    0x980F: 0x9883,
    0x9810: 0x9884,
    0x9811: 0x987D,
    0x9812: 0x9881,
    0x9813: 0x987F,
    0x9817: 0x9887,
    0x9818: 0x9886,
    0x981A: 0x9888,
    0x9821: 0x9889,
    0x9824: 0x9890,
    0x982C: 0x988A,
    0x982D: 0x5934,
    0x9834: 0x9895,
    0x9834: 0x9896,
    0x9837: 0x9894,
    0x9838: 0x9888,
    0x983B: 0x9891,
    0x983C: 0x8D56,
    0x983D: 0x9893,
    0x9846: 0x9897,
    0x984B: 0x816E,
    0x984C: 0x9898,
    0x984D: 0x989D,
    0x984E: 0x989A,
    0x984F: 0x989C,
    0x9854: 0x989C,
    0x9855: 0x663E,
    0x9858: 0x613F,
    0x985B: 0x98A0,
    0x985E: 0x7C7B,
    0x9865: 0x98A2,
    0x9867: 0x987E,
    0x986B: 0x98A4,
    0x986F: 0x663E,
    0x9870: 0x98A6,
    0x9871: 0x9885,
    0x9873: 0x989E,
    0x9874: 0x98A7,
    0x98A8: 0x98CE,
    0x98AF: 0x98D2,
    0x98B1: 0x53F0,
    0x98B6: 0x98D3,
    0x98C3: 0x98D8,
    0x98C4: 0x98D8,
    0x98C6: 0x98D9,
    0x98DB: 0x98DE,
    0x98DC: 0x7FFB,
    0x98E2: 0x9965,
    0x98E9: 0x9968,
    0x98EB: 0x996B,
    0x98ED: 0x996C,
    0x98EE: 0x996E,
    0x98EF: 0x996D,
    0x98F2: 0x996E,
    0x98F4: 0x9974,
    0x98FC: 0x9972,
    0x98FD: 0x9971,
    0x98FE: 0x9970,
    0x9903: 0x997A,
    0x9905: 0x997C,
    0x9909: 0x9977,
    0x990A: 0x517B,
    0x990C: 0x9975,
    0x9912: 0x9981,
    0x9913: 0x997F,
    0x9918: 0x4F59,
    0x991D: 0x9970,
    0x991E: 0x996F,
    0x9920: 0x997C,
    0x9921: 0x9985,
    0x9928: 0x9986,
    0x993D: 0x9988,
    0x993E: 0x998F,
    0x9942: 0x5EBD,
    0x9945: 0x9992,
    0x9949: 0x9991,
    0x994B: 0x9988,
    0x994C: 0x9994,
    0x9951: 0x9965,
    0x9952: 0x9976,
    0x9957: 0x98E8,
    0x99AC: 0x9A6C,
    0x99AD: 0x9A6D,
    0x99AE: 0x51AF,
    0x99B3: 0x9A70,
    0x99B4: 0x9A6F,
    0x99BC: 0x7B29,
    0x99C1: 0x9A73,
    0x99C4: 0x9A6E,
    0x99C5: 0x9A7F,
    0x99C6: 0x9A71,
    0x99C8: 0x9A71,
    0x99D0: 0x9A7B,
    0x99D1: 0x9A7D,
    0x99D2: 0x9A79,
    0x99D5: 0x9A7E,
    0x99D8: 0x9A80,
    0x99DB: 0x9A76,
    0x99DD: 0x9A7C,
    0x99DF: 0x9A77,
    0x99E2: 0x9A88,
    0x99ED: 0x9A87,
    0x99EE: 0x9A73,
    0x99F1: 0x9A86,
    0x99F8: 0x9A8E,
    0x99FF: 0x9A8F,
    0x9A01: 0x9A8B,
    0x9A05: 0x9A93,
    0x9A0E: 0x9A91,
    0x9A0F: 0x9A90,
    0x9A12: 0x9A9A,
    0x9A13: 0x9A8C,
    0x9A19: 0x9A97,
    0x9A28: 0x9A52,
    0x9A2B: 0x9A9E,
    0x9A30: 0x817E,
    0x9A37: 0x9A9A,
    0x9A3E: 0x9AA1,
    0x9A40: 0x84E6,
    0x9A42: 0x9A96,
    0x9A43: 0x9AA0,
    0x9A45: 0x9A71,
    0x9A4D: 0x9A81,
    0x9A55: 0x9A84,
    0x9A57: 0x9A8C,
    0x9A5A: 0x60CA,
    0x9A5B: 0x9A7F,
    0x9A5F: 0x9AA4,
    0x9A62: 0x9A74,
    0x9A64: 0x9AA7,
    0x9A65: 0x9AA5,
    0x9A6A: 0x9A8A,
    0x9A6B: 0x9A89,
    0x9AC4: 0x9AD3,
    0x9ACF: 0x9AC5,
    0x9AD4: 0x4F53,
    0x9AD9: 0x9AD8,
    0x9AE2: 0x9B04,
    0x9AEA: 0x53D1,
    0x9AEE: 0x53D1,
    0x9AF4: 0x62C2,
    0x9B06: 0x677E,
    0x9B1A: 0x987B,
    0x9B22: 0x9B13,
    0x9B25: 0x6597,
    0x9B27: 0x95F9,
    0x9B28: 0x54C4,
    0x9B29: 0x960B,
    0x9B2A: 0x6597,
    0x9B2E: 0x9604,
    0x9B31: 0x90C1,
    0x9B4E: 0x9B49,
    0x9B58: 0x9B47,
    0x9B5A: 0x9C7C,
    0x9B6F: 0x9C81,
    0x9B72: 0x9C88,
    0x9B74: 0x9C82,
    0x9B83: 0x8E75,
    0x9B83: 0x9C86,
    0x9B8E: 0x9C87,
    0x9B8E: 0x9CB6,
    0x9B8F: 0x8165,
    0x9B91: 0x9C8D,
    0x9B92: 0x9C8B,
    0x9B93: 0x9C8A,
    0x9B97: 0x8492,
    0x9B9F: 0x55B9,
    0x9BAA: 0x9C94,
    0x9BAB: 0x9C9B,
    0x9BAD: 0x9C91,
    0x9BAE: 0x9C9C,
    0x9BC0: 0x9CA7,
    0x9BC9: 0x9CA4,
    0x9BCA: 0x9CA8,
    0x9BCF: 0x54DA,
    0x9BD2: 0x9CAC,
    0x9BD4: 0x9CBB,
    0x9BD6: 0x9CAD,
    0x9BDB: 0x9CB7,
    0x9BE1: 0x9CB1,
    0x9BE2: 0x9CB5,
    0x9BE4: 0x9CB2,
    0x9BE8: 0x9CB8,
    0x9BF0: 0x9CB6,
    0x9BF1: 0x6119,
    0x9BF5: 0x9CB9,
    0x9C00: 0x9CA9,
    0x9C08: 0x9CBD,
    0x9C09: 0x9CC7,
    0x9C0A: 0x7E65,
    0x9C0C: 0x9CC5,
    0x9C0D: 0x9CC5,
    0x9C10: 0x9CC4,
    0x9C12: 0x9CC6,
    0x9C13: 0x9CC3,
    0x9C15: 0x867E,
    0x9C1B: 0x9CC1,
    0x9C1B: 0x9EA2,
    0x9C25: 0x9CCF,
    0x9C2D: 0x9CCD,
    0x9C2E: 0x9CC1,
    0x9C2E: 0x9EA2,
    0x9C2F: 0x676B,
    0x9C32: 0x9CCC,
    0x9C39: 0x9CA3,
    0x9C3A: 0x61C0,
    0x9C3A: 0x9CB9,
    0x9C3B: 0x9CD7,
    0x9C3E: 0x9CD4,
    0x9C48: 0x9CD5,
    0x9C52: 0x9CDF,
    0x9C57: 0x9CDE,
    0x9C60: 0x9C99,
    0x9C67: 0x9CE2,
    0x9C78: 0x9C88,
    0x9CE5: 0x9E1F,
    0x9CE7: 0x51EB,
    0x9CE9: 0x9E20,
    0x9CEB: 0x96C1,
    0x9CEC: 0x51EB,
    0x9CF3: 0x51E4,
    0x9CF4: 0x9E23,
    0x9CF6: 0x9E22,
    0x9D06: 0x9E29,
    0x9D07: 0x9E28,
    0x9D09: 0x9E26,
    0x9D0E: 0x9E25,
    0x9D12: 0x9E30,
    0x9D15: 0x9E35,
    0x9D1B: 0x9E33,
    0x9D1F: 0x9E31,
    0x9D23: 0x9E2A,
    0x9D26: 0x9E2F,
    0x9D28: 0x9E2D,
    0x9D2A: 0x9D25,
    0x9D2C: 0x83BA,
    0x9D2C: 0x9E34,
    0x9D3B: 0x9E3F,
    0x9D3F: 0x9E3D,
    0x9D44: 0x9E31,
    0x9D50: 0x9373,
    0x9D50: 0x9E40,
    0x9D51: 0x9E43,
    0x9D5C: 0x9E48,
    0x9D5D: 0x9E45,
    0x9D5E: 0x9E45,
    0x9D60: 0x9E44,
    0x9D61: 0x9E49,
    0x9D6C: 0x9E4F,
    0x9D6F: 0x9E4E,
    0x9D72: 0x9E4A,
    0x9D87: 0x9E2B,
    0x9D89: 0x9E51,
    0x9D8F: 0x9E21,
    0x9D9A: 0x9E57,
    0x9DA4: 0x9E4D,
    0x9DA9: 0x9E5C,
    0x9DAB: 0x99A4,
    0x9DAF: 0x83BA,
    0x9DB2: 0x9E5F,
    0x9DB4: 0x9E64,
    0x9DBA: 0x9E61,
    0x9DBB: 0x9E58,
    0x9DC1: 0x9E62,
    0x9DC2: 0x9E5E,
    0x9DC4: 0x9E21,
    0x9DC6: 0x9DCF,
    0x9DD3: 0x9E67,
    0x9DD9: 0x9E37,
    0x9DE6: 0x9E6A,
    0x9DEF: 0x9E69,
    0x9DF2: 0x9E6B,
    0x9DF8: 0x9E6C,
    0x9DF9: 0x9E70,
    0x9DFA: 0x9E6D,
    0x9E1A: 0x9E66,
    0x9E1B: 0x9E73,
    0x9E1E: 0x9E3E,
    0x9E75: 0x5364,
    0x9E78: 0x78B1,
    0x9E79: 0x54B8,
    0x9E7D: 0x76D0,
    0x9E97: 0x4E3D,
    0x9EA5: 0x9EA6,
    0x9EA9: 0x9EB8,
    0x9EAA: 0x9762,
    0x9EB9: 0x66F2,
    0x9EBA: 0x9762,
    0x9EBC: 0x4E48,
    0x9EBF: 0x7E3B,
    0x9ECC: 0x9EC9,
    0x9ED2: 0x9ED1,
    0x9ED9: 0x9ED8,
    0x9EDE: 0x70B9,
    0x9EE8: 0x515A,
    0x9EF4: 0x9709,
    0x9EF6: 0x9EE1,
    0x9EF7: 0x9EE9,
    0x9EFD: 0x9EFE,
    0x9F07: 0x9CCC,
    0x9F08: 0x9CD6,
    0x9F15: 0x51AC,
    0x9F21: 0x9F20,
    0x9F4A: 0x9F50,
    0x9F4B: 0x658B,
    0x9F4E: 0x8D4D,
    0x9F4F: 0x9F51,
    0x9F52: 0x9F7F,
    0x9F54: 0x9F80,
    0x9F5F: 0x9F83,
    0x9F60: 0x9F86,
    0x9F61: 0x9F84,
    0x9F62: 0x9F84,
    0x9F63: 0x51FA,
    0x9F66: 0x9F88,
    0x9F67: 0x556E,
    0x9F6A: 0x9F8A,
    0x9F6C: 0x9F89,
    0x9F72: 0x9F8B,
    0x9F76: 0x816D,
    0x9F77: 0x9F8C,
    0x9F8D: 0x9F99,
    0x9F95: 0x9F9B,
    0x9F9C: 0x9F9F,
    0x9F9D: 0x79CB,
    0xF929: 0x6717,
    0xF9DC: 0x9686,
    0xFA10: 0x51A2,
    0xFA10: 0x585A,
    0xFA11: 0x5D0E,
    0xFA12: 0x6674,
    0xFA14: 0x6989,
    0xFA15: 0x51DE,
    0xFA16: 0x732A,
    0xFA16: 0x8C6C,
    0xFA17: 0x76CA,
    0xFA18: 0x793C,
    0xFA19: 0x795E,
    0xFA1A: 0x7965,
    0xFA1B: 0x798F,
    0xFA1C: 0x9756,
    0xFA1D: 0x7CBE,
    0xFA1E: 0x7FBD,
    0xFA22: 0x8AF8,
    0xFA22: 0x8BF8,
    0xFA25: 0x9038,
    0xFA26: 0x90FD,
    0xFA29: 0x5C9B,
    0xFA2A: 0x98EF,
    0xFA2A: 0x996D,
    0xFA2B: 0x98FC,
    0xFA2B: 0x9972,
    0xFA2C: 0x9928,
    0xFA2C: 0x9986,
    0xFA2D: 0x9DB4,
    0xFA2D: 0x9E64,
    0xFF61: 0x3002,
    0xFF62: 0x300C,
    0xFF63: 0x300D,
    0xFF64: 0x3001,
    0xFF65: 0xFF0E,
    0xFF9E: 0x309B,
    0xFF9F: 0x309C,
}

Chinese2Kanji_Table = {
    0x4E13: 0x5C02,
    0x4E1A: 0x696D,
    0x4E1B: 0x53E2,
    0x4E1C: 0x6771,
    0x4E1D: 0x7D72,
    0x4E24: 0x4E21,
    0x4E25: 0x53B3,
    0x4E27: 0x55AA,
    0x4E30: 0x8C50,
    0x4E34: 0x81E8,
    0x4E3A: 0x70BA,
    0x4E3D: 0x9E97,
    0x4E3E: 0x6319,
    0x4E49: 0x7FA9,
    0x4E4C: 0x70CF,
    0x4E50: 0x697D,
    0x4E54: 0x55AC,
    0x4E58: 0x4E57,
    0x4E61: 0x90F7,
    0x4E66: 0x66F8,
    0x4E70: 0x8CB7,
    0x4E71: 0x4E82,
    0x4E82: 0x4E71,
    0x4E85: 0x4E28,
    0x4E9A: 0x4E9C,
    0x4E9E: 0x4E9C,
    0x4EA7: 0x7523,
    0x4EA9: 0x755D,
    0x4EB2: 0x89AA,
    0x4EB5: 0x893B,
    0x4EBF: 0x5104,
    0x4EC5: 0x50C5,
    0x4ED1: 0x4F96,
    0x4ED3: 0x5009,
    0x4EEA: 0x5100,
    0x4EEC: 0x5011,
    0x4EF7: 0x4FA1,
    0x4EFF: 0x5023,
    0x4F15: 0x592B,
    0x4F17: 0x8846,
    0x4F18: 0x512A,
    0x4F1B: 0x50B4,
    0x4F1E: 0x5098,
    0x4F1F: 0x5049,
    0x4F20: 0x4F1D,
    0x4F21: 0x4FE5,
    0x4F23: 0x4FD4,
    0x4F24: 0x50B7,
    0x4F26: 0x502B,
    0x4F2A: 0x507D,
    0x4F2B: 0x4F47,
    0x4F48: 0x5E03,
    0x4F5B: 0x4ECF,
    0x4F63: 0x50AD,
    0x4F65: 0x50C9,
    0x4F86: 0x6765,
    0x4FA5: 0x50E5,
    0x4FA6: 0x5075,
    0x4FA7: 0x5074,
    0x4FA8: 0x50D1,
    0x4FAA: 0x5115,
    0x4FAC: 0x5102,
    0x4FB7: 0x5C40,
    0x4FC1: 0x4FE3,
    0x4FDE: 0x516A,
    0x4FE0: 0x4FA0,
    0x4FE6: 0x5114,
    0x4FE8: 0x513C,
    0x4FE9: 0x5006,
    0x4FEA: 0x5137,
    0x4FEC: 0x79C1,
    0x4FED: 0x5039,
    0x4FF1: 0x5036,
    0x5008: 0x71F5,
    0x503A: 0x50B5,
    0x503C: 0x5024,
    0x503E: 0x50BE,
    0x5047: 0x4EEE,
    0x506A: 0x903C,
    0x5077: 0x5078,
    0x507B: 0x50C2,
    0x507F: 0x511F,
    0x50A2: 0x5BB6,
    0x50A5: 0x513B,
    0x50A8: 0x5132,
    0x50A9: 0x513A,
    0x50AF: 0x506C,
    0x50E9: 0x50F4,
    0x50F1: 0x96C7,
    0x50F9: 0x4FA1,
    0x5109: 0x5039,
    0x5118: 0x4FAD,
    0x5151: 0x514C,
    0x5152: 0x5150,
    0x5154: 0x514E,
    0x5167: 0x5185,
    0x5169: 0x4E21,
    0x5170: 0x862D,
    0x5173: 0x95A2,
    0x5174: 0x8208,
    0x517B: 0x990A,
    0x517D: 0x7363,
    0x518C: 0x518A,
    0x519B: 0x8ECD,
    0x519C: 0x8FB2,
    0x51AF: 0x99AE,
    0x51B0: 0x6C37,
    0x51B1: 0x51B4,
    0x51BB: 0x51CD,
    0x51C0: 0x6D44,
    0x51C8: 0x6D44,
    0x51DC: 0x51DB,
    0x51DE: 0xFA15,
    0x51E4: 0x9CF3,
    0x51EB: 0x9CEC,
    0x51EF: 0x51F1,
    0x51FB: 0x6483,
    0x51FF: 0x947F,
    0x5212: 0x5283,
    0x5218: 0x5289,
    0x5219: 0x5247,
    0x521A: 0x525B,
    0x521B: 0x5275,
    0x5220: 0x522A,
    0x5228: 0x924B,
    0x522B: 0x5225,
    0x522D: 0x5244,
    0x5231: 0x524F,
    0x5240: 0x5274,
    0x5242: 0x5264,
    0x524E: 0x5239,
    0x5251: 0x5263,
    0x525D: 0x5265,
    0x5263: 0x6E76,
    0x5267: 0x5287,
    0x5269: 0x5270,
    0x5284: 0x5273,
    0x528D: 0x5263,
    0x5291: 0x5264,
    0x529D: 0x52E7,
    0x52A1: 0x52D9,
    0x52A8: 0x52D5,
    0x52B2: 0x52C1,
    0x52B3: 0x52B4,
    0x52BF: 0x52E2,
    0x52CB: 0x52F2,
    0x52DE: 0x52B4,
    0x52F2: 0x4F03,
    0x52F3: 0x52F2,
    0x52F5: 0x52B1,
    0x52F8: 0x52E7,
    0x52FB: 0x5300,
    0x5308: 0x5302,
    0x531A: 0x5338,
    0x532E: 0x5331,
    0x5340: 0x533A,
    0x534E: 0x83EF,
    0x534F: 0x5354,
    0x5355: 0x5358,
    0x5356: 0x58F2,
    0x5361: 0x5CE0,
    0x5362: 0x76E7,
    0x5364: 0x9E75,
    0x5367: 0x81E5,
    0x536B: 0x885B,
    0x5377: 0x5DFB,
    0x5379: 0x6064,
    0x537B: 0x5374,
    0x5385: 0x5E81,
    0x5386: 0x6B74,
    0x5389: 0x53B2,
    0x538C: 0x53AD,
    0x5395: 0x53A0,
    0x53A2: 0x9596,
    0x53BF: 0x770C,
    0x53C3: 0x53C2,
    0x53C6: 0x9749,
    0x53C7: 0x9746,
    0x53D1: 0x767A,
    0x53D8: 0x5909,
    0x53E0: 0x7573,
    0x53F9: 0x5606,
    0x5412: 0x54A4,
    0x541E: 0x5451,
    0x5428: 0x5678,
    0x5433: 0x5449,
    0x5434: 0x5449,
    0x5452: 0x5638,
    0x5453: 0x56C8,
    0x5455: 0x5614,
    0x5457: 0x5504,
    0x5458: 0x54E1,
    0x545C: 0x55DA,
    0x5492: 0x546A,
    0x549B: 0x5680,
    0x54CD: 0x97FF,
    0x54D1: 0x5516,
    0x54D7: 0x5629,
    0x54DA: 0x9BCF,
    0x5524: 0x559A,
    0x5527: 0x559E,
    0x555E: 0x5516,
    0x555F: 0x5553,
    0x5567: 0x5616,
    0x556C: 0x55C7,
    0x556D: 0x56C0,
    0x556E: 0x565B,
    0x5578: 0x562F,
    0x55AE: 0x5358,
    0x55B7: 0x5674,
    0x55B9: 0x9B9F,
    0x55BB: 0x55A9,
    0x55EB: 0x56C1,
    0x55F0: 0x74F1,
    0x5624: 0x56B6,
    0x5641: 0x60AA,
    0x5653: 0x5618,
    0x5699: 0x565B,
    0x569F: 0x7667,
    0x56A3: 0x56C2,
    0x56B4: 0x53B3,
    0x56CA: 0x56A2,
    0x56D1: 0x5631,
    0x56E2: 0x56E3,
    0x56ED: 0x5712,
    0x56F4: 0x56F2,
    0x56FE: 0x56F3,
    0x5706: 0x5713,
    0x5708: 0x570F,
    0x570B: 0x56FD,
    0x570D: 0x56F2,
    0x5716: 0x56F3,
    0x5718: 0x56E3,
    0x5723: 0x8056,
    0x5739: 0x58D9,
    0x573A: 0x5834,
    0x5757: 0x584A,
    0x575A: 0x5805,
    0x575B: 0x58C7,
    0x575E: 0x5862,
    0x575F: 0x58B3,
    0x5760: 0x589C,
    0x576B: 0x5CBE,
    0x5775: 0x4E18,
    0x577B: 0x5CBB,
    0x5784: 0x58DF,
    0x5788: 0x60A7,
    0x5792: 0x5841,
    0x57A6: 0x58BE,
    0x57C2: 0x5CFA,
    0x57D2: 0x57D3,
    0x57D8: 0x5852,
    0x57DA: 0x581D,
    0x5811: 0x5879,
    0x582F: 0x5C2D,
    0x589E: 0x5897,
    0x58AE: 0x5815,
    0x58B0: 0x7560,
    0x58D3: 0x5727,
    0x58D8: 0x5841,
    0x58DE: 0x58CA,
    0x58E4: 0x58CC,
    0x58EF: 0x58EE,
    0x58F3: 0x6BBB,
    0x58F6: 0x58F7,
    0x58F9: 0x58F1,
    0x58FA: 0x58F7,
    0x58FD: 0x5BFF,
    0x5904: 0x51E6,
    0x5907: 0x5099,
    0x590A: 0x6535,
    0x590D: 0x5FA9,
    0x5934: 0x982D,
    0x593A: 0x596A,
    0x5941: 0x5969,
    0x5942: 0x5950,
    0x594B: 0x596E,
    0x5956: 0x5968,
    0x5967: 0x5965,
    0x5969: 0x5333,
    0x5986: 0x7CA7,
    0x5987: 0x5A66,
    0x5988: 0x5ABD,
    0x5992: 0x59AC,
    0x59AA: 0x5AD7,
    0x59C9: 0x92F2,
    0x59CA: 0x59C9,
    0x59EC: 0x59EB,
    0x5A04: 0x5A41,
    0x5A07: 0x5B0C,
    0x5A1B: 0x5A2F,
    0x5A31: 0x5A2F,
    0x5A34: 0x5AFB,
    0x5A61: 0x60E3,
    0x5A74: 0x5B30,
    0x5A75: 0x5B0B,
    0x5AAA: 0x5ABC,
    0x5AB8: 0x599B,
    0x5AD4: 0x5B2A,
    0x5AFE: 0x88AE,
    0x5B43: 0x5B22,
    0x5B59: 0x5B6B,
    0x5B78: 0x5B66,
    0x5B81: 0x5BE7,
    0x5B9E: 0x5B9F,
    0x5BA0: 0x5BF5,
    0x5BA1: 0x5BE9,
    0x5BAA: 0x61B2,
    0x5BBD: 0x5BDB,
    0x5BBE: 0x8CD3,
    0x5BC7: 0x51A6,
    0x5BE2: 0x5BDD,
    0x5BE6: 0x5B9F,
    0x5BEB: 0x5199,
    0x5BEC: 0x5BDB,
    0x5BF6: 0x5B9D,
    0x5BF9: 0x5BFE,
    0x5BFB: 0x5C0B,
    0x5BFC: 0x5C0E,
    0x5C07: 0x5C06,
    0x5C08: 0x5C02,
    0x5C0D: 0x5BFE,
    0x5C18: 0x5875,
    0x5C1D: 0x5617,
    0x5C27: 0x5C2D,
    0x5C42: 0x5C64,
    0x5C43: 0x5C53,
    0x5C46: 0x5C4A,
    0x5C5C: 0x7B39,
    0x5C62: 0x5C61,
    0x5C6C: 0x5C5E,
    0x5C6D: 0x5C53,
    0x5C7F: 0x5DBC,
    0x5C81: 0x6B73,
    0x5C96: 0x5D87,
    0x5C97: 0x5D17,
    0x5C9A: 0x5D50,
    0x5C9B: 0x5CF6,
    0x5CAD: 0x5CBA,
    0x5CE3: 0x5DA2,
    0x5CE5: 0x5D22,
    0x5CE6: 0x5DD2,
    0x5CEA: 0x7872,
    0x5CF0: 0x5CEF,
    0x5CFD: 0x5CE1,
    0x5D19: 0x5D18,
    0x5D2D: 0x5D84,
    0x5D58: 0x5DB8,
    0x5D68: 0x5D8B,
    0x5DC5: 0x5DD3,
    0x5DD4: 0x5DD3,
    0x5DD6: 0x5DCC,
    0x5DE0: 0x5759,
    0x5DE2: 0x5DE3,
    0x5DE9: 0x978F,
    0x5E01: 0x5E63,
    0x5E05: 0x5E25,
    0x5E08: 0x5E2B,
    0x5E0F: 0x5E43,
    0x5E10: 0x5E33,
    0x5E15: 0x7D48,
    0x5E18: 0x7C3E,
    0x5E1C: 0x5E5F,
    0x5E26: 0x5E2F,
    0x5E27: 0x5E40,
    0x5E2E: 0x5E47,
    0x5E36: 0x5E2F,
    0x5E3C: 0x5E57,
    0x5E6B: 0x5E47,
    0x5E86: 0x6176,
    0x5E90: 0x5EEC,
    0x5E91: 0x5EE1,
    0x5E93: 0x5EAB,
    0x5E94: 0x5FDC,
    0x5E99: 0x5EDF,
    0x5E9F: 0x5EC3,
    0x5EBD: 0x9942,
    0x5EC1: 0x53A0,
    0x5EC4: 0x53A9,
    0x5EC8: 0x53A6,
    0x5EDD: 0x53AE,
    0x5EE2: 0x5EC3,
    0x5EE3: 0x5E83,
    0x5EEA: 0x5EE9,
    0x5EF3: 0x5E81,
    0x5F00: 0x958B,
    0x5F02: 0x7570,
    0x5F12: 0x5F11,
    0x5F20: 0x5F35,
    0x5F39: 0x5F3E,
    0x5F3A: 0x5F37,
    0x5F48: 0x5F3E,
    0x5F4C: 0x5F25,
    0x5F4E: 0x5F2F,
    0x5F52: 0x5E30,
    0x5F55: 0x9332,
    0x5F5D: 0x5F5C,
    0x5F65: 0x5F66,
    0x5F7B: 0x5FB9,
    0x5F91: 0x5F84,
    0x5F95: 0x5FA0,
    0x5F9E: 0x5F93,
    0x5FB5: 0x5FB4,
    0x5FB7: 0x5FB3,
    0x5FC6: 0x61B6,
    0x5FCF: 0x61F4,
    0x5FE7: 0x6182,
    0x5FFE: 0x613E,
    0x6000: 0x61D0,
    0x6001: 0x614B,
    0x6003: 0x61AE,
    0x6005: 0x60B5,
    0x6006: 0x6134,
    0x601C: 0x6190,
    0x603B: 0x7DCF,
    0x603F: 0x61CC,
    0x6058: 0x6077,
    0x6073: 0x61C7,
    0x6076: 0x60AA,
    0x6078: 0x615F,
    0x607A: 0x6137,
    0x607B: 0x60FB,
    0x607C: 0x60A9,
    0x607D: 0x60F2,
    0x607F: 0x6142,
    0x6080: 0x6111,
    0x6085: 0x60A6,
    0x60AB: 0x6128,
    0x60AC: 0x61F8,
    0x60AD: 0x6173,
    0x60AF: 0x61AB,
    0x60CA: 0x9A5A,
    0x60E0: 0x6075,
    0x60E1: 0x60AA,
    0x60E9: 0x61F2,
    0x60EB: 0x618A,
    0x60ED: 0x615A,
    0x60EE: 0x619A,
    0x60EF: 0x6163,
    0x60F1: 0x60A9,
    0x6119: 0x9BF1,
    0x6124: 0x61A4,
    0x6151: 0x61FE,
    0x6158: 0x60E8,
    0x6164: 0x6128,
    0x617C: 0x621A,
    0x6191: 0x51ED,
    0x61C0: 0x9C3A,
    0x61C9: 0x5FDC,
    0x61D2: 0x61F6,
    0x61D4: 0x61CD,
    0x61EE: 0x6182,
    0x61F7: 0x61D0,
    0x61FA: 0x61F4,
    0x61FC: 0x60E7,
    0x6200: 0x604B,
    0x620B: 0x6214,
    0x620F: 0x622F,
    0x6218: 0x6226,
    0x622E: 0x52E0,
    0x6230: 0x6226,
    0x6232: 0x622F,
    0x6236: 0x6238,
    0x623E: 0x623B,
    0x6251: 0x64B2,
    0x6267: 0x57F7,
    0x6269: 0x62E1,
    0x626A: 0x636B,
    0x626B: 0x6383,
    0x626C: 0x63DA,
    0x6270: 0x64FE,
    0x629A: 0x64AB,
    0x629F: 0x6476,
    0x62A2: 0x6436,
    0x62A4: 0x8B77,
    0x62A5: 0x5831,
    0x62CB: 0x629B,
    0x62D4: 0x629C,
    0x62DC: 0x62DD,
    0x62DF: 0x64EC,
    0x62E3: 0x63C0,
    0x62E5: 0x64C1,
    0x62E8: 0x64A5,
    0x62E9: 0x64C7,
    0x631B: 0x6523,
    0x631E: 0x64BB,
    0x6320: 0x6493,
    0x6324: 0x64E0,
    0x6325: 0x63EE,
    0x633E: 0x631F,
    0x635E: 0x6488,
    0x635F: 0x640D,
    0x6362: 0x63DB,
    0x6363: 0x64E3,
    0x6374: 0x6460,
    0x63B7: 0x64F2,
    0x63D2: 0x633F,
    0x63ED: 0x63B2,
    0x63F8: 0x936E,
    0x63FD: 0x652C,
    0x6401: 0x64F1,
    0x6405: 0x64B9,
    0x6414: 0x63BB,
    0x6416: 0x63FA,
    0x641C: 0x635C,
    0x6425: 0x6376,
    0x6444: 0x6442,
    0x6446: 0x64FA,
    0x6447: 0x63FA,
    0x6448: 0x64EF,
    0x644A: 0x6524,
    0x6451: 0x63B4,
    0x6470: 0x646F,
    0x64AF: 0x691A,
    0x64C7: 0x629E,
    0x64CA: 0x6483,
    0x64D4: 0x62C5,
    0x64E5: 0x5840,
    0x64F4: 0x62E1,
    0x6512: 0x6505,
    0x651C: 0x643A,
    0x6522: 0x6505,
    0x652A: 0x64B9,
    0x6536: 0x53CE,
    0x6548: 0x52B9,
    0x654C: 0x6575,
    0x6555: 0x52C5,
    0x6558: 0x53D9,
    0x655B: 0x6B5B,
    0x6578: 0x6570,
    0x658B: 0x658E,
    0x65A9: 0x65AC,
    0x65B7: 0x65AD,
    0x65DB: 0x65D9,
    0x65F6: 0x6642,
    0x65F7: 0x663F,
    0x65F8: 0x6698,
    0x6619: 0x66C7,
    0x663A: 0x661E,
    0x663E: 0x9855,
    0x6649: 0x664B,
    0x6653: 0x6681,
    0x6654: 0x66C4,
    0x6655: 0x6688,
    0x6656: 0x6689,
    0x665A: 0x6669,
    0x665D: 0x663C,
    0x6670: 0x6673,
    0x6682: 0x66AB,
    0x66A7: 0x66D6,
    0x66A8: 0x66C1,
    0x66B1: 0x6635,
    0x66B3: 0x567A,
    0x66C6: 0x66A6,
    0x66C9: 0x6681,
    0x66E0: 0x663F,
    0x66EC: 0x6652,
    0x6703: 0x4F1A,
    0x6725: 0x73C9,
    0x6735: 0x6736,
    0x6740: 0x6BBA,
    0x6742: 0x96D1,
    0x6743: 0x6A29,
    0x6768: 0x694A,
    0x676B: 0x9C2F,
    0x6781: 0x6975,
    0x6784: 0x69CB,
    0x679E: 0x6A05,
    0x67A5: 0x6AEA,
    0x67AA: 0x69CD,
    0x67AB: 0x6953,
    0x67CF: 0x6822,
    0x67DB: 0x698A,
    0x67DC: 0x6AC3,
    0x67E0: 0x6AB8,
    0x67E5: 0x67FB,
    0x6805: 0x67F5,
    0x6807: 0x6A19,
    0x6808: 0x685F,
    0x6809: 0x6ADB,
    0x680A: 0x69DE,
    0x680B: 0x68DF,
    0x680E: 0x6AAA,
    0x680F: 0x6B04,
    0x6811: 0x6A39,
    0x6837: 0x69D8,
    0x683E: 0x6B12,
    0x6860: 0x690F,
    0x6861: 0x6A48,
    0x6862: 0x6968,
    0x6865: 0x6A4B,
    0x6866: 0x67A0,
    0x689D: 0x6761,
    0x68C0: 0x691C,
    0x68C2: 0x6AFA,
    0x68E7: 0x685F,
    0x68EC: 0x6926,
    0x6964: 0x84AD,
    0x6984: 0x6B16,
    0x6986: 0x6961,
    0x6988: 0x6ADA,
    0x6993: 0x6AC1,
    0x69A8: 0x643E,
    0x69AE: 0x6804,
    0x69D4: 0x69F9,
    0x69DB: 0x6ABB,
    0x69E8: 0x6901,
    0x69F6: 0x6922,
    0x6A02: 0x697D,
    0x6A11: 0x6881,
    0x6A13: 0x697C,
    0x6A23: 0x69D8,
    0x6A2F: 0x6AA3,
    0x6A31: 0x685C,
    0x6A36: 0x701E,
    0x6A3A: 0x67A0,
    0x6A62: 0x6955,
    0x6A6B: 0x6A2A,
    0x6A79: 0x6AD3,
    0x6A7C: 0x6ADE,
    0x6A94: 0x6863,
    0x6A9C: 0x6867,
    0x6AA2: 0x691C,
    0x6AAE: 0x68BC,
    0x6AB3: 0x68B9,
    0x6ADF: 0x6AAA,
    0x6AF1: 0x8616,
    0x6AF3: 0x69DE,
    0x6AF8: 0x6B05,
    0x6AFB: 0x685C,
    0x6B0A: 0x6A29,
    0x6B1E: 0x6AFA,
    0x6B22: 0x6B53,
    0x6B24: 0x6B5F,
    0x6B50: 0x6B27,
    0x6B61: 0x6B53,
    0x6B65: 0x6B69,
    0x6B72: 0x6B73,
    0x6B77: 0x6B74,
    0x6B78: 0x5E30,
    0x6B7C: 0x6BB1,
    0x6B87: 0x6BA4,
    0x6B92: 0x6B9E,
    0x6B98: 0x6B8B,
    0x6B9A: 0x6BAB,
    0x6BA1: 0x6BAF,
    0x6BAD: 0x50F5,
    0x6BB2: 0x6BB1,
    0x6BBC: 0x6BBB,
    0x6BC1: 0x6BC0,
    0x6BC2: 0x8F42,
    0x6BC6: 0x6BB4,
    0x6BCF: 0x6BCE,
    0x6BD5: 0x7562,
    0x6BD9: 0x6583,
    0x6C23: 0x6C17,
    0x6C49: 0x6F22,
    0x6C61: 0x6C5A,
    0x6C64: 0x6E6F,
    0x6C92: 0x6CA1,
    0x6C9F: 0x6E9D,
    0x6CA6: 0x6DEA,
    0x6CA7: 0x6EC4,
    0x6CB5: 0x6FD4,
    0x6CDE: 0x6FD8,
    0x6CF7: 0x6EDD,
    0x6CF8: 0x7018,
    0x6CFB: 0x7009,
    0x6CFC: 0x6E8C,
    0x6CFD: 0x6CA2,
    0x6CFE: 0x6D87,
    0x6D01: 0x6F54,
    0x6D3C: 0x7AAA,
    0x6D43: 0x6D79,
    0x6D47: 0x6F86,
    0x6D4A: 0x6FC1,
    0x6D4B: 0x6E2C,
    0x6D4E: 0x6E08,
    0x6D4F: 0x700F,
    0x6D51: 0x6E3E,
    0x6D52: 0x6EF8,
    0x6D53: 0x6FC3,
    0x6D54: 0x6F6F,
    0x6D82: 0x5857,
    0x6D89: 0x6E09,
    0x6D99: 0x681E,
    0x6D9E: 0x6764,
    0x6D9F: 0x6F23,
    0x6DA1: 0x6E26,
    0x6DA3: 0x6E19,
    0x6DA6: 0x6F64,
    0x6DA7: 0x6F97,
    0x6DA8: 0x6F32,
    0x6DB1: 0x66BF,
    0x6DDA: 0x6D99,
    0x6DE8: 0x6D44,
    0x6DFA: 0x6D45,
    0x6E0D: 0x6F2C,
    0x6E0E: 0x6D9C,
    0x6E10: 0x6F38,
    0x6E14: 0x6F01,
    0x6E34: 0x6E07,
    0x6E4C: 0x9910,
    0x6E83: 0x6F70,
    0x6E85: 0x6FFA,
    0x6E89: 0x6F11,
    0x6EAA: 0x6E13,
    0x6EAB: 0x6E29,
    0x6EAF: 0x9061,
    0x6EE1: 0x6E80,
    0x6EE2: 0x7005,
    0x6EE4: 0x6FFE,
    0x6EE5: 0x6FEB,
    0x6EE8: 0x6D5C,
    0x6EE9: 0x7058,
    0x6EEF: 0x6EDE,
    0x6EFF: 0x6E80,
    0x6F47: 0x701F,
    0x6F4B: 0x7032,
    0x6F51: 0x6E8C,
    0x6F5B: 0x6F5C,
    0x6F80: 0x6E0B,
    0x6F81: 0x8262,
    0x6F9C: 0x703E,
    0x6FA4: 0x6CA2,
    0x6FD1: 0x702C,
    0x6FD2: 0x7015,
    0x6FD5: 0x6E7F,
    0x6FDF: 0x6E08,
    0x6FE4: 0x6D9B,
    0x6FF1: 0x6D5C,
    0x7006: 0x6D9C,
    0x7028: 0x702C,
    0x704C: 0x6F45,
    0x7063: 0x6E7E,
    0x706D: 0x6EC5,
    0x7075: 0x970A,
    0x7076: 0x7AC3,
    0x707F: 0x71E6,
    0x7080: 0x716C,
    0x708B: 0x5788,
    0x7096: 0x71C9,
    0x70BC: 0x7149,
    0x70BD: 0x71BE,
    0x70C1: 0x720D,
    0x70C2: 0x721B,
    0x70DB: 0x71ED,
    0x70E6: 0x7169,
    0x70E7: 0x713C,
    0x70E8: 0x71C1,
    0x70EC: 0x71FC,
    0x70ED: 0x71B1,
    0x7115: 0x7165,
    0x7118: 0x71FE,
    0x7130: 0x7114,
    0x718E: 0x8977,
    0x71C4: 0x7114,
    0x71D2: 0x713C,
    0x71DF: 0x55B6,
    0x7210: 0x7089,
    0x722D: 0x4E89,
    0x7231: 0x611B,
    0x7237: 0x723A,
    0x724D: 0x7258,
    0x7275: 0x727D,
    0x727A: 0x72A0,
    0x7281: 0x7282,
    0x728A: 0x72A2,
    0x72A7: 0x72A0,
    0x72B7: 0x7377,
    0x72C0: 0x72B6,
    0x72C8: 0x72FD,
    0x72DE: 0x7370,
    0x72EE: 0x7345,
    0x72EF: 0x736A,
    0x72F1: 0x7344,
    0x72F9: 0x72ED,
    0x730E: 0x731F,
    0x734E: 0x5968,
    0x7368: 0x72EC,
    0x736D: 0x737A,
    0x7375: 0x731F,
    0x7378: 0x7363,
    0x737B: 0x732E,
    0x739B: 0x746A,
    0x73AF: 0x74B0,
    0x73B0: 0x73FE,
    0x73BA: 0x74BD,
    0x73D1: 0x74CF,
    0x73F2: 0x743F,
    0x740F: 0x7489,
    0x7410: 0x7463,
    0x743C: 0x74CA,
    0x7464: 0x7476,
    0x748E: 0x73F1,
    0x74D4: 0x73F1,
    0x74EF: 0x750C,
    0x7522: 0x7523,
    0x7535: 0x96FB,
    0x7545: 0x66A2,
    0x756B: 0x753B,
    0x756C: 0x756D,
    0x7576: 0x5F53,
    0x7587: 0x7574,
    0x758A: 0x7573,
    0x7597: 0x7642,
    0x75A0: 0x7658,
    0x75A1: 0x760D,
    0x75AE: 0x7621,
    0x75AF: 0x760B,
    0x75C3: 0x65E0,
    0x75C8: 0x7670,
    0x75E8: 0x7646,
    0x75EB: 0x7647,
    0x75F9: 0x75FA,
    0x7618: 0x763B,
    0x7626: 0x75E9,
    0x763A: 0x763B,
    0x765E: 0x7669,
    0x7663: 0x766C,
    0x7665: 0x75C7,
    0x766B: 0x7672,
    0x767C: 0x767A,
    0x7682: 0x7680,
    0x768B: 0x7690,
    0x76B2: 0x76B8,
    0x76CF: 0x76DE,
    0x76D0: 0x5869,
    0x76D1: 0x76E3,
    0x76D8: 0x76E4,
    0x76DC: 0x76D7,
    0x76E1: 0x5C3D,
    0x773E: 0x8846,
    0x7751: 0x77BC,
    0x776A: 0x777E,
    0x7786: 0x77B6,
    0x7792: 0x779E,
    0x77A9: 0x77DA,
    0x77EB: 0x77EF,
    0x77F6: 0x78EF,
    0x77FF: 0x9271,
    0x7801: 0x78BC,
    0x7816: 0x750E,
    0x781A: 0x786F,
    0x783E: 0x792B,
    0x7855: 0x78A9,
    0x7856: 0x7864,
    0x7857: 0x78FD,
    0x786E: 0x78BA,
    0x7877: 0x9E78,
    0x788E: 0x7815,
    0x789B: 0x78E7,
    0x78CC: 0x78B5,
    0x78DA: 0x750E,
    0x7906: 0x9E78,
    0x7919: 0x788D,
    0x7926: 0x9271,
    0x792A: 0x783A,
    0x7936: 0x91E5,
    0x796F: 0x798E,
    0x7978: 0x798D,
    0x797F: 0x7984,
    0x79AA: 0x7985,
    0x79AE: 0x793C,
    0x79B0: 0x7962,
    0x79B1: 0x7977,
    0x79BB: 0x96E2,
    0x79C3: 0x79BF,
    0x79CD: 0x7A2E,
    0x79EF: 0x7A4D,
    0x79FD: 0x7A62,
    0x7A05: 0x7A0E,
    0x7A1F: 0x7980,
    0x7A31: 0x79F0,
    0x7A33: 0x7A4F,
    0x7A3B: 0x7A32,
    0x7A51: 0x7A61,
    0x7A57: 0x7A42,
    0x7A69: 0x7A4F,
    0x7A70: 0x7A63,
    0x7A77: 0x7AAE,
    0x7A8D: 0x7AC5,
    0x7A91: 0x7AAF,
    0x7A97: 0x7A93,
    0x7A9C: 0x7AC4,
    0x7A9D: 0x7AA9,
    0x7AA5: 0x7ABA,
    0x7AA6: 0x7AC7,
    0x7ACA: 0x7A83,
    0x7AD6: 0x7AEA,
    0x7ADE: 0x7AF6,
    0x7B03: 0x7BE4,
    0x7B14: 0x7B46,
    0x7B15: 0x7B67,
    0x7B3A: 0x7B8B,
    0x7B3C: 0x7BED,
    0x7B4D: 0x7B0B,
    0x7B50: 0x7B7A,
    0x7B5A: 0x7BF3,
    0x7B5B: 0x7BE9,
    0x7B79: 0x7C4C,
    0x7B80: 0x7C21,
    0x7B8F: 0x7B5D,
    0x7BA6: 0x7C00,
    0x7BA7: 0x7BCB,
    0x7BAB: 0x7C2B,
    0x7BD1: 0x7C23,
    0x7BD3: 0x7C0D,
    0x7BE1: 0x7C12,
    0x7BE6: 0x7B86,
    0x7BEE: 0x7C43,
    0x7BF1: 0x7C6C,
    0x7C11: 0x7C14,
    0x7C1E: 0x7BAA,
    0x7C60: 0x7BED,
    0x7C64: 0x7C56,
    0x7C72: 0x5401,
    0x7C7B: 0x985E,
    0x7C9D: 0x7CF2,
    0x7CAA: 0x7CDE,
    0x7CAE: 0x7CE7,
    0x7CB5: 0x7CA4,
    0x7CB8: 0x9348,
    0x7CDD: 0x7CC2,
    0x7CED: 0x9277,
    0x7CF0: 0x56E3,
    0x7CF5: 0x4FE4,
    0x7D27: 0x7DCA,
    0x7D55: 0x7D76,
    0x7D93: 0x7D4C,
    0x7DA0: 0x7DD1,
    0x7DD1: 0x68B6,
    0x7DE3: 0x7E01,
    0x7DFE: 0x6130,
    0x7E23: 0x770C,
    0x7E31: 0x7E26,
    0x7E3B: 0x9EBF,
    0x7E3D: 0x7DCF,
    0x7E48: 0x7E66,
    0x7E61: 0x7E4D,
    0x7E65: 0x9C0A,
    0x7E69: 0x7E04,
    0x7E6A: 0x7D75,
    0x7E6B: 0x7E4B,
    0x7E7C: 0x7D99,
    0x7E8A: 0x7D4B,
    0x7E8C: 0x7D9A,
    0x7E96: 0x7E4A,
    0x7E98: 0x7E89,
    0x7EA0: 0x7CFE,
    0x7EA1: 0x7D06,
    0x7EA2: 0x7D05,
    0x7EA3: 0x7D02,
    0x7EA4: 0x7E4A,
    0x7EA6: 0x7D04,
    0x7EA7: 0x7D1A,
    0x7EA9: 0x7D4B,
    0x7EAA: 0x7D00,
    0x7EAC: 0x7DEF,
    0x7EAD: 0x7D1C,
    0x7EAE: 0x7D18,
    0x7EAF: 0x7D14,
    0x7EB0: 0x7D15,
    0x7EB1: 0x7D17,
    0x7EB2: 0x7DB1,
    0x7EB3: 0x7D0D,
    0x7EB5: 0x7E26,
    0x7EB6: 0x7DB8,
    0x7EB7: 0x7D1B,
    0x7EB9: 0x7D0B,
    0x7EBA: 0x7D21,
    0x7EBB: 0x7D35,
    0x7EBF: 0x7DDA,
    0x7EC0: 0x7D3A,
    0x7EC1: 0x7D32,
    0x7EC3: 0x7DF4,
    0x7EC4: 0x7D44,
    0x7EC5: 0x7D33,
    0x7EC6: 0x7D30,
    0x7EC7: 0x7E54,
    0x7EC8: 0x7D42,
    0x7ECA: 0x7D46,
    0x7ECD: 0x7D39,
    0x7ECE: 0x7E79,
    0x7ECF: 0x7D4C,
    0x7ED0: 0x7D3F,
    0x7ED2: 0x7D68,
    0x7ED3: 0x7D50,
    0x7ED5: 0x7E5E,
    0x7ED7: 0x7D4E,
    0x7ED8: 0x7D75,
    0x7ED9: 0x7D66,
    0x7EDA: 0x7D62,
    0x7EDB: 0x7D73,
    0x7EDC: 0x7D61,
    0x7EDD: 0x7D76,
    0x7EDE: 0x7D5E,
    0x7EDF: 0x7D71,
    0x7EE2: 0x7D79,
    0x7EE3: 0x7D89,
    0x7EE5: 0x7D8F,
    0x7EE6: 0x7D5B,
    0x7EE7: 0x7D99,
    0x7EE9: 0x7E3E,
    0x7EEA: 0x7DD2,
    0x7EEB: 0x7DBE,
    0x7EED: 0x7D9A,
    0x7EEE: 0x7DBA,
    0x7EEF: 0x7DCB,
    0x7EF0: 0x7DBD,
    0x7EF3: 0x7E04,
    0x7EF4: 0x7DAD,
    0x7EF5: 0x7DBF,
    0x7EF6: 0x7DAC,
    0x7EF7: 0x7E43,
    0x7EF8: 0x7DA2,
    0x7EF9: 0x7DAF,
    0x7EFB: 0x7DA3,
    0x7EFC: 0x7D9C,
    0x7EFD: 0x7DBB,
    0x7EFE: 0x7DB0,
    0x7EFF: 0x7DD1,
    0x7F00: 0x7DB4,
    0x7F01: 0x7DC7,
    0x7F04: 0x7DD8,
    0x7F05: 0x7DEC,
    0x7F06: 0x7E9C,
    0x7F08: 0x7DF2,
    0x7F09: 0x7DDD,
    0x7F0E: 0x7DDE,
    0x7F12: 0x7E0B,
    0x7F13: 0x7DE9,
    0x7F14: 0x7DE0,
    0x7F15: 0x7E37,
    0x7F16: 0x7DE8,
    0x7F17: 0x7DE1,
    0x7F18: 0x7E01,
    0x7F19: 0x7E09,
    0x7F1A: 0x7E1B,
    0x7F1B: 0x7E1F,
    0x7F1D: 0x7E2B,
    0x7F1F: 0x7E1E,
    0x7F20: 0x7E8F,
    0x7F22: 0x7E0A,
    0x7F24: 0x7E7D,
    0x7F25: 0x7E39,
    0x7F26: 0x7E35,
    0x7F27: 0x7E32,
    0x7F28: 0x7E93,
    0x7F29: 0x7E2E,
    0x7F2A: 0x7E46,
    0x7F2C: 0x7E88,
    0x7F2D: 0x7E5A,
    0x7F2E: 0x7E55,
    0x7F2F: 0x7E52,
    0x7F32: 0x7E70,
    0x7F35: 0x7E89,
    0x7F3D: 0x9262,
    0x7F48: 0x58DC,
    0x7F57: 0x7F85,
    0x7F5A: 0x7F70,
    0x7F62: 0x7F77,
    0x7F74: 0x7F86,
    0x7F81: 0x7F88,
    0x7FB9: 0x7FAE,
    0x7FD8: 0x7FF9,
    0x8042: 0x8076,
    0x804B: 0x807E,
    0x804C: 0x8077,
    0x804D: 0x8079,
    0x8054: 0x806F,
    0x805B: 0x923C,
    0x806A: 0x8061,
    0x8070: 0x8061,
    0x8072: 0x58F0,
    0x807D: 0x8074,
    0x8083: 0x7C9B,
    0x8085: 0x7C9B,
    0x8089: 0x5B8D,
    0x80A0: 0x8178,
    0x80A4: 0x819A,
    0x80BE: 0x814E,
    0x80BF: 0x816B,
    0x80C0: 0x8139,
    0x80C1: 0x8107,
    0x80DC: 0x52DD,
    0x80E7: 0x6727,
    0x80EA: 0x81DA,
    0x80EB: 0x811B,
    0x80F6: 0x81A0,
    0x810D: 0x81BE,
    0x8110: 0x81CD,
    0x8111: 0x8133,
    0x8113: 0x81BF,
    0x8114: 0x81E0,
    0x812B: 0x8131,
    0x8138: 0x81C9,
    0x814A: 0x81D8,
    0x8158: 0x8195,
    0x8166: 0x8133,
    0x8173: 0x811A,
    0x817B: 0x81A9,
    0x817C: 0x9766,
    0x817D: 0x8183,
    0x817E: 0x9A30,
    0x81BB: 0x7FB6,
    0x81BD: 0x80C6,
    0x81DF: 0x81D3,
    0x8206: 0x8F3F,
    0x8209: 0x6319,
    0x820A: 0x65E7,
    0x820D: 0x820E,
    0x8216: 0x8217,
    0x8223: 0x8264,
    0x8230: 0x8266,
    0x8231: 0x8259,
    0x823B: 0x826B,
    0x8270: 0x8271,
    0x8273: 0x8276,
    0x8277: 0x8276,
    0x827A: 0x85DD,
    0x8282: 0x7BC0,
    0x8284: 0x7B02,
    0x829C: 0x856A,
    0x82C7: 0x8466,
    0x82CC: 0x8407,
    0x82CD: 0x84BC,
    0x82CE: 0x82E7,
    0x82CF: 0x8607,
    0x830F: 0x8622,
    0x8311: 0x8526,
    0x8314: 0x584B,
    0x8327: 0x7E6D,
    0x8354: 0x8318,
    0x835B: 0x8558,
    0x835E: 0x854E,
    0x835F: 0x8588,
    0x8360: 0x85BA,
    0x8361: 0x8569,
    0x8363: 0x6804,
    0x8364: 0x8477,
    0x8368: 0x8541,
    0x836B: 0x852D,
    0x836F: 0x85AC,
    0x837F: 0x7B6C,
    0x838A: 0x8358,
    0x8396: 0x830E,
    0x83B2: 0x84EE,
    0x83B3: 0x8494,
    0x83B7: 0x7372,
    0x83B8: 0x8362,
    0x83B9: 0x7469,
    0x83BA: 0x9D2C,
    0x83BC: 0x84F4,
    0x83CE: 0x7B86,
    0x83E1: 0x839F,
    0x83E4: 0x7B9E,
    0x840A: 0x83B1,
    0x8416: 0x4F39,
    0x841D: 0x863F,
    0x8421: 0x549C,
    0x8424: 0x86CD,
    0x8425: 0x55B6,
    0x8427: 0x856D,
    0x8428: 0x85A9,
    0x8457: 0x7740,
    0x8492: 0x9B97,
    0x8493: 0x84F4,
    0x849E: 0x6D96,
    0x84CB: 0x76D6,
    0x84DD: 0x85CD,
    0x84DF: 0x858A,
    0x84E3: 0x8577,
    0x84E6: 0x9A40,
    0x84E8: 0x84DA,
    0x8523: 0x848B,
    0x8525: 0x8471,
    0x8537: 0x8594,
    0x853A: 0x85FA,
    0x853C: 0x85F9,
    0x8574: 0x860A,
    0x85B0: 0x85AB,
    0x85CF: 0x8535,
    0x85D3: 0x861A,
    0x85D6: 0x6282,
    0x85E5: 0x85AC,
    0x85EA: 0x85AE,
    0x8606: 0x82A6,
    0x860D: 0x7AD3,
    0x864F: 0x865C,
    0x8651: 0x616E,
    0x8655: 0x51E6,
    0x865B: 0x865A,
    0x865F: 0x53F7,
    0x867D: 0x96D6,
    0x867E: 0x8766,
    0x8680: 0x8755,
    0x8681: 0x87FB,
    0x86CA: 0x8831,
    0x86CD: 0x4FE5,
    0x86CF: 0x87F6,
    0x8721: 0x874B,
    0x8747: 0x877F,
    0x8766: 0x86EF,
    0x877C: 0x87BB,
    0x877E: 0x8811,
    0x87A2: 0x86CD,
    0x87EC: 0x8749,
    0x8805: 0x877F,
    0x881F: 0x874B,
    0x8823: 0x86CE,
    0x8839: 0x8827,
    0x883B: 0x86EE,
    0x8845: 0x91C1,
    0x8854: 0x929C,
    0x8865: 0x88DC,
    0x886C: 0x896F,
    0x8884: 0x8956,
    0x889C: 0x896A,
    0x88AD: 0x8972,
    0x88C6: 0x8960,
    0x88C8: 0x890C,
    0x88DD: 0x88C5,
    0x8902: 0x88BF,
    0x891B: 0x8938,
    0x8932: 0x88B4,
    0x8934: 0x8964,
    0x894C: 0x891D,
    0x8955: 0x8974,
    0x89BA: 0x899A,
    0x89BD: 0x89A7,
    0x89C0: 0x89B3,
    0x89C1: 0x898B,
    0x89C2: 0x89B3,
    0x89C4: 0x898F,
    0x89C5: 0x8993,
    0x89C6: 0x8996,
    0x89C7: 0x8998,
    0x89C8: 0x89A7,
    0x89C9: 0x899A,
    0x89CA: 0x89AC,
    0x89CB: 0x89A1,
    0x89CC: 0x89BF,
    0x89CE: 0x89A6,
    0x89CF: 0x89AF,
    0x89D0: 0x89B2,
    0x89D4: 0x7B4B,
    0x89DE: 0x89F4,
    0x89E5: 0x4F8A,
    0x8A1A: 0x8ABE,
    0x8A8A: 0x8B04,
    0x8AAA: 0x8AAC,
    0x8AEB: 0x8ACC,
    0x8B20: 0x8B21,
    0x8B54: 0x64B0,
    0x8B56: 0x8B5B,
    0x8B6D: 0x6BC0,
    0x8B6F: 0x8A33,
    0x8B7D: 0x8A89,
    0x8B80: 0x8AAD,
    0x8B8A: 0x5909,
    0x8B93: 0x8B72,
    0x8B9A: 0x8B83,
    0x8BA1: 0x8A08,
    0x8BA2: 0x8A02,
    0x8BA3: 0x8A03,
    0x8BA4: 0x8A8D,
    0x8BA5: 0x8B4F,
    0x8BA6: 0x8A10,
    0x8BA7: 0x8A0C,
    0x8BA8: 0x8A0E,
    0x8BA9: 0x8B93,
    0x8BAB: 0x8A16,
    0x8BAC: 0x8A17,
    0x8BAD: 0x8A13,
    0x8BAE: 0x8B70,
    0x8BAF: 0x8A0A,
    0x8BB0: 0x8A18,
    0x8BB1: 0x8A12,
    0x8BB2: 0x8B1B,
    0x8BB3: 0x8AF1,
    0x8BB4: 0x8B33,
    0x8BB6: 0x8A1D,
    0x8BB7: 0x8A25,
    0x8BB8: 0x8A31,
    0x8BB9: 0x8A1B,
    0x8BBA: 0x8AD6,
    0x8BBC: 0x8A1F,
    0x8BBD: 0x8AF7,
    0x8BBE: 0x8A2D,
    0x8BBF: 0x8A2A,
    0x8BC0: 0x8A23,
    0x8BC1: 0x8A3C,
    0x8BC2: 0x8A41,
    0x8BC3: 0x8A36,
    0x8BC4: 0x8A55,
    0x8BC5: 0x8A5B,
    0x8BC6: 0x8B58,
    0x8BC8: 0x8A50,
    0x8BC9: 0x8A34,
    0x8BCA: 0x8A3A,
    0x8BCB: 0x8A46,
    0x8BCD: 0x8A5E,
    0x8BCF: 0x8A54,
    0x8BD1: 0x8A33,
    0x8BD2: 0x8A52,
    0x8BD4: 0x8A84,
    0x8BD5: 0x8A66,
    0x8BD7: 0x8A69,
    0x8BD8: 0x8A70,
    0x8BD9: 0x8A7C,
    0x8BDA: 0x8AA0,
    0x8BDB: 0x8A85,
    0x8BDD: 0x8A71,
    0x8BDE: 0x8A95,
    0x8BDF: 0x8A6C,
    0x8BE0: 0x8A6E,
    0x8BE1: 0x8A6D,
    0x8BE2: 0x8A62,
    0x8BE3: 0x8A63,
    0x8BE4: 0x8ACD,
    0x8BE5: 0x8A72,
    0x8BE6: 0x8A73,
    0x8BE7: 0x8A6B,
    0x8BE8: 0x8AE2,
    0x8BEB: 0x8AA1,
    0x8BEC: 0x8AA3,
    0x8BED: 0x8A9E,
    0x8BEE: 0x8A9A,
    0x8BEF: 0x8AA4,
    0x8BF0: 0x8AA5,
    0x8BF1: 0x8A98,
    0x8BF2: 0x8AA8,
    0x8BF3: 0x8A91,
    0x8BF4: 0x8AAC,
    0x8BF5: 0x8AA6,
    0x8BF6: 0x7E67,
    0x8BF7: 0x8ACB,
    0x8BF8: 0x8AF8,
    0x8BF9: 0x8ACF,
    0x8BFA: 0x8AFE,
    0x8BFB: 0x8AAD,
    0x8BFD: 0x8AB9,
    0x8BFE: 0x8AB2,
    0x8C00: 0x8ADB,
    0x8C01: 0x8AB0,
    0x8C03: 0x8ABF,
    0x8C04: 0x8AC2,
    0x8C05: 0x8AD2,
    0x8C06: 0x8AC4,
    0x8C08: 0x8AC7,
    0x8C0A: 0x8ABC,
    0x8C0B: 0x8B00,
    0x8C0C: 0x8AF6,
    0x8C0D: 0x8ADC,
    0x8C0F: 0x8ACC,
    0x8C10: 0x8AE7,
    0x8C11: 0x8B14,
    0x8C12: 0x8B01,
    0x8C13: 0x8B02,
    0x8C14: 0x8AE4,
    0x8C15: 0x8AED,
    0x8C17: 0x8B92,
    0x8C18: 0x8AEE,
    0x8C19: 0x8AF3,
    0x8C1A: 0x8AFA,
    0x8C1B: 0x8AE6,
    0x8C1C: 0x8B0E,
    0x8C1D: 0x8ADE,
    0x8C1F: 0x8B28,
    0x8C21: 0x8B16,
    0x8C22: 0x8B1D,
    0x8C23: 0x8B21,
    0x8C24: 0x8B17,
    0x8C25: 0x8B1A,
    0x8C26: 0x8B19,
    0x8C27: 0x8B10,
    0x8C28: 0x8B39,
    0x8C29: 0x8B3E,
    0x8C2A: 0x8B2B,
    0x8C2C: 0x8B2C,
    0x8C2D: 0x8B5A,
    0x8C2E: 0x8B5B,
    0x8C31: 0x8B5C,
    0x8C32: 0x8B4E,
    0x8C34: 0x8B74,
    0x8C35: 0x8B6B,
    0x8C36: 0x8B96,
    0x8C4E: 0x7AEA,
    0x8C54: 0x8276,
    0x8C6C: 0xFA16,
    0x8C7A: 0x72B2,
    0x8C89: 0x72E2,
    0x8C92: 0x732F,
    0x8C93: 0x732B,
    0x8C98: 0x734F,
    0x8CB3: 0x5F10,
    0x8CE3: 0x58F2,
    0x8CE4: 0x8CCE,
    0x8CF4: 0x983C,
    0x8CF8: 0x5270,
    0x8D0A: 0x8CDB,
    0x8D13: 0x8CCD,
    0x8D17: 0x8D0B,
    0x8D1D: 0x8C9D,
    0x8D1E: 0x8C9E,
    0x8D1F: 0x8CA0,
    0x8D21: 0x8CA2,
    0x8D23: 0x8CAC,
    0x8D24: 0x8CE2,
    0x8D25: 0x6557,
    0x8D27: 0x8CA8,
    0x8D28: 0x8CEA,
    0x8D29: 0x8CA9,
    0x8D2A: 0x8CAA,
    0x8D2B: 0x8CA7,
    0x8D2C: 0x8CB6,
    0x8D2D: 0x8CFC,
    0x8D2E: 0x8CAF,
    0x8D2F: 0x8CAB,
    0x8D30: 0x8CB3,
    0x8D31: 0x8CCE,
    0x8D32: 0x8CC1,
    0x8D33: 0x8CB0,
    0x8D34: 0x8CBC,
    0x8D35: 0x8CB4,
    0x8D37: 0x8CB8,
    0x8D38: 0x8CBF,
    0x8D39: 0x8CBB,
    0x8D3A: 0x8CC0,
    0x8D3B: 0x8CBD,
    0x8D3C: 0x8CCA,
    0x8D3D: 0x8D04,
    0x8D3E: 0x8CC8,
    0x8D3F: 0x8CC4,
    0x8D40: 0x8CB2,
    0x8D41: 0x8CC3,
    0x8D42: 0x8CC2,
    0x8D43: 0x8CCD,
    0x8D44: 0x8CC7,
    0x8D46: 0x8D10,
    0x8D48: 0x8CD1,
    0x8D49: 0x8CDA,
    0x8D4B: 0x8CE6,
    0x8D4C: 0x8CED,
    0x8D4E: 0x8D16,
    0x8D4F: 0x8CDE,
    0x8D50: 0x8CDC,
    0x8D51: 0x8D14,
    0x8D56: 0x983C,
    0x8D58: 0x8D05,
    0x8D59: 0x8CFB,
    0x8D5A: 0x8CFA,
    0x8D5B: 0x8CFD,
    0x8D5D: 0x8D0B,
    0x8D5E: 0x8CDB,
    0x8D5F: 0x8D07,
    0x8D60: 0x8D08,
    0x8D61: 0x8D0D,
    0x8D8B: 0x8DA8,
    0x8D95: 0x8D76,
    0x8DC3: 0x8E8D,
    0x8DC4: 0x8E4C,
    0x8DF8: 0x8E55,
    0x8DFB: 0x8E8B,
    0x8E0C: 0x8E8A,
    0x8E10: 0x8DF5,
    0x8E2C: 0x8E93,
    0x8E2F: 0x8E91,
    0x8E34: 0x8E0A,
    0x8E51: 0x8EA1,
    0x8E52: 0x8E63,
    0x8E64: 0x8E2A,
    0x8E75: 0x9B83,
    0x8E8F: 0x8EAA,
    0x8EB2: 0x8EB1,
    0x8EC0: 0x8EAF,
    0x8EC6: 0x9E95,
    0x8F15: 0x8EFD,
    0x8F1B: 0x8F0C,
    0x8F49: 0x8EE2,
    0x8F66: 0x8ECA,
    0x8F67: 0x8ECB,
    0x8F68: 0x8ECC,
    0x8F69: 0x8ED2,
    0x8F6C: 0x8EE2,
    0x8F6D: 0x8EDB,
    0x8F6E: 0x8F2A,
    0x8F6F: 0x8EDF,
    0x8F70: 0x8F5F,
    0x8F72: 0x8EFB,
    0x8F73: 0x8F64,
    0x8F74: 0x8EF8,
    0x8F76: 0x8EFC,
    0x8F78: 0x8EEB,
    0x8F79: 0x8F62,
    0x8F7B: 0x8EFD,
    0x8F7C: 0x8EFE,
    0x8F7D: 0x8F09,
    0x8F7E: 0x8F0A,
    0x8F7F: 0x8F4E,
    0x8F82: 0x8F05,
    0x8F83: 0x8F03,
    0x8F84: 0x8F12,
    0x8F85: 0x8F14,
    0x8F86: 0x8F0C,
    0x8F87: 0x8F26,
    0x8F88: 0x8F29,
    0x8F89: 0x8F1D,
    0x8F8D: 0x8F1F,
    0x8F8E: 0x8F1C,
    0x8F8F: 0x8F33,
    0x8F90: 0x8F3B,
    0x8F91: 0x8F2F,
    0x8F93: 0x8F38,
    0x8F94: 0x8F61,
    0x8F95: 0x8F45,
    0x8F96: 0x8F44,
    0x8F97: 0x8F3E,
    0x8F98: 0x8F46,
    0x8F99: 0x8F4D,
    0x8FA9: 0x8FAF,
    0x8FAB: 0x8FAE,
    0x8FAD: 0x8F9E,
    0x8FB9: 0x908A,
    0x8FBD: 0x907C,
    0x8FBE: 0x9054,
    0x8FC1: 0x9077,
    0x8FC7: 0x904E,
    0x8FC8: 0x9081,
    0x8FD0: 0x904B,
    0x8FD9: 0x9019,
    0x8FDB: 0x9032,
    0x8FDC: 0x9060,
    0x8FDE: 0x9023,
    0x8FDF: 0x9045,
    0x8FEA: 0x5EF8,
    0x8FF3: 0x9015,
    0x8FF4: 0x5EFB,
    0x8FFA: 0x5EFC,
    0x9002: 0x9069,
    0x9009: 0x9078,
    0x900A: 0x905C,
    0x9012: 0x9013,
    0x903B: 0x908F,
    0x9057: 0x907A,
    0x9059: 0x9065,
    0x905E: 0x9013,
    0x9072: 0x9045,
    0x9087: 0x8FE9,
    0x908A: 0x8FBA,
    0x9093: 0x9127,
    0x90AE: 0x90F5,
    0x90B9: 0x9112,
    0x90BB: 0x96A3,
    0x90D1: 0x912D,
    0x90F8: 0x9132,
    0x9109: 0x90F7,
    0x9115: 0x90F7,
    0x9130: 0x96A3,
    0x9166: 0x9197,
    0x9171: 0x91A4,
    0x917F: 0x91C0,
    0x91AB: 0x533B,
    0x91AC: 0x91A4,
    0x91B1: 0x9197,
    0x91C0: 0x91B8,
    0x91CA: 0x91C8,
    0x91CB: 0x91C8,
    0x9246: 0x945A,
    0x9264: 0x920E,
    0x9274: 0x9451,
    0x92AE: 0x947E,
    0x92B3: 0x92ED,
    0x9304: 0x9332,
    0x9322: 0x92AD,
    0x933E: 0x93E8,
    0x934A: 0x932C,
    0x9350: 0x9441,
    0x9373: 0x9D50,
    0x93D3: 0x57AA,
    0x93FD: 0x92B9,
    0x9435: 0x9244,
    0x9444: 0x92F3,
    0x947D: 0x945A,
    0x9489: 0x91D8,
    0x948A: 0x91D7,
    0x948F: 0x91E7,
    0x9490: 0x91E4,
    0x9493: 0x91E3,
    0x9497: 0x91F5,
    0x949C: 0x9245,
    0x949D: 0x920D,
    0x949E: 0x9214,
    0x949F: 0x9418,
    0x94A2: 0x92FC,
    0x94A3: 0x9211,
    0x94A4: 0x9210,
    0x94A5: 0x9470,
    0x94A6: 0x6B3D,
    0x94A7: 0x921E,
    0x94A9: 0x920E,
    0x94AE: 0x9215,
    0x94B0: 0x923A,
    0x94B1: 0x92AD,
    0x94B2: 0x9266,
    0x94B3: 0x9257,
    0x94B4: 0x9237,
    0x94B5: 0x9262,
    0x94BA: 0x925E,
    0x94BB: 0x945A,
    0x94BE: 0x9240,
    0x94BF: 0x923F,
    0x94C1: 0x9244,
    0x94C2: 0x9251,
    0x94C3: 0x9234,
    0x94C4: 0x9460,
    0x94C5: 0x925B,
    0x94C6: 0x925A,
    0x94C9: 0x9249,
    0x94CA: 0x9248,
    0x94CD: 0x9239,
    0x94CE: 0x9438,
    0x94D3: 0x92E9,
    0x94D4: 0x941A,
    0x94D7: 0x92CF,
    0x94D9: 0x9403,
    0x94DB: 0x943A,
    0x94DC: 0x9285,
    0x94E0: 0x93A7,
    0x94E2: 0x9296,
    0x94E3: 0x9291,
    0x94E6: 0x929B,
    0x94E8: 0x9293,
    0x94EB: 0x929A,
    0x94ED: 0x9298,
    0x94EE: 0x931A,
    0x94F0: 0x9278,
    0x94F3: 0x9283,
    0x94F6: 0x9280,
    0x94F8: 0x92F3,
    0x94FB: 0x92D9,
    0x94FE: 0x93C8,
    0x94FF: 0x93D7,
    0x9500: 0x92B7,
    0x9501: 0x9396,
    0x9504: 0x92E4,
    0x9505: 0x934B,
    0x9508: 0x92B9,
    0x950B: 0x92D2,
    0x9510: 0x92ED,
    0x9516: 0x9306,
    0x9519: 0x932F,
    0x951A: 0x9328,
    0x951C: 0x9321,
    0x9521: 0x932B,
    0x9522: 0x932E,
    0x9523: 0x947C,
    0x9524: 0x9318,
    0x9525: 0x9310,
    0x9526: 0x9326,
    0x952D: 0x9320,
    0x952E: 0x9375,
    0x952F: 0x92F8,
    0x9531: 0x9319,
    0x9533: 0x9348,
    0x9535: 0x93D8,
    0x9537: 0x9354,
    0x9539: 0x936C,
    0x953A: 0x937E,
    0x953B: 0x935B,
    0x953D: 0x9360,
    0x953E: 0x9370,
    0x9540: 0x934D,
    0x9542: 0x93E4,
    0x9547: 0x93AE,
    0x954A: 0x9477,
    0x954C: 0x942B,
    0x9550: 0x93AC,
    0x9552: 0x93B0,
    0x9555: 0x9394,
    0x9558: 0x93DD,
    0x955B: 0x93DE,
    0x955C: 0x93E1,
    0x955D: 0x93D1,
    0x955E: 0x93C3,
    0x9560: 0x93D0,
    0x9561: 0x9414,
    0x9563: 0x9410,
    0x9566: 0x9413,
    0x956B: 0x9419,
    0x956E: 0x9436,
    0x9574: 0x945E,
    0x957F: 0x9577,
    0x95B1: 0x95B2,
    0x95DC: 0x95A2,
    0x95E8: 0x9580,
    0x95E9: 0x9582,
    0x95ED: 0x9589,
    0x95EE: 0x554F,
    0x95EF: 0x95D6,
    0x95F0: 0x958F,
    0x95F2: 0x9591,
    0x95F4: 0x9593,
    0x95F5: 0x9594,
    0x95F7: 0x60B6,
    0x95F8: 0x9598,
    0x95F9: 0x9B27,
    0x95FA: 0x95A8,
    0x95FB: 0x805E,
    0x95FC: 0x95E5,
    0x95FE: 0x95AD,
    0x9600: 0x95A5,
    0x9601: 0x95A3,
    0x9604: 0x9B2E,
    0x9605: 0x95B2,
    0x9607: 0x95CD,
    0x9608: 0x95BE,
    0x9609: 0x95B9,
    0x960B: 0x9B29,
    0x960E: 0x95BB,
    0x960F: 0x95BC,
    0x9610: 0x95E1,
    0x9611: 0x95CC,
    0x9612: 0x95C3,
    0x9614: 0x95CA,
    0x9616: 0x95D4,
    0x9619: 0x95D5,
    0x961F: 0x968A,
    0x9631: 0x7A7D,
    0x9633: 0x967D,
    0x9634: 0x9670,
    0x9635: 0x9663,
    0x9636: 0x968E,
    0x9645: 0x969B,
    0x9646: 0x9678,
    0x9647: 0x96B4,
    0x9648: 0x9673,
    0x9655: 0x965C,
    0x9668: 0x9695,
    0x9669: 0x967A,
    0x9677: 0x9665,
    0x9690: 0x96A0,
    0x96AA: 0x967A,
    0x96B1: 0x96A0,
    0x96B6: 0x96B7,
    0x96B8: 0x96B7,
    0x96BD: 0x96CB,
    0x96BE: 0x96E3,
    0x96CF: 0x96DB,
    0x96D9: 0x53CC,
    0x96DC: 0x96D1,
    0x96DE: 0x9D8F,
    0x96F3: 0x9742,
    0x96FE: 0x9727,
    0x9701: 0x973D,
    0x972D: 0x9744,
    0x9738: 0x8987,
    0x9748: 0x970A,
    0x975C: 0x9759,
    0x9765: 0x9768,
    0x9791: 0x97C3,
    0x97CC: 0x976D,
    0x97E6: 0x97CB,
    0x97E7: 0x976D,
    0x97E9: 0x97D3,
    0x97EC: 0x97DC,
    0x97ED: 0x97EE,
    0x9830: 0x982C,
    0x9838: 0x981A,
    0x9839: 0x983D,
    0x984F: 0x9854,
    0x986F: 0x9855,
    0x9875: 0x9801,
    0x9876: 0x9802,
    0x9877: 0x9803,
    0x9879: 0x9805,
    0x987A: 0x9806,
    0x987D: 0x9811,
    0x987E: 0x9867,
    0x987F: 0x9813,
    0x9881: 0x9812,
    0x9882: 0x980C,
    0x9883: 0x980F,
    0x9884: 0x9810,
    0x9885: 0x9871,
    0x9886: 0x9818,
    0x9887: 0x9817,
    0x9888: 0x981A,
    0x9889: 0x9821,
    0x988A: 0x982C,
    0x988D: 0x6F41,
    0x9890: 0x9824,
    0x9891: 0x983B,
    0x9893: 0x983D,
    0x9894: 0x9837,
    0x9896: 0x7A4E,
    0x9897: 0x9846,
    0x9898: 0x984C,
    0x989A: 0x984E,
    0x989C: 0x9854,
    0x989D: 0x984D,
    0x989E: 0x9873,
    0x98A0: 0x985B,
    0x98A2: 0x9865,
    0x98A4: 0x986B,
    0x98A6: 0x9870,
    0x98A7: 0x9874,
    0x98CE: 0x98A8,
    0x98D2: 0x98AF,
    0x98D3: 0x98B6,
    0x98D8: 0x98C4,
    0x98D9: 0x98C6,
    0x98E7: 0x55B0,
    0x98E8: 0x9957,
    0x98F1: 0x9910,
    0x991A: 0x80B4,
    0x9937: 0x5056,
    0x9938: 0x75C3,
    0x9965: 0x98E2,
    0x9968: 0x98E9,
    0x996B: 0x98EB,
    0x996C: 0x98ED,
    0x996D: 0x98EF,
    0x996E: 0x98F2,
    0x996F: 0x991E,
    0x9970: 0x98FE,
    0x9971: 0x98FD,
    0x9972: 0x98FC,
    0x9974: 0x98F4,
    0x9975: 0x990C,
    0x9976: 0x9952,
    0x9977: 0x9909,
    0x997C: 0x9905,
    0x997F: 0x9913,
    0x9980: 0x9918,
    0x9981: 0x9912,
    0x9985: 0x9921,
    0x9986: 0x9928,
    0x9988: 0x994B,
    0x998F: 0x993E,
    0x9991: 0x9949,
    0x9992: 0x9945,
    0x9994: 0x994C,
    0x99A4: 0x9DAB,
    0x99AA: 0x8F5C,
    0x99B1: 0x99C4,
    0x99E0: 0x97B4,
    0x9A26: 0x70BB,
    0x9A2D: 0x96B2,
    0x9A37: 0x9A12,
    0x9A45: 0x99C6,
    0x9A52: 0x9A28,
    0x9A57: 0x9A13,
    0x9A5B: 0x99C5,
    0x9A6C: 0x99AC,
    0x9A6D: 0x99AD,
    0x9A6E: 0x99C4,
    0x9A6F: 0x99B4,
    0x9A70: 0x99B3,
    0x9A71: 0x99C6,
    0x9A73: 0x99C1,
    0x9A74: 0x9A62,
    0x9A76: 0x99DB,
    0x9A77: 0x99DF,
    0x9A79: 0x99D2,
    0x9A7B: 0x99D0,
    0x9A7C: 0x99DD,
    0x9A7D: 0x99D1,
    0x9A7E: 0x99D5,
    0x9A7F: 0x99C5,
    0x9A80: 0x99D8,
    0x9A81: 0x9A4D,
    0x9A82: 0x7F75,
    0x9A84: 0x9A55,
    0x9A86: 0x99F1,
    0x9A87: 0x99ED,
    0x9A88: 0x99E2,
    0x9A8A: 0x9A6A,
    0x9A8B: 0x9A01,
    0x9A8C: 0x9A13,
    0x9A8E: 0x99F8,
    0x9A8F: 0x99FF,
    0x9A90: 0x9A0F,
    0x9A93: 0x9A05,
    0x9A96: 0x9A42,
    0x9A97: 0x9A19,
    0x9A98: 0x96B2,
    0x9A9A: 0x9A12,
    0x9A9E: 0x9A2B,
    0x9AA0: 0x9A43,
    0x9AA1: 0x9A3E,
    0x9AA4: 0x9A5F,
    0x9AA5: 0x9A65,
    0x9AA7: 0x9A64,
    0x9AC5: 0x9ACF,
    0x9AD3: 0x9AC4,
    0x9AEE: 0x9AEA,
    0x9B04: 0x9AE2,
    0x9B13: 0x9B22,
    0x9B25: 0x95D8,
    0x9B47: 0x9B58,
    0x9B49: 0x9B4E,
    0x9BC7: 0x9C00,
    0x9C0D: 0x9C0C,
    0x9C49: 0x9F08,
    0x9C77: 0x9C10,
    0x9C7C: 0x9B5A,
    0x9C82: 0x9B74,
    0x9C87: 0x9B8E,
    0x9C8A: 0x9B93,
    0x9C8B: 0x9B92,
    0x9C8D: 0x9B91,
    0x9C91: 0x9BAD,
    0x9C94: 0x9BAA,
    0x9C99: 0x9C60,
    0x9C9B: 0x9BAB,
    0x9C9C: 0x9BAE,
    0x9CA3: 0x9C39,
    0x9CA4: 0x9BC9,
    0x9CA7: 0x9BC0,
    0x9CA8: 0x9BCA,
    0x9CAD: 0x9BD6,
    0x9CB1: 0x9BE1,
    0x9CB2: 0x9BE4,
    0x9CB5: 0x9BE2,
    0x9CB6: 0x9BF0,
    0x9CB7: 0x9BDB,
    0x9CB8: 0x9BE8,
    0x9CBB: 0x9BD4,
    0x9CBD: 0x9C08,
    0x9CC3: 0x9C13,
    0x9CC4: 0x9C10,
    0x9CC5: 0x9C0D,
    0x9CC6: 0x9C12,
    0x9CC7: 0x9C09,
    0x9CCC: 0x9C32,
    0x9CCD: 0x9C2D,
    0x9CCF: 0x9C25,
    0x9CD4: 0x9C3E,
    0x9CD5: 0x9C48,
    0x9CD7: 0x9C3B,
    0x9CD9: 0x6A2B,
    0x9CDE: 0x9C57,
    0x9CDF: 0x9C52,
    0x9CE2: 0x9C67,
    0x9CE7: 0x9CEC,
    0x9D25: 0x9D2A,
    0x9DAF: 0x9D2C,
    0x9DD4: 0x7C7E,
    0x9DD7: 0x9D0E,
    0x9E1F: 0x9CE5,
    0x9E20: 0x9CE9,
    0x9E21: 0x9D8F,
    0x9E22: 0x9CF6,
    0x9E23: 0x9CF4,
    0x9E25: 0x9D0E,
    0x9E26: 0x9D09,
    0x9E28: 0x9D07,
    0x9E29: 0x9D06,
    0x9E2A: 0x9D23,
    0x9E2B: 0x9D87,
    0x9E2D: 0x9D28,
    0x9E2F: 0x9D26,
    0x9E30: 0x9D12,
    0x9E31: 0x9D1F,
    0x9E33: 0x9D1B,
    0x9E34: 0x9DFD,
    0x9E35: 0x9D15,
    0x9E37: 0x9DD9,
    0x9E3D: 0x9D3F,
    0x9E3E: 0x9E1E,
    0x9E3F: 0x9D3B,
    0x9E43: 0x9D51,
    0x9E44: 0x9D60,
    0x9E45: 0x9D5D,
    0x9E48: 0x9D5C,
    0x9E49: 0x9D61,
    0x9E4A: 0x9D72,
    0x9E4D: 0x9DA4,
    0x9E4E: 0x9D6F,
    0x9E4F: 0x9D6C,
    0x9E51: 0x9D89,
    0x9E57: 0x9D9A,
    0x9E58: 0x9DBB,
    0x9E5C: 0x9DA9,
    0x9E5E: 0x9DC2,
    0x9E5F: 0x9DB2,
    0x9E61: 0x9DBA,
    0x9E62: 0x9DC1,
    0x9E64: 0x9DB4,
    0x9E66: 0x9E1A,
    0x9E67: 0x9DD3,
    0x9E69: 0x9DEF,
    0x9E6A: 0x9DE6,
    0x9E6B: 0x9DF2,
    0x9E6C: 0x9DF8,
    0x9E6D: 0x9DFA,
    0x9E70: 0x9DF9,
    0x9E73: 0x9E1B,
    0x9E7C: 0x9E78,
    0x9E7D: 0x5869,
    0x9EA2: 0x9C1B,
    0x9EA5: 0x9EA6,
    0x9EA9: 0x9EB8,
    0x9EB4: 0x9EB9,
    0x9EB5: 0x9EBA,
    0x9EBD: 0x6A0C,
    0x9EC3: 0x9EC4,
    0x9EC9: 0x9ECC,
    0x9ED1: 0x9ED2,
    0x9ED8: 0x9ED9,
    0x9EDE: 0x70B9,
    0x9EE9: 0x9EF7,
    0x9EFE: 0x9EFD,
    0x9F4A: 0x6589,
    0x9F4B: 0x658E,
    0x9F4F: 0x97F2,
    0x9F50: 0x6589,
    0x9F51: 0x9F4F,
    0x9F52: 0x6B6F,
    0x9F61: 0x9F62,
    0x9F7F: 0x6B6F,
    0x9F80: 0x9F54,
    0x9F83: 0x9F5F,
    0x9F84: 0x9F62,
    0x9F86: 0x9F60,
    0x9F88: 0x9F66,
    0x9F89: 0x9F6C,
    0x9F8A: 0x9F6A,
    0x9F8B: 0x9F72,
    0x9F8C: 0x9F77,
    0x9F8D: 0x7ADC,
    0x9F99: 0x7ADC,
    0x9F9B: 0x9F95,
    0x9F9C: 0x4E80,
    0x9F9F: 0x4E80,
}


def default_error_handler(char, e):
    return char


def empty_error_handler(char, e):
    return ''


def null_error_handler(char, e):
    return char


def raise_error_handler(char, e):
    raise e


def converter(text, table, errors=None):
    if errors is None:
        errors = default_error_handler
    assert errors is None or callable(errors)
    ret = [UEMPTY] * len(text)
    for i, char in enumerate(text):
        try:
            ret[i] = chr(table[ord(char)])
        except KeyError as e:
            ret[i] = errors(char, e)
    return UEMPTY.join(ret)


# <FIXME> some characters are not in SHIFT_JIS
for k in (0x805B, 0x607A, 0x607D, 0x6080, 0x6374, 0x83B8, 0x83E4, 0x8416,
        0x8421, 0x849E, 0x663A, 0x6670, 0x7118, 0x9BC7, 0x6725, 0x6862, 0x89E5,
        0x8A1A, 0x8BB1, 0x8C0C, 0x8C6C, 0x6CFE, 0x8D95, 0x6DB1, 0x4E85, 0x6EE2,
        0x9093, 0x70E8, 0x50E9, 0x51DE, 0x72B7, 0x52F2, 0x52FB, 0x5389, 0x740F,
        0x948A, 0x9490, 0x94A4, 0x94B0, 0x94BE, 0x94C2, 0x94F0, 0x94FB, 0x951C,
        0x9533, 0x953E, 0x955B, 0x7856, 0x98A2, 0x7936, 0x9A26, 0x5CAD, 0x7CB8,
        0x94CD, 0x7CED, 0x5D58, 0x5DE0, 0x7DFE, 0x5E15, 0x7F2F):
    del Chinese2Kanji_Table[k]


if '__main__' == __name__:
    import unittest

    class ConverterTest(unittest.TestCase):
        def toU(self, s):
            return s.decode('utf8') if py2 else s

        def testSimpTrad(self):
            s1 = self.toU('优酷视频下载的Python')
            s2 = self.toU('優酷視頻下載的Python')
            self.assertEqual(
                    converter(s1, Simp2Trad_Table, null_error_handler),
                    s2)
            self.assertEqual(
                    converter(s2, Trad2Simp_Table, null_error_handler),
                    s1)

        def testSimpKanji(self):
            s1 = self.toU('从优酷网站上下载flv或mp4格式的视频文件')
            s2 = self.toU('从優酷网站上下載flv或mp4格式的視頻文件')
            self.assertEqual(converter(s1, Chinese2Kanji_Table), s2)
            self.assertEqual(converter(s2, Kanji2Simp_Table), s1)

        def testTradKanji(self):
            s1 = self.toU('mp4格式的視頻文件（包括分段視頻的拼接）')
            self.assertEqual(
                    converter(s1, Chinese2Kanji_Table, empty_error_handler),
                    self.toU(''))
            self.assertEqual(converter(s1, Chinese2Kanji_Table), s1)
            self.assertEqual(converter(s1, Kanji2Trad_Table), s1)

    # out = []
    # for k, v in Chinese2Kanji_Table.items():
    #     try:
    #         bytes(chr(v), 'SHIFT-JIS')
    #     except:
    #         out.append('0x%X' % k)
    # print(', '.join(out))

    unittest.main()
