﻿

//设置标尺为像素
preferences.rulerUnits = Units.PIXELS;

//禁止警告弹窗
displayDialogs = DialogModes.NO

//定义黑色
black = new SolidColor();
black.rgb.red = black.rgb.green = black.rgb.blue = 0;

//定义灰色
grey = new SolidColor();
grey.rgb.red = grey.rgb.green = grey.rgb.blue = 120;





//读取数据
var GetExif = function (Data) {
	var AD = activeDocument;
	if (ExternalObject.AdobeXMPScript == undefined) {
		ExternalObject.AdobeXMPScript = new ExternalObject("lib:AdobeXMPScript");
	}
	var xmp = new XMPMeta(AD.xmpMetadata.rawData);
	

	// 设置ppi为300
	var SetPpi = charIDToTypeID( "ImgS" );
		var desc = new ActionDescriptor();
		var Rslt = charIDToTypeID( "Rslt" );
		var Rsl = charIDToTypeID( "#Rsl" );
		desc.putUnitDouble( Rslt, Rsl, 300.000000 );
	executeAction( SetPpi, desc, DialogModes.NO );

	//////////////////////////////////////////////

	/*焦距 */
	if (xmp.doesPropertyExist(XMPConst.NS_EXIF, "FocalLength")) {
		var FocalLength = xmp.getProperty(XMPConst.NS_EXIF, "FocalLength").toString();
		var i = FocalLength.split("/")[0];
		var j = FocalLength.split("/")[1];
		FocalLength = parseInt(i / j);

	} else {
		var FocalLength = "80"
	}


	/*光圈 */
	if (xmp.doesPropertyExist(XMPConst.NS_EXIF, "FNumber")) {
		var FNumber = xmp.getProperty(XMPConst.NS_EXIF, "FNumber").toString();
		var i = FNumber.split("/")[0];
		var j = FNumber.split("/")[1];
		FNumber = j > 1 ? parseFloat(i / j) : i;

	} else {
		var FNumber = "1.8"
	}


	/*/快门速度 */
	if (xmp.doesPropertyExist(XMPConst.NS_EXIF, "ExposureTime")) {
		var ExposureTime = xmp.getProperty(XMPConst.NS_EXIF, "ExposureTime").toString();
		var j = ExposureTime.split("/")[0];
		var i = ExposureTime.split("/")[1];
		if (j / i >= 1) {

			ExposureTime = parseInt(j / i) + "." + (j - parseInt(j / i) * i);
		} else {
			i = parseInt(i / j);
			j = 1;
			ExposureTime = j + "/" + i;
		}

	} else {
		var ExposureTime = "1/100";
	}


	/*ISO */
	if (xmp.doesArrayItemExist(XMPConst.NS_EXIF, "ISOSpeedRatings", 1)) {
		var ISOSpeedRatings = xmp.getArrayItem(XMPConst.NS_EXIF, "ISOSpeedRatings", 1).toString();

	} else {
		var ISOSpeedRatings = "100";

	}


	/*相机厂家 */
	if (xmp.doesPropertyExist(XMPConst.NS_TIFF, "Make")) {
		var Make = xmp.getProperty(XMPConst.NS_TIFF, "Make").toString().toUpperCase();
	} else {
		var Make = "UNKNOWN CAMERA";
	}


	/*相机型号 */
	if (xmp.doesPropertyExist(XMPConst.NS_TIFF, "Model")) {
		var Model = xmp.getProperty(XMPConst.NS_TIFF, "Model").toString();
		var Model = Model.replace("_2", "ⅱ")
		//var Model = Model.replace("Z", "ℤ")
	} else {
		var Model = "UNKOWN CAMERA";
	}


	// 过滤知名手机厂商型号
	var Phone = ["HUAWEI", "XIAOMI", "REDMI", "SONY"];
	// 如果匹配到列表品牌，就使用手机品牌当相机型号
	if (Phone.join("#").indexOf(Make) > -1) {
		var Model = Make;
	}


	/*拍摄时间*/
	if (xmp.doesPropertyExist(XMPConst.NS_EXIF, "DateTimeOriginal")) {
		var dateTimeOriginal = xmp.getProperty(XMPConst.NS_EXIF, "DateTimeOriginal").toString().replace(/T/g, " ")
	} else {
		var dateTimeOriginal = new Date().toString().toUpperCase();
	}


	var json = JSON.stringify({
		"Drive": Model,
		"Exif": FocalLength + "MM  F/" + FNumber + "  " + ExposureTime + "  ISO" + ISOSpeedRatings,
		"Time": dateTimeOriginal.toUpperCase(),
	})

	return json;

}





var UPguides = function(Frame,lastFrame,TxtDis) {

	var AD = activeDocument;
	// 删除参考线
	if (AD.guides.length > -1) {
		AD.guides.removeAll()
	}
		//画布属性
		var photoWidth = AD.width.value;
		var photoHight = AD.height.value;

	// 创建参考线
	Frame = Frame * 0.01 * 150;
	// 左
	var L = Frame * -1;
	AD.guides.add(Direction.VERTICAL, UnitValue(L + " px"));

	// 上
	// var T = Frame / 2;
	AD.guides.add(Direction.HORIZONTAL, UnitValue(L + " px"));

	// 右
	var R = photoWidth + Frame;
	AD.guides.add(Direction.VERTICAL, UnitValue(R + " px"));

	// 下
	var B = photoHight + Frame;
	AD.guides.add(Direction.HORIZONTAL, UnitValue(B + " px"));

	// 下下
	var BB = B + ((lastFrame*0.01)* (photoHight*0.1) );
	AD.guides.add(Direction.HORIZONTAL, UnitValue(BB + " px"));


	// 左字
	var Ll = TxtDis * 0.01 * (photoWidth * 0.2);
	AD.guides.add(Direction.VERTICAL, UnitValue(Ll + " px"));

	// 右字
	var Rr = photoWidth - Ll;
	AD.guides.add(Direction.VERTICAL, UnitValue(Rr + " px"));




}




var Generates = function (Data) {

	var AD = app.activeDocument;


	// 设置ppi为300
	var SetPpi = charIDToTypeID( "ImgS" );
		var desc = new ActionDescriptor();
		var Rslt = charIDToTypeID( "Rslt" );
		var Rsl = charIDToTypeID( "#Rsl" );
		desc.putUnitDouble( Rslt, Rsl, 300.000000 );
	executeAction( SetPpi, desc, DialogModes.NO );

	//画布属性
	var photoWidth = AD.width.value;
	var photoHight = AD.height.value;


	//边框宽度,这里将宽窄设为图片宽度+高度的总和的1/80，两边，实际宽度再除以2
	var StrokeWidth = 300 * (Data.Frame * 0.01);
	var lastFrameWidth = (photoHight*0.1) * (Data.lastFrame * 0.01);
	

	//设置边框
	AD.resizeCanvas(AD.width.value + StrokeWidth, AD.height.value + StrokeWidth, AnchorPosition.MIDDLECENTER);



	// 横图主次文字Y位置
	var landTextPosYMain = photoHight + StrokeWidth * 0.5  + (StrokeWidth * 0.5 + lastFrameWidth) * 0.2; //10%的位置
	var landTextPosYSec = photoHight + StrokeWidth * 0.5  + (StrokeWidth * 0.5 + lastFrameWidth) * 0.6; //50%的位置




	//修改画布大小顶部缩放 增加底部宽度
	AD.resizeCanvas(AD.width.value, AD.height.value + lastFrameWidth, AnchorPosition.TOPCENTER);
 

	// 获取新的画布数据
	var AD2 = app.activeDocument;
	//画布属性
	var photoWidth2 = AD2.width.value;
	var photoHight2 = AD2.height.value;

	// 文字左右边距
	var TxtDisValue = Data.TxtDis * 0.01 * (photoWidth * 0.2); //获取参考线的边距：由原始图像宽度的20% 乘以滑杆的百分比得出。
	var TextDisRight = photoWidth2 - (StrokeWidth * 0.5) - TxtDisValue;
	var TextDisLeft =  photoWidth2 - TextDisRight ;


	//新建型号
	AddText({
		Str: Data.Drive,
		H: lastFrameWidth * 0.25, //字体高度占25%
		X: TextDisLeft,
		Y: landTextPosYMain,
	})


	//新建拍摄信息
	AddText({
		Str: Data.Exif,
		H: lastFrameWidth * 0.25,
		Just: true,
		X:  TextDisRight,
		Y: landTextPosYMain,
	})
	//新建时间
	AddText({
		Str: Data.Time,
		Color: grey,
		H: lastFrameWidth * 0.15,
		X: TextDisLeft,
		Y: landTextPosYSec,
	})

	//新建作者
	AddText({
		Str: Data.Signa,
		Color: grey,
		H: lastFrameWidth * 0.15,
		Just: true,
		X:  TextDisRight,
		Y: landTextPosYSec,
	})





}








//统一新建图层函数
function AddText(Data) {




	var AD = app.activeDocument;
	//新建文字图层
	var TextLayer = AD.artLayers.add();
	TextLayer.kind = LayerKind.TEXT;

	//取得文字对象 
	var TextView = TextLayer.textItem;


	//字体、字号、颜色等  
	TextView.font = Data.Font || "AdobeHeitiStd-Regular"; // Data.Font || "AdobeHeitiStd-Regular";
	//如果为白框，字体为黑色
	TextView.color = Data.Color || black;
	//字体大小
	TextView.size = parseInt(Data.Size) || 24;
	//文本内容
	TextView.contents = Data.Str || "";
	//对齐方式
	TextView.justification = Data.Just ? Justification.RIGHT : Justification.LEFT;

	//粗体
	TextView.fauxBold = Data.Bold || true;
	//文本的位置
	//TextView.position = [ 0, 0];
	//返回图层的具体信息


	var H = Math.abs(TextLayer.bounds[3] - TextLayer.bounds[1]) //减法绝对值 获得高度



	// 目标尺寸
	var target_size = Data.H  || 150
	// 1%得到的像素 向上取整
	var instance_size = H * 0.01
	// 百分比
	var percentage = target_size / instance_size

	
	// 缩放 用对齐方式来决定缩放的位置
	TextLayer.resize(percentage, percentage, Data.Just ? AnchorPosition.TOPRIGHT : AnchorPosition.TOPLEFT);
	
	//栅格化
	TextLayer.rasterize(RasterizeType.TEXTCONTENTS);
	var X = TextLayer.bounds[0]
	var Y = TextLayer.bounds[1]
	var W = Math.abs(TextLayer.bounds[2] - X)//减法绝对值 获得宽度

	//归零
	TextLayer.translate(X*-1,Y*-1);


	if(Data.Just){
	TextLayer.translate(Data.X - W || 0,Data.Y || 0);
}else{
	TextLayer.translate(Data.X  || 0,Data.Y || 0);
}

}




