/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.generators.config;

import net.bdew.generators.Generators$;
import net.bdew.generators.config.Blocks$;
import net.bdew.generators.config.Items$;
import net.bdew.generators.config.Tuning$;
import net.bdew.generators.config.TurbineMaterial;
import net.bdew.generators.items.TurbineItem;
import net.bdew.generators.items.TurbineUpgradeKit;
import net.bdew.generators.modules.turbine.BlockTurbine;
import net.bdew.lib.Misc$;
import net.bdew.lib.block.BaseBlock;
import net.bdew.lib.recipes.gencfg.ConfigSection;
import net.minecraftforge.oredict.OreDictionary;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;

public final class TurbineMaterials$ {
    public static final TurbineMaterials$ MODULE$;
    private Map<String, TurbineMaterial> registry;

    static {
        new TurbineMaterials$();
    }

    public Map<String, TurbineMaterial> registry() {
        return this.registry;
    }

    public void registry_$eq(Map<String, TurbineMaterial> x$1) {
        this.registry = x$1;
    }

    public Set<TurbineMaterial> materials() {
        return this.registry().values().toSet();
    }

    public void init() {
        Tuning$.MODULE$.getSection("TurbineMaterials").filterType(ConfigSection.class).withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<String, ConfigSection> check$ifrefutable$1) {
                Tuple2<String, ConfigSection> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(){

            public final void apply(Tuple2<String, ConfigSection> x$1) {
                Tuple2<String, ConfigSection> tuple2 = x$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String name = (String)tuple2._1();
                    ConfigSection cfg = (ConfigSection)tuple2._2();
                    if (cfg.hasValue("ReqOreDict") && OreDictionary.getOres((String)cfg.getString("ReqOreDict")).isEmpty()) {
                        Generators$.MODULE$.logInfo("Turbine material %s not present - skipping", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (cfg.hasValue("ReqMod") && !Misc$.MODULE$.haveModVersion(cfg.getString("ReqMod"))) {
                        Generators$.MODULE$.logInfo("Mod %s for turbine material %s not present - skipping", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cfg.getString("ReqMod"), name}));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Generators$.MODULE$.logInfo("Registering turbine material: %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
                        TurbineMaterial material = new TurbineMaterial(name, cfg.getInt("Tier"), cfg.getDouble("MaxMJPerTick"), cfg.getDouble("InertiaMultiplier"));
                        TurbineMaterials$.MODULE$.registry_$eq((Map<String, TurbineMaterial>)TurbineMaterials$.MODULE$.registry().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)material)));
                        if (!cfg.hasValue("RegisterBlade") || cfg.getBoolean("RegisterBlade")) {
                            material.bladeItem_$eq((Option<TurbineItem>)new Some((Object)Items$.MODULE$.regItem(new TurbineItem(material, "Blade"))));
                        }
                        if (!cfg.hasValue("RegisterRotor") || cfg.getBoolean("RegisterRotor")) {
                            material.rotorItem_$eq((Option<TurbineItem>)new Some((Object)Items$.MODULE$.regItem(new TurbineItem(material, "Rotor"))));
                        }
                        if (!cfg.hasValue("RegisterKit") || cfg.getBoolean("RegisterKit")) {
                            material.kitItem_$eq((Option<TurbineItem>)new Some((Object)Items$.MODULE$.regItem(new TurbineUpgradeKit(material))));
                        }
                        material.turbineBlock_$eq((Option<BlockTurbine>)new Some((Object)Blocks$.MODULE$.regBlock((BaseBlock)new BlockTurbine(material), true)));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    private TurbineMaterials$() {
        MODULE$ = this;
        this.registry = Predef$.MODULE$.Map().empty();
    }
}

