<?php

	/*******************************************************************\
	|																	|
	|	房佳（新房报备ERP管理系统）										|
	|																	|
	|	© 2020-2023 http://www.kaidandashi.com/ All rights reserved.	|
	|																	|
	|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
	|																	|
	|	QQ号：984784483													|
	|																	|
	\*******************************************************************/

	namespace Admin\Controller;
	use Think\Controller;
	class LoupanController extends CommonController {

		// 楼盘列表
		public function index(){
			if (I('is_ajax')) {
				$condition = "e.gongsiid = '".session('gongsiid')."'";
				$x = _rbac_lists_where(963,0);
				if ($x && $x != "all" && $x != "me") {
					$condition .= " and e.bumen in ({$x})";
				} elseif ($x == "me") {
					$condition .= " and e.id = '".session('uid')."'";
				} elseif ($x == false) {
					$condition .= " and e.id = 0";
				}
				$sousuo = sql_check_param(I('sousuo'));
				if ($sousuo) {
					$condition .= " and (a.xiaoqum like '%$sousuo%' or a.pinyinjs like '%$sousuo%')";
				}
				$field = I('field'); //排序字段名
				$order = I('order'); //排序方式
				$limit = I('limit',30,'int'); //每页条数
				$limit = $limit > 150 ? 150 : $limit;
				if ($field && $order) {
					$xqpx = "a.".$field." ".$order;
				} else {
					$xqpx = "a.id desc";
				}
				$count = M('xiaoqu')->alias('a')->join('jjrxt_yonghu e on a.whrid=e.id')->where($condition)->count();
				$Page = I('p');
				$data = M('xiaoqu')->alias('a')->join('jjrxt_yonghu e on a.whrid=e.id')->field('a.*,e.ygmingcheng,e.dianhua,e.bumen as whrbm')->where($condition)->order($xqpx)->page($Page,$limit)->select();
				foreach ($data as $key => $value) {
					$img = get_x_img($value['id']);
					$data[$key]['img'] = $img ? $img['imgxt'] : "/Public/img/default_icon.png";
					$data[$key]['pqm'] = zym($value['sspianqu'],2);
					$data[$key]['whr'] = $value['ygmingcheng'];
					$data[$key]['whrdh'] = $value['dianhua'];
					$data[$key]['whrbm'] = zym($value['whrbm'],6);
					$is_rbacxq = _rbac_btn_show(964,0,$value['whrid']);
					$data[$key]['rbacxq'] = $is_rbacxq ? 1 : 0;
					$data[$key]['dituzb'] = $value['dituzb'] ? $value['dituzb'] : "——";
					// $data[$key]['xxm'] = $value['ssxuexiao'] ? zym($value['ssxuexiao'],4) : "——";
				}
				$return_data = array(
					'code'=>0,
					'count'=>$count,
					'data'=>$data
				);
				$this->ajaxReturn($return_data);
			} else {
				$this->display();
			}
		}

		// 楼盘内容
		public function neirong(){
			$id = I('id',0,'int');
			$xiaoqu = M('xiaoqu')->where(array('id'=>$id))->find();
			$is_rbac = _rbac_btn_show(964,0,$xiaoqu['whrid']);
			if (!$is_rbac) {
				$this->redirect('Index/error');
			}
			switch ($xiaoqu['5a']) {
				case 1:
					$wua = "有";
					break;
				case 2:
					$wua = "无";
					break;
				default:
					$wua = "暂无信息";
					break;
			}
			switch ($xiaoqu['zhuce']) {
				case 1:
					$zhuce = "有";
					break;
				case 2:
					$zhuce = "无";
					break;
				default:
					$zhuce = "暂无信息";
					break;
			}
			switch ($xiaoqu['chewei']) {
				case 1:
					$chewei = "有";
					break;
				case 2:
					$chewei = "无";
					break;
				default:
					$chewei = "暂无信息";
					break;
			}
			switch ($xiaoqu['dianti']) {
				case 1:
					$dianti = "有";
					break;
				case 2:
					$dianti = "无";
					break;
				default:
					$dianti = "暂无信息";
					break;
			}
			switch ($xiaoqu['youhui']) {
				case 1:
					$youhui = "有";
					break;
				case 2:
					$youhui = "无";
					break;
				default:
					$youhui = "暂无信息";
					break;
			}
			switch ($xiaoqu['yjfjzx']) {
				case 1:
					$yjfjzx = "有";
					break;
				case 2:
					$yjfjzx = "无";
					break;
				default:
					$yjfjzx = "暂无信息";
					break;
			}
			switch ($xiaoqu['wldiban']) {
				case 1:
					$wldiban = "有";
					break;
				case 2:
					$wldiban = "无";
					break;
				default:
					$wldiban = "暂无信息";
					break;
			}
			switch ($xiaoqu['ygcanting']) {
				case 1:
					$ygcanting = "有";
					break;
				case 2:
					$ygcanting = "无";
					break;
				default:
					$ygcanting = "暂无信息";
					break;
			}
			$xzqming = zym($xiaoqu['ssxzq'],1);
			$pianqum = zym($xiaoqu['sspianqu'],2);
			$ssxzq = $xzqming ? $xzqming : "";
			$sspq = $pianqum ? $pianqum : "";
			$diqu = $ssxzq && $sspq ? $ssxzq."-".$sspq : $ssxzq.$sspq;
			// $xuexiao = zym($xiaoqu['ssxuexiao'],4);
			$fukuan = get_peizhi('lpfkfs',$xiaoqu['fukuan'],3);
			$wuyelx = get_peizhi('wuyelx',$xiaoqu['wuyelx'],3);
			$wuyezz = get_peizhi('wuyezz',$xiaoqu['wuyezz'],3);
			$xmjibie = get_peizhi('xmjibie',$xiaoqu['xmjibie'],3);
			$gongqifs = get_peizhi('gongqifs',$xiaoqu['gongqifs'],3);
			$gongrefs = get_peizhi('gongrefs',$xiaoqu['gongrefs'],3);
			$kangzhen = get_peizhi('kangzhen',$xiaoqu['kangzhen'],3);
			$ceweizldw = get_peizhi('ceweizldw',$xiaoqu['ceweizldw'],3);
			$gongdianlx = get_peizhi('gongdianlx',$xiaoqu['gongdianlx'],3);
			$gongshuilx = get_peizhi('gongshuilx',$xiaoqu['gongshuilx'],3);
			$spjzleixing = get_peizhi('spjzleixing',$xiaoqu['spjzleixing'],3);
			$xiaoqu['5a'] = $wua;
			$xiaoqu['zhuce'] = $zhuce;
			$xiaoqu['chewei'] = $chewei;
			$xiaoqu['dianti'] = $dianti;
			$xiaoqu['youhui'] = $youhui;
			$xiaoqu['yjfjzx'] = $yjfjzx;
			$xiaoqu['wldiban'] = $wldiban;
			$xiaoqu['ygcanting'] = $ygcanting;
			$xiaoqu['diqu'] = $diqu ? $diqu : "暂无信息";
            $xiaoqu['fukuan'] = $fukuan ? $fukuan : "暂无信息";
			$xiaoqu['wuyelx'] = $wuyelx ? $wuyelx : "暂无信息";
			$xiaoqu['wuyezz'] = $wuyezz ? $wuyezz : "暂无信息";
			// $xiaoqu['xuexiao'] = $xuexiao ? $xuexiao : "暂无信息";
			$xiaoqu['xmjibie'] = $xmjibie ? $xmjibie : "暂无信息";
			$xiaoqu['gongqifs'] = $gongqifs ? $gongqifs : "暂无信息";
			$xiaoqu['gongrefs'] = $gongrefs ? $gongrefs : "暂无信息";
			$xiaoqu['kangzhen'] = $kangzhen ? $kangzhen : "暂无信息";
			$xiaoqu['gongdianlx'] = $gongdianlx ? $gongdianlx : "暂无信息";
			$xiaoqu['gongshuilx'] = $gongshuilx ? $gongshuilx : "暂无信息";
			$xiaoqu['spjzleixing'] = $spjzleixing ? $spjzleixing : "暂无信息";
			$xiaoqu['shoujia'] = $xiaoqu['shoujia'] ? $xiaoqu['shoujia'] : "";
			$xiaoqu['hxymj'] = $xiaoqu['hxymj'] ? $xiaoqu['hxymj'] : "暂无信息";
			$xiaoqu['tihupb'] = $xiaoqu['tihupb'] ? $xiaoqu['tihupb'] : "暂无信息";
			$xiaoqu['wuyemc'] = $xiaoqu['wuyemc'] ? $xiaoqu['wuyemc'] : "暂无信息";
			$xiaoqu['wuyedh'] = $xiaoqu['wuyedh'] ? $xiaoqu['wuyedh'] : "暂无信息";
			$xiaoqu['wuyedz'] = $xiaoqu['wuyedz'] ? $xiaoqu['wuyedz'] : "暂无信息";
			// $xiaoqu['jiedao'] = $xiaoqu['jiedao'] ? $xiaoqu['jiedao'] : "暂无信息";
			// $xiaoqu['beizhu'] = $xiaoqu['beizhu'] ? $xiaoqu['beizhu'] : "暂无信息";
			$xiaoqu['zyktpp'] = $xiaoqu['zyktpp'] ? $xiaoqu['zyktpp'] : "暂无信息";
			$xiaoqu['maidian'] = $xiaoqu['maidian'] ? $xiaoqu['maidian'] : "暂无信息";
			$xiaoqu['zyktjsf'] = $xiaoqu['zyktjsf'] ? $xiaoqu['zyktjsf'] : "暂无信息";
			$xiaoqu['xiaoqum'] = $xiaoqu['xiaoqum'] ? $xiaoqu['xiaoqum'] : "暂无信息";
			$xiaoqu['wlmzxbz'] = $xiaoqu['wlmzxbz'] ? $xiaoqu['wlmzxbz'] : "暂无信息";
			$xiaoqu['jianjie'] = $xiaoqu['jianjie'] ? $xiaoqu['jianjie'] : "暂无信息";
			$xiaoqu['ditielx'] = $xiaoqu['ditielx'] ? $xiaoqu['ditielx'] : "暂无信息";
			$xiaoqu['jinkuang'] = $xiaoqu['jinkuang'] ? $xiaoqu['jinkuang'] : "暂无信息";
			$xiaoqu['baobeigz'] = $xiaoqu['baobeigz'] ? $xiaoqu['baobeigz'] : "暂无信息";
            $xiaoqu['daikangz'] = $xiaoqu['daikangz'] ? $xiaoqu['daikangz'] : "暂无信息";
			$xiaoqu['zyktgzsj'] = $xiaoqu['zyktgzsj'] ? $xiaoqu['zyktgzsj'] : "暂无信息";
			$xiaoqu['youhuizc'] = $xiaoqu['youhuizc'] ? $xiaoqu['youhuizc'] : "暂无信息";
			$xiaoqu['diantixq'] = $xiaoqu['diantixq'] ? $xiaoqu['diantixq'] : "暂无信息";
			// $xiaoqu['xiaoqubm'] = $xiaoqu['xiaoqubm'] ? $xiaoqu['xiaoqubm'] : "暂无信息";
			$xiaoqu['xiaoqudz'] = $xiaoqu['xiaoqudz'] ? $xiaoqu['xiaoqudz'] : "暂无信息";
			// $xiaoqu['youzheng'] = $xiaoqu['youzheng'] ? $xiaoqu['youzheng'] : "暂无信息";
			// $xiaoqu['paichusuo'] = $xiaoqu['paichusuo'] ? $xiaoqu['paichusuo'] : "暂无信息";
			$xiaoqu['jinrongjg'] = $xiaoqu['jinrongjg'] ? $xiaoqu['jinrongjg'] : "暂无信息";
			// $xiaoqu['zhengfujg'] = $xiaoqu['zhengfujg'] ? $xiaoqu['zhengfujg'] : "暂无信息";
			$xiaoqu['ycqdanwei'] = $xiaoqu['ycqdanwei'] ? $xiaoqu['ycqdanwei'] : "暂无信息";
			$xiaoqu['kaifashang'] = $xiaoqu['kaifashang'] ? $xiaoqu['kaifashang'] : "暂无信息";
			$xiaoqu['gongjiaolx'] = $xiaoqu['gongjiaolx'] ? $xiaoqu['gongjiaolx'] : "暂无信息";
			// $xiaoqu['xiuxianyule'] = $xiaoqu['xiuxianyule'] ? $xiaoqu['xiuxianyule'] : "暂无信息";
			$xiaoqu['yiliaojigou'] = $xiaoqu['yiliaojigou'] ? $xiaoqu['yiliaojigou'] : "暂无信息";
			$xiaoqu['ygcantingjj'] = $xiaoqu['ygcantingjj'] ? $xiaoqu['ygcantingjj'] : "暂无信息";
			// $xiaoqu['shangchangcs'] = $xiaoqu['shangchangcs'] ? $xiaoqu['shangchangcs'] : "暂无信息";
			$xiaoqu['jiaowupeitao'] = $xiaoqu['jiaowupeitao'] ? $xiaoqu['jiaowupeitao'] : "暂无信息";
			$xiaoqu['shangwupeitao'] = $xiaoqu['shangwupeitao'] ? $xiaoqu['shangwupeitao'] : "暂无信息";
			$xiaoqu['jingguanpeitao'] = $xiaoqu['jingguanpeitao'] ? $xiaoqu['jingguanpeitao'] : "暂无信息";
			$xiaoqu['zdshu'] = $zdshu > 0 ? $zdshu."栋" : 0;
			$xiaoqu['fjshu'] = $fjshu > 0 ? $fjshu."户" : 0;
			$xiaoqu['baobei'] = $xiaoqu['baobei'] > 0 ? $xiaoqu['baobei']."天" : "暂无信息";
			$xiaoqu['daikan'] = $xiaoqu['daikan'] > 0 ? $xiaoqu['daikan']."天" : "暂无信息";
			// $xiaoqu['rengou'] = $xiaoqu['rengou'] > 0 ? $xiaoqu['rengou']."天" : "暂无信息";
			// $xiaoqu['renchou'] = $xiaoqu['renchou'] > 0 ? $xiaoqu['renchou']."天" : "暂无信息";
			$xiaoqu['lvhualv'] = $xiaoqu['lvhualv'] > 0 ? $xiaoqu['lvhualv']."%" : "暂无信息";
			// $xiaoqu['qianyue'] = $xiaoqu['qianyue'] > 0 ? $xiaoqu['qianyue']."天" : "暂无信息";
			// $xiaoqu['wangqian'] = $xiaoqu['wangqian'] > 0 ? $xiaoqu['wangqian']."天" : "暂无信息";
			$xiaoqu['rongjilv'] = $xiaoqu['rongjilv'] > 0 ? $xiaoqu['rongjilv']."%" : "暂无信息";
			$xiaoqu['nianxian'] = $xiaoqu['nianxian'] > 0 ? $xiaoqu['nianxian']."年" : "暂无信息";
			$zdmjdw = get_peizhi('zdmjdw',$xiaoqu['zdmjdw'],3);
			$xiaoqu['zhandimj'] = $xiaoqu['zhandimj'] > 0 ? $xiaoqu['zhandimj'].$zdmjdw : "暂无信息";
			$xiaoqu['jianzhumj'] = $xiaoqu['jianzhumj'] > 0 ? $xiaoqu['jianzhumj']."m²" : "暂无信息";
			$xiaoqu['jianzaond'] = $xiaoqu['jianzaond'] > 0 ? $xiaoqu['jianzaond']."年" : "暂无信息";
			$xiaoqu['dxiatcwsl'] = $xiaoqu['dxiatcwsl'] > 0 ? $xiaoqu['dxiatcwsl']."个" : "暂无信息";
			$xiaoqu['dshangtcwsl'] = $xiaoqu['dshangtcwsl'] > 0 ? $xiaoqu['dshangtcwsl']."个" : "暂无信息";
			$xiaoqu['shoufu'] = $xiaoqu['shoufu'] > 0 ? floatval($xiaoqu['shoufu'])."%" : "暂无信息";
			$xiaoqu['cenggao'] = $xiaoqu['cenggao'] > 0 ? floatval($xiaoqu['cenggao'])."米" : "暂无信息";
			$xiaoqu['xmgaodu'] = $xiaoqu['xmgaodu'] > 0 ? floatval($xiaoqu['xmgaodu'])."米" : "暂无信息";
			$xiaoqu['bzcjzmj'] = $xiaoqu['bzcjzmj'] > 0 ? floatval($xiaoqu['bzcjzmj'])."m²" : "暂无信息";
			$xiaoqu['dianfei'] = $xiaoqu['dianfei'] > 0 ? floatval($xiaoqu['dianfei'])."元/度" : "暂无信息";
			$xiaoqu['wuyefei'] = $xiaoqu['wuyefei'] > 0 ? floatval($xiaoqu['wuyefei'])."元/月" : "暂无信息";
			$xiaoqu['xfsjgyl'] = $xiaoqu['xfsjgyl'] > 0 ? floatval($xiaoqu['xfsjgyl'])."m³/人/小时" : "暂无信息";
			$xiaoqu['dxiatcwsj'] = $xiaoqu['dxiatcwsj'] > 0 ? floatval($xiaoqu['dxiatcwsj'])."万" : "暂无信息";
			$xiaoqu['gongtanmj'] = $xiaoqu['gongtanmj'] > 0 ? floatval($xiaoqu['gongtanmj'])."m²" : "暂无信息";
			$xiaoqu['csjunjia'] = $xiaoqu['csjunjia'] > 0 ? floatval($xiaoqu['csjunjia'])."元/m²" : "暂无信息";
			$xiaoqu['wldibangd'] = $xiaoqu['wldibangd'] > 0 ? floatval($xiaoqu['wldibangd'])."毫米" : "暂无信息";
			$xiaoqu['dshangtcwsj'] = $xiaoqu['dshangtcwsj'] > 0 ? floatval($xiaoqu['dshangtcwsj'])."万" : "暂无信息";
			$xiaoqu['dxiatcwzl'] = $xiaoqu['dxiatcwzl'] > 0 ? floatval($xiaoqu['dxiatcwzl']).$ceweizldw : "暂无信息";
			$xiaoqu['dshangtcwzl'] = $xiaoqu['dshangtcwzl'] > 0 ? floatval($xiaoqu['dshangtcwzl']).$ceweizldw : "暂无信息";
			$xiaoqu['cainuanfy'] = $xiaoqu['cainuanfy'] > 0 ? floatval($xiaoqu['cainuanfy'])."元/m²/供暖季" : "暂无信息";
			$xiaoqu['kpshijian'] = $xiaoqu['kpshijian'] > 0 ? date('Y-m-d',$xiaoqu['kpshijian']) : "暂无信息";
			$xiaoqu['rzshijian'] = $xiaoqu['rzshijian'] > 0 ? date('Y-m-d',$xiaoqu['rzshijian']) : "暂无信息";
			$Model = new \Think\Model();
			if ($xiaoqu['jiegou']) {
				$condition1 = "pzming = 'jiegou' and lxid in (".$xiaoqu['jiegou'].")";
				$jiegou1 = $Model->query("select * from __PEIZHI__ where {$condition1} order by xsshunxu asc");
				$jiegou2 = array();
				foreach ($jiegou1 AS $key => $val) {
					$jiegou2[] =  $val['lxming'];
				}
				$xiaoqu['jiegou'] = implode("、",$jiegou2);
			} else {
				$xiaoqu['jiegou'] = "暂无信息";
			}
			if ($xiaoqu['yongtu']) {
				$condition2 = "pzming = 'yongtu' and lxid in (".$xiaoqu['yongtu'].")";
				$yongtu1 = $Model->query("select * from __PEIZHI__ where {$condition2} order by xsshunxu asc");
				$yongtu2 = array();
				foreach ($yongtu1 AS $key => $val) {
					$yongtu2[] =  $val['lxming'];
				}
				$xiaoqu['yongtu'] = implode("、",$yongtu2);
			} else {
				$xiaoqu['yongtu'] = "暂无信息";
			}
			if ($xiaoqu['dianshi']) {
				$condition3 = "pzming = 'dianshi' and lxid in (".$xiaoqu['dianshi'].")";
				$dianshi1 = $Model->query("select * from __PEIZHI__ where {$condition3} order by xsshunxu asc");
				$dianshi2 = array();
				foreach ($dianshi1 AS $key => $val) {
					$dianshi2[] =  $val['lxming'];
				}
				$xiaoqu['dianshi'] = implode("、",$dianshi2);
			} else {
				$xiaoqu['dianshi'] = "暂无信息";
			}
			if ($xiaoqu['tongxun']) {
				$condition4 = "pzming = 'tongxun' and lxid in (".$xiaoqu['tongxun'].")";
				$tongxun1 = $Model->query("select * from __PEIZHI__ where {$condition4} order by xsshunxu asc");
				$tongxun2 = array();
				foreach ($tongxun1 AS $key => $val) {
					$tongxun2[] =  $val['lxming'];
				}
				$xiaoqu['tongxun'] = implode("、",$tongxun2);
			} else {
				$xiaoqu['tongxun'] = "暂无信息";
			}
			if ($xiaoqu['chanquan']) {
				$condition5 = "pzming = 'chanquan' and lxid in (".$xiaoqu['chanquan'].")";
				$chanquan1 = $Model->query("select * from __PEIZHI__ where {$condition5} order by xsshunxu asc");
				$chanquan2 = array();
				foreach ($chanquan1 AS $key => $val) {
					$chanquan2[] =  $val['lxming'];
				}
				$xiaoqu['chanquan'] = implode("、",$chanquan2);
			} else {
				$xiaoqu['chanquan'] = "暂无信息";
			}
			if ($xiaoqu['sqanquan']) {
				$condition6 = "pzming = 'sqanquan' and lxid in (".$xiaoqu['sqanquan'].")";
				$sqanquan1 = $Model->query("select * from __PEIZHI__ where {$condition6} order by xsshunxu asc");
				$sqanquan2 = array();
				foreach ($sqanquan1 AS $key => $val) {
					$sqanquan2[] =  $val['lxming'];
				}
				$xiaoqu['sqanquan'] = implode("、",$sqanquan2);
			} else {
				$xiaoqu['sqanquan'] = "暂无信息";
			}
			if ($xiaoqu['cainuanfs']) {
				$condition7 = "pzming = 'cainuanfs' and lxid in (".$xiaoqu['cainuanfs'].")";
				$cainuanfs1 = $Model->query("select * from __PEIZHI__ where {$condition7} order by xsshunxu asc");
				$cainuanfs2 = array();
				foreach ($cainuanfs1 AS $key => $val) {
					$cainuanfs2[] =  $val['lxming'];
				}
				$xiaoqu['cainuanfs'] = implode("、",$cainuanfs2);
			} else {
				$xiaoqu['cainuanfs'] = "暂无信息";
			}
			if ($xiaoqu['fwleixing']) {
				$condition8 = "pzming = 'fwleixing' and lxid in (".$xiaoqu['fwleixing'].")";
				$fwleixing1 = $Model->query("select * from __PEIZHI__ where {$condition8} order by xsshunxu asc");
				$fwleixing2 = array();
				foreach ($fwleixing1 AS $key => $val) {
					$fwleixing2[] =  $val['lxming'];
				}
				$xiaoqu['fwleixing'] = implode("、",$fwleixing2);
			} else {
				$xiaoqu['fwleixing'] = "暂无信息";
			}
			if ($xiaoqu['wldibanlx']) {
				$condition9 = "pzming = 'wldibanlx' and lxid in (".$xiaoqu['wldibanlx'].")";
				$wldibanlx1 = $Model->query("select * from __PEIZHI__ where {$condition9} order by xsshunxu asc");
				$wldibanlx2 = array();
				foreach ($wldibanlx1 AS $key => $val) {
					$wldibanlx2[] =  $val['lxming'];
				}
				$xiaoqu['wldibanlx'] = implode("、",$wldibanlx2);
			} else {
				$xiaoqu['wldibanlx'] = "暂无信息";
			}
			if ($xiaoqu['gongshuifs']) {
				$condition10 = "pzming = 'gongshuifs' and lxid in (".$xiaoqu['gongshuifs'].")";
				$gongshuifs1 = $Model->query("select * from __PEIZHI__ where {$condition10} order by xsshunxu asc");
				$gongshuifs2 = array();
				foreach ($gongshuifs1 AS $key => $val) {
					$gongshuifs2[] =  $val['lxming'];
				}
				$xiaoqu['gongshuifs'] = implode("、",$gongshuifs2);
			} else {
				$xiaoqu['gongshuifs'] = "暂无信息";
			}
			$this->xiaoqu = $xiaoqu;
			$this->display();
		}

		// 添加报备
		public function baobei(){
			$ispl = I('ispl',0,'int');
			if ($ispl) {
				$ids = I('ids');
				if ($ids) {
					$idsz = array_unique(array_filter(explode(",",$ids)));
					$xiaoqu = M('xiaoqu')->where(array('id'=>array('in',$idsz)))->field('id,whrid,xiaoqum')->select();
					foreach ($xiaoqu as $key => $value) {
						$is_rbac = _rbac_btn_show(966,0,$value['whrid']);
						if (!$is_rbac) {
							$this->error('您选择了权限范围外的楼盘！');
						}
					}
				} else {
					$is_rbac = _rbac_node_show(966);
					if (!$is_rbac) {
						$this->error('请选择报备楼盘！');
					}
				}
			} else {
				$id = I('id',0,'int');
				$xiaoqu = M('xiaoqu')->where(array('id'=>$id))->field('xiaoqum,whrid,daikangz')->find();
				$is_rbac = _rbac_btn_show(966,0,$xiaoqu['whrid']);
				if (!$is_rbac) {
					$this->redirect('Index/error');
				}
			}
			if (IS_POST) {
				$whrid = I('whrid',0,'int');
				$is_rbac = _rbac_btn_show(966,0,$whrid);
				if (!$is_rbac) {
					$this->error('您选择了权限范围外的用户！');
				}
				$dianhua = I('dianhua');
				$khxingming = I('khxingming');
				$khtype = I('khtype',0,'int');
				$yjdfsj = strtotime(I('yjdfsj'));
				$khlxm = get_peizhi('yezhulx',$khtype,3);
				$remark = preg_replace ( "/\s(?=\s)/","\\1",I('remark'));
				if (!$khxingming) {
					$this->error('请输入客户姓名！');
				}
				if (!preg_match("/^(13[0-9]|14[0-1,4-9]|15[0-3,5-9]|16[2567]|17[0-8]|18[0-9]|19[0-3,5-9])\d{8}$|^0\d{2,3}-?\d{7,8}$/",$dianhua)) {
					$this->error('客户电话请输入正确的手机号码或电话号码！');
				}
				if ($yjdfsj < time()) {
					$this->error('预计到访时间小于当前时间！');
				}
				if (!preg_match("/^$|^[\s\S]{0,300}$/",$remark)) {
					$this->error('备注只能输入300个字符！');
				}
				if ($ispl) {
					foreach ($xiaoqu as $key => $value) {
						$bh = M('bianhao')->where(array('id'=>7))->setInc('bianhao');
						$bh1 = M('bianhao')->where(array('id'=>7))->getField('bianhao');
						$bianhao = "KH-".$bh1;
						$data['gongsiid'] = session('gongsiid');
						$data['bianhao'] = $bianhao;
						$data['khxingming'] = $khxingming;
						$data['khtype'] = $khtype;
						$data['dianhua'] = $dianhua;
						$data['xiaoqu'] = $value['id'];
						$data['remark'] = $remark;
						$data['yjdfsj'] = $yjdfsj;
						$data['whrid'] = $whrid;
						$data['adduid'] = session('uid');
						$data['addtime'] = time();
						$data['jindu'] = 1;
						$data['status'] = 3;
						$shenhe = session("ygmingcheng")."提交了楼盘【".$value['xiaoqum']."】的报备申请，";
						$shenhe .= "报备编号：【".$bianhao."】；";
						$shenhe .= "客户姓名：【".$khxingming.$khlxm."】；";
						$shenhe .= "客户电话：【".$dianhua."】；";
						$shenhe .= "备注：【".$remark."】；";
						$isok = M('baobei')->add($data);
						$data_shenhe['gongsiid'] = session("gongsiid");
						$data_shenhe['type'] = 1;
						$data_shenhe['zyid'] = $isok;
						$data_shenhe['zybh'] = $bianhao;
						$data_shenhe['status'] = 3;
						$data_shenhe['adduid'] = session("uid");
						$data_shenhe['addtime'] = time();
						$data_shenhe['neirong'] = $shenhe;
						M('shenhe')->add($data_shenhe);
						$data_rizhi['zy_type'] = 4;
						$data_rizhi['uid'] = session("uid");
						$data_rizhi['addtime'] = time();
						$data_rizhi['cz_type'] = 1;
						$data_rizhi['zy_id'] = $isok;
						$data_rizhi['zy_bianhao'] = $bianhao;
						$data_rizhi['neirong'] = "新增报备";
						M('rizhi')->add($data_rizhi);
					}
				} else {
					$bh = M('bianhao')->where(array('id'=>7))->setInc('bianhao');
					$bh1 = M('bianhao')->where(array('id'=>7))->getField('bianhao');
					$bianhao = "KH-".$bh1;
					$data['gongsiid'] = session('gongsiid');
					$data['bianhao'] = $bianhao;
					$data['khxingming'] = $khxingming;
					$data['khtype'] = $khtype;
					$data['dianhua'] = $dianhua;
					$data['xiaoqu'] = $id;
					$data['remark'] = $remark;
					$data['yjdfsj'] = $yjdfsj;
					$data['whrid'] = $whrid;
					$data['adduid'] = session('uid');
					$data['addtime'] = time();
					$data['jindu'] = 1;
					$data['status'] = 3;
					$shenhe = session("ygmingcheng")."提交了楼盘【".$xiaoqu['xiaoqum']."】的报备申请，";
					$shenhe .= "报备编号：【".$bianhao."】；";
					$shenhe .= "客户姓名：【".$khxingming.$khlxm."】；";
					$shenhe .= "客户电话：【".$dianhua."】；";
					$shenhe .= "备注：【".$remark."】；";
					$isok = M('baobei')->add($data);
					$data_shenhe['gongsiid'] = session("gongsiid");
					$data_shenhe['type'] = 1;
					$data_shenhe['zyid'] = $isok;
					$data_shenhe['zybh'] = $bianhao;
					$data_shenhe['status'] = 3;
					$data_shenhe['adduid'] = session("uid");
					$data_shenhe['addtime'] = time();
					$data_shenhe['neirong'] = $shenhe;
					M('shenhe')->add($data_shenhe);
					$data_rizhi['zy_type'] = 4;
					$data_rizhi['uid'] = session("uid");
					$data_rizhi['addtime'] = time();
					$data_rizhi['cz_type'] = 1;
					$data_rizhi['zy_id'] = $isok;
					$data_rizhi['zy_bianhao'] = $bianhao;
					$data_rizhi['neirong'] = "新增报备";
					M('rizhi')->add($data_rizhi);
				}
				if ($isok) {
					$this->success('已提交审核');
				} else {
					$this->error('提交失败！');
				}
			} else {
				if ($ispl) {
					$this->ispl = 1;
				} else {
					$this->ispl = 0;
					$this->id = $id;
					$this->xiaoqum = $xiaoqu['xiaoqum'];
					$this->daikangz = $xiaoqu['daikangz'];
				}
				$this->uid = session('uid');
				$this->khtype = get_peizhi('yezhulx',0,1);
				$this->ygmingcheng = session('ygmingcheng');
				$this->display();
			}
		}

	}