<?php

    /*******************************************************************\
    |                                                                   |
    |   房佳（新房报备ERP管理系统）                                     |
    |                                                                   |
    |   © 2020-2023 http://www.kaidandashi.com/ All rights reserved.    |
    |                                                                   |
    |   本系统由淮南市银泰软件科技有限公司提供技术支持                  |
    |                                                                   |
    |   QQ号：984784483                                                 |
    |                                                                   |
    \*******************************************************************/

    namespace Admin\Controller;
    use Think\Controller;
    class ZiyuanController extends CommonController {
        // 行政区列表
        public function xingzhengqu() {
            if (I('is_ajax')) {
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                $map .= " where gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(372,0);
                if ($x && $x != "all" && $x != "me") {
                    $map .= " and bumen in ({$x})";
                }elseif ($x == "me") {
                    $map .= " and id=".session('uid');
                }elseif ($x == false) {
                    $map .= " and id=0";
                }
                $condition="gongsiid=".session('gongsiid');
                $sousuo = sql_check_param(I('sousuo'));
                if ($sousuo) {
                    $condition.=" and ((xzqming like '%$sousuo%') or (pinyinjs like '%$sousuo%'))";
                }
                if ($field && $order) {
                    $xzqpx.="order by ".$field." ".$order;
                } else {
                    $xzqpx.="order by id DESC";
                }
                $Model = new \Think\Model();
                $count=$Model->query("select count(*) from (select * from __XINGZHENGQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list="select a.*,e.* from (select * from __XINGZHENGQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id ".$xzqpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data=$Model->query($list);
                foreach ($data as $key => $value) {
                    // $data[$key]['ssbm'] = zym($value['bumen'],6);
                    $data[$key]['whbm'] = yhbm($value['whrid'],3);
                    $data[$key]['whr'] = zym($value['whrid'],5);
                    $data[$key]['tjr'] = zym($value['adduid'],5);
                    $is_rbacgx = _rbac_btn_show(375,0,$value['whrid']);
                    // $is_rbaczy = _rbac_btn_show(533,0,$value['whrid']);
                    $is_rbacsc = _rbac_btn_show(377,0,$value['whrid']);
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    // $data[$key]['rbaczy'] = $is_rbaczy ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                    $data[$key]['pinyinjs'] = $value['pinyinjs'] ? $value['pinyinjs'] : "——";
                    $data[$key]['dituzb'] = $value['dituzb'] ? $value['dituzb'] : "——";
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        // 添加行政区
        public function addxzq(){
            $is_rbac = _rbac_node_show(373);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $xzqming=I('xzqming');
                $condition['xzqming']=$xzqming;
                $cfxzq=M('xingzhengqu')->where($condition)->find();
                if($cfxzq){
                    $this->error('行政区已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(373,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['shijian']=time();
                $data['xzqming']=I('xzqming');
                $data['pinyinjs']=I('pinyinjs');
                $data['dituzb']=I('zuobiao');
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['adduid']=session('uid');
                $data['gongsiid']=session('gongsiid');
                $isok=M('xingzhengqu')->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $this->display();
            }
        }
        // 更新行政区
        public function editxzq(){
            $id=I('id');
            $whrid=M('xingzhengqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(375,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $condition['id']=array('neq',$id);
                $xzqming=I('xzqming');
                $condition['xzqming']=$xzqming;
                $cfxzq=M('xingzhengqu')->where($condition)->find();
                if($cfxzq){
                    $this->error('行政区已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(375,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['dituzb']=I('zuobiao');
                $data['xzqming']=I('xzqming');
                $data['pinyinjs']=I('pinyinjs');
                $isok=M("xingzhengqu")->where(array('id'=>$id))->save($data);
                if ($isok){
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $this->xingzhengqu=M('xingzhengqu')->where(array('id'=>$id))->find();
                $this->user=zym($this->xingzhengqu['whrid'],5);
                $this->display();
            }
        }
        // 删除行政区
        public function delxzq(){
            $id=I('id');
            $whrid=M('xingzhengqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(377,0,$whrid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $pqshu=M('pianqu')->where(array('ssxzq'=>$id))->count();
            $xqshu=M('xiaoqu')->where(array('ssxzq'=>$id))->count();
            if ($pqshu==0 && $xqshu==0){
                $isok=M('xingzhengqu')->where(array('id'=>$id))->delete();
            } else {
                $this->error('请先转移数据');
            }
            if ($isok){
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        // 片区列表
        public function Pianqu() {
            if (I('is_ajax')) {
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                $map .= " where gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(123,0);
                if ($x && $x != "all" && $x != "me") {
                    $map .= " and bumen in ({$x})";
                }elseif ($x == "me") {
                    $map .= " and id=".session('uid');
                }elseif ($x == false) {
                    $map .= " and id=0";
                }
                $condition="gongsiid=".session('gongsiid');
                $sousuo = sql_check_param(I('sousuo'));
                if ($sousuo) {
                    $condition.=" and ((pianqum like '%$sousuo%') or (pinyinjs like '%$sousuo%'))";
                }
                if ($field && $order) {
                    $pqpx.="order by ".$field." ".$order;
                } else {
                    $pqpx.="order by id DESC";
                }
                $Model = new \Think\Model();
                $count=$Model->query("select count(*) from (select * from __PIANQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list="select * from (select * from __PIANQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id ".$pqpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data=$Model->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['xzqm'] = zym($value['ssxzq'],1);
                    $data[$key]['whbm'] = yhbm($value['whrid'],3);
                    $data[$key]['whr'] = zym($value['whrid'],5);
                    $data[$key]['tjr'] = zym($value['adduid'],5);
                    $is_rbacgx = _rbac_btn_show(126,0,$value['whrid']);
                    // $is_rbaczy = _rbac_btn_show(533,0,$value['whrid']);
                    $is_rbacsc = _rbac_btn_show(128,0,$value['whrid']);
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    // $data[$key]['rbaczy'] = $is_rbaczy ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                    $data[$key]['pinyinjs'] = $value['pinyinjs'] ? $value['pinyinjs'] : "——";
                    $data[$key]['dituzb'] = $value['dituzb'] ? $value['dituzb'] : "——";
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        // 添加片区
        public function addPianqu(){
            $is_rbac = _rbac_node_show(124);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $ssxzq=I('ssxzq');
                $pianqum=I('pianqum');
                $condition['ssxzq']=$ssxzq;
                $condition['pianqum']=$pianqum;
                $cfpq=M('pianqu')->where($condition)->find();
                if($cfpq){
                    $this->error('片区已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(124,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['shijian']=time();
                $data['pianqum']=I('pianqum');
                $data['pinyinjs']=I('pinyinjs');
                $data['ssxzq']=I('ssxzq');
                $data['dituzb']=I('zuobiao');
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['adduid']=session('uid');
                $data['gongsiid']=session('gongsiid');
                $isok=M('pianqu')->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $this->ssxzq=M('xingzhengqu')->where(array('gongsiid'=>session('gongsiid')))->select();
                $this->display();
            }
        }
        // 更新片区
        public function editPianqu(){
            $id=I('id');
            $whrid=M('pianqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(126,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $condition['id']=array('neq',$id);
                $ssxzq=I('ssxzq');
                $pianqum=I('pianqum');
                $condition['ssxzq']=$ssxzq;
                $condition['pianqum']=$pianqum;
                $cfpq=M('pianqu')->where($condition)->find();
                if($cfpq){
                    $this->error('片区已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(126,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['pianqum']=I('pianqum');
                $data['pinyinjs']=I('pinyinjs');
                $data['ssxzq']=I('ssxzq');
                $data['dituzb']=I('zuobiao');
                $isok=M("pianqu")->where(array('id'=>$id))->save($data);
                if ($isok){
                    M('xiaoqu')->where(array('sspianqu'=>$id))->setField('ssxzq',I('ssxzq'));
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $this->pianqu=M('pianqu')->where(array('id'=>$id))->find();
                $this->user=zym($this->pianqu['whrid'],5);
                $this->ssxzq=M('xingzhengqu')->where(array('gongsiid'=>session('gongsiid')))->select();
                $this->display();
            }
        }
        // 删除片区
        public function delPianqu(){
            $id=I('id');
            $whrid=M('pianqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(128,0,$whrid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $xqshu=M('xiaoqu')->where(array('sspianqu'=>$id))->count();
            if ($xqshu==0){
                $isok=M('pianqu')->where(array('id'=>$id))->delete();
            } else {
                $this->error('请先转移数据');
            }
            if ($isok){
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        // 小区列表
        public function Xiaoqu() {
            if (I('is_ajax')) {
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                $condition = "e.gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(129,0);
                if ($x && $x != "all" && $x != "me") {
                    $condition .= " and e.bumen in ({$x})";
                }elseif ($x == "me") {
                    $condition .= " and e.id=".session('uid');
                }elseif ($x == false) {
                    $condition .= " and e.id=0";
                }
                $sousuo = sql_check_param(I('sousuo'));
                if ($sousuo) {
                    $condition.=" and (a.xiaoqum like '%$sousuo%' or a.pinyinjs like '%$sousuo%')";
                }
                if ($field && $order) {
                    $xqpx.="a.".$field." ".$order;
                } else {
                    $xqpx.="a.id DESC";
                }
                $count=M('xiaoqu')->alias('a')->join('jjrxt_yonghu e on a.whrid=e.id')->where($condition)->count();
                $Page = I('p');
                $data=M('xiaoqu')->alias('a')->join('jjrxt_yonghu e on a.whrid=e.id')->field('a.*,e.ygmingcheng,e.dianhua,e.bumen as whrbm')->where($condition)->order($xqpx)->page($Page,$limit)->select();
                foreach ($data as $key => $value) {
                    $img = get_x_img($value['id']);
                    $data[$key]['img'] = $img ? $img['imgxt'] : "/Public/img/default_icon.png";
                    $data[$key]['pqm'] = zym($value['sspianqu'],2);
                    $data[$key]['xzqm'] = zym($value['ssxzq'],1);
                    $data[$key]['whr'] = $value['ygmingcheng'];
                    $data[$key]['whrdh'] = $value['dianhua'];
                    $data[$key]['whrbm'] = zym($value['whrbm'],6);
                    $data[$key]['tjr'] = zym($value['adduid'],5);
                    $is_rbaczd = _rbac_btn_show(503,0,$value['whrid']);
                    $is_rbacxq = _rbac_btn_show(175,0,$value['whrid']);
                    $is_rbacgx = _rbac_btn_show(132,0,$value['whrid']);
                    $is_rbacsc = _rbac_btn_show(134,0,$value['whrid']);
                    $data[$key]['rbaczd'] = $is_rbaczd ? 1 : 0;
                    $data[$key]['rbacxq'] = $is_rbacxq ? 1 : 0;
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                    $data[$key]['pinyinjs'] = $value['pinyinjs'] ? $value['pinyinjs'] : "——";
                    $data[$key]['dituzb'] = $value['dituzb'] ? $value['dituzb'] : "——";
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count,
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        // 添加小区
        public function addXiaoqu(){
            $is_rbac = _rbac_node_show(130);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $ssxzq=I('ssxzq');
                $sspianqu=I('sspianqu');
                $xiaoqum=I('xiaoqum');
                $condition['ssxzq']=$ssxzq;
                $condition['sspianqu']=$sspianqu;
                $condition['xiaoqum']=$xiaoqum;
                $cfxq=M('xiaoqu')->where($condition)->find();
                if($cfxq){
                    $this->error('楼盘已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(130,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $baobei = I('baobei');
                $daikan = I('daikan');
                // $renchou = I('renchou');
                // $rengou = I('rengou');
                // $qianyue = I('qianyue');
                // $wangqian = I('wangqian');
                // $youzheng = I('youzheng');
                $shoufu = I('shoufu');
                if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$baobei)){
                    $this->error('报备保护期请输入＞0≤100的整数！');
                }
                if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$daikan)){
                    $this->error('带看保护期请输入＞0≤100的整数！');
                }
                // if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$renchou)){
                //     $this->error('认筹保护期请输入＞0≤100的整数！');
                // }
                // if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$rengou)){
                //     $this->error('认购保护期请输入＞0≤100的整数！');
                // }
                // if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$qianyue)){
                //     $this->error('签约保护期请输入＞0≤100的整数！');
                // }
                // if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$wangqian)){
                //     $this->error('网签保护期请输入＞0≤100的整数！');
                // }
                if ($shoufu) {
                    if (!preg_match("/^$|^([1-9][0-9]{0,1})(\.[0-9]{1,2})?$|^([0]\.[1-9][0-9]{0,1})$|^([0]\.[0][1-9]{1})$|^(1[0]{2})(\.[0][0]{0,1})?$/",$shoufu)) {
                        $this->error('首付比例请输入＞0且≤100的数字（限两位小数）！');
                    }
                }
                $data['ssxzq']=$ssxzq;
                $data['sspianqu']=$sspianqu;
                $data['xiaoqum']=$xiaoqum;
                $data['baobei']=$baobei;
                $data['daikan']=$daikan;
                $data['renchou']=36525;
                $data['rengou']=36525;
                $data['qianyue']=36525;
                $data['wangqian']=36525;
                $data['shijian']=time();
                $data['dituzb']=I('dituzb');
                $data['fukuan']=I('fukuan');
                // $data['jiedao']=I('jiedao');
                $data['shoufu']=$shoufu;
                $data['shoujia']=I('shoujia');
                $data['baobeigz']=I('baobeigz');
                $data['daikangz']=I('daikangz');
                $data['jianjie']=I('jianjie');
                if (I('csjunjia')) {
                    $data['csjunjia']=I('csjunjia');
                }
                $data['pinyinjs']=I('pinyinjs');
                $data['xiaoqudz']=I('xiaoqudz');
                // $data['youzheng']=I('youzheng');
                // $data['ssxuexiao']=I('ssxuexiao');
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['adduid']=session('uid');
                $data['gongsiid']=session('gongsiid');
                $isok=M("xiaoqu")->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $this->fukuan = get_peizhi('lpfkfs',0,1);
                $this->ssxzq=M('xingzhengqu')->where(array('gongsiid'=>session('gongsiid')))->select();
                $this->display();
            }
        }
        // 更新小区
        public function editXiaoqu(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(132,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $condition['id']=array('neq',$id);
                $ssxzq=I('ssxzq');
                $sspianqu=I('sspianqu');
                $xiaoqum=I('xiaoqum');
                $condition['ssxzq']=$ssxzq;
                $condition['sspianqu']=$sspianqu;
                $condition['xiaoqum']=$xiaoqum;
                $cfxq=M('xiaoqu')->where($condition)->find();
                if($cfxq){
                    $this->error('楼盘已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(132,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $baobei = I('baobei');
                $daikan = I('daikan');
                // $renchou = I('renchou');
                // $rengou = I('rengou');
                // $qianyue = I('qianyue');
                // $wangqian = I('wangqian');
                // $youzheng = I('youzheng');
                $shoufu = I('shoufu');
                if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$baobei)){
                    $this->error('报备保护期请输入＞0≤100的整数！');
                }
                if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$daikan)){
                    $this->error('带看保护期请输入＞0≤100的整数！');
                }
                // if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$renchou)){
                //     $this->error('认筹保护期请输入＞0≤100的整数！');
                // }
                // if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$rengou)){
                //     $this->error('认购保护期请输入＞0≤100的整数！');
                // }
                // if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$qianyue)){
                //     $this->error('签约保护期请输入＞0≤100的整数！');
                // }
                // if (!preg_match("/^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$wangqian)){
                //     $this->error('网签保护期请输入＞0≤100的整数！');
                // }
                if ($shoufu) {
                    if (!preg_match("/^$|^([1-9][0-9]{0,1})(\.[0-9]{1,2})?$|^([0]\.[1-9][0-9]{0,1})$|^([0]\.[0][1-9]{1})$|^(1[0]{2})(\.[0][0]{0,1})?$/",$shoufu)) {
                        $this->error('首付比例请输入＞0且≤100的数字（限两位小数）！');
                    }
                }
                $data['ssxzq']=$ssxzq;
                $data['sspianqu']=$sspianqu;
                $data['xiaoqum']=$xiaoqum;
                $data['baobei']=$baobei;
                $data['daikan']=$daikan;
                $data['renchou']=36525;
                $data['rengou']=36525;
                $data['qianyue']=36525;
                $data['wangqian']=36525;
                $data['dituzb']=I('dituzb');
                $data['fukuan']=I('fukuan');
                // $data['jiedao']=I('jiedao');
                $data['shoufu']=$shoufu;
                $data['shoujia']=I('shoujia');
                $data['baobeigz']=I('baobeigz');
                $data['daikangz']=I('daikangz');
                $data['jianjie']=I('jianjie');
                if (I('csjunjia')) {
                    $data['csjunjia']=I('csjunjia');
                }
                $data['pinyinjs']=I('pinyinjs');
                $data['xiaoqudz']=I('xiaoqudz');
                // $data['youzheng']=I('youzheng');
                // $data['ssxuexiao']=I('ssxuexiao');
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $isok=M("xiaoqu")->where(array('id'=>$id))->save($data);
                if ($isok){
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $this->fukuan = get_peizhi('lpfkfs',0,1);
                $xiaoqu=M('xiaoqu')->where(array('id'=>$id))->find();
                $xiaoqu['csjunjia']=$xiaoqu['csjunjia'] > 0 ? floatval($xiaoqu['csjunjia']) : '';
                $xiaoqu['shoufu']=$xiaoqu['shoufu'] > 0 ? floatval($xiaoqu['shoufu']) : '';
                $this->xiaoqu=$xiaoqu;
                $this->user=zym($xiaoqu['whrid'],5);
                $this->ssxzq=M('xingzhengqu')->where(array('gongsiid'=>session('gongsiid')))->select();
                $this->sspianqu=M('pianqu')->where(array('gongsiid'=>session('gongsiid'),'ssxzq'=>$xiaoqu['ssxzq']))->select();
                $this->display();
            }
        }
        // 删除小区
        public function delXiaoqu(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(134,0,$whrid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $isok=M('xiaoqu')->where(array('id'=>$id))->delete();
            if ($isok){
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        // 小区详情
        public function xiaoqurr(){
            $id = I('id',0,'int');
            $whrid = M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(175,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $xiaoqu = M('xiaoqu')->where(array('id'=>$id))->find();
            switch ($xiaoqu['5a']) {
                case 1:
                    $wua = "有";
                    break;
                case 2:
                    $wua = "无";
                    break;
                default:
                    $wua = "暂无信息";
                    break;
            }
            switch ($xiaoqu['zhuce']) {
                case 1:
                    $zhuce = "有";
                    break;
                case 2:
                    $zhuce = "无";
                    break;
                default:
                    $zhuce = "暂无信息";
                    break;
            }
            switch ($xiaoqu['chewei']) {
                case 1:
                    $chewei = "有";
                    break;
                case 2:
                    $chewei = "无";
                    break;
                default:
                    $chewei = "暂无信息";
                    break;
            }
            switch ($xiaoqu['dianti']) {
                case 1:
                    $dianti = "有";
                    break;
                case 2:
                    $dianti = "无";
                    break;
                default:
                    $dianti = "暂无信息";
                    break;
            }
            switch ($xiaoqu['youhui']) {
                case 1:
                    $youhui = "有";
                    break;
                case 2:
                    $youhui = "无";
                    break;
                default:
                    $youhui = "暂无信息";
                    break;
            }
            switch ($xiaoqu['yjfjzx']) {
                case 1:
                    $yjfjzx = "有";
                    break;
                case 2:
                    $yjfjzx = "无";
                    break;
                default:
                    $yjfjzx = "暂无信息";
                    break;
            }
            switch ($xiaoqu['wldiban']) {
                case 1:
                    $wldiban = "有";
                    break;
                case 2:
                    $wldiban = "无";
                    break;
                default:
                    $wldiban = "暂无信息";
                    break;
            }
            switch ($xiaoqu['ygcanting']) {
                case 1:
                    $ygcanting = "有";
                    break;
                case 2:
                    $ygcanting = "无";
                    break;
                default:
                    $ygcanting = "暂无信息";
                    break;
            }
            $xzqming = zym($xiaoqu['ssxzq'],1);
            $pianqum = zym($xiaoqu['sspianqu'],2);
            $ssxzq = $xzqming ? $xzqming : "";
            $sspq = $pianqum ? $pianqum : "";
            $diqu = $ssxzq && $sspq ? $ssxzq."-".$sspq : $ssxzq.$sspq;
            $fukuan = get_peizhi('lpfkfs',$xiaoqu['fukuan'],3);
            $wuyelx = get_peizhi('wuyelx',$xiaoqu['wuyelx'],3);
            $wuyezz = get_peizhi('wuyezz',$xiaoqu['wuyezz'],3);
            $xmjibie = get_peizhi('xmjibie',$xiaoqu['xmjibie'],3);
            $gongqifs = get_peizhi('gongqifs',$xiaoqu['gongqifs'],3);
            $gongrefs = get_peizhi('gongrefs',$xiaoqu['gongrefs'],3);
            $kangzhen = get_peizhi('kangzhen',$xiaoqu['kangzhen'],3);
            $ceweizldw = get_peizhi('ceweizldw',$xiaoqu['ceweizldw'],3);
            $gongdianlx = get_peizhi('gongdianlx',$xiaoqu['gongdianlx'],3);
            $gongshuilx = get_peizhi('gongshuilx',$xiaoqu['gongshuilx'],3);
            $spjzleixing = get_peizhi('spjzleixing',$xiaoqu['spjzleixing'],3);
            $zdshu = 0;
            $fjshu = 0;
            $xiaoqu['5a'] = $wua;
            $xiaoqu['zhuce'] = $zhuce;
            $xiaoqu['chewei'] = $chewei;
            $xiaoqu['dianti'] = $dianti;
            $xiaoqu['youhui'] = $youhui;
            $xiaoqu['yjfjzx'] = $yjfjzx;
            $xiaoqu['wldiban'] = $wldiban;
            $xiaoqu['ygcanting'] = $ygcanting;
            $xiaoqu['diqu'] = $diqu ? $diqu : "暂无信息";
            $xiaoqu['fukuan'] = $fukuan ? $fukuan : "暂无信息";
            $xiaoqu['wuyelx'] = $wuyelx ? $wuyelx : "暂无信息";
            $xiaoqu['wuyezz'] = $wuyezz ? $wuyezz : "暂无信息";
            $xiaoqu['xmjibie'] = $xmjibie ? $xmjibie : "暂无信息";
            $xiaoqu['gongqifs'] = $gongqifs ? $gongqifs : "暂无信息";
            $xiaoqu['gongrefs'] = $gongrefs ? $gongrefs : "暂无信息";
            $xiaoqu['kangzhen'] = $kangzhen ? $kangzhen : "暂无信息";
            $xiaoqu['gongdianlx'] = $gongdianlx ? $gongdianlx : "暂无信息";
            $xiaoqu['gongshuilx'] = $gongshuilx ? $gongshuilx : "暂无信息";
            $xiaoqu['spjzleixing'] = $spjzleixing ? $spjzleixing : "暂无信息";
            $xiaoqu['shoujia'] = $xiaoqu['shoujia'] ? $xiaoqu['shoujia'] : "";
            $xiaoqu['hxymj'] = $xiaoqu['hxymj'] ? $xiaoqu['hxymj'] : "暂无信息";
            $xiaoqu['tihupb'] = $xiaoqu['tihupb'] ? $xiaoqu['tihupb'] : "暂无信息";
            $xiaoqu['wuyemc'] = $xiaoqu['wuyemc'] ? $xiaoqu['wuyemc'] : "暂无信息";
            $xiaoqu['wuyedh'] = $xiaoqu['wuyedh'] ? $xiaoqu['wuyedh'] : "暂无信息";
            $xiaoqu['wuyedz'] = $xiaoqu['wuyedz'] ? $xiaoqu['wuyedz'] : "暂无信息";
            // $xiaoqu['jiedao'] = $xiaoqu['jiedao'] ? $xiaoqu['jiedao'] : "暂无信息";
            // $xiaoqu['beizhu'] = $xiaoqu['beizhu'] ? $xiaoqu['beizhu'] : "暂无信息";
            $xiaoqu['zyktpp'] = $xiaoqu['zyktpp'] ? $xiaoqu['zyktpp'] : "暂无信息";
            $xiaoqu['maidian'] = $xiaoqu['maidian'] ? $xiaoqu['maidian'] : "暂无信息";
            $xiaoqu['zyktjsf'] = $xiaoqu['zyktjsf'] ? $xiaoqu['zyktjsf'] : "暂无信息";
            $xiaoqu['xiaoqum'] = $xiaoqu['xiaoqum'] ? $xiaoqu['xiaoqum'] : "暂无信息";
            $xiaoqu['wlmzxbz'] = $xiaoqu['wlmzxbz'] ? $xiaoqu['wlmzxbz'] : "暂无信息";
            $xiaoqu['jianjie'] = $xiaoqu['jianjie'] ? $xiaoqu['jianjie'] : "暂无信息";
            $xiaoqu['ditielx'] = $xiaoqu['ditielx'] ? $xiaoqu['ditielx'] : "暂无信息";
            $xiaoqu['jinkuang'] = $xiaoqu['jinkuang'] ? $xiaoqu['jinkuang'] : "暂无信息";
            $xiaoqu['baobeigz'] = $xiaoqu['baobeigz'] ? $xiaoqu['baobeigz'] : "暂无信息";
            $xiaoqu['daikangz'] = $xiaoqu['daikangz'] ? $xiaoqu['daikangz'] : "暂无信息";
            $xiaoqu['zyktgzsj'] = $xiaoqu['zyktgzsj'] ? $xiaoqu['zyktgzsj'] : "暂无信息";
            $xiaoqu['youhuizc'] = $xiaoqu['youhuizc'] ? $xiaoqu['youhuizc'] : "暂无信息";
            $xiaoqu['diantixq'] = $xiaoqu['diantixq'] ? $xiaoqu['diantixq'] : "暂无信息";
            // $xiaoqu['xiaoqubm'] = $xiaoqu['xiaoqubm'] ? $xiaoqu['xiaoqubm'] : "暂无信息";
            $xiaoqu['xiaoqudz'] = $xiaoqu['xiaoqudz'] ? $xiaoqu['xiaoqudz'] : "暂无信息";
            // $xiaoqu['youzheng'] = $xiaoqu['youzheng'] ? $xiaoqu['youzheng'] : "暂无信息";
            // $xiaoqu['paichusuo'] = $xiaoqu['paichusuo'] ? $xiaoqu['paichusuo'] : "暂无信息";
            $xiaoqu['jinrongjg'] = $xiaoqu['jinrongjg'] ? $xiaoqu['jinrongjg'] : "暂无信息";
            // $xiaoqu['zhengfujg'] = $xiaoqu['zhengfujg'] ? $xiaoqu['zhengfujg'] : "暂无信息";
            $xiaoqu['ycqdanwei'] = $xiaoqu['ycqdanwei'] ? $xiaoqu['ycqdanwei'] : "暂无信息";
            $xiaoqu['kaifashang'] = $xiaoqu['kaifashang'] ? $xiaoqu['kaifashang'] : "暂无信息";
            $xiaoqu['gongjiaolx'] = $xiaoqu['gongjiaolx'] ? $xiaoqu['gongjiaolx'] : "暂无信息";
            // $xiaoqu['xiuxianyule'] = $xiaoqu['xiuxianyule'] ? $xiaoqu['xiuxianyule'] : "暂无信息";
            $xiaoqu['yiliaojigou'] = $xiaoqu['yiliaojigou'] ? $xiaoqu['yiliaojigou'] : "暂无信息";
            $xiaoqu['ygcantingjj'] = $xiaoqu['ygcantingjj'] ? $xiaoqu['ygcantingjj'] : "暂无信息";
            // $xiaoqu['shangchangcs'] = $xiaoqu['shangchangcs'] ? $xiaoqu['shangchangcs'] : "暂无信息";
            $xiaoqu['jiaowupeitao'] = $xiaoqu['jiaowupeitao'] ? $xiaoqu['jiaowupeitao'] : "暂无信息";
            $xiaoqu['shangwupeitao'] = $xiaoqu['shangwupeitao'] ? $xiaoqu['shangwupeitao'] : "暂无信息";
            $xiaoqu['jingguanpeitao'] = $xiaoqu['jingguanpeitao'] ? $xiaoqu['jingguanpeitao'] : "暂无信息";
            $xiaoqu['zdshu'] = $zdshu > 0 ? $zdshu."栋" : 0;
            $xiaoqu['fjshu'] = $fjshu > 0 ? $fjshu."户" : 0;
            $xiaoqu['baobei'] = $xiaoqu['baobei'] > 0 ? $xiaoqu['baobei']."天" : "暂无信息";
            $xiaoqu['daikan'] = $xiaoqu['daikan'] > 0 ? $xiaoqu['daikan']."天" : "暂无信息";
            // $xiaoqu['rengou'] = $xiaoqu['rengou'] > 0 ? $xiaoqu['rengou']."天" : "暂无信息";
            // $xiaoqu['renchou'] = $xiaoqu['renchou'] > 0 ? $xiaoqu['renchou']."天" : "暂无信息";
            $xiaoqu['lvhualv'] = $xiaoqu['lvhualv'] > 0 ? $xiaoqu['lvhualv']."%" : "暂无信息";
            // $xiaoqu['qianyue'] = $xiaoqu['qianyue'] > 0 ? $xiaoqu['qianyue']."天" : "暂无信息";
            // $xiaoqu['wangqian'] = $xiaoqu['wangqian'] > 0 ? $xiaoqu['wangqian']."天" : "暂无信息";
            $xiaoqu['rongjilv'] = $xiaoqu['rongjilv'] > 0 ? $xiaoqu['rongjilv']."%" : "暂无信息";
            $xiaoqu['nianxian'] = $xiaoqu['nianxian'] > 0 ? $xiaoqu['nianxian']."年" : "暂无信息";
            $zdmjdw = get_peizhi('zdmjdw',$xiaoqu['zdmjdw'],3);
            $xiaoqu['zhandimj'] = $xiaoqu['zhandimj'] > 0 ? $xiaoqu['zhandimj'].$zdmjdw : "暂无信息";
            $xiaoqu['jianzhumj'] = $xiaoqu['jianzhumj'] > 0 ? $xiaoqu['jianzhumj']."m²" : "暂无信息";
            $xiaoqu['jianzaond'] = $xiaoqu['jianzaond'] > 0 ? $xiaoqu['jianzaond']."年" : "暂无信息";
            $xiaoqu['dxiatcwsl'] = $xiaoqu['dxiatcwsl'] > 0 ? $xiaoqu['dxiatcwsl']."个" : "暂无信息";
            $xiaoqu['dshangtcwsl'] = $xiaoqu['dshangtcwsl'] > 0 ? $xiaoqu['dshangtcwsl']."个" : "暂无信息";
            $xiaoqu['shoufu'] = $xiaoqu['shoufu'] > 0 ? floatval($xiaoqu['shoufu'])."%" : "暂无信息";
            $xiaoqu['cenggao'] = $xiaoqu['cenggao'] > 0 ? floatval($xiaoqu['cenggao'])."米" : "暂无信息";
            $xiaoqu['xmgaodu'] = $xiaoqu['xmgaodu'] > 0 ? floatval($xiaoqu['xmgaodu'])."米" : "暂无信息";
            $xiaoqu['bzcjzmj'] = $xiaoqu['bzcjzmj'] > 0 ? floatval($xiaoqu['bzcjzmj'])."m²" : "暂无信息";
            $xiaoqu['dianfei'] = $xiaoqu['dianfei'] > 0 ? floatval($xiaoqu['dianfei'])."元/度" : "暂无信息";
            $xiaoqu['wuyefei'] = $xiaoqu['wuyefei'] > 0 ? floatval($xiaoqu['wuyefei'])."元/月" : "暂无信息";
            $xiaoqu['xfsjgyl'] = $xiaoqu['xfsjgyl'] > 0 ? floatval($xiaoqu['xfsjgyl'])."m³/人/小时" : "暂无信息";
            $xiaoqu['dxiatcwsj'] = $xiaoqu['dxiatcwsj'] > 0 ? floatval($xiaoqu['dxiatcwsj'])."万" : "暂无信息";
            $xiaoqu['gongtanmj'] = $xiaoqu['gongtanmj'] > 0 ? floatval($xiaoqu['gongtanmj'])."m²" : "暂无信息";
            $xiaoqu['csjunjia'] = $xiaoqu['csjunjia'] > 0 ? floatval($xiaoqu['csjunjia'])."元/m²" : "暂无信息";
            $xiaoqu['wldibangd'] = $xiaoqu['wldibangd'] > 0 ? floatval($xiaoqu['wldibangd'])."毫米" : "暂无信息";
            $xiaoqu['dshangtcwsj'] = $xiaoqu['dshangtcwsj'] > 0 ? floatval($xiaoqu['dshangtcwsj'])."万" : "暂无信息";
            $xiaoqu['dxiatcwzl'] = $xiaoqu['dxiatcwzl'] > 0 ? floatval($xiaoqu['dxiatcwzl']).$ceweizldw : "暂无信息";
            $xiaoqu['dshangtcwzl'] = $xiaoqu['dshangtcwzl'] > 0 ? floatval($xiaoqu['dshangtcwzl']).$ceweizldw : "暂无信息";
            $xiaoqu['cainuanfy'] = $xiaoqu['cainuanfy'] > 0 ? floatval($xiaoqu['cainuanfy'])."元/m²/供暖季" : "暂无信息";
            $xiaoqu['kpshijian'] = $xiaoqu['kpshijian'] > 0 ? date('Y-m-d',$xiaoqu['kpshijian']) : "暂无信息";
            $xiaoqu['rzshijian'] = $xiaoqu['rzshijian'] > 0 ? date('Y-m-d',$xiaoqu['rzshijian']) : "暂无信息";
            $Model = new \Think\Model();
            if ($xiaoqu['jiegou']) {
                $condition1 = "pzming = 'jiegou' and lxid in (".$xiaoqu['jiegou'].")";
                $jiegou1 = $Model->query("select * from __PEIZHI__ where {$condition1} order by xsshunxu asc");
                $jiegou2 = array();
                foreach ($jiegou1 AS $key => $val) {
                    $jiegou2[] =  $val['lxming'];
                }
                $xiaoqu['jiegou'] = implode("、",$jiegou2);
            } else {
                $xiaoqu['jiegou'] = "暂无信息";
            }
            if ($xiaoqu['yongtu']) {
                $condition2 = "pzming = 'yongtu' and lxid in (".$xiaoqu['yongtu'].")";
                $yongtu1 = $Model->query("select * from __PEIZHI__ where {$condition2} order by xsshunxu asc");
                $yongtu2 = array();
                foreach ($yongtu1 AS $key => $val) {
                    $yongtu2[] =  $val['lxming'];
                }
                $xiaoqu['yongtu'] = implode("、",$yongtu2);
            } else {
                $xiaoqu['yongtu'] = "暂无信息";
            }
            if ($xiaoqu['dianshi']) {
                $condition3 = "pzming = 'dianshi' and lxid in (".$xiaoqu['dianshi'].")";
                $dianshi1 = $Model->query("select * from __PEIZHI__ where {$condition3} order by xsshunxu asc");
                $dianshi2 = array();
                foreach ($dianshi1 AS $key => $val) {
                    $dianshi2[] =  $val['lxming'];
                }
                $xiaoqu['dianshi'] = implode("、",$dianshi2);
            } else {
                $xiaoqu['dianshi'] = "暂无信息";
            }
            if ($xiaoqu['tongxun']) {
                $condition4 = "pzming = 'tongxun' and lxid in (".$xiaoqu['tongxun'].")";
                $tongxun1 = $Model->query("select * from __PEIZHI__ where {$condition4} order by xsshunxu asc");
                $tongxun2 = array();
                foreach ($tongxun1 AS $key => $val) {
                    $tongxun2[] =  $val['lxming'];
                }
                $xiaoqu['tongxun'] = implode("、",$tongxun2);
            } else {
                $xiaoqu['tongxun'] = "暂无信息";
            }
            if ($xiaoqu['chanquan']) {
                $condition5 = "pzming = 'chanquan' and lxid in (".$xiaoqu['chanquan'].")";
                $chanquan1 = $Model->query("select * from __PEIZHI__ where {$condition5} order by xsshunxu asc");
                $chanquan2 = array();
                foreach ($chanquan1 AS $key => $val) {
                    $chanquan2[] =  $val['lxming'];
                }
                $xiaoqu['chanquan'] = implode("、",$chanquan2);
            } else {
                $xiaoqu['chanquan'] = "暂无信息";
            }
            if ($xiaoqu['sqanquan']) {
                $condition6 = "pzming = 'sqanquan' and lxid in (".$xiaoqu['sqanquan'].")";
                $sqanquan1 = $Model->query("select * from __PEIZHI__ where {$condition6} order by xsshunxu asc");
                $sqanquan2 = array();
                foreach ($sqanquan1 AS $key => $val) {
                    $sqanquan2[] =  $val['lxming'];
                }
                $xiaoqu['sqanquan'] = implode("、",$sqanquan2);
            } else {
                $xiaoqu['sqanquan'] = "暂无信息";
            }
            if ($xiaoqu['cainuanfs']) {
                $condition7 = "pzming = 'cainuanfs' and lxid in (".$xiaoqu['cainuanfs'].")";
                $cainuanfs1 = $Model->query("select * from __PEIZHI__ where {$condition7} order by xsshunxu asc");
                $cainuanfs2 = array();
                foreach ($cainuanfs1 AS $key => $val) {
                    $cainuanfs2[] =  $val['lxming'];
                }
                $xiaoqu['cainuanfs'] = implode("、",$cainuanfs2);
            } else {
                $xiaoqu['cainuanfs'] = "暂无信息";
            }
            if ($xiaoqu['fwleixing']) {
                $condition8 = "pzming = 'fwleixing' and lxid in (".$xiaoqu['fwleixing'].")";
                $fwleixing1 = $Model->query("select * from __PEIZHI__ where {$condition8} order by xsshunxu asc");
                $fwleixing2 = array();
                foreach ($fwleixing1 AS $key => $val) {
                    $fwleixing2[] =  $val['lxming'];
                }
                $xiaoqu['fwleixing'] = implode("、",$fwleixing2);
            } else {
                $xiaoqu['fwleixing'] = "暂无信息";
            }
            if ($xiaoqu['wldibanlx']) {
                $condition9 = "pzming = 'wldibanlx' and lxid in (".$xiaoqu['wldibanlx'].")";
                $wldibanlx1 = $Model->query("select * from __PEIZHI__ where {$condition9} order by xsshunxu asc");
                $wldibanlx2 = array();
                foreach ($wldibanlx1 AS $key => $val) {
                    $wldibanlx2[] =  $val['lxming'];
                }
                $xiaoqu['wldibanlx'] = implode("、",$wldibanlx2);
            } else {
                $xiaoqu['wldibanlx'] = "暂无信息";
            }
            if ($xiaoqu['gongshuifs']) {
                $condition10 = "pzming = 'gongshuifs' and lxid in (".$xiaoqu['gongshuifs'].")";
                $gongshuifs1 = $Model->query("select * from __PEIZHI__ where {$condition10} order by xsshunxu asc");
                $gongshuifs2 = array();
                foreach ($gongshuifs1 AS $key => $val) {
                    $gongshuifs2[] =  $val['lxming'];
                }
                $xiaoqu['gongshuifs'] = implode("、",$gongshuifs2);
            } else {
                $xiaoqu['gongshuifs'] = "暂无信息";
            }
            $this->xiaoqu = $xiaoqu;
            $this->display();
        }
        // 修改小区详情
        public function xiugaixiaoqu(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(176,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $bjlpxq = I('bjlpxq');
            if (IS_POST) {
                switch ($bjlpxq) {
                    case '1':
                        // $wuyedh = explode("；",I('wuyedh'));
                        // foreach ($wuyedh as $key => $value) {
                        //     if(!preg_match("/^$|^(13[0-9]|14[0-1,4-9]|15[0-3,5-9]|16[2567]|17[0-8]|18[0-9]|19[0-3,5-9])\d{8}$|^0\d{2,3}-?\d{7,8}$/",$value)){
                        //         $this->error('物业电话请输入正确的手机号码或电话号码！');
                        //     }
                        // }
                        // if (I('youzheng') && !is_numeric(I('youzheng'))) {
                        //     $this->error('邮编只能为数字！');
                        // }
                        if (I('csjunjia') && !is_numeric(I('csjunjia'))) {
                            $this->error('均价只能为数字！');
                        }
                        if (I('gongtanmj') && !is_numeric(I('gongtanmj'))) {
                            $this->error('公摊面积只能为数字！');
                        }
                        if (I('shoufu') && !is_numeric(I('shoufu')) && I('shoufu')<0 && I('shoufu')>100) {
                            $this->error('首付比例只能为0-100的数字,！');
                        }
                        if (I('cenggao') && !is_numeric(I('cenggao')) && I('cenggao')<0 && I('cenggao')>100) {
                            $this->error('层高只能为0-100的数字,！');
                        }
                        if (I('rongjilv') && !is_numeric(I('rongjilv')) && I('rongjilv')<0 && I('rongjilv')>100) {
                            $this->error('容积率只能为0-100的数字,！');
                        }
                        if (I('lvhualv') && !is_numeric(I('lvhualv')) && I('lvhualv')<0 && I('lvhualv')>100) {
                            $this->error('绿化率只能为0-100的数字,！');
                        }
                        if (I('wuyefei') && !is_numeric(I('wuyefei'))) {
                            $this->error('物业费只能为数字！');
                        }
                        if (I('chewei')) {
                            $data['chewei']=1;
                            $data['ceweizldw']=I('ceweizldw',0,'int');
                            $data['dxiatcwsj']=I('dxiatcwsj',0,'int');
                            $data['dxiatcwsl']=I('dxiatcwsl',0,'float');
                            $data['dxiatcwzl']=I('dxiatcwzl',0,'float');
                            $data['dshangtcwsj']=I('dshangtcwsj',0,'float');
                            $data['dshangtcwsl']=I('dshangtcwsl',0,'int');
                            $data['dshangtcwzl']=I('dshangtcwzl',0,'float');
                        } else {
                            $data['chewei']=2;
                        }
                        // if (I('dianti')) {
                        //     $data['dianti']=1;
                        //     $data['diantixq']=I('diantixq');
                        // } else {
                        //     $data['dianti']=2;
                        // }
                        $data['hxymj']=I('hxymj');
                        // $data['beizhu']=I('beizhu');
                        $data['fukuan']=I('fukuan');
                        // $data['jiedao']=I('jiedao');
                        $data['shoufu']=I('shoufu');
                        $data['tihupb']=I('tihupb');
                        // $data['wuyedh']=I('wuyedh');
                        // $data['wuyedz']=I('wuyedz');
                        $data['wuyemc']=I('wuyemc');
                        $data['zdmjdw']=I('zdmjdw');
                        $data['cenggao']=I('cenggao');
                        $data['jianjie']=I('jianjie');
                        $data['lvhualv']=I('lvhualv');
                        $data['maidian']=I('maidian');
                        $data['shoujia']=I('shoujia');
                        $data['wuyefei']=I('wuyefei');
                        $data['csjunjia']=I('csjunjia');
                        $data['gongqifs']=I('gongqifs');
                        $data['gongrefs']=I('gongrefs');
                        $data['jinkuang']=I('jinkuang');
                        $data['rongjilv']=I('rongjilv');
                        // $data['xiaoqubm']=I('xiaoqubm');
                        $data['xiaoqudz']=I('xiaoqudz');
                        // $data['youzheng']=I('youzheng');
                        $data['zhandimj']=I('zhandimj');
                        $data['gongtanmj']=I('gongtanmj');
                        $data['jianzaond']=I('jianzaond');
                        $data['jianzhumj']=I('jianzhumj');
                        // $data['ssxuexiao']=I('ssxuexiao');
                        $data['gongdianlx']=I('gongdianlx');
                        $data['gongshuilx']=I('gongshuilx');
                        $data['kaifashang']=I('kaifashang');
                        break;
                    case '2':
                        $data['ditielx']=I('ditielx');
                        $data['jinrongjg']=I('jinrongjg');
                        // $data['paichusuo']=I('paichusuo');
                        // $data['ssxuexiao']=I('ssxuexiao');
                        // $data['zhengfujg']=I('zhengfujg');
                        $data['gongjiaolx']=I('gongjiaolx');
                        // $data['xiuxianyule']=I('xiuxianyule');
                        $data['yiliaojigou']=I('yiliaojigou');
                        // $data['shangchangcs']=I('shangchangcs');
                        $data['jiaowupeitao']=I('jiaowupeitao');
                        $data['shangwupeitao']=I('shangwupeitao');
                        $data['jingguanpeitao']=I('jingguanpeitao');
                        break;
                    case '3':
                        if (I('csjunjia') && !is_numeric(I('csjunjia'))) {
                            $this->error('均价只能为数字！');
                        }
                        if (I('rongjilv') && !is_numeric(I('rongjilv')) && I('rongjilv')<0 && I('rongjilv')>100) {
                            $this->error('容积率只能为0-100的数字,！');
                        }
                        if (I('lvhualv') && !is_numeric(I('lvhualv')) && I('lvhualv')<0 && I('lvhualv')>100) {
                            $this->error('绿化率只能为0-100的数字,！');
                        }
                        $jg1=array_keys(I('jiegou'));
                        $jg2=implode(',',$jg1);
                        $data['jiegou']=$jg2;
                        $yt1=array_keys(I('yongtu'));
                        $yt2=implode(',',$yt1);
                        $data['yongtu']=$yt2;
                        $cq1=array_keys(I('chanquan'));
                        $cq2=implode(',',$cq1);
                        $data['chanquan']=$cq2;
                        $fw1=array_keys(I('fwleixing'));
                        $fw2=implode(',',$fw1);
                        $data['fwleixing']=$fw2;
                        $data['zdmjdw']=I('zdmjdw');
                        $data['lvhualv']=I('lvhualv');
                        $data['csjunjia']=I('csjunjia');
                        $data['nianxian']=I('nianxian');
                        $data['rongjilv']=I('rongjilv');
                        $data['zhandimj']=I('zhandimj');
                        $data['jianzaond']=I('jianzaond');
                        $data['jianzhumj']=I('jianzhumj');
                        $data['ycqdanwei']=I('ycqdanwei');
                        $data['kaifashang']=I('kaifashang');
                        $data['kpshijian']=strtotime(I('kpshijian'));
                        $data['rzshijian']=strtotime(I('rzshijian'));
                        break;
                    case '4':
                        $wuyedh = explode("；",I('wuyedh'));
                        foreach ($wuyedh as $key => $value) {
                            if(!preg_match("/^$|^(13[0-9]|14[0-1,4-9]|15[0-3,5-9]|16[2567]|17[0-8]|18[0-9]|19[0-3,5-9])\d{8}$|^0\d{2,3}-?\d{7,8}$/",$value)){
                                $this->error('物业电话请输入正确的手机号码或电话号码！');
                            }
                        }
                        if (I('wuyefei') && !is_numeric(I('wuyefei'))) {
                            $this->error('物业费只能为数字！');
                        }
                        if (I('chewei')) {
                            $data['chewei']=1;
                            $data['ceweizldw']=I('ceweizldw',0,'int');
                            $data['dxiatcwsj']=I('dxiatcwsj',0,'int');
                            $data['dxiatcwsl']=I('dxiatcwsl',0,'float');
                            $data['dxiatcwzl']=I('dxiatcwzl',0,'float');
                            $data['dshangtcwsj']=I('dshangtcwsj',0,'float');
                            $data['dshangtcwsl']=I('dshangtcwsl',0,'int');
                            $data['dshangtcwzl']=I('dshangtcwzl',0,'float');
                        } else {
                            $data['chewei']=2;
                        }
                        if (I('dianti')) {
                            $data['dianti']=1;
                            $data['diantixq']=I('diantixq');
                        } else {
                            $data['dianti']=2;
                        }
                        $ds1=array_keys(I('dianshi'));
                        $ds2=implode(',',$ds1);
                        $data['dianshi']=$ds2;
                        $tx1=array_keys(I('tongxun'));
                        $tx2=implode(',',$tx1);
                        $data['tongxun']=$tx2;
                        $aq1=array_keys(I('sqanquan'));
                        $aq2=implode(',',$aq1);
                        $data['sqanquan']=$aq2;
                        $cn1=array_keys(I('cainuanfs'));
                        $cn2=implode(',',$cn1);
                        $data['cainuanfs']=$cn2;
                        $gs1=array_keys(I('gongshuifs'));
                        $gs2=implode(',',$gs1);
                        $data['gongshuifs']=$gs2;
                        $data['wuyedh']=I('wuyedh');
                        $data['wuyedz']=I('wuyedz');
                        $data['wuyelx']=I('wuyelx');
                        $data['wuyemc']=I('wuyemc');
                        $data['wuyezz']=I('wuyezz');
                        $data['dianfei']=I('dianfei');
                        $data['wuyefei']=I('wuyefei');
                        $data['gongqifs']=I('gongqifs');
                        $data['cainuanfy']=I('cainuanfy');
                        $data['gongdianlx']=I('gongdianlx');
                        $data['gongshuilx']=I('gongshuilx');
                        break;
                    case '5':
                        if (I('5a')) {
                            $data['5a']=1;
                        } else {
                            $data['5a']=2;
                        }
                        if (I('zhuce')) {
                            $data['zhuce']=1;
                        } else {
                            $data['zhuce']=2;
                        }
                        if (I('youhui')) {
                            $data['youhui']=1;
                            $data['youhuizc']=I('youhuizc');
                        } else {
                            $data['youhui']=2;
                        }
                        $data['bzcjzmj']=I('bzcjzmj');
                        $data['wlmzxbz']=I('wlmzxbz');
                        $data['xmgaodu']=I('xmgaodu');
                        $data['xmjibie']=I('xmjibie');
                        $data['kangzhen']=I('kangzhen');
                        $data['spjzleixing']=I('spjzleixing');
                        break;
                    case '6':
                        if (I('yjfjzx')) {
                            $data['yjfjzx']=1;
                        } else {
                            $data['yjfjzx']=2;
                        }
                        if (I('wldiban')) {
                            $data['wldiban']=1;
                            $db1=array_keys(I('wldibanlx'));
                            $db2=implode(',',$db1);
                            $data['wldibanlx']=$db2;
                            $data['wldibangd']=I('wldibangd');
                        } else {
                            $data['wldiban']=2;
                        }
                        if (I('ygcanting')) {
                            $data['ygcanting']=1;
                            $data['ygcantingjj']=I('ygcantingjj');
                        } else {
                            $data['ygcanting']=2;
                        }
                        $data['zyktpp']=I('zyktpp');
                        $data['xfsjgyl']=I('xfsjgyl');
                        $data['zyktjsf']=I('zyktjsf');
                        $data['zyktgzsj']=I('zyktgzsj');
                        break;
                    case '7':
                        $data['baobeigz']=I('baobeigz');
                        $data['daikangz']=I('daikangz');
                        break;
                    default:
                        // $wuyedh = explode("；",I('wuyedh'));
                        // foreach ($wuyedh as $key => $value) {
                        //     if(!preg_match("/^$|^(13[0-9]|14[0-1,4-9]|15[0-3,5-9]|16[2567]|17[0-8]|18[0-9]|19[0-3,5-9])\d{8}$|^0\d{2,3}-?\d{7,8}$/",$value)){
                        //         $this->error('物业电话请输入正确的手机号码或电话号码！');
                        //     }
                        // }
                        // if (I('youzheng') && !is_numeric(I('youzheng'))) {
                        //     $this->error('邮编只能为数字！');
                        // }
                        if (I('csjunjia') && !is_numeric(I('csjunjia'))) {
                            $this->error('均价只能为数字！');
                        }
                        if (I('gongtanmj') && !is_numeric(I('gongtanmj'))) {
                            $this->error('公摊面积只能为数字！');
                        }
                        if (I('shoufu') && !is_numeric(I('shoufu')) && I('shoufu')<0 && I('shoufu')>100) {
                            $this->error('首付比例只能为0-100的数字,！');
                        }
                        if (I('cenggao') && !is_numeric(I('cenggao')) && I('cenggao')<0 && I('cenggao')>100) {
                            $this->error('层高只能为0-100的数字,！');
                        }
                        if (I('rongjilv') && !is_numeric(I('rongjilv')) && I('rongjilv')<0 && I('rongjilv')>100) {
                            $this->error('容积率只能为0-100的数字,！');
                        }
                        if (I('lvhualv') && !is_numeric(I('lvhualv')) && I('lvhualv')<0 && I('lvhualv')>100) {
                            $this->error('绿化率只能为0-100的数字,！');
                        }
                        if (I('wuyefei') && !is_numeric(I('wuyefei'))) {
                            $this->error('物业费只能为数字！');
                        }
                        if (I('chewei')) {
                            $data['chewei']=1;
                            $data['ceweizldw']=I('ceweizldw',0,'int');
                            $data['dxiatcwsj']=I('dxiatcwsj',0,'int');
                            $data['dxiatcwsl']=I('dxiatcwsl',0,'float');
                            $data['dxiatcwzl']=I('dxiatcwzl',0,'float');
                            $data['dshangtcwsj']=I('dshangtcwsj',0,'float');
                            $data['dshangtcwsl']=I('dshangtcwsl',0,'int');
                            $data['dshangtcwzl']=I('dshangtcwzl',0,'float');
                        } else {
                            $data['chewei']=2;
                        }
                        // if (I('dianti')) {
                        //     $data['dianti']=1;
                        //     $data['diantixq']=I('diantixq');
                        // } else {
                        //     $data['dianti']=2;
                        // }
                        $data['hxymj']=I('hxymj');
                        // $data['beizhu']=I('beizhu');
                        $data['fukuan']=I('fukuan');
                        // $data['jiedao']=I('jiedao');
                        $data['shoufu']=I('shoufu');
                        $data['tihupb']=I('tihupb');
                        // $data['wuyedh']=I('wuyedh');
                        // $data['wuyedz']=I('wuyedz');
                        $data['wuyemc']=I('wuyemc');
                        $data['zdmjdw']=I('zdmjdw');
                        $data['cenggao']=I('cenggao');
                        $data['jianjie']=I('jianjie');
                        $data['lvhualv']=I('lvhualv');
                        $data['maidian']=I('maidian');
                        $data['shoujia']=I('shoujia');
                        $data['wuyefei']=I('wuyefei');
                        $data['csjunjia']=I('csjunjia');
                        $data['gongqifs']=I('gongqifs');
                        $data['gongrefs']=I('gongrefs');
                        $data['jinkuang']=I('jinkuang');
                        $data['rongjilv']=I('rongjilv');
                        // $data['xiaoqubm']=I('xiaoqubm');
                        $data['xiaoqudz']=I('xiaoqudz');
                        // $data['youzheng']=I('youzheng');
                        $data['zhandimj']=I('zhandimj');
                        $data['gongtanmj']=I('gongtanmj');
                        $data['jianzaond']=I('jianzaond');
                        $data['jianzhumj']=I('jianzhumj');
                        // $data['ssxuexiao']=I('ssxuexiao');
                        $data['gongdianlx']=I('gongdianlx');
                        $data['gongshuilx']=I('gongshuilx');
                        $data['kaifashang']=I('kaifashang');
                        break;
                }
                $isok=M('xiaoqu')->where(array('id'=>$id))->save($data);
                if ($isok===1){
                    $this->success('更新成功！');
                }elseif ($isok===0){
                    $this->error('数据无变动！');
                }else{
                    $this->error('更新失败！');
                }
            } else {
                switch ($bjlpxq) {
                    case '1':
                        $this->fukuan=get_peizhi('lpfkfs',0,1);
                        $this->zdmjdw=get_peizhi('zdmjdw',0,1);
                        $this->gongqifs=get_peizhi('gongqifs',0,1);
                        $this->gongrefs=get_peizhi('gongrefs',0,1);
                        $this->ceweizldw=get_peizhi('ceweizldw',0,1);
                        $this->gongdianlx=get_peizhi('gongdianlx',0,1);
                        $this->gongshuilx=get_peizhi('gongshuilx',0,1);
                        break;
                    case '2':
                        break;
                    case '3':
                        $this->jiegou=get_peizhi('jiegou',0,1);
                        $this->yongtu=get_peizhi('yongtu',0,1);
                        $this->zdmjdw=get_peizhi('zdmjdw',0,1);
                        $this->chanquan=get_peizhi('chanquan',0,1);
                        $this->fwleixing=get_peizhi('fwleixing',0,1);
                        $jiegou1=M('xiaoqu')->where(array('id'=>$id))->getField('jiegou');
                        $this->jiegou2=explode(",", $jiegou1);
                        $yongtu1=M('xiaoqu')->where(array('id'=>$id))->getField('yongtu');
                        $this->yongtu2=explode(",", $yongtu1);
                        $chanquan1=M('xiaoqu')->where(array('id'=>$id))->getField('chanquan');
                        $this->chanquan2=explode(",", $chanquan1);
                        $fwleixing1=M('xiaoqu')->where(array('id'=>$id))->getField('fwleixing');
                        $this->fwleixing2=explode(",", $fwleixing1);
                        break;
                    case '4':
                        $this->wuyelx=get_peizhi('wuyelx',0,1);
                        $this->wuyezz=get_peizhi('wuyezz',0,1);
                        $this->dianshi=get_peizhi('dianshi',0,1);
                        $this->tongxun=get_peizhi('tongxun',0,1);
                        $this->gongqifs=get_peizhi('gongqifs',0,1);
                        $this->sqanquan=get_peizhi('sqanquan',0,1);
                        $this->cainuanfs=get_peizhi('cainuanfs',0,1);
                        $this->ceweizldw=get_peizhi('ceweizldw',0,1);
                        $this->gongdianlx=get_peizhi('gongdianlx',0,1);
                        $this->gongshuifs=get_peizhi('gongshuifs',0,1);
                        $this->gongshuilx=get_peizhi('gongshuilx',0,1);
                        $dianshi1=M('xiaoqu')->where(array('id'=>$id))->getField('dianshi');
                        $this->dianshi2=explode(",", $dianshi1);
                        $tongxun1=M('xiaoqu')->where(array('id'=>$id))->getField('tongxun');
                        $this->tongxun2=explode(",", $tongxun1);
                        $sqanquan1=M('xiaoqu')->where(array('id'=>$id))->getField('sqanquan');
                        $this->sqanquan2=explode(",", $sqanquan1);
                        $cainuanfs1=M('xiaoqu')->where(array('id'=>$id))->getField('cainuanfs');
                        $this->cainuanfs2=explode(",", $cainuanfs1);
                        $gongshuifs1=M('xiaoqu')->where(array('id'=>$id))->getField('gongshuifs');
                        $this->gongshuifs2=explode(",", $gongshuifs1);
                        break;
                    case '5':
                        $this->xmjibie=get_peizhi('xmjibie',0,1);
                        $this->kangzhen=get_peizhi('kangzhen',0,1);
                        $this->spjzleixing=get_peizhi('spjzleixing',0,1);
                        break;
                    case '6':
                        $this->wldibanlx=get_peizhi('wldibanlx',0,1);
                        $wldibanlx1=M('xiaoqu')->where(array('id'=>$id))->getField('wldibanlx');
                        $this->wldibanlx2=explode(",", $wldibanlx1);
                        break;
                    case '7':
                        break;
                    default:
                        $bjlpxq = 1;
                        $this->fukuan=get_peizhi('lpfkfs',0,1);
                        $this->zdmjdw=get_peizhi('zdmjdw',0,1);
                        $this->gongqifs=get_peizhi('gongqifs',0,1);
                        $this->gongrefs=get_peizhi('gongrefs',0,1);
                        $this->ceweizldw=get_peizhi('ceweizldw',0,1);
                        $this->gongdianlx=get_peizhi('gongdianlx',0,1);
                        $this->gongshuilx=get_peizhi('gongshuilx',0,1);
                        break;
                }
                $this->bjlpxq = $bjlpxq;
                $xiaoqu = M('xiaoqu')->where(array('id'=>$id))->find();
                $xiaoqu['csjunjia'] = $xiaoqu['csjunjia'] > 0 ? floatval($xiaoqu['csjunjia']) : '';
                $xiaoqu['shoufu'] = $xiaoqu['shoufu'] > 0 ? floatval($xiaoqu['shoufu']) : '';
                $xiaoqu['wuyefei'] = $xiaoqu['wuyefei'] > 0 ? floatval($xiaoqu['wuyefei']) : '';
                $xiaoqu['cenggao'] = $xiaoqu['cenggao'] > 0 ? floatval($xiaoqu['cenggao']) : '';
                $this->xiaoqu = $xiaoqu;
                $this->display();
            }
        }
        // 调整坐标
        public function tzdtzb(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(180,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $data['dituzb']=I('dituzb');
                $isok=M("xiaoqu")->where(array('id'=>$id))->save($data);
                if ($isok===1){
                    $this->success('更新成功！');
                }elseif ($isok===0){
                    $this->error('数据无变动！');
                }else{
                    $this->error('更新失败！');
                }
            } else {
                $this->xiaoqu=M('xiaoqu')->where(array('id'=>$id))->find();
                $this->display();
            }
        }
        /**
        * webuploader 图片上传
        */
        function scxqtp() {
            $xqid=I('xqid');
            $whrid=M('xiaoqu')->where(array('id'=>$xqid))->getField('whrid');
            $is_rbac = _rbac_btn_show(185,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $mark = "./Upload/".session('gongsiid')."/xiaoqu/".$xqid;
                if (!file_exists($mark)){
                    mkdir($mark);
                }
                // 根据自己的业务调整上传路径、允许的格式、文件大小
                $path = "/Upload/".session('gongsiid')."/xiaoqu/".$xqid;
                ajax_upload_xq($path);
            } else {
                $this->display();
            }
        }
        /**
        * [xq_pic_setfengmian 异步小区图片为封面]
        * @return [json] [description]
        */
        public function xq_pic_setfengmian(){
            $id=I('xq_pic_id');
            //根据图片id查找小区图片的小区id号xqid
            $xqid = M('xqphoto')->where(array('id'=>$id))->getField('xqid');
            $adduid=M('xqphoto')->where(array('id'=>$id))->getField('uid');
            $is_rbac = _rbac_btn_show(485,0,$adduid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            M('xqphoto')->where(array('xqid'=>$xqid,'fengmian'=>1))->setField(array('fengmian'=>0));
            $r = M('xqphoto')->where(array('id'=>$id))->setField(array('fengmian'=>1));
            if ($r) {
                $this->success('设置成功');
            }else{
                $this->error('设置失败');
            }
        }
        /**
        * [xq_pic_del 异步删除图片]
        * @return [json] [description]
        */
        public function xq_pic_del(){
            $id=I('xq_pic_id');
            //根据图片id查看当前是否还有当前小区的图片
            $xqid = M('xqphoto')->where(array('id'=>$id))->getField('xqid');
            $adduid=M('xqphoto')->where(array('id'=>$id))->getField('uid');
            $is_rbac = _rbac_btn_show(188,0,$adduid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $piccount = M('xqphoto')->where(array('xqid'=>$xqid))->count();
            $dp=M('xqphoto');
            if($id){    //删除当前图片
                $plist = $dp->where(array('id'=>$id))->find();
                if ($plist){
                    unlink('./Upload/'.$plist['gongsiid'].'/xiaoqu/'.$plist['xqid'].'/'.$plist['image']);
                    unlink('./Upload/'.$plist['gongsiid'].'/xiaoqu/'.$plist['xqid'].'/t_'.$plist['image']);
                    $dp->where(array('id'=>$id))->delete();
                    $data=array('pics'=>$plist);
                    //删除最后一个小区图片后给xiaoqu表的tupian字段置 0
                    if ($piccount==1) {
                        M('xiaoqu')->where(array('id'=>$xqid))->setField('tupian',0);
                    }
                }else{
                    $data=array('pics'=>$plist);
                }
            }
            //返回值
            header("Content-type: application/json");
            exit(json_encode($data));
        }
        //批量删除小区图片
        public function xq_pic_dels(){
            $is_rbac = _rbac_node_show(486);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $ids=I('xq_pic_ids');
            foreach ($ids as $key => $value) {
                $adduid=M('xqphoto')->where(array('id'=>$value))->getField('uid');
                $is_rbac = _rbac_btn_show(486,0,$adduid);
                if (!$is_rbac) {
                    $this->error("您选择了权限范围之外的图片！");
                }
            }
            $xqid = M('xqphoto')->where(array('id'=>$ids[0]))->getField('xqid');
            if(is_array($ids)){
                $where = 'id in('.implode(',',$ids).')';//p($where);die;
                //获取当前图片的小区id
                $dp=M('xqphoto');
                foreach ($ids as $value) {//删除小区图片文件
                    $plist = $dp->where(array('id'=>$value))->find();
                    unlink('./Upload/'.$plist['gongsiid'].'/xiaoqu/'.$plist['xqid'].'/'.$plist['image']);
                    unlink('./Upload/'.$plist['gongsiid'].'/xiaoqu/'.$plist['xqid'].'/t_'.$plist['image']);
                }
                $dp->where($where)->delete();
                //删除最后一个小区图片后给xiaoqu表的tupian字段置 0
                $nopic = M('xqphoto')->where(array('xqid'=>$xqid))->count();
                if ($nopic<=0) {
                    M('xiaoqu')->where(array('id'=>$xqid))->setField('tupian',0);
                }
                $this->success('删除成功');
            }else{
                $this->error('删除失败'); 
            }
        }
        //批量下载小区图片
        public function xq_pic_downloads(){
            $is_rbac = _rbac_node_show(487);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $ids=I('xq_pic_ids');
            foreach ($ids as $key => $value) {
                $adduid=M('xqphoto')->where(array('id'=>$value))->getField('uid');
                $is_rbac = _rbac_btn_show(487,0,$adduid);
                if (!$is_rbac) {
                    $this->error("您选择了权限范围之外的图片！");
                }
            }
            $where = 'id in('.implode(',',$ids).')';
            $dp=M('xqphoto');
            $plist = $dp->where($where)->field('id,gongsiid,xqid,image')->select();
            $zip = new \ZipArchive; 
            if ($plist) {
                //压缩文件名(临时文件)
                $filename = './Upload/'.$plist[0]['gongsiid'].'/xiaoqu/'.$plist[0]['xqid'].'/'.md5($plist[0]['xqid']).'.zip';
                $downname = I("server.HTTP_HOST").'/Upload/'.$plist[0]['gongsiid'].'/xiaoqu/'.$plist[0]['xqid'].'/'.md5($plist[0]['xqid']).'.zip';
                //p($downname);die;
            }
            //新建zip压缩包
            $zip->open($filename,\ZipArchive::OVERWRITE | \ZipArchive::CREATE);
            //把图片一张一张加进去压缩
            foreach ($plist as $value) {
                $zip->addFile('./Upload/'.$value['gongsiid'].'/xiaoqu/'.$value['xqid'].'/'.$value['image']);
                $zip->renameName('./Upload/'.$value['gongsiid'].'/xiaoqu/'.$value['xqid'].'/'.$value['image'],$value['image']);
            }
            //打包zip
            $zip->close();
            //可以直接重定向下载
            //header('Location:'.$downname);
            $this->success($downname);
        }
        //设置图片类型
        public function settupianleixing(){
            $is_rbac = _rbac_node_show(488);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $ids=explode(",",I('xq_pic_ids'));
                foreach ($ids as $key => $value) {
                    $adduid=M('xqphoto')->where(array('id'=>$value))->getField('uid');
                    $is_rbac = _rbac_btn_show(488,0,$adduid);
                    if (!$is_rbac) {
                        $this->error("您选择了权限范围之外的图片！");
                    }
                }
                $ids1=I('xq_pic_ids');
                $tpleixing = I('tpleixing');
                if ($tpleixing=="") {
                    $this->error("请选择图片类型");
                }
                $where = 'id in('.$ids1.')';
                $dp=M('xqphoto');
                $plist = $dp->where($where)->setField(array('leixing' => $tpleixing ));
                if ($plist) {
                    $this->success("设置成功");
                }else{
                    $this->error("设置失败");
                }
            } else {
                $this->tpleixing = get_peizhi('xqtplx',0,1);
                $this->display();// 输出模板
            }
        }
        //小区视频
        public function shipin(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(534,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $shipin_url = I('shipin_url');
                if (preg_match_all('/src=&quot;(.*?)&quot;/', $shipin_url, $matches)) {
                    $s1 = $matches[1][0];
                    $shipin_url='<iframe src="'.$s1.'" frameborder="0" allowfullscreen="true" width="100%" height="100%"></iframe>';
                }elseif (preg_match_all('/src=\'(.*?)\'/', $shipin_url, $matches)) {
                    $s1 = $matches[1][0];
                    $shipin_url='<iframe src="'.$s1.'" frameborder="0" allowfullscreen="true" width="100%" height="100%"></iframe>';
                }else{
                    $this->error('视频地址格式不正确!');
                }
                $isok=M('xiaoqu')->where(array('id'=>$id))->setField('shipin_url',$shipin_url);
                
                if ($isok===1){
                    $this->success('更新成功！');
                }elseif ($isok===0){
                    $this->error('数据无变动！');
                }else{
                    $this->error('更新失败！');
                }
            }else{
                $this->shipin_url=M('xiaoqu')->where(array('id'=>$id))->getField('shipin_url');
                $this->display();
            }
        }
    }