<?php

    /*******************************************************************\
    |                                                                   |
    |   房佳（新房报备ERP管理系统）                                     |
    |                                                                   |
    |   © 2020-2023 http://www.kaidandashi.com/ All rights reserved.    |
    |                                                                   |
    |   本系统由淮南市银泰软件科技有限公司提供技术支持                  |
    |                                                                   |
    |   QQ号：984784483                                                 |
    |                                                                   |
    \*******************************************************************/

    namespace Admin\Controller;
    use Think\Controller;
    use Think\Model;
    class RbacController extends CommonController {
        //岗位列表
        public function Role(){
            $is_rbac = _rbac_node_show(18);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $rolefl = I('rolefl');
            $sousuo = I('sousuo');
            $condition = "where gongsiid = ".session('gongsiid');
            if($rolefl){
                $condition .= " and rolefl = '$rolefl'";
            }
            if ($sousuo) {
                $condition .= " and (remark like '%$sousuo%' or miaoshu like '%$sousuo%')";
            }
            $Model = new \Think\Model();
            $count=$Model->query("select count(*) from __ROLE__ {$condition}");
            $Page=new \Think\Page($count['0']['count(*)'],30);
            $show=$Page->show();
            $list="select * from __ROLE__ {$condition} order by rolefl asc,xsshunxu asc limit ".$Page->firstRow.','.$Page->listRows;
            $Role=$Model->query($list);
            $this->assign('firstRow',$Page->firstRow);
            $this->assign('role',$Role);
            $this->assign('count',$count);
            $this->assign('page',$show);
            $this->rolefl=get_peizhi('rolefl',0,1);
            $this->display();
        }
    	//用户列表
        public function index(){
            if (I('is_ajax')) {
                /*权限控制开始*/
                $map = "where gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(17,0);
                if ($x && $x != "all" && $x != "me") {
                    $map .= " and bumen in ({$x})";
                } elseif ($x == "me") {
                    $map .= " and id=".session('uid');
                } elseif ($x == false) {
                    $map .= " and id=0";
                }
                /*权限控制结束*/
                $sousuo = I('sousuo');
                $status = I('status');
                $shijian = I('shijian');
                $tree = new \Org\Util\Tree();
                $bumen = I("bumen",0,'intval');
                $result = M('bumen')->order(array("sort" => "ASC"))->select();
                if ($status == 1) {
                    $map .= " and status=0";
                } else {
                    $map .= " and status=1";
                }
                if ($sousuo) {
                    $map .= " and (dianhua like '%$sousuo%' or pinyinjs like '%$sousuo%' or ygmingcheng like '%$sousuo%' or ygbianhao like '%$sousuo%')";
                }
                if ($bumen) {
                    $arr_string = _rbac_bumen_array($result,$bumen);
                    $arr_string[] = $bumen;
                    $string = implode(',',$arr_string);
                    $map .= " and bumen in ($string)";
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $yhpx = "order by ".$field." ".$order;
                } else {
                    $yhpx = "order by id asc";
                }
                $Model = new \Think\Model();
                $count = $Model->query("select count(*) from __YONGHU__ {$map}");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list = "select * from __YONGHU__ {$map} ".$yhpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $Model->query($list);
                foreach ($data as $key => $value) {
                    $tuijianren = zym($value['tuijianren'],5);
                    $data[$key]['tuijianren'] = $tuijianren ? $tuijianren : "——";
                    $data[$key]['logintime'] = $value['logintime'] ? date('Y-m-d H:i:s',$value['logintime']) : "——";
                    $data[$key]['lock1'] = $value['lock1'] ? "已停用" : "已启用";
                    $data[$key]['bmming'] = zym($value['bumen'],6);
                    if (C("RBAC_SUPERADMIN") == $value['dianhua']) {
                        $data[$key]['remark'] = "超级管理员";
                    } else {
                        $data[$key]['remark'] = get_yh_role($value['id'],2);
                    }
                    switch ($value['xingbie']) {
                        case '1':
                            $data[$key]['xingbie'] = "男";
                            break;
                        case '2':
                            $data[$key]['xingbie'] = "女";
                            break;
                        default:
                            $data[$key]['xingbie'] = "未知";
                            break;
                    }
                    if ($value['status'] == 0) {
                        $is_rbachy = _rbac_btn_show(518,0,$value['id']);
                        $data[$key]['rbachy'] = $is_rbachy ? 1 : 0;
                    } else {
                        if (C("RBAC_SUPERADMIN") != $value['dianhua']) {
                            if ($value['lock1']) {
                                $is_rbacqy = _rbac_btn_show(192,0,$value['id']);
                                $data[$key]['rbacqy'] = $is_rbacqy ? 1 : 0;
                            } else {
                                $is_rbacty = _rbac_btn_show(190,0,$value['id']);
                                $data[$key]['rbacty'] = $is_rbacty ? 1 : 0;
                            }
                            $is_rbacsc = _rbac_btn_show(108,0,$value['adduid']);
                        }
                    }
                    $is_rbacgx = _rbac_btn_show(106,0,$value['adduid']);
                    // $is_rbaczy = _rbac_btn_show(414,0,$value['adduid']);
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    // $data[$key]['rbaczy'] = $is_rbaczy ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $select_categorys = bumen_option( $bumen, 17);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        public function stopUser(){
            $is_rbac = _rbac_btn_show(190,0,I('id',0,'intval'));
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $id=I('id');
            $yh=M('yonghu')->where(array('id'=>$id))->find();
            $xiugai.="停用员工[".$yh['ygmingcheng']."]";
            if(M('yonghu')->where(array('id'=>$id))->setField('lock1',1)){
                $data_rizhi['zy_type']=8;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=21;
                $data_rizhi['zy_id']=I('id');
                $data_rizhi['neirong']=$xiugai;
                M('rizhi')->add($data_rizhi);
                $this->success('已停用');
            }else{
                $this->error('停用失败');
            }
        }
        public function startUser(){
            $is_rbac = _rbac_btn_show(192,0,I('id',0,'intval'));
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $id=I('id');
            $yh=M('yonghu')->where(array('id'=>$id))->find();
            $xiugai.="启用员工[".$yh['ygmingcheng']."]";
            if(M('yonghu')->where(array('id'=>$id))->setField('lock1',0)){
                $data_rizhi['zy_type']=8;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=22;
                $data_rizhi['zy_id']=I('id');
                $data_rizhi['neirong']=$xiugai;
                M('rizhi')->add($data_rizhi);
                $this->success('已启用');
            }else{
                $this->error('启用失败');
            }
        }
        //添加岗位
        public function addRole(){
            $is_rbac = _rbac_node_show(99);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                //防止重复提交
                $yonghu=M('yonghu');
                if (!$yonghu->autoCheckToken($_POST)) {
                    $this->error('请不要重复添加');
                }
                if (session('gongsiid')=="") {
                    $this->error('请重新登录');
                }
                $data['pid']=0;
                $data['status']=1;
                $data['remark']=I('remark');
                $data['rolefl']=I('rolefl');
                $data['miaoshu']=I('miaoshu');
                $data['xsshunxu']=I('xsshunxu');
                $data['gongsiid']=session('gongsiid');
                $isok=M('Role')->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            }else{
                $this->rolefl=get_peizhi('rolefl',0,1);
                $this->display();
            }
        }
        //更新岗位
        public function editRole(){
            $is_rbac = _rbac_node_show(101);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $data['remark']=I('remark');
                $data['rolefl']=I('rolefl');
                $data['miaoshu']=I('miaoshu');
                $data['xsshunxu']=I('xsshunxu');
                $data['gongsiid']=session('gongsiid');
                $isok=M('Role')->where(array('id'=>I('id')))->save($data);
                if ($isok) {
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            }else{
                $this->role=M('Role')->where(array('id'=>I('id')))->find();
                $this->rolefl=get_peizhi('rolefl',0,1);
                $this->display();
            }
        }
        //删除岗位
        public function delRole(){
            $is_rbac = _rbac_node_show(103);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $isok=M('Role')->where(array('id'=>I('id')))->delete();
            if ($isok) {
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        //添加用户
        public function addUser(){
            $is_rbac = _rbac_node_show(104);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $dianhua = I('dianhua');
                $ygbianhao = I('ygbianhao');
                $bumen = I('bumen',0,'int');
                $role = I('role_id',0,'int');
                $gongke = I('gongke',0,'int');
                $xingbie = I('xingbie',0,'int');
                $tuijianren = I('tuijianren',0,'int');
                if (session('username') != C('RBAC_SUPERADMIN')) {
                    $kxrole = yhkxrole(0,2);
                    if (!in_array($role,$kxrole)) {
                        $this->error('异常错误！');
                    }
                }
                $tjbmsz = bumen_idsz(104);
                if (!in_array($bumen,$tjbmsz) && $tjbmsz[0] != "all"){
                    $this->error('异常错误！');
                }
                if ($tuijianren) {
                    $is_rbactj = _rbac_btn_show(104,0,$tuijianren);
                    if (!$is_rbactj) {
                        $this->error('异常错误！');
                    }
                }
                if (!preg_match("/^(13[0-9]|14[0-1,4-9]|15[0-3,5-9]|16[2567]|17[0-8]|18[0-9]|19[0-3,5-9])\d{8}$/",$dianhua)) {  
                    $this->error('电话号码格式不正确!'); 
                }
                if ($dianhua) {
                    $user1 = M('yonghu')->where(array('dianhua'=>$dianhua,'gongsiid'=>session('gongsiid')))->find();
                    if ($user1) {
                        $this->error('手机号已被使用');
                    }
                } else {
                    $this->error('手机号不能为空');
                }
                if ($gongke) {
                    $gongke = 1;
                } else {
                    $gongke = 0;
                }
                if ($ygbianhao) {
                    $user2 = M('yonghu')->where(array('ygbianhao'=>$ygbianhao,'gongsiid'=>session('gongsiid')))->find();
                    if ($user2) {
                        $this->error('员工编号已被使用');
                    }
                }
                switch ($xingbie) {
                    case 1:
                        $xingbie = 1;
                        break;
                    case 2:
                        $xingbie = 2;
                        break;
                    default:
                        $xingbie = 0;
                        break;
                }
                $mima = trim(I('mima')) == '' ? '123456' : trim(I('mima'));
                $user = array(
                    'gongsiid'=>session('gongsiid'),
                    'ygmingcheng'=>I('ygmingcheng'),
                    'pinyinjs'=>I('pinyinjs'),
                    'dianhua'=>$dianhua,
                    'gongke'=>$gongke,
                    'ygbianhao'=>$ygbianhao,
                    'xingbie'=>$xingbie,
                    'tuijianren'=>$tuijianren,
                    'bumen'=>$bumen,
                    'mima'=>md5($mima),
                    'logintime'=>time(),
                    'loginip'=>get_client_ip(),
                );
                for ($i = 1; $i < 7; $i++) { 
                    $user['company'.$i] = 0;
                }
                $bumen_find = M('bumen')->where(array('id'=>$bumen))->find();
                $u = $bumen_find['level'];
                $user['company'.$bumen_find['level']] = $bumen_find['id'];
                for ($i = 0; $i < $u; $i++) {
                    $bumen_find = M('bumen')->where(array('id'=>$bumen_find['parentid']))->find();
                    if ($bumen_find['bmming']) {
                        $user['company'.$bumen_find['level']] = $bumen_find['id'];
                    }
                }
                $data_role = array(
                    'role_id'=>$role,
                    'user_id'=>$isok
                );
                $isok = M('yonghu')->add($user);
                if ($isok) {
                    M('role_user')->add($data_role);
                    $data_rizhi['zy_type'] = 8;
                    $data_rizhi['uid'] = session("uid");
                    $data_rizhi['addtime'] = time();
                    $data_rizhi['cz_type'] = 1;
                    $data_rizhi['zy_id'] = $isok;
                    $yhrz = "新增用户".I('ygmingcheng')."（".$dianhua."）";
                    $data_rizhi['neirong'] = $yhrz;
                    M('rizhi')->add($data_rizhi);
                    $this->success('添加成功');
                } else {
                    $this->error('添加失败');
                }
            } else {
                if (session('username') == C('RBAC_SUPERADMIN')) {
                    $this->role = M('role')->where(array('gongsiid'=>session('gongsiid')))->order('rolefl asc,xsshunxu asc')->select();
                } else {
                    $this->role = yhkxrole(0,1,0);
                }
                $select_categorys = bumen_option(0,104);
                $this->assign("select_categorys",$select_categorys);
                $this->display();
            }
        }
        //更新用户
        public function editUser(){
            $id = I('id',0,'intval');
            $is_rbac = _rbac_btn_show(106,0,$id);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $et = I('edittype');
            switch ($et) {
                case '1':
                    if (!IS_POST) {$this->redirect('Rbac/edituser');}
                    $dianhua = I('dianhua');
                    $ygbianhao = I('ygbianhao');
                    $bumen = I('bumen',0,'int');
                    $role = I('role',0,'int');
                    $gongke = I('gongke',0,'int');
                    $xingbie = I('xingbie',0,'int');
                    $tuijianren = I('tuijianren',0,'int');
                    if (session('username') != C('RBAC_SUPERADMIN')) {
                        $kxrole = yhkxrole(0,2);
                        if (!in_array($role,$kxrole)) {
                            $this->error('异常错误！');
                        }
                    }
                    $tjbmsz = bumen_idsz(106);
                    if (!in_array($bumen,$tjbmsz) && $tjbmsz[0] != "all"){
                        $this->error('异常错误！');
                    }
                    if ($tuijianren) {
                        $is_rbactj = _rbac_btn_show(106,0,$tuijianren);
                        if (!$is_rbactj) {
                            $this->error('异常错误！');
                        }
                    }
                    if (!preg_match("/^(13[0-9]|14[0-1,4-9]|15[0-3,5-9]|16[2567]|17[0-8]|18[0-9]|19[0-3,5-9])\d{8}$/",$dianhua)) {  
                        $this->error('电话号码格式不正确!'); 
                    }
                    if ($dianhua) {
                        $user1 = M('yonghu')->where(array('dianhua'=>$dianhua,'id'=>array('neq',$id)))->find();
                        if ($user1) {
                            $this->error('手机号已被使用');
                        }
                    } else {
                        $this->error('手机号不能为空');
                    }
                    if ($gongke) {
                        $gongke = 1;
                    } else {
                        $gongke = 0;
                    }
                    if ($ygbianhao) {
                        $user2 = M('yonghu')->where(array('ygbianhao'=>$ygbianhao,'id'=>array('neq',$id)))->find();
                        if ($user2) {
                            $this->error('员工编号已被使用');
                        }
                    }
                    switch ($xingbie) {
                        case 1:
                            $xingbie = 1;
                            break;
                        case 2:
                            $xingbie = 2;
                            break;
                        default:
                            $xingbie = 0;
                            break;
                    }
                    $role_id = M('role_user')->where(array('user_id'=>$id))->getField('role_id');
                    $yh = M('yonghu')->where(array('id'=>$id))->find();
                    $data['dianhua'] = $dianhua;
                    $data['gongke'] = $gongke;
                    $data['ygmingcheng'] = I('ygmingcheng');
                    $data['pinyinjs'] = I('pinyinjs');
                    $data['bumen'] = $bumen;
                    $data['ygbianhao'] = $ygbianhao;
                    $data['xingbie'] = $xingbie;
                    $data['tuijianren'] = $tuijianren;
                    $data_role = array(
                        'role_id'=>$role,
                        'user_id'=>$id
                    );
                    if ($yh['dianhua'] == $dianhua && $yh['gongke'] == $gongke && $yh['ygmingcheng'] == I('ygmingcheng') && $yh['pinyinjs'] == I('pinyinjs') && $yh['bumen'] == $bumen && $role_id == $role && $yh['ygbianhao'] == $ygbianhao && $yh['xingbie'] == $xingbie && $yh['tuijianren'] == $tuijianren) {
                        $this->error('没有数据被更新！');
                    }
                    $xiugai .= "修改[".$yh['ygmingcheng']."]的信息为：";
                    if ($yh['dianhua'] != $dianhua && ($yh['dianhua'] == true || $dianhua == true)) {
                        $xiugai .= "手机号：[".$yh['dianhua']."]=>[".$dianhua."]；";
                    }
                    if ($yh['ygmingcheng'] != I('ygmingcheng') && ($yh['ygmingcheng'] == true || I('ygmingcheng') == true)) {
                        $xiugai .= "用户名称：[".$yh['ygmingcheng']."]=>[".I('ygmingcheng')."]；";
                    }
                    if ($yh['gongke'] != $gongke && ($yh['gongke'] == true || $gongke == true)) {
                        if ($yh['gongke']) {
                            $xgqgk = "是";
                        } else {
                            $xgqgk = "否";
                        }
                        if ($gongke) {
                            $xghgk = "是";
                        } else {
                            $xghgk = "否";
                        }
                        $xiugai .= "是否公客：[".$xgqgk."]=>[".$xghgk."]；";
                    }
                    if ($yh['pinyinjs'] != I('pinyinjs') && ($yh['pinyinjs'] == true || I('pinyinjs') == true)) {
                        $xiugai .= "拼音检索：[".$yh['pinyinjs']."]=>[".I('pinyinjs')."]；";
                    }
                    if ($yh['ygbianhao'] != $ygbianhao && ($yh['ygbianhao'] == true || $ygbianhao == true)) {
                        $xiugai .= "员工编号：[".$yh['ygbianhao']."]=>[".$ygbianhao."]；";
                    }
                    if ($yh['xingbie'] != $xingbie && ($yh['xingbie'] == true || $xingbie == true)) {
                        switch ($yh['xingbie']) {
                            case 1:
                                $xgqxb = "男";
                                break;
                            case 2:
                                $xgqxb = "女";
                                break;
                            default:
                                $xgqxb = "未知";
                                break;
                        }
                        switch ($xingbie) {
                            case 1:
                                $xghxb = "男";
                                break;
                            case 2:
                                $xghxb = "女";
                                break;
                            default:
                                $xghxb = "未知";
                                break;
                        }
                        $xiugai .= "性别：[".$xgqxb."]=>[".$xghxb."]；";
                    }
                    if ($yh['tuijianren'] != $tuijianren && ($yh['tuijianren'] == true || $tuijianren == true)) {
                        $xiugai .= "推荐人：[".zym($yh['tuijianren'],5)."]=>[".zym($tuijianren,5)."]；";
                    }
                    if ($bumen != $yh['bumen'] && ($yh['bumen'] == true || $bumen == true)) {
                        $xiugai .= get_xgbm($yh['bumen'],$bumen,'bumen');
                    }
                    if ($role != $role_id && ($role_id == true || $role == true)) {
                        $xiugai .= get_xgjs($role_id,$role,'role');
                    }
                    $data_rizhi = array(
                        'zy_type'=>8,
                        'uid'=>session('uid'),
                        'addtime'=>time(),
                        'cz_type'=>2,
                        'zy_id'=>$id,
                        'neirong'=>$xiugai,
                    );
                    for ($i = 1; $i < 7; $i++) { 
                        $data['company'.$i] = 0;
                    }
                    $bumen_find = M('bumen')->where(array('id'=>I('bumen')))->find();
                    $u = $bumen_find['level'];
                    $data['company'.$bumen_find['level']] = $bumen_find['id'];
                    for ($i = 0; $i < $u; $i++) { 
                        $bumen_find = M('bumen')->where(array('id'=>$bumen_find['parentid']))->find();
                        if ($bumen_find['bmming']) {
                            $data['company'.$bumen_find['level']] = $bumen_find['id'];
                        }
                    }
                    $user = M('yonghu')->where(array('id'=>$id))->save($data);
                    M('role_user')->where(array('user_id'=>$id))->delete();
                    $isok = M('role_user')->add($data_role);
                    if ($user or $isok) {
                        M('rizhi')->add($data_rizhi);
                        $this->success('更新成功');
                    } else {
                        $this->error('更新失败');
                    }
                    break;
                case '2':
                    if (!IS_POST) {$this->redirect('Rbac/edituser');}
                    $uid = $id;
                    $mima = trim(I('mima')) == '' ? '123456' : trim(I('mima'));
                    $isok = M('yonghu')->where(array('id'=>$uid))->setField(array('mima' =>md5($mima)));
                    if ($isok) {
                        $this->success('密码已重置为：'.$mima);
                    } else {
                        $this->error('密码未更改');
                    }
                    break;
                case '3':
                    if (!IS_POST) {$this->redirect('Rbac/edituser');}
                    $uid = $id;
                    $keyid = trim(I('keyid'));
                    if ($keyid == '') {
                        $this->error('加密锁ID不能为空');
                    }
                    $id = M('yonghu')->where(array('keyid'=>$keyid))->getField('id');
                    $isok = $id > 0 ? false : M('yonghu')->where(array('id'=>$uid))->setField(array('keyid' =>$keyid));
                    if ($isok) {
                        $this->success('更新成功');
                    } else {
                        $this->error('加密锁ID未更改或已存在');
                    }
                    break;
                default:
                    $user = M('yonghu')->where(array('id'=>$id))->find();
                    $this->user = $user;
                    $bumen = $user['bumen'];
                    $this->role = yhkxrole(0,1);
                    $this->role_id = get_yh_role($id,1);
                    $this->tuijianren = zym($user['tuijianren'],5);
                    $select_categorys = bumen_option($bumen,106);
                    $this->assign("select_categorys",$select_categorys);
                    $this->display();
                break;
            }
        }
        //删除用户
        public function delUser(){
            $is_rbac = _rbac_btn_show(108,0,I('id',0,'intval'));
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $id=I('id');
            $yh=M('yonghu')->where(array('id'=>$id))->find();
            $xiugai.="删除员工[".$yh['ygmingcheng']."]";
            $isok=M('yonghu')->where(array('id'=>$id))->setField('status',0);
            if ($isok){
                $data_rizhi['zy_type']=8;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=8;
                $data_rizhi['zy_id']=I('id');
                $data_rizhi['neirong']=$xiugai;
                M('rizhi')->add($data_rizhi);
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        //恢复用户
        public function huifuUser(){
            $id=I('id');
            $is_rbac = _rbac_btn_show(518,0,$id);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $yh=M('yonghu')->where(array('id'=>$id))->find();
            $xiugai.="恢复员工[".$yh['ygmingcheng']."]";
            $dp=M('Yonghu');
            $isok=$dp->where(array('id'=>$id))->setField('status',1);
            if ($isok){
                $data_rizhi['zy_type']=8;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=24;
                $data_rizhi['zy_id']=I('id');
                $data_rizhi['neirong']=$xiugai;
                M('rizhi')->add($data_rizhi);
                $this->success('恢复成功');
            }else{
                $this->error('恢复失败');
            }
        }
        //配置权限
        public function access(){
            $is_rbac = _rbac_node_show(113);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $access1 = htmlspecialchars_decode(I('access'));
                $access2 = json_decode($access1,true);
                $access = array_unique(array_filter($access2));
                $rid = $access['rid'];
                $db = M('access');
                //清空原权限
                $db->where(array('role_id'=>$rid))->delete();
                //组合新权限
                unset($access['rid']);
                unset($access['__hash__']);
                $data = array();
                foreach ($access as $v) {
                    if ($v != "") {
                        $tmp = explode('_', $v);
                        if ($tmp[0] != 0) {
                            $data[]=array(
                            'role_id'=>$rid,
                            'node_id'=>$tmp[0],
                            'level'=>3,
                            'fanwei'=>$tmp[1],
                            'zhuangtai'=>$tmp[2],
                           );
                        }
                    }
                }
                $node = M('node')->where(array('level'=>array('in','1,2')))->select();
                foreach ($node as $v) {
                    $data[]=array(
                        'role_id'=>$rid,
                        'node_id'=>$v['id'],
                        'level'=>$v['level'],
                        'fanwei'=>0,
                        'zhuangtai'=>0,
                    );
                }
                //插入新权限
                if ($db->addALL($data)) {
                    $this->success('修改成功');
                }else{
                    $this->error('修改失败');
                }
            } else {
                $rid = I('rid',0,'intval');
                $arr = M('node_set')->where(array('status'=>1))->order(array("sort" => "ASC"))->select();
                foreach ($arr as $key => $value) {
                    $arr[$key]['pid'] = $value['parentid'];
                }
                $access = M('access')->where(array('level'=>3,'role_id'=>$rid))->select();
                $result = [];
                foreach($access as $k=>$v){
                    $result[$v['node_id']][] = $v;
                }
                $arr = node_merge($arr,null,0);
                foreach ($arr as $k1 => $v1) {
                    if ($v1['is_sign']) {
                        foreach ($v1['child'] as $k2 => $v2) {
                            $arr[$k1]['child'][$k2]['config'] = $result[$v2['node_id']];
                        }
                    } else {
                        foreach ($v1['child'] as $k2 => $v2) {
                            foreach ($v2['child'] as $key => $value) {
                                $arr[$k1]['child'][$k2]['child'][$key]['config'] = $result[$value['node_id']];
                            }
                        }
                    }
                }
                $this->categorys = $arr;
                $this->bumen_arr_level = get_options('bumen_options','bumen_array');
                $this->rid=$rid;
                $this->display('access2');
            }
        }
        public function Bumen(){
            $is_rbac = _rbac_node_show(115);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $map['gongsiid']=session('gongsiid');
            $Data=M('bumen');
            $result = $Data->where($map)->order(array("id" => "ASC"))->select();
            $xiao = $result;
            $tree = new \Org\Util\Tree();
            $tree->icon = array('&nbsp;&nbsp;&nbsp;│ ', '&nbsp;&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;&nbsp;└─ ');
            $tree->nbsp = '&nbsp;&nbsp;&nbsp;';
            $newmenus=array();
            foreach ($result as $m){
                $newmenus[$m['id']]=$m;
            }
            $bumen_option_value_arr = get_options('bumen_options','bumen_array');
            $sc=new AjaxController();
            foreach ($result as $n=> $r) {
                $result[$n]['level_s'] = $bumen_option_value_arr[$sc->get_level($r['id'], $newmenus)];
                $result[$n]['str_manage'] = '<if condition="_rbac_node_show(116)"><a href="javascript:;" class="layui-btn layui-btn-mini" onclick="layer_show(\'添加部门\',\''.U('addBumen',array('parentid'=>$r['id'])).'\',\'480\',\'480\')"><i class="Hui-iconfont">&#xe604;</i> 添加</a></if>';
                $result[$n]['str_manage'] .='&nbsp;&nbsp;&nbsp;<if condition="_rbac_node_show(118)"><a href="javascript:;" class="layui-btn layui-btn-normal layui-btn-mini" onclick="layer_show(\'更新部门\',\''.U('editbumen',array('id'=>$r['id'])).'\',\'480\',\'480\')"><i class="Hui-iconfont">&#xe6df;</i> 编辑</a></if>';
                $result[$n]['str_manage'] .='&nbsp;&nbsp;&nbsp;<if condition="_rbac_node_show(120)"><a href="javascript:;" class="layui-btn layui-btn-danger layui-btn-mini" onclick="admin_bumen_del(this,\''.$r['id'].'\')"><i class="Hui-iconfont">&#xe6df;</i> 删除</a></if>';
            }
            $tree->init($result);
            $str = "<tr id='node-\$id' \$parentid_node style='\$style'>
                        <td style='padding-left:20px;'>\$id</td>
                        <td>\$level-\$level_s</td>
                        <td>\$spacer\$bmming</td>
                        <td>\$bmdianhua</td>
                        <td>\$str_manage</td>
                    </tr>";
            $categorys = $tree->get_tree(0, $str);
            $this->assign("categorys", $categorys);
            $this->display();
        }
        public function addBumen(){
            $is_rbac = _rbac_node_show(116);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $s = count(get_options('bumen_options','bumen_array'));
                $data['parentid']=I('parentid',0,'intval');
                $level = M('bumen')->where(array('id'=>$data['parentid']))->getField('level');
                if ($s<=$level) {
                    $this->error('此部门已是最后一级部门，不能添加子部门。');
                }
                if ($level > 5) {
                    $this->error('当前部门的级别超出六级');
                }
                $data['level']=$level+1;//重要的等级
                $data['cjshijian']=time();
                $data['bmming']=I('bmming');
                $data['bmdianhua']=I('bmdianhua');
                $data['bmdizhi']=I('bmdizhi');
                $data['gongsiid']=session('gongsiid');
                if(M('bumen')->add($data)){
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $parentid = I("get.parentid",0,'intval');
                $select_categorys = bumen_option( $parentid, 0);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        public function editBumen(){
            $is_rbac = _rbac_node_show(118);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $id=I('id');
                $_POST['parentid']=I('parentid',0,'intval');
                $bumen_arr = get_bm_sz($id,1);
                if (in_array($_POST['parentid'],$bumen_arr)){
                    $this->error('不能选择自己或子级部门为父级部门！');
                }
                $s = count(get_options('bumen_options','bumen_array'));
                $level = M('bumen')->where(array('id'=>$_POST['parentid']))->getField('level');
                if ($s<=$level) {
                    $this->error('父级部门已是最后一级部门，不能修改为此部门的子级部门。');
                }
                if ($level > 5) {
                    $this->error('当前部门的级别超出六级');
                }
                $_POST['level']=$level+1;//重要的等级
                if (M('bumen')->where(array('id'=>$id,'gongsiid'=>session('gongsiid')))->save($_POST)) {
                    $this->success('修改成功'); 
                }else{
                    $this->error('修改失败');
                }
            } else {
                $id = I("get.id",0,'intval');
                $this->bumen = M('bumen')->where(array('id'=>$id))->find();
                $parentid = $this->bumen['parentid'];
                $select_categorys = bumen_option( $parentid, 0);
                $this->assign("select_categorys", $select_categorys);
                $this->bm=M('bumen')->where(array('id'=>$id))->find();
                $this->yonghu=M('yonghu')->where(array('bumen'=>$id,'gongsiid'=>session('gongsiid')))->select();
                $this->display();
            }
        }
        public function delBumen(){
            $is_rbac = _rbac_node_show(120);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $id = I('id');
            $string = get_bm_sz($id,2);
            $yonghu = M('yonghu')->where(array('gongsiid'=>session("gongsiid"),'bumen'=>array('in',$string)))->count();
            if ($yonghu) {
                $this->error('该部门存在'.$yonghu.'个用户！');
            }
            $isok = M('bumen')->where(array('gongsiid'=>session("gongsiid"),'id'=>array('in',$string)))->delete();
            if ($isok) {
                $this->success('删除成功'); 
            }else{
                $this->error('删除失败');
            }
        }
        // 员工日志
        public function rizhi(){
            if (I('is_ajax')) {
                $condition = "e.gongsiid=".session('gongsiid')." and a.zy_type = 8";
                $x = _rbac_lists_where(442,0);
                if ($x && $x != "all" && $x != "me") {
                    $condition .= " and e.bumen in ({$x})";
                } elseif ($x == "me") {
                    $condition .= " and e.id=".session('uid');
                } elseif ($x == false) {
                    $condition .= " and e.id=0";
                }
                $bumen = I('bumen');
                $sousuo = I('sousuo');
                $shijian = I('shijian');
                if ($bumen) {
                    $string = get_bm_sz($bumen,2);
                    $condition .= " and e.bumen in ($string)";
                }
                if ($shijian) {
                    $time_s = explode(' - ',$shijian);
                    $time_s1 = strtotime($time_s[0]);
                    $time_s2 = strtotime($time_s[1])+86400;
                    $condition .= " and a.addtime>=".$time_s1." and a.addtime<".$time_s2;
                }
                if ($sousuo) {
                    $condition .= " and (e.ygmingcheng like '%$sousuo%' or e.pinyinjs like '%$sousuo%' or e.dianhua like '%$sousuo%' or a.zy_bianhao like '%$sousuo%')";
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $rzpx = "a.".$field." ".$order;
                } else {
                    $rzpx = "a.addtime desc";
                }
                $count = M('rizhi')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->where($condition)->count();
                $Page = I('p');
                $data = M('rizhi')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->field('a.*,e.ygmingcheng,e.dianhua,e.bumen')->where($condition)->order($rzpx)->page($Page,$limit)->select();
                foreach ($data as $key => $value) {
                    $data[$key]['addtime'] = date('Y-m-d H:i:s',$value['addtime']);
                    $data[$key]['bmming'] = zym($value['bumen'],6);
                    $zybh = explode("-", $value['zy_bianhao']);
                    $data[$key]['zybh'] = $value['zy_bianhao'] ? $value['zy_bianhao'] : "——";
                    $data[$key]['zy_bianhao'] = $zybh[1];
                    $data[$key]['zylx'] = "用户";
                    switch ($value['cz_type']) {
                        case 1:
                            $cz_type = "新增";
                            break;
                        case 2:
                            $cz_type = "基础修改";
                            break;
                        case 8:
                            $cz_type = "删除";
                            break;
                        case 18:
                            $cz_type = "审核";
                            break;
                        case 21:
                            $cz_type = "停用";
                            break;
                        case 22:
                            $cz_type = "启用";
                            break;
                        case 23:
                            $cz_type = "信息转移";
                            break;
                        case 38:
                            $cz_type = "用户注册";
                            $data[$key]['bmming'] = "——";
                            $data[$key]['ygmingcheng'] = "——";
                            $data[$key]['dianhua'] = "——";
                            break;
                        default:
                            $cz_type = "——";
                            break;
                    }
                    $data[$key]['cz_type'] = $cz_type;
                    $data[$key]['neirong'] = $value['neirong'] ? $value['neirong'] : "——";
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count,
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $select_categorys = bumen_option( $bumen, 442);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        //可选岗位
        public function kxrole(){
            $is_rbac = _rbac_node_show(36);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $id=I('id');
            if (IS_POST) {
                $roleids=I('duoxuan');
                foreach ($roleids as $key => $value) {
                    $arr[]=$value;
                }
                $ids=implode(",",$arr);
                $isok=M('role')->where(array('id'=>$id))->setField('kxrole',$ids);
                if ($isok) {
                    $this->success('配置成功');
                }else{
                    $this->error('配置失败');
                }
            }else{
                $this->role=yhkxrole(0,1);
                $this->roleid=yhkxrole($id,2);
                $this->rolefl=get_peizhi('rolefl',0,1);
                $this->display();
            }
        }
    }
?>