/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.command;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ItemBlockArmor;
import twopiradians.blockArmor.packet.PacketDevColors;

public class CommandDev
implements ICommand {
    private static HashMap<String, ArmorSet> setMap = Maps.newHashMap();
    private static final String ARMOR = "armor";
    private static final String COLOR = "color";
    private static ArrayList<String> ALL_COMMAND_NAMES = new ArrayList<String>(){
        {
            this.add(CommandDev.ARMOR);
            this.add(CommandDev.COLOR);
        }
    };
    public static final ArrayList<UUID> DEVS = new ArrayList<UUID>(){
        {
            this.add(UUID.fromString("f08951bc-e379-4f19-a113-7728b0367647"));
            this.add(UUID.fromString("93d28330-e1e2-447b-b552-00cb13e9afbd"));
        }
    };
    public static HashMap<UUID, Float[]> devColors = Maps.newHashMap();

    public static void addBlockName(ArmorSet set) {
        if (!setMap.containsKey(set)) {
            String name = "";
            try {
                name = set.stack.func_82833_r();
                name = name.replace(" ", "_");
                name = TextFormatting.func_110646_a((String)name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!name.equals("")) {
                setMap.put(name, set);
            }
        }
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public String func_71517_b() {
        return "dev";
    }

    public String func_71518_a(ICommandSender sender) {
        return "";
    }

    public List<String> func_71514_a() {
        return new ArrayList<String>();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }

    public static boolean runCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayer) {
            if (args.length == 2 && args[0].equalsIgnoreCase(ARMOR)) {
                ArmorSet set = setMap.get(args[1]);
                if (set != null) {
                    for (EntityEquipmentSlot slot : ArmorSet.SLOTS) {
                        ItemStack stack = ((EntityPlayer)sender).func_184582_a(slot);
                        ItemStack newStack = new ItemStack((Item)set.getArmorForSlot(slot));
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74757_a("devSpawned", true);
                        newStack.func_77982_d(nbt);
                        if (stack != null && !(stack.func_77973_b() instanceof ItemBlockArmor)) continue;
                        ((EntityPlayer)sender).func_184201_a(slot, newStack);
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + "Spawned set for " + args[1].replace("_", " "), new Object[0]));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Invalid block", new Object[0]));
                }
                return true;
            }
            if (args.length == 4 && args[0].equalsIgnoreCase(COLOR)) {
                try {
                    Float[] color = new Float[]{Float.valueOf(Float.parseFloat(args[1])), Float.valueOf(Float.parseFloat(args[2])), Float.valueOf(Float.parseFloat(args[3]))};
                    if (color[0].floatValue() == -1.0f && color[1].floatValue() == -1.0f && color[2].floatValue() == -1.0f) {
                        devColors.remove(((EntityPlayer)sender).getPersistentID());
                    } else {
                        devColors.put(((EntityPlayer)sender).getPersistentID(), color);
                    }
                    BlockArmor.network.sendToAll((IMessage)new PacketDevColors());
                }
                catch (Exception e) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Color must be 3 floats (-1 to 1 for standard results)", new Object[0]));
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return DEVS.contains(((EntityPlayer)sender).getPersistentID());
        }
        return false;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, ALL_COMMAND_NAMES);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase(ARMOR)) {
            return CommandBase.func_175762_a((String[])args, setMap.keySet());
        }
        if (args.length < 5 && args[0].equalsIgnoreCase(COLOR)) {
            return new ArrayList<String>(){
                {
                    this.add("-1");
                    this.add("0");
                }
            };
        }
        return new ArrayList<String>();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }
}

