/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.seteffect;

import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class SetEffectAutoSmelt
extends SetEffect {
    protected SetEffectAutoSmelt() {
        this.color = TextFormatting.DARK_RED;
        this.description = "Smelts harvested blocks";
        this.usesButton = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (ArmorSet.getFirstSetItem((EntityLivingBase)player, this) == stack && !world.field_72995_K && BlockArmor.key.isKeyDown(player) && !player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            boolean deactivated = !stack.func_77978_p().func_74767_n("deactivated");
            stack.func_77978_p().func_74757_a("deactivated", deactivated);
            player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GRAY + "[Block Armor] " + TextFormatting.ITALIC + "AutoSmelt set effect " + (deactivated ? TextFormatting.RED + "" + TextFormatting.ITALIC + "disabled." : TextFormatting.GREEN + "" + TextFormatting.ITALIC + "enabled."), new Object[0]));
            this.setCooldown(player, 10);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEvent(BlockEvent.HarvestDropsEvent event) {
        if (ArmorSet.getWornSetEffects((EntityLivingBase)event.getHarvester()).contains(this)) {
            ItemStack stack = ArmorSet.getFirstSetItem((EntityLivingBase)event.getHarvester(), this);
            if (event.getWorld().field_72995_K || event.isSilkTouching() || !stack.func_77942_o() || stack.func_77978_p().func_74767_n("deactivated")) {
                return;
            }
            ListIterator dropsIterator = event.getDrops().listIterator();
            boolean smelted = false;
            while (dropsIterator.hasNext()) {
                ItemStack oldDrops = (ItemStack)dropsIterator.next();
                ItemStack newDrops = FurnaceRecipes.func_77602_a().func_151395_a(oldDrops);
                if (newDrops == null || newDrops.func_77973_b() == null) continue;
                newDrops = newDrops.func_77946_l();
                event.getDrops().clear();
                event.getDrops().add(newDrops);
                smelted = true;
            }
            if (smelted) {
                ((WorldServer)event.getWorld()).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)event.getPos().func_177958_n() + 0.5f), (double)((float)event.getPos().func_177956_o() + 0.5f), (double)((float)event.getPos().func_177952_p() + 0.5f), 10, (double)0.3f, (double)0.3f, (double)0.3f, 0.0, new int[0]);
                event.getWorld().func_184133_a(null, event.getHarvester().func_180425_c(), SoundEvents.field_187606_E, SoundCategory.PLAYERS, 0.1f, event.getWorld().field_73012_v.nextFloat() + 0.7f);
                this.damageArmor((EntityLivingBase)event.getHarvester(), 1, false);
            }
        }
    }

    @Override
    protected boolean isValid(Block block, int meta) {
        return SetEffect.registryNameContains(block, meta, new String[]{"furnace", "fire", "flame", "smelt"});
    }
}

