/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.seteffect;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class SetEffectLightweight
extends SetEffect {
    protected SetEffectLightweight() {
        this.color = TextFormatting.GREEN;
        this.description = "Fall slowly, like a leaf in the wind";
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEvent(LivingFallEvent event) {
        if (ArmorSet.getWornSetEffects(event.getEntityLiving()).contains(this)) {
            if (event.getEntityLiving().func_70093_af()) {
                event.setDamageMultiplier(0.1f);
            } else {
                event.setDamageMultiplier(0.01f);
                event.setDistance(event.getDistance() / 10.0f);
            }
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (!player.func_70093_af() && ArmorSet.getFirstSetItem((EntityLivingBase)player, this) == stack && player.field_70181_x < 0.0 && !player.field_70122_E && world.func_175623_d(player.func_180425_c().func_177979_c(2)) && world.field_72995_K && player.field_70143_R > 1.0f) {
            player.func_70024_g(0.0, 0.07, 0.0);
            if (player.field_70143_R > 5.0f) {
                double driftX = world.field_73012_v.nextDouble() - 0.5;
                double driftZ = world.field_73012_v.nextDouble() - 0.5;
                player.func_70024_g(driftX / 5.0, 0.0, driftZ / 5.0);
                if (Math.abs(driftX) + Math.abs(driftZ) >= 0.75) {
                    world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187579_bV, SoundCategory.PLAYERS, 0.08f, world.field_73012_v.nextFloat() / 5.0f);
                }
            }
        }
    }

    @Override
    protected boolean isValid(Block block, int meta) {
        try {
            if (SetEffect.registryNameContains(block, meta, new String[]{"leaves", "feather"}) || block.isLeaves(null, null, BlockPos.field_177992_a)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

