/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.client;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import twopiradians.blockArmor.client.gui.armorDisplay.OpenGuiEvent;
import twopiradians.blockArmor.client.gui.config.GuiConfigUpdater;
import twopiradians.blockArmor.client.key.KeyActivateSetEffect;
import twopiradians.blockArmor.client.model.ModelBlockArmor;
import twopiradians.blockArmor.client.model.ModelDynBlockArmor;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.CommonProxy;
import twopiradians.blockArmor.common.block.ModBlocks;
import twopiradians.blockArmor.common.config.Config;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ModItems;

public class ClientProxy
extends CommonProxy {
    private HashMap<String, ModelBlockArmor> modelMaps = Maps.newHashMap();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        KeyActivateSetEffect.ACTIVATE_SET_EFFECT = new KeyBinding("Activate Set Effect", 19, "Block Armor");
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelDynBlockArmor.LoaderDynBlockArmor.INSTANCE);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new OpenGuiEvent());
        MinecraftForge.EVENT_BUS.register((Object)BlockArmor.key);
        MinecraftForge.EVENT_BUS.register((Object)new GuiConfigUpdater());
        ClientRegistry.registerKeyBinding((KeyBinding)KeyActivateSetEffect.ACTIVATE_SET_EFFECT);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        ModBlocks.registerRenders();
        ModItems.registerRenders();
    }

    @Override
    public Object getBlockArmorModel(int height, int width, int currentFrame, int nextFrame, EntityEquipmentSlot slot) {
        String key = height + "" + width + "" + currentFrame + "" + nextFrame + "" + slot.func_188450_d();
        ModelBlockArmor model = this.modelMaps.get(key);
        if (model == null) {
            model = new ModelBlockArmor(height, width, currentFrame, nextFrame, slot);
            this.modelMaps.put(key, model);
        }
        return model;
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                ClientProxy.this.mapTextures();
                Config.syncJEIBlacklist();
            }
        });
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (!Minecraft.func_71410_x().func_147113_T() && event.side == Side.CLIENT) {
            for (ArmorSet set : ArmorSet.allSets) {
                for (int i = 0; i < 4; ++i) {
                    if (set.animations[i] == null) continue;
                    int n = i;
                    set.frames[n] = set.frames[n] + 0.5f / (float)set.animations[i].func_110472_a((int)set.frames[i]);
                    if (!(set.frames[i] >= (float)set.animations[i].func_110473_c())) continue;
                    int n2 = i;
                    set.frames[n2] = set.frames[n2] - (float)set.animations[i].func_110473_c();
                }
            }
        }
    }

    private void mapTextures() {
        this.modelMaps = Maps.newHashMap();
        ArrayList<ArmorSet> setsToDisable = new ArrayList<ArmorSet>();
        int numTextures = 0;
        for (ArmorSet set : ArmorSet.allSets) {
            Tuple<Integer, Boolean> tup = set.initTextures();
            numTextures += ((Integer)tup.func_76341_a()).intValue();
            if (!((Boolean)tup.func_76340_b()).booleanValue()) continue;
            setsToDisable.add(set);
        }
        if (numTextures == 0) {
            return;
        }
        if (!setsToDisable.isEmpty()) {
            int disabledSets = 0;
            for (ArmorSet set : setsToDisable) {
                set.missingTextures = true;
                set.disable();
                ++disabledSets;
            }
            if (disabledSets > 0) {
                BlockArmor.logger.info("Disabled " + disabledSets + " armor set" + (disabledSets > 1 ? "s" : "") + " without textures");
            }
        }
        BlockArmor.logger.info("Found " + numTextures + " block textures for Block Armor");
        int numIcons = ModelDynBlockArmor.BakedDynBlockArmorOverrideHandler.createInventoryIcons();
        BlockArmor.logger.info("Created " + numIcons + " inventory icons for Block Armor");
    }

    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre event) {
        for (Item item : ArmorSet.TEXTURE_OVERRIDES) {
            for (EntityEquipmentSlot slot : ArmorSet.SLOTS) {
                event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/overrides/" + item.getRegistryName().func_110623_a().toLowerCase().replace(" ", "_") + "_" + slot.func_188450_d()));
            }
        }
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_helmet_base"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_helmet_cover"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_helmet1_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_helmet2_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_chestplate_base"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_chestplate_cover"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_chestplate1_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_chestplate2_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_leggings_base"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_leggings_cover"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_leggings1_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_leggings2_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_boots_base"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_boots_cover"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_boots1_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_boots2_template"));
    }
}

