/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.client.gui.config;

import java.util.ArrayList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twopiradians.blockArmor.common.config.Config;

@SideOnly(value=Side.CLIENT)
public class GuiConfigUpdater {
    @SubscribeEvent
    public void onGuiConfigInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiConfig && ((GuiConfig)event.getGui()).modID == "blockarmor" && !((GuiConfig)event.getGui()).entryList.listEntries.isEmpty() && ((GuiConfig)event.getGui()).entryList.listEntries.get(0) instanceof GuiConfigEntries.BooleanEntry) {
            ConfigCategory category = Config.config.getCategory("general");
            category.setLanguageKey(" ");
            if (category != null) {
                category.setRequiresMcRestart(!((GuiConfigEntries.IConfigEntry)((GuiConfig)event.getGui()).entryList.listEntries.get(0)).enabled());
                ((GuiConfig)event.getGui()).entryList.listEntries.add(0, new ButtonToggleConfig(((GuiConfig)event.getGui()).entryList.owningScreen, ((GuiConfig)event.getGui()).entryList, (IConfigElement)new ConfigElement(category)));
            }
        }
    }

    public static class ButtonToggleConfig
    extends GuiConfigEntries.ButtonEntry {
        protected final boolean beforeValue;
        protected boolean currentValue;

        public ButtonToggleConfig(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.toolTip = new ArrayList<String>(){
                {
                    this.add("Enable or disable everything below.");
                }
            };
            this.beforeValue = this.owningEntryList.listEntries.size() >= 2 && this.owningEntryList.listEntries.get(1) instanceof GuiConfigEntries.BooleanEntry ? ((GuiConfigEntries.BooleanEntry)this.owningEntryList.listEntries.get(1)).getCurrentValue() == false : false;
            this.currentValue = this.beforeValue;
            this.updateValueButtonText();
        }

        public void updateValueButtonText() {
            this.btnValue.field_146126_j = this.currentValue ? TextFormatting.DARK_GREEN + "" + TextFormatting.BOLD + "Enable All" : TextFormatting.DARK_RED + "" + TextFormatting.BOLD + "Disable All";
        }

        public void valueButtonPressed(int slotIndex) {
            this.currentValue = !this.currentValue;
            for (GuiConfigEntries.IConfigEntry entry : this.owningEntryList.listEntries) {
                if (!(entry instanceof GuiConfigEntries.BooleanEntry) || ((GuiConfigEntries.BooleanEntry)entry).getCurrentValue() != this.currentValue) continue;
                ((GuiConfigEntries.BooleanEntry)entry).valueButtonPressed(1);
                ((GuiConfigEntries.BooleanEntry)entry).updateValueButtonText();
            }
            this.updateValueButtonText();
        }

        public boolean isDefault() {
            return !this.currentValue;
        }

        public void setToDefault() {
            if (this.currentValue) {
                this.valueButtonPressed(0);
            }
        }

        public boolean isChanged() {
            return this.currentValue != this.beforeValue;
        }

        public void undoChanges() {
            this.currentValue = this.beforeValue;
            this.updateValueButtonText();
        }

        public boolean saveConfigElement() {
            return false;
        }

        public Boolean getCurrentValue() {
            return this.currentValue;
        }

        public Boolean[] getCurrentValues() {
            return new Boolean[]{this.getCurrentValue()};
        }
    }
}

