/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.item;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.config.Config;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ItemBlockArmor;

public class ModItems {
    public static ArrayList<ItemBlockArmor> allArmors = new ArrayList();

    public static void postInit() {
        int vanillaItems = 0;
        int moddedItems = 0;
        for (ArmorSet set : ArmorSet.allSets) {
            if (Config.disabledSets.contains(set)) continue;
            String registryName = ArmorSet.getItemStackRegistryName(set.stack);
            set.helmet = ModItems.registerItem(new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.HEAD, set), registryName + "_helmet", true);
            set.chestplate = ModItems.registerItem(new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.CHEST, set), registryName + "_chestplate", true);
            set.leggings = ModItems.registerItem(new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.LEGS, set), registryName + "_leggings", true);
            set.boots = ModItems.registerItem(new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.FEET, set), registryName + "_boots", true);
            if (set.isFromModdedBlock) {
                moddedItems += 4;
            } else {
                vanillaItems += 4;
            }
            ArrayList<ShapedRecipes> recipes = new ArrayList<ShapedRecipes>();
            ItemStack A = set.stack;
            ItemStack B = ItemStack.field_190927_a;
            recipes.add(new ShapedRecipes(3, 2, new ItemStack[]{A, A, A, A, B, A}, new ItemStack((Item)set.helmet)));
            recipes.add(new ShapedRecipes(3, 3, new ItemStack[]{A, B, A, A, A, A, A, A, A}, new ItemStack((Item)set.chestplate)));
            recipes.add(new ShapedRecipes(3, 3, new ItemStack[]{A, A, A, A, B, A, A, B, A}, new ItemStack((Item)set.leggings)));
            recipes.add(new ShapedRecipes(3, 2, new ItemStack[]{A, B, A, A, B, A}, new ItemStack((Item)set.boots)));
            set.recipes = recipes;
        }
        for (ArmorSet set : Config.disabledSets) {
            ArmorSet.allSets.remove(set);
        }
        BlockArmor.logger.info("Generated " + vanillaItems + " Block Armor items from Vanilla Blocks");
        if (moddedItems > 0) {
            BlockArmor.logger.info("Generated " + moddedItems + " Block Armor items from Modded Blocks");
        }
    }

    public static void registerRenders() {
        for (ItemBlockArmor item : allArmors) {
            ModItems.registerRender((Item)item);
        }
    }

    private static ItemBlockArmor registerItem(ItemBlockArmor item, String unlocalizedName, boolean isFromModdedBlock) {
        allArmors.add(item);
        item.func_77655_b(unlocalizedName);
        item.setRegistryName("blockarmor", unlocalizedName);
        GameRegistry.register((IForgeRegistryEntry)item);
        return item;
    }

    private static void registerRender(Item item) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation("blockarmor:" + item.func_77658_a().substring(5), "inventory"));
    }
}

