/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.seteffect;

import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStone;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class SetEffectMusical
extends SetEffect {
    protected SetEffectMusical() {
        this.color = TextFormatting.LIGHT_PURPLE;
        this.description = "Every step you take becomes a musical melody";
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (!world.field_72995_K && ArmorSet.getFirstSetItem((EntityLivingBase)player, this) == stack && !player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            double velX = player.field_70165_t - player.field_71094_bP;
            double velZ = player.field_70161_v - player.field_71085_bR;
            double motion = Math.sqrt(velX * velX + velZ * velZ);
            if (player.field_70122_E && motion > 0.1) {
                this.setCooldown(player, (int)Math.min(8.0 / motion, 100.0));
                ((WorldServer)world).func_175739_a(EnumParticleTypes.NOTE, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, 1, (double)0.8f, (double)0.4f, (double)0.8f, world.field_73012_v.nextDouble(), new int[0]);
                Block block = world.func_180495_p(player.func_180425_c().func_177977_b()).func_177230_c();
                SoundEvent sound = SoundEvents.field_187682_dG;
                if (block instanceof BlockLog || block instanceof BlockPlanks) {
                    sound = SoundEvents.field_187679_dF;
                } else if (block instanceof BlockSand || block instanceof BlockGravel) {
                    sound = SoundEvents.field_187688_dI;
                } else if (block instanceof BlockGlass) {
                    sound = SoundEvents.field_187685_dH;
                } else if (block instanceof BlockStone) {
                    sound = SoundEvents.field_187676_dE;
                }
                world.func_184133_a((EntityPlayer)null, player.func_180425_c(), sound, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 2.0f);
            }
        }
    }

    @Override
    protected boolean isValid(Block block, int meta) {
        return SetEffect.registryNameContains(block, meta, new String[]{"music", "note", "sound"});
    }
}

