/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.client.gui.armorDisplay;

import com.google.common.collect.Multimap;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twopiradians.blockArmor.client.gui.armorDisplay.EntityGuiPlayer;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ItemBlockArmor;
import twopiradians.blockArmor.common.seteffect.SetEffect;

@SideOnly(value=Side.CLIENT)
public class GuiArmorDisplay
extends GuiScreen {
    public static final boolean DISPLAY_ARMOR_GUI = false;
    public static final int GUI_MODE = 3;
    private final ResourceLocation backgroundWhite = new ResourceLocation("blockarmor:textures/gui/white.png");
    private final ResourceLocation backgroundTooltipColor = new ResourceLocation("blockarmor:textures/gui/tooltip_color.png");
    private EntityGuiPlayer guiPlayer;
    private float partialTicks;
    private ArrayList<ItemBlockArmor> armors;
    private Map<String, ArrayList<ItemStack>> tooltips;

    public GuiArmorDisplay() {
        this.guiPlayer = new EntityGuiPlayer((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_146103_bH(), (AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g);
        this.armors = new ArrayList();
        this.tooltips = new TreeMap<String, ArrayList<ItemStack>>(new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                arg0 = TextFormatting.func_110646_a((String)arg0);
                arg1 = TextFormatting.func_110646_a((String)arg1);
                return arg0.compareToIgnoreCase(arg1);
            }
        });
        for (ArmorSet set : ArmorSet.allSets) {
            if (set.isEnabled()) {
                this.armors.add(set.helmet);
                this.armors.add(set.chestplate);
                this.armors.add(set.leggings);
                this.armors.add(set.boots);
            }
            for (SetEffect effect : set.setEffects) {
                String tooltip = effect.addInformation(new ItemStack((Item)set.helmet), true, (EntityPlayer)this.guiPlayer, new ArrayList<String>(), false).get(0);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                stacks.add(0, set.stack);
                if (this.tooltips.containsKey(tooltip)) {
                    stacks.addAll(0, (Collection)this.tooltips.get(tooltip));
                }
                this.tooltips.put(tooltip, stacks);
            }
        }
        this.guiPlayer.func_82142_c(false);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.backgroundWhite);
        GlStateManager.func_179094_E();
        float scale = 1.0f;
        this.func_73729_b(0, 0, 0, 0, this.field_146294_l, this.field_146295_m);
        GlStateManager.func_179121_F();
        for (int i = 0; i < this.tooltips.size(); ++i) {
            GlStateManager.func_179094_E();
            int spaceBetween = 40;
            if (i < 11) {
                GlStateManager.func_179109_b((float)185.0f, (float)(20 + i * spaceBetween), (float)0.0f);
            } else if (i < 23) {
                GlStateManager.func_179109_b((float)510.0f, (float)(20 + (i - 11) * spaceBetween), (float)0.0f);
            } else {
                GlStateManager.func_179109_b((float)835.0f, (float)(20 + (i - 23) * spaceBetween), (float)0.0f);
            }
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(this.tooltips.keySet().toArray(new String[0])[i]);
            int numStacks = this.tooltips.get(this.tooltips.keySet().toArray(new String[0])[i]).size();
            if (numStacks == 14) {
                tooltip.set(0, "   " + (String)tooltip.get(0) + "   ");
            } else if (numStacks == 17) {
                tooltip.set(0, "                      " + (String)tooltip.get(0) + "                      ");
            }
            tooltip.add("");
            tooltip.add("");
            int length = 0;
            for (String string : tooltip) {
                if (this.field_146289_q.func_78256_a(string) <= length) continue;
                length = this.field_146289_q.func_78256_a(string);
            }
            this.func_146283_a(tooltip, -length / 2, 0);
            GlStateManager.func_179121_F();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private ArrayList<String> addStatTooltips(ArrayList<String> tooltip, ItemStack[] armor) {
        NBTTagList nbttaglist;
        ArrayList<Multimap> list = new ArrayList<Multimap>();
        list.add(armor[0].func_111283_C(EntityEquipmentSlot.HEAD));
        list.add(armor[1].func_111283_C(EntityEquipmentSlot.CHEST));
        list.add(armor[2].func_111283_C(EntityEquipmentSlot.LEGS));
        list.add(armor[3].func_111283_C(EntityEquipmentSlot.FEET));
        if (armor[3].func_77942_o() && (nbttaglist = armor[3].func_77986_q()) != null) {
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                short l = nbttaglist.func_150305_b(j).func_74765_d("lvl");
                if (Enchantment.func_185262_c((int)k) == null) continue;
                tooltip.add(ChatFormatting.GRAY + Enchantment.func_185262_c((int)k).func_77316_c((int)l));
            }
        }
        boolean flag = false;
        ArrayList<Double> finalD0s = new ArrayList<Double>();
        ArrayList<Double> finalD1s = new ArrayList<Double>();
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>();
        for (Multimap multimap : list) {
            if (multimap.isEmpty()) continue;
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.func_111164_d();
                flag = false;
                if (attributemodifier.func_111167_a() == SetEffect.ATTACK_DAMAGE_UUID) {
                    d0 += this.guiPlayer.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
                    d0 += (double)EnchantmentHelper.func_152377_a((ItemStack)armor[0], (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
                    flag = true;
                } else if (attributemodifier.func_111167_a() == SetEffect.ATTACK_SPEED_UUID) {
                    d0 += this.guiPlayer.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                    flag = true;
                }
                double d1 = attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2 ? d0 : d0 * 100.0;
                boolean contains = false;
                int index2 = 0;
                for (int i = 0; i < entries.size(); ++i) {
                    if (((AttributeModifier)((Map.Entry)entries.get(i)).getValue()).func_111166_b() != attributemodifier.func_111166_b()) continue;
                    contains = true;
                    index2 = i;
                }
                if (!contains) {
                    entries.add(entry);
                    finalD0s.add(d0);
                    finalD1s.add(d1);
                    continue;
                }
                if (!((AttributeModifier)((Map.Entry)entries.get(index2)).getValue()).func_111166_b().equalsIgnoreCase("Armor toughness") && !((AttributeModifier)((Map.Entry)entries.get(index2)).getValue()).func_111166_b().equalsIgnoreCase("Armor modifier")) continue;
                finalD0s.set(index2, (Double)finalD0s.get(index2) + d0);
                finalD1s.set(index2, (Double)finalD1s.get(index2) + d1);
            }
        }
        for (int i = 0; i < entries.size(); ++i) {
            AttributeModifier attributemodifier = (AttributeModifier)((Map.Entry)entries.get(i)).getValue();
            if (flag) {
                tooltip.add(TextFormatting.BLUE + " +" + I18n.func_74837_a((String)("attribute.modifier.equals." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(finalD1s.get(i)), I18n.func_74838_a((String)("attribute.name." + (String)((Map.Entry)entries.get(i)).getKey()))}));
                continue;
            }
            if ((Double)finalD0s.get(i) > 0.0) {
                tooltip.add(TextFormatting.BLUE + " " + I18n.func_74837_a((String)("attribute.modifier.plus." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(finalD1s.get(i)), I18n.func_74838_a((String)("attribute.name." + (String)((Map.Entry)entries.get(i)).getKey()))}));
                continue;
            }
            if (!((Double)finalD0s.get(i) < 0.0)) continue;
            finalD1s.set(i, (Double)finalD1s.get(i) * -1.0);
            tooltip.add(TextFormatting.RED + " " + I18n.func_74837_a((String)("attribute.modifier.take." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(finalD1s.get(i)), I18n.func_74838_a((String)("attribute.name." + (String)((Map.Entry)entries.get(i)).getKey()))}));
        }
        return tooltip;
    }
}

